/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.util;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.InheritanceUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiElementUtil {
    public static boolean methodMatches(@NotNull PsiMethod method, @NonNls @Nullable String containingClassName, @Nullable PsiType returnType, @NonNls @Nullable String methodName, @Nullable List<PsiType> parameterTypes) {
        PsiType methodReturnType;
        if (method == null) {
            PsiElementUtil.$$$reportNull$$$0(0);
        }
        String name = method.getName();
        if (methodName != null && !methodName.equals(name)) {
            return false;
        }
        if (parameterTypes != null) {
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != parameterTypes.size()) {
                return false;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                PsiType type = parameters[i].getType();
                PsiType parameterType = parameterTypes.get(i);
                if (PsiTypes.nullType().equals(parameterType) || parameterType == null || PsiElementUtil.typesAreEquivalent(type, parameterType)) continue;
                return false;
            }
        }
        if (returnType != null && !PsiElementUtil.typesAreEquivalent(returnType, methodReturnType = method.getReturnType())) {
            return false;
        }
        if (containingClassName != null) {
            PsiClass containingClass = method.getContainingClass();
            return InheritanceUtil.isInheritor((PsiClass)containingClass, (String)containingClassName);
        }
        return true;
    }

    public static boolean typesAreEquivalent(@Nullable PsiType type1, @Nullable PsiType type2) {
        if (type1 == null) {
            return type2 == null;
        }
        if (type2 == null) {
            return false;
        }
        String type1Text = type1.getCanonicalText();
        String type2Text = type2.getCanonicalText();
        return type1Text.equals(type2Text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "de/plushnikov/intellij/plugin/util/PsiElementUtil", "methodMatches"));
    }
}

