/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.react;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.flow.psi.impl.FlowJSTypeCastImpl;
import com.intellij.lang.javascript.frameworks.jsx.tsx.TypeScriptJSXComponentUtil;
import com.intellij.lang.javascript.frameworks.react.ReactUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ES6QualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluatorBase;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSVariantRecordTypeConverter;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSPsiBasedTypeOfType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.evaluable.JSTypeWithDeclarations;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureImpl;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.react.ReactComponent;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReactPropTypesUtil {
    public static final String PROPS_IS_REQUIRED_NAME = "isRequired";

    @NotNull
    static Stream<JSPsiElementBase> resolveNamespacePropTypes(@NotNull ReactComponent reactComponent, @NotNull GlobalSearchScope scope) {
        if (reactComponent == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(1);
        }
        String namespace = reactComponent.getNamespace().replace(".props", ".propTypes");
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        JSClassResolver.getInstance().processElementsByQNameIncludingImplicit(namespace, scope, JSClassResolver.IncludeLocalMembersOptions.ALL, (Processor)processor);
        Collection elements = processor.getResults();
        if (elements.isEmpty()) {
            Stream<JSPsiElementBase> stream = Stream.empty();
            if (stream == null) {
                ReactPropTypesUtil.$$$reportNull$$$0(2);
            }
            return stream;
        }
        Stream<JSPsiElementBase> stream = elements.stream().flatMap(element -> ReactPropTypesUtil.getPropTypesForNamespaceElement(element)).distinct();
        if (stream == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(3);
        }
        return stream;
    }

    @NotNull
    private static Stream<JSPsiElementBase> getPropTypesForNamespaceElement(@NotNull JSPsiElementBase element) {
        if (element == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(4);
        }
        Collection meaningfulElements = JSStubBasedPsiTreeUtil.calculateMeaningfulElements((PsiElement)element);
        Stream<JSPsiElementBase> stream = meaningfulElements.stream().flatMap(meaningfulElement -> {
            List expressions;
            JSExpression initializer;
            if (meaningfulElement instanceof JSInitializerOwner && (initializer = ((JSInitializerOwner)meaningfulElement).getInitializerOrStub()) != null) {
                meaningfulElement = initializer;
            }
            if (meaningfulElement instanceof JSDefinitionExpression) {
                String reference = JSPsiImplUtils.getInitializerReference((JSInitializerOwner)((JSDefinitionExpression)meaningfulElement));
                if (!StringUtil.isEmptyOrSpaces((String)reference)) {
                    Collection resolvedElements = new ES6QualifiedNameResolver(meaningfulElement, true).resolveQualifiedName(reference);
                    meaningfulElement = (PsiElement)ContainerUtil.getFirstItem((Collection)resolvedElements);
                } else {
                    JSExpression initializerOrStub = ((JSDefinitionExpression)meaningfulElement).getInitializerOrStub();
                    if (initializerOrStub != null) {
                        meaningfulElement = initializerOrStub;
                    }
                }
            }
            if (meaningfulElement instanceof JSFunction && ((JSFunction)meaningfulElement).isGetProperty() && (expressions = JSStubBasedPsiTreeUtil.findReturnedExpressions((JSFunction)((JSFunction)meaningfulElement))).size() == 1) {
                meaningfulElement = (PsiElement)ContainerUtil.getFirstItem((List)expressions);
            }
            if (meaningfulElement instanceof JSObjectLiteralExpression) {
                return ReactPropTypesUtil.convertObjectLiteralToPropsType((JSObjectLiteralExpression)meaningfulElement);
            }
            return Stream.empty();
        });
        if (stream == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(5);
        }
        return stream;
    }

    @NotNull
    private static Stream<JSPsiElementBase> convertObjectLiteralToPropsType(@NotNull JSObjectLiteralExpression expression) {
        JSElement[] properties;
        if (expression == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(6);
        }
        if ((properties = expression.getPropertiesIncludingSpreads()).length == 0) {
            Stream<JSPsiElementBase> stream = Stream.empty();
            if (stream == null) {
                ReactPropTypesUtil.$$$reportNull$$$0(7);
            }
            return stream;
        }
        SmartList result = new SmartList();
        for (JSElement element : properties) {
            if (element instanceof JSProperty) {
                ReactPropTypesUtil.addSimpleProperty((List<JSPsiElementBase>)result, (JSProperty)element);
                continue;
            }
            if (!(element instanceof JSSpreadExpression)) continue;
            ReactPropTypesUtil.addSpreadProperties((List<JSPsiElementBase>)result, (JSSpreadExpression)element);
        }
        Stream<JSPsiElementBase> stream = result.stream();
        if (stream == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(8);
        }
        return stream;
    }

    private static void addSpreadProperties(@NotNull List<JSPsiElementBase> result, @NotNull JSSpreadExpression element) {
        List resultsFromSpread;
        PsiFile file;
        if (result == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(9);
        }
        if (element == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(10);
        }
        if ((file = element.getContainingFile()) == null) {
            return;
        }
        JSType type = element.getInnerExpressionType();
        if (type == null) {
            return;
        }
        JSRecordType recordType = type.asRecordType();
        Collection properties = recordType.getProperties();
        for (JSRecordType.PropertySignature member : properties) {
            PsiElement sourceElement = member.getMemberSource().getSingleElement();
            if (sourceElement instanceof JSProperty) {
                ReactPropTypesUtil.addSimpleProperty(result, (JSProperty)sourceElement);
                continue;
            }
            if (!(sourceElement instanceof JSPsiElementBase)) continue;
            result.add((JSPsiElementBase)sourceElement);
        }
        if (properties.isEmpty() && type instanceof JSTypeWithDeclarations && (resultsFromSpread = (List)RecursionManager.doPreventingRecursion((Object)element, (boolean)false, () -> StreamEx.of((Collection)((JSTypeWithDeclarations)type).getDeclarations()).select(JSPsiElementBase.class).flatMap(ReactPropTypesUtil::getPropTypesForNamespaceElement).toList())) != null) {
            result.addAll(resultsFromSpread);
        }
    }

    private static void addSimpleProperty(@NotNull List<JSPsiElementBase> result, @NotNull JSProperty property) {
        Collection elements;
        String name;
        if (result == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(11);
        }
        if (property == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(12);
        }
        if ((name = property.getName()) == null) {
            return;
        }
        JSElementIndexingData data = property.getIndexingData();
        if (data != null && (elements = data.getImplicitElements()) != null) {
            for (JSImplicitElement element : elements) {
                if (!element.getQualifiedName().endsWith("props." + element.getName())) continue;
                result.add((JSPsiElementBase)element);
                return;
            }
        }
        result.add((JSPsiElementBase)ReactPropTypesUtil.createSimpleImplicitElement(property, name));
    }

    @NotNull
    public static JSImplicitElementImpl createImplicitReactPropsElement(@NotNull JSProperty property, @NotNull JSQualifiedName prop) {
        if (property == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(13);
        }
        if (prop == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(14);
        }
        JSImplicitElementImpl.Builder propBuilder = new JSImplicitElementImpl.Builder(prop, (PsiElement)property).setType(JSImplicitElement.Type.Property).setOptional(true);
        JSExpression value = property.getValue();
        if (value != null) {
            Pair<JSType, Boolean> pair = ReactPropTypesUtil.processPropTypesExpression(value);
            propBuilder.setJSType((JSType)pair.first).setOptional((Boolean)pair.second == false);
        }
        JSImplicitElementImpl jSImplicitElementImpl = propBuilder.toImplicitElement();
        if (jSImplicitElementImpl == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(15);
        }
        return jSImplicitElementImpl;
    }

    private static JSImplicitElement createSimpleImplicitElement(@NotNull JSProperty property, @NotNull String name) {
        if (property == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(16);
        }
        if (name == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(17);
        }
        return new JSLocalImplicitElementImpl(name, null, (PsiElement)property, JSImplicitElement.Type.Property);
    }

    @Nullable
    public static JSType getClassComponentGenericType(@NotNull JSClass contextClass, boolean isState) {
        JSTypeDeclaration typeDeclaration;
        if (contextClass == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(18);
        }
        return (typeDeclaration = ReactPropTypesUtil.getClassComponentGenericDeclaration(contextClass, isState)) != null ? typeDeclaration.getJSType() : null;
    }

    @Nullable
    public static JSTypeDeclaration getClassComponentGenericDeclaration(@NotNull JSClass contextClass, boolean isState) {
        JSReferenceList list;
        if (contextClass == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(19);
        }
        if ((list = contextClass.getExtendsList()) == null) {
            return null;
        }
        for (JSReferenceListMember refMember : list.getMembers()) {
            int startIndex;
            String text = refMember.getReferenceText();
            if (text == null || !ReactPropTypesUtil.isPossibleReactClassName(text)) continue;
            JSTypeDeclaration[] arguments = refMember.getTypeArguments();
            int argsLength = arguments.length;
            int n = startIndex = isState ? 1 : 0;
            if (argsLength <= startIndex) continue;
            return argsLength == 3 ? arguments[startIndex + 1] : arguments[startIndex];
        }
        return null;
    }

    public static boolean isPossibleReactClassName(@NotNull String text) {
        if (text == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(20);
        }
        int index = text.lastIndexOf(46) + 1;
        String className = text.contains(".") && index < text.length() ? text.substring(index) : text;
        return ReactUtil.REACT_COMPONENT_NAMES.contains(className);
    }

    @NotNull
    private static @NotNull Pair<@NotNull JSType, Boolean> processPropTypesExpression(@NotNull JSExpression expression) {
        if (expression == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(21);
        }
        boolean isRequired = false;
        if (expression instanceof JSReferenceExpression && PROPS_IS_REQUIRED_NAME.equals(((JSReferenceExpression)expression).getReferenceName())) {
            isRequired = true;
            expression = ((JSReferenceExpression)expression).getQualifier();
        }
        JSTypeSource emptySource = JSTypeSource.EMPTY;
        if (expression instanceof JSReferenceExpression) {
            String name = ((JSReferenceExpression)expression).getReferenceName();
            if ("object".equals(name) || "array".equals(name) || "symbol".equals(name)) {
                Pair pair = Pair.create((Object)JSNamedTypeFactory.createType((String)StringUtil.capitalize((String)name), (JSTypeSource)emptySource, (JSContext)JSContext.INSTANCE), (Object)isRequired);
                if (pair == null) {
                    ReactPropTypesUtil.$$$reportNull$$$0(22);
                }
                return pair;
            }
            if ("string".equals(name) || "number".equals(name)) {
                Pair pair = Pair.create((Object)JSNamedTypeFactory.createType((String)name, (JSTypeSource)emptySource, (JSContext)JSContext.INSTANCE), (Object)isRequired);
                if (pair == null) {
                    ReactPropTypesUtil.$$$reportNull$$$0(23);
                }
                return pair;
            }
            if ("bool".equals(name)) {
                Pair pair = Pair.create((Object)JSNamedTypeFactory.createType((String)"boolean", (JSTypeSource)emptySource, (JSContext)JSContext.INSTANCE), (Object)isRequired);
                if (pair == null) {
                    ReactPropTypesUtil.$$$reportNull$$$0(24);
                }
                return pair;
            }
            if ("func".equals(name)) {
                Pair pair = Pair.create((Object)JSNamedTypeFactory.createFunctionType((JSTypeSource)emptySource), (Object)isRequired);
                if (pair == null) {
                    ReactPropTypesUtil.$$$reportNull$$$0(25);
                }
                return pair;
            }
        }
        if (expression instanceof JSCallExpression) {
            JSExpression methodExpression = ((JSCallExpression)expression).getMethodExpression();
            if (!(methodExpression instanceof JSReferenceExpression)) {
                Pair pair = Pair.create((Object)JSAnyType.get((JSTypeSource)emptySource), (Object)isRequired);
                if (pair == null) {
                    ReactPropTypesUtil.$$$reportNull$$$0(26);
                }
                return pair;
            }
            String name = ((JSReferenceExpression)methodExpression).getReferenceName();
            JSExpression firstArgument = (JSExpression)ArrayUtil.getFirstElement((Object[])((JSCallExpression)expression).getArguments());
            if (StringUtil.equals((CharSequence)name, (CharSequence)"instanceOf") && firstArgument instanceof JSReferenceExpression) {
                String text = firstArgument.getText();
                Pair pair = Pair.create((Object)JSNamedTypeFactory.createType((String)text, (JSTypeSource)emptySource, (JSContext)JSContext.INSTANCE), (Object)isRequired);
                if (pair == null) {
                    ReactPropTypesUtil.$$$reportNull$$$0(27);
                }
                return pair;
            }
            if (StringUtil.equals((CharSequence)name, (CharSequence)"shape") && firstArgument instanceof JSObjectLiteralExpression) {
                JSObjectLiteralExpression shapeLiteral = (JSObjectLiteralExpression)firstArgument;
                ArrayList<PropertySignatureImpl> properties = new ArrayList<PropertySignatureImpl>();
                for (JSProperty property : shapeLiteral.getProperties()) {
                    String propertyName = property.getName();
                    JSExpression value = property.getValue();
                    if (propertyName == null || value == null) continue;
                    Pair<JSType, Boolean> pair = ReactPropTypesUtil.processPropTypesExpression(value);
                    properties.add(new PropertySignatureImpl(propertyName, (JSType)pair.first, ((Boolean)pair.second).booleanValue(), false));
                }
                Pair pair = Pair.create((Object)new JSRecordTypeImpl(emptySource, properties), (Object)isRequired);
                if (pair == null) {
                    ReactPropTypesUtil.$$$reportNull$$$0(28);
                }
                return pair;
            }
            if (StringUtil.equals((CharSequence)name, (CharSequence)"oneOf") && firstArgument instanceof JSArrayLiteralExpression) {
                Object[] expressions = ((JSArrayLiteralExpression)firstArgument).getExpressions();
                List types = ContainerUtil.mapNotNull((Object[])expressions, e -> e instanceof JSLiteralExpression ? JSTypeEvaluator.getTypeFromConstant((JSExpression)e) : null);
                Pair pair = Pair.create((Object)JSCompositeTypeFactory.createUnionType((JSTypeSource)emptySource, (Collection)types), (Object)isRequired);
                if (pair == null) {
                    ReactPropTypesUtil.$$$reportNull$$$0(29);
                }
                return pair;
            }
            if (StringUtil.equals((CharSequence)name, (CharSequence)"arrayOf") && firstArgument != null) {
                Pair<JSType, Boolean> pair = ReactPropTypesUtil.processPropTypesExpression(firstArgument);
                Pair pair2 = Pair.create((Object)new JSArrayTypeImpl((JSType)pair.first, emptySource), (Object)isRequired);
                if (pair2 == null) {
                    ReactPropTypesUtil.$$$reportNull$$$0(30);
                }
                return pair2;
            }
        }
        Pair pair = Pair.create((Object)JSAnyType.get((JSTypeSource)emptySource), (Object)isRequired);
        if (pair == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(31);
        }
        return pair;
    }

    @NotNull
    public static String toPropType(String qualifier, @Nullable JSType type, @NotNull PsiElement context) {
        if (context == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(32);
        }
        if (JSNamedType.isNamedTypeWithName((JSType)type, (String)"JSX.Element")) {
            String string = qualifier + ".element";
            if (string == null) {
                ReactPropTypesUtil.$$$reportNull$$$0(33);
            }
            return string;
        }
        if (JSNamedType.isNamedTypeWithName((JSType)type, (String)"ReactNode")) {
            String string = qualifier + ".node";
            if (string == null) {
                ReactPropTypesUtil.$$$reportNull$$$0(34);
            }
            return string;
        }
        if (JSTypeUtils.getFunctionType((JSType)type, (boolean)false, (PsiElement)context).anyMatch(t -> !JSTypeUtils.isNullOrAny((JSType)t))) {
            String string = qualifier + ".func";
            if (string == null) {
                ReactPropTypesUtil.$$$reportNull$$$0(35);
            }
            return string;
        }
        if ((type = JSTypeUtils.unwrapType((JSType)type)) instanceof JSRecordType) {
            String string = qualifier + String.format(".shape({%s})", StringUtil.join((Collection)((JSRecordType)type).getTypeMembers(), t -> {
                if (t instanceof JSRecordType.PropertySignature) {
                    return ((JSRecordType.PropertySignature)t).getMemberName() + ":" + ReactPropTypesUtil.toPropType(qualifier, ((JSRecordType.PropertySignature)t).getJSType(), context);
                }
                return "";
            }, (String)","));
            if (string == null) {
                ReactPropTypesUtil.$$$reportNull$$$0(36);
            }
            return string;
        }
        if (type instanceof JSBooleanType) {
            String string = qualifier + ".bool";
            if (string == null) {
                ReactPropTypesUtil.$$$reportNull$$$0(37);
            }
            return string;
        }
        if (type instanceof JSStringType) {
            String string = qualifier + ".string";
            if (string == null) {
                ReactPropTypesUtil.$$$reportNull$$$0(38);
            }
            return string;
        }
        if (type instanceof JSNumberType) {
            String string = qualifier + ".number";
            if (string == null) {
                ReactPropTypesUtil.$$$reportNull$$$0(39);
            }
            return string;
        }
        if (type instanceof JSArrayType) {
            String string = qualifier + String.format(".arrayOf(%s)", ReactPropTypesUtil.toPropType(qualifier, ((JSArrayType)type).getType(), context));
            if (string == null) {
                ReactPropTypesUtil.$$$reportNull$$$0(40);
            }
            return string;
        }
        String string = qualifier + ".any";
        if (string == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(41);
        }
        return string;
    }

    @Nullable
    static JSType getGenericPropType(@NotNull XmlTag tag, @NotNull ReactComponent reactComponent) {
        if (tag == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(42);
        }
        if (reactComponent == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(43);
        }
        if (!DialectDetector.isJSX((PsiElement)tag)) {
            return null;
        }
        Collection<? extends PsiElement> elements = reactComponent.getElements();
        if (elements.isEmpty()) {
            return null;
        }
        SmartList results = new SmartList();
        for (PsiElement psiElement : elements) {
            results.addAll(ReactPropTypesUtil.getPropsTypeFromPsiElement(psiElement, tag));
        }
        return ReactPropTypesUtil.chooseOverload(tag, (List<JSType>)results);
    }

    @Nullable
    private static JSType chooseOverload(@NotNull XmlTag tag, @NotNull List<JSType> overloads) {
        if (tag == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(44);
        }
        if (overloads == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(45);
        }
        if (overloads.size() == 1) {
            return overloads.get(0);
        }
        XmlAttribute[] attributes = tag.getAttributes();
        HashMap specified = new HashMap();
        for (XmlAttribute attribute : attributes) {
            String name = attribute.getName();
            if (name.contains(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED)) continue;
            specified.put(name, null);
        }
        List<Object> result = new ArrayList();
        for (JSType overload : overloads) {
            JSRecordType type = overload.asRecordType();
            boolean allMatched = true;
            for (Map.Entry entry : specified.entrySet()) {
                String name = (String)entry.getKey();
                if (type.hasProperty(name)) continue;
                allMatched = false;
            }
            if (!allMatched) continue;
            result.add(overload);
        }
        if (result.size() == 1) {
            return (JSType)result.get(0);
        }
        if (result.isEmpty()) {
            result = overloads;
        }
        return JSCompositeTypeFactory.createContextualUnionType(result, (JSTypeSource)JSTypeSourceFactory.createTypeSource((PsiElement)tag, (boolean)false));
    }

    @Nullable
    private static JSType getTypeFromFunctionParameter(@NotNull JSFunction resolve) {
        JSParameterListElement[] parameters;
        JSType typeFromParam;
        if (resolve == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(46);
        }
        if ((typeFromParam = ReactPropTypesUtil.getPropsTypeFromParameters(parameters = resolve.getParameters())) != null) {
            return typeFromParam;
        }
        return null;
    }

    @Nullable
    private static JSType getPropsTypeFromParameters(JSParameterListElement @NotNull [] parameters) {
        if (parameters == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(47);
        }
        if (parameters.length == 0 || parameters.length > 2) {
            return null;
        }
        JSParameterListElement propParameter = parameters[0];
        boolean hasTypeElement = propParameter.getTypeElement() != null;
        JSType type = propParameter.getJSType();
        if (type != null) {
            return hasTypeElement ? type : type.copyWithStrict(false);
        }
        return ReactPropTypesUtil.getJSTypeStubSafelyInJS((PsiElement)propParameter);
    }

    @Nullable
    private static JSType getJSTypeStubSafelyInJS(PsiElement element) {
        return DialectDetector.isTypeScript((PsiElement)element) ? JSResolveUtil.getElementJSType((PsiElement)element) : new JSPsiBasedTypeOfType(element, new JSEvaluateContext(element.getContainingFile()).withAstAccessForbidden()).substituteOrNull();
    }

    @Nullable
    public static JSRecordType asPropsResult(@Nullable JSType type, @Nullable PsiElement context) {
        if (type == null) {
            return null;
        }
        if (type instanceof JSIntersectionType) {
            return type.asRecordType();
        }
        if (type instanceof JSUnionType) {
            JSUnionType unionType = (JSUnionType)type;
            List types = ContainerUtil.map((Collection)unionType.getTypes(), JSType::asRecordType);
            type = JSCompositeTypeFactory.createContextualUnionType((Collection)types, (JSTypeSource)type.getSource());
            JSType expanded = JSTypeUtils.getValuableType((JSType)type, (PsiElement)context);
            return expanded.asRecordType();
        }
        if (type instanceof JSGenericTypeImpl) {
            return JSVariantRecordTypeConverter.getTypeAsRecord((JSType)type, (PsiElement)context);
        }
        return type.asRecordType();
    }

    @Nullable
    public static JSRecordType getResultPropsFromPsiElement(@Nullable PsiElement elementOrExpression) {
        List<JSType> propsTypes = ReactPropTypesUtil.getPropsTypeFromPsiElementImpl(elementOrExpression);
        JSType propsType = JSCompositeTypeFactory.createContextualUnionType(propsTypes, (JSTypeSource)JSTypeSourceFactory.createTypeSource((PsiElement)elementOrExpression, (boolean)false));
        return ReactPropTypesUtil.asPropsResult(propsType, elementOrExpression);
    }

    @NotNull
    public static List<JSType> getPropsTypeFromPsiElementImpl(@Nullable PsiElement elementOrExpression) {
        JSTypeDeclaration type;
        JSExpression initializerOrStub;
        if (elementOrExpression == null) {
            List<JSType> list = Collections.emptyList();
            if (list == null) {
                ReactPropTypesUtil.$$$reportNull$$$0(48);
            }
            return list;
        }
        if (elementOrExpression instanceof JSDefinitionExpression && (initializerOrStub = ((JSDefinitionExpression)elementOrExpression).getInitializerOrStub()) != null) {
            elementOrExpression = initializerOrStub;
        }
        if (elementOrExpression instanceof FlowJSTypeCastImpl && (type = ((FlowJSTypeCastImpl)elementOrExpression).getResultType()) != null) {
            JSType jsType = type.getJSType();
            return ReactPropTypesUtil.getPropsTypeFromJsType(jsType);
        }
        if (elementOrExpression instanceof JSClass) {
            return ReactPropTypesUtil.getPropsTypeFromClass((JSClass)elementOrExpression);
        }
        if (elementOrExpression instanceof JSFunction) {
            return ReactPropTypesUtil.getPropsTypeFromFunction((JSFunction)elementOrExpression);
        }
        JSType varType = ReactPropTypesUtil.getJSTypeStubSafelyInJS(elementOrExpression);
        if (varType != null) {
            JSType genericStatelessArg;
            if (varType instanceof JSGenericTypeImpl && (genericStatelessArg = JSTypeUtils.getSingleGenericArgTypeFromGenericType((JSGenericTypeImpl)((JSGenericTypeImpl)varType), ReactPropTypesUtil::isReactSingleVariantComponent, (boolean)true)) != null) {
                List<JSType> list = Collections.singletonList(genericStatelessArg);
                if (list == null) {
                    ReactPropTypesUtil.$$$reportNull$$$0(49);
                }
                return list;
            }
            return ReactPropTypesUtil.getPropsTypeFromJsType(varType);
        }
        List<JSType> list = Collections.emptyList();
        if (list == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(50);
        }
        return list;
    }

    @NotNull
    private static List<JSType> getPropsTypeFromClass(@NotNull JSClass componentClass) {
        if (componentClass == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(51);
        }
        JSType props = ReactPropTypesUtil.getPropsFieldType(componentClass);
        JSType propTypes = ReactPropTypesUtil.getPropTypesStaticFieldType(componentClass);
        List list = StreamEx.of((Object[])new JSType[]{props, propTypes}).nonNull().toList();
        if (list == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(52);
        }
        return list;
    }

    @Nullable
    private static JSType getPropTypesStaticFieldType(@NotNull JSClass componentClass) {
        JSField propTypes;
        if (componentClass == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(53);
        }
        if ((propTypes = componentClass.findFieldByName("propTypes")) == null || propTypes.getTypeElement() == null) {
            return null;
        }
        JSType type = JSTypeUtils.getValuableType((JSType)propTypes.getJSType(), (PsiElement)componentClass);
        if (type == null) {
            return null;
        }
        return type;
    }

    @Nullable
    private static JSType getPropsFieldType(@NotNull JSClass componentClass) {
        JSType result;
        JSRecordType type;
        if (componentClass == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(54);
        }
        if (!(type = TypeScriptTypeParser.buildTypeFromClass((JSClass)componentClass, (boolean)false)).hasMembers()) {
            return null;
        }
        JSRecordType.PropertySignature signature = type.findPropertySignature("props");
        if (signature != null && (result = signature.getJSType()) != null && !(result instanceof JSAnyType)) {
            return result;
        }
        JSType genericsType = ReactPropTypesUtil.getClassComponentGenericType(componentClass, false);
        if (genericsType != null && !(genericsType instanceof JSAnyType)) {
            return genericsType;
        }
        return null;
    }

    @NotNull
    private static List<JSType> getPropsTypeFromJsType(@Nullable JSType type) {
        JSRecordType.PropertySignature types;
        if (type == null) {
            List<JSType> list = Collections.emptyList();
            if (list == null) {
                ReactPropTypesUtil.$$$reportNull$$$0(55);
            }
            return list;
        }
        JSRecordType recordType = type.asRecordType();
        List signatures = recordType.getCallSignatures();
        ArrayList<JSType> calls = new ArrayList<JSType>();
        for (JSRecordType.CallSignature signature : signatures) {
            if (signature.hasNew()) {
                calls.addAll(ReactPropTypesUtil.getPropsTypeFromNewSignatureType(signature.getReturnType()));
                continue;
            }
            JSFunctionType functionType = signature.getFunctionType();
            JSType result = ReactPropTypesUtil.getPropsTypeFromCallSignatureType(functionType);
            if (result == null) continue;
            calls.add(result);
        }
        if (calls.isEmpty() && (types = recordType.findPropertySignature("propTypes")) != null) {
            List list = ContainerUtil.createMaybeSingletonList((Object)types.getJSType());
            if (list == null) {
                ReactPropTypesUtil.$$$reportNull$$$0(56);
            }
            return list;
        }
        ArrayList<JSType> arrayList = calls;
        if (arrayList == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(57);
        }
        return arrayList;
    }

    @Nullable
    private static JSType getPropsTypeFromCallSignatureType(@NotNull JSFunctionType functionType) {
        List declarations;
        List parameters;
        if (functionType == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(58);
        }
        if ((parameters = functionType.getParameters()).isEmpty()) {
            return null;
        }
        JSParameterTypeDecorator props = (JSParameterTypeDecorator)parameters.get(0);
        JSType type = props.getSimpleType();
        if (functionType instanceof TypeScriptJSFunctionTypeImpl && !(declarations = ((TypeScriptJSFunctionTypeImpl)functionType).getGenericDeclarations()).isEmpty()) {
            JSTypeSubstitutor defaultParameters = JSGenericTypesEvaluatorBase.getSubstitutorForDefaultParameters((JSFunctionType)functionType);
            return JSTypeUtils.applyGenericArguments((JSType)type, (JSTypeSubstitutor)defaultParameters);
        }
        return type;
    }

    @NotNull
    private static List<JSType> getPropsTypeFromNewSignatureType(@Nullable JSType returnType) {
        String className;
        List<JSType> candidates;
        JSResolvedTypeInfo info;
        JSClass resolved;
        if (returnType == null) {
            List<JSType> list = Collections.emptyList();
            if (list == null) {
                ReactPropTypesUtil.$$$reportNull$$$0(59);
            }
            return list;
        }
        if (returnType instanceof JSResolvableType && (resolved = (JSClass)(info = ((JSResolvableType)returnType).resolveType()).getDeclarationOfType(JSClass.class)) != null && !(candidates = ReactPropTypesUtil.getPropsTypeFromClass(resolved)).isEmpty()) {
            List<JSType> list = candidates;
            if (list == null) {
                ReactPropTypesUtil.$$$reportNull$$$0(60);
            }
            return list;
        }
        if (!(returnType instanceof JSGenericTypeImpl)) {
            List<JSType> list = Collections.emptyList();
            if (list == null) {
                ReactPropTypesUtil.$$$reportNull$$$0(61);
            }
            return list;
        }
        JSGenericTypeImpl genericType = (JSGenericTypeImpl)returnType;
        JSType innerType = genericType.getType();
        if (!(innerType instanceof JSResolvableType)) {
            List<JSType> list = Collections.emptyList();
            if (list == null) {
                ReactPropTypesUtil.$$$reportNull$$$0(62);
            }
            return list;
        }
        JSResolvedTypeInfo info2 = ((JSResolvableType)innerType).resolveType();
        JSClass aClass = (JSClass)info2.getDeclarationOfType(JSClass.class);
        String string = className = aClass == null ? null : aClass.getName();
        if (className == null) {
            String string2 = className = innerType instanceof JSNamedType ? innerType.getTypeText() : null;
        }
        if (ReactUtil.REACT_COMPONENT_NAMES.contains(className)) {
            JSRecordType.PropertySignature signature = returnType.asRecordType().findPropertySignature("props");
            if (signature != null) {
                List list = ContainerUtil.createMaybeSingletonList((Object)signature.getJSType());
                if (list == null) {
                    ReactPropTypesUtil.$$$reportNull$$$0(63);
                }
                return list;
            }
            List list = ContainerUtil.createMaybeSingletonList((Object)((JSType)ContainerUtil.getFirstItem((List)genericType.getArguments())));
            if (list == null) {
                ReactPropTypesUtil.$$$reportNull$$$0(64);
            }
            return list;
        }
        List<JSType> list = Collections.emptyList();
        if (list == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(65);
        }
        return list;
    }

    @NotNull
    private static List<JSType> getPropsTypeFromFunction(@NotNull JSFunction resolvedElementOrExpression) {
        if (resolvedElementOrExpression == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(66);
        }
        if (resolvedElementOrExpression instanceof TypeScriptFunction && ((TypeScriptFunction)resolvedElementOrExpression).isOverloadImplementation()) {
            ArrayList<JSType> allTypes = new ArrayList<JSType>();
            for (TypeScriptFunction overload : ((TypeScriptFunction)resolvedElementOrExpression).getOverloadDeclarations()) {
                JSType typeFromParam;
                if (overload.isOverloadImplementation() || (typeFromParam = ReactPropTypesUtil.getTypeFromFunctionParameter((JSFunction)overload)) == null) continue;
                allTypes.add(typeFromParam);
            }
            if (!allTypes.isEmpty()) {
                ArrayList<JSType> arrayList = allTypes;
                if (arrayList == null) {
                    ReactPropTypesUtil.$$$reportNull$$$0(67);
                }
                return arrayList;
            }
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)ReactPropTypesUtil.getTypeFromFunctionParameter(resolvedElementOrExpression));
        if (list == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(68);
        }
        return list;
    }

    @Contract(value="null -> false")
    private static boolean isReactSingleVariantComponent(@Nullable JSType t) {
        String name;
        if (!(t instanceof JSResolvableType)) {
            return false;
        }
        JSResolvedTypeInfo info = ((JSResolvableType)t).resolveType();
        JSClass declaration = (JSClass)info.getDeclarationOfType(TypeScriptInterface.class);
        if (declaration == null) {
            declaration = (JSClass)info.getDeclarationOfType(TypeScriptTypeAlias.class);
        }
        return declaration != null && (name = declaration.getName()) != null && ReactUtil.REACT_SINGLE_VARIANT_COMPONENT_NAMES.contains(name);
    }

    @NotNull
    private static List<JSType> getPropsTypeFromPsiElement(@Nullable PsiElement resolve, @NotNull XmlTag tag) {
        if (tag == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(69);
        }
        List<JSType> result = ReactPropTypesUtil.getPropsTypeFromPsiElementImpl(resolve);
        List list = ContainerUtil.map(result, el -> JSTypeUtils.applyGenericArguments((JSType)el, (JSTypeSubstitutor)TypeScriptJSXComponentUtil.getGenericSubstitutorForTag((PsiElement)resolve, (XmlTag)tag)));
        if (list == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(70);
        }
        return list;
    }

    @Nullable
    public static JSImplicitElement substitutePropTypesPropDeclaration(@NotNull JSProperty property) {
        if (property == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(71);
        }
        if (ReactPropTypesUtil.isNamespaceMember((JSPsiElementBase)property, "propTypes")) {
            Collection implicitElements;
            JSElementIndexingData indexingData = property.getIndexingData();
            Collection collection = implicitElements = indexingData != null ? indexingData.getImplicitElements() : null;
            if (implicitElements == null) {
                return null;
            }
            for (JSImplicitElement element : implicitElements) {
                if (!ReactPropTypesUtil.isNamespaceMember((JSPsiElementBase)element, "props")) continue;
                return element;
            }
            return null;
        }
        if (ReactPropTypesUtil.isNamespaceMember((JSPsiElementBase)property, "defaultProps", "getDefaultProps")) {
            JSQualifiedName namespace = property.getNamespace();
            assert (namespace != null);
            JSQualifiedName parent = namespace.getParent();
            assert (parent != null);
            Collection elements = JSClassResolver.getInstance().findElementsByQNameIncludingImplicit(parent.getQualifiedName() + ".props." + property.getName(), property.getResolveScope());
            for (JSPsiElementBase element : elements) {
                if (!(element instanceof JSImplicitElement)) continue;
                return (JSImplicitElement)element;
            }
        }
        return null;
    }

    public static boolean isNamespaceMember(@NotNull JSPsiElementBase element, String ... namespaceNames) {
        JSQualifiedName namespace;
        if (element == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(72);
        }
        if (namespaceNames == null) {
            ReactPropTypesUtil.$$$reportNull$$$0(73);
        }
        return (namespace = element.getNamespace()) != null && ArrayUtil.contains((String)namespace.getName(), (String[])namespaceNames) && namespace.getParent() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 7, 8, 15, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 33, 34, 35, 36, 37, 38, 39, 40, 41, 48, 49, 50, 52, 55, 56, 57, 59, 60, 61, 62, 63, 64, 65, 67, 68, 70 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reactComponent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/react/ReactPropTypesUtil";
                break;
            }
            case 4: 
            case 10: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 12: 
            case 13: 
            case 16: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prop";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextClass";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 42: 
            case 44: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overloads";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolve";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 51: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentClass";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionType";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedElementOrExpression";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/react/ReactPropTypesUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveNamespacePropTypes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropTypesForNamespaceElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "convertObjectLiteralToPropsType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createImplicitReactPropsElement";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "processPropTypesExpression";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "toPropType";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropsTypeFromPsiElementImpl";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropsTypeFromClass";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropsTypeFromJsType";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropsTypeFromNewSignatureType";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropsTypeFromFunction";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropsTypeFromPsiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveNamespacePropTypes";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 70: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPropTypesForNamespaceElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertObjectLiteralToPropsType";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addSpreadProperties";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addSimpleProperty";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createImplicitReactPropsElement";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleImplicitElement";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getClassComponentGenericType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getClassComponentGenericDeclaration";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isPossibleReactClassName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processPropTypesExpression";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "toPropType";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getGenericPropType";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "chooseOverload";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromFunctionParameter";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getPropsTypeFromParameters";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getPropsTypeFromClass";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getPropTypesStaticFieldType";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getPropsFieldType";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getPropsTypeFromCallSignatureType";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getPropsTypeFromFunction";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getPropsTypeFromPsiElement";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "substitutePropTypesPropDeclaration";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isNamespaceMember";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 7, 8, 15, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 33, 34, 35, 36, 37, 38, 39, 40, 41, 48, 49, 50, 52, 55, 56, 57, 59, 60, 61, 62, 63, 64, 65, 67, 68, 70 -> new IllegalStateException(string);
        };
    }
}

