/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.messaging.providers;

import com.intellij.microservices.jvm.callsites.ArgumentCallSite;
import com.intellij.microservices.jvm.callsites.ArgumentCallSiteCollector;
import com.intellij.microservices.jvm.callsites.ArgumentPlace;
import com.intellij.microservices.jvm.callsites.ConstructorArgument;
import com.intellij.microservices.jvm.callsites.MethodArgument;
import com.intellij.microservices.jvm.mq.CallSiteMQTargetInfo;
import com.intellij.microservices.mq.MQAccessType;
import com.intellij.microservices.mq.MQAccessTypes;
import com.intellij.microservices.mq.MQResolver;
import com.intellij.microservices.mq.MQResolverFactory;
import com.intellij.microservices.mq.MQTargetInfo;
import com.intellij.microservices.mq.MQType;
import com.intellij.microservices.mq.MQTypes;
import com.intellij.openapi.project.Project;
import com.intellij.spring.messaging.providers.SpringMQUtils;
import com.intellij.spring.messaging.providers.SpringRabbitBindingDestinationMQResolver;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/intellij/spring/messaging/providers/SpringRabbitTemplateMQResolver;", "Lcom/intellij/microservices/mq/MQResolver;", "project", "Lcom/intellij/openapi/project/Project;", "type", "Lcom/intellij/microservices/mq/MQType;", "collector", "Lcom/intellij/microservices/jvm/callsites/ArgumentCallSiteCollector;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/microservices/mq/MQType;Lcom/intellij/microservices/jvm/callsites/ArgumentCallSiteCollector;)V", "supportedTypes", "", "getSupportedTypes", "()Ljava/util/List;", "getVariants", "", "Lcom/intellij/microservices/mq/MQTargetInfo;", "typeHint", "Companion", "Factory", "intellij.spring.messaging"})
public final class SpringRabbitTemplateMQResolver
implements MQResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final MQType type;
    @NotNull
    private final ArgumentCallSiteCollector collector;
    @NotNull
    private final List<MQType> supportedTypes;
    @NotNull
    private static final ArgumentCallSiteCollector SPRING_RABBIT_OPERATIONS_EXCHANGE_SEND;
    @NotNull
    private static final ArgumentCallSiteCollector SPRING_RABBIT_OPERATIONS_EXCHANGE_SEND_AND_RECEIVE;
    @NotNull
    private static final ArgumentCallSiteCollector SPRING_RABBIT_OPERATIONS_EXCHANGE_ADMINISTRATION;
    @NotNull
    private static final ArgumentCallSiteCollector SPRING_RABBIT_OPERATIONS_QUEUE_RECEIVE;
    @NotNull
    private static final ArgumentCallSiteCollector SPRING_RABBIT_OPERATIONS_QUEUE_RECEIVE_AND_REPLY;
    @NotNull
    private static final ArgumentCallSiteCollector SPRING_RABBIT_OPERATIONS_QUEUE_ADMINISTRATION;
    @NotNull
    private static final ArgumentCallSiteCollector SPRING_RABBIT_OPERATIONS_DIRECT;
    @NotNull
    private static final ArgumentCallSiteCollector SPRING_RABBIT_OPERATIONS_FANOUT;
    @NotNull
    private static final ArgumentCallSiteCollector SPRING_RABBIT_OPERATIONS_HEADERS;
    @NotNull
    private static final ArgumentCallSiteCollector SPRING_RABBIT_OPERATIONS_TOPIC;
    @NotNull
    private static final ArgumentCallSiteCollector SPRING_RABBIT_BINDING_EXCHANGE;

    public SpringRabbitTemplateMQResolver(@NotNull Project project, @NotNull MQType type, @NotNull ArgumentCallSiteCollector collector) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        this.project = project;
        this.type = type;
        this.collector = collector;
        this.supportedTypes = CollectionsKt.listOf((Object)this.type);
    }

    @NotNull
    public List<MQType> getSupportedTypes() {
        return this.supportedTypes;
    }

    @NotNull
    public Iterable<MQTargetInfo> getVariants(@NotNull MQType typeHint) {
        Intrinsics.checkNotNullParameter((Object)typeHint, (String)"typeHint");
        return SequencesKt.asIterable((Sequence)SequencesKt.map((Sequence)this.collector.getCallSitesSequence(this.project), arg_0 -> SpringRabbitTemplateMQResolver.getVariants$lambda$0(this, arg_0)));
    }

    private static final CallSiteMQTargetInfo getVariants$lambda$0(SpringRabbitTemplateMQResolver this$0, ArgumentCallSite it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        MQType mQType = this$0.type;
        Object object = this$0.collector.getUserData(MQAccessType.KEY);
        Intrinsics.checkNotNull((Object)object);
        return new CallSiteMQTargetInfo(it, mQType, (MQAccessType)object);
    }

    static {
        String[] stringArray = new MethodArgument[3];
        Object[] objectArray = new String[]{"send", "convertAndSend"};
        stringArray[0] = new MethodArgument("org.springframework.amqp.core.AmqpTemplate", CollectionsKt.listOf((Object[])objectArray), 0, 3, null, 16, null);
        stringArray[1] = new MethodArgument("org.springframework.amqp.core.AmqpTemplate", CollectionsKt.listOf((Object)"convertAndSend"), 0, 4, null, 16, null);
        objectArray = new String[]{"send", "convertAndSend"};
        stringArray[2] = new MethodArgument("org.springframework.amqp.rabbit.core.RabbitOperations", CollectionsKt.listOf((Object[])objectArray), 0, 4, null, 16, null);
        stringArray = new ArgumentCallSiteCollector("SPRING_RABBIT_OPERATIONS_EXCHANGE_SEND", CollectionsKt.listOf((Object[])stringArray), null, 4, null);
        Object[] $this$SPRING_RABBIT_OPERATIONS_EXCHANGE_SEND_u24lambda_u241 = stringArray;
        boolean bl = false;
        $this$SPRING_RABBIT_OPERATIONS_EXCHANGE_SEND_u24lambda_u241.putUserData(MQAccessType.KEY, (Object)MQAccessTypes.SEND_TYPE);
        SPRING_RABBIT_OPERATIONS_EXCHANGE_SEND = stringArray;
        stringArray = new MethodArgument[6];
        $this$SPRING_RABBIT_OPERATIONS_EXCHANGE_SEND_u24lambda_u241 = new String[]{"sendAndReceive", "convertSendAndReceive"};
        stringArray[0] = new MethodArgument("org.springframework.amqp.core.AmqpTemplate", CollectionsKt.listOf((Object[])$this$SPRING_RABBIT_OPERATIONS_EXCHANGE_SEND_u24lambda_u241), 0, 3, null, 16, null);
        $this$SPRING_RABBIT_OPERATIONS_EXCHANGE_SEND_u24lambda_u241 = new String[]{"convertSendAndReceive", "convertSendAndReceiveAsType"};
        stringArray[1] = new MethodArgument("org.springframework.amqp.core.AmqpTemplate", CollectionsKt.listOf((Object[])$this$SPRING_RABBIT_OPERATIONS_EXCHANGE_SEND_u24lambda_u241), 0, 4, null, 16, null);
        stringArray[2] = new MethodArgument("org.springframework.amqp.core.AmqpTemplate", CollectionsKt.listOf((Object)"convertSendAndReceiveAsType"), 0, 5, null, 16, null);
        stringArray[3] = new MethodArgument("org.springframework.amqp.rabbit.core.RabbitOperations", CollectionsKt.listOf((Object)"convertSendAndReceive"), 0, 4, null, 16, null);
        $this$SPRING_RABBIT_OPERATIONS_EXCHANGE_SEND_u24lambda_u241 = new String[]{"convertSendAndReceive", "convertSendAndReceiveAsType"};
        stringArray[4] = new MethodArgument("org.springframework.amqp.rabbit.core.RabbitOperations", CollectionsKt.listOf((Object[])$this$SPRING_RABBIT_OPERATIONS_EXCHANGE_SEND_u24lambda_u241), 0, 5, null, 16, null);
        stringArray[5] = new MethodArgument("org.springframework.amqp.rabbit.core.RabbitOperations", CollectionsKt.listOf((Object)"convertSendAndReceiveAsType"), 0, 6, null, 16, null);
        String[] $this$SPRING_RABBIT_OPERATIONS_EXCHANGE_SEND_AND_RECEIVE_u24lambda_u242 = stringArray = new ArgumentCallSiteCollector("SPRING_RABBIT_OPERATIONS_EXCHANGE_SEND_AND_RECEIVE", CollectionsKt.listOf((Object[])stringArray), null, 4, null);
        boolean bl2 = false;
        $this$SPRING_RABBIT_OPERATIONS_EXCHANGE_SEND_AND_RECEIVE_u24lambda_u242.putUserData(MQAccessType.KEY, (Object)MQAccessTypes.SEND_AND_RECEIVE_TYPE);
        SPRING_RABBIT_OPERATIONS_EXCHANGE_SEND_AND_RECEIVE = stringArray;
        String[] $this$SPRING_RABBIT_OPERATIONS_EXCHANGE_ADMINISTRATION_u24lambda_u243 = stringArray = new ArgumentCallSiteCollector("SPRING_RABBIT_OPERATIONS_EXCHANGE_ADMINISTRATION", CollectionsKt.listOf((Object)new MethodArgument("org.springframework.amqp.rabbit.core.RabbitTemplate", "setExchange", 0, 0, 8, null)), null, 4, null);
        boolean bl3 = false;
        $this$SPRING_RABBIT_OPERATIONS_EXCHANGE_ADMINISTRATION_u24lambda_u243.putUserData(MQAccessType.KEY, (Object)MQAccessTypes.ADMINISTRATION_TYPE);
        SPRING_RABBIT_OPERATIONS_EXCHANGE_ADMINISTRATION = stringArray;
        stringArray = new String[]{"receive", "receiveAndConvert"};
        String[] $this$SPRING_RABBIT_OPERATIONS_QUEUE_RECEIVE_u24lambda_u244 = stringArray = new ArgumentCallSiteCollector("SPRING_RABBIT_OPERATIONS_QUEUE_RECEIVE", CollectionsKt.listOf((Object)new MethodArgument("org.springframework.amqp.core.AmqpTemplate", CollectionsKt.listOf((Object[])stringArray), 0, 0, null, 24, null)), null, 4, null);
        boolean bl4 = false;
        $this$SPRING_RABBIT_OPERATIONS_QUEUE_RECEIVE_u24lambda_u244.putUserData(MQAccessType.KEY, (Object)MQAccessTypes.RECEIVE_TYPE);
        SPRING_RABBIT_OPERATIONS_QUEUE_RECEIVE = stringArray;
        stringArray = new ArgumentCallSiteCollector("SPRING_RABBIT_OPERATIONS_QUEUE_RECEIVE_AND_REPLY", CollectionsKt.listOf((Object)new MethodArgument("org.springframework.amqp.core.AmqpTemplate", CollectionsKt.listOf((Object)"receiveAndReply"), 0, 0, null, 24, null)), null, 4, null);
        Object[] $this$SPRING_RABBIT_OPERATIONS_QUEUE_RECEIVE_AND_REPLY_u24lambda_u245 = stringArray;
        boolean bl5 = false;
        $this$SPRING_RABBIT_OPERATIONS_QUEUE_RECEIVE_AND_REPLY_u24lambda_u245.putUserData(MQAccessType.KEY, (Object)MQAccessTypes.SEND_AND_RECEIVE_TYPE);
        SPRING_RABBIT_OPERATIONS_QUEUE_RECEIVE_AND_REPLY = stringArray;
        stringArray = new ArgumentPlace[5];
        stringArray[0] = new MethodArgument("org.springframework.amqp.rabbit.core.RabbitTemplate", "setQueue", 0, 0, 8, null);
        $this$SPRING_RABBIT_OPERATIONS_QUEUE_RECEIVE_AND_REPLY_u24lambda_u245 = new String[]{"deleteQueue", "purgeQueue", "getQueueProperties"};
        stringArray[1] = new MethodArgument("org.springframework.amqp.core.AmqpAdmin", CollectionsKt.listOf((Object[])$this$SPRING_RABBIT_OPERATIONS_QUEUE_RECEIVE_AND_REPLY_u24lambda_u245), 0, 0, null, 24, null);
        stringArray[2] = new ConstructorArgument("org.springframework.amqp.core.Queue", 0, 0, null, 12, null);
        stringArray[3] = new ConstructorArgument("org.springframework.amqp.core.QueueBuilder", 0, 0, null, 12, null);
        $this$SPRING_RABBIT_OPERATIONS_QUEUE_RECEIVE_AND_REPLY_u24lambda_u245 = new String[]{"durable", "nonDurable"};
        stringArray[4] = new MethodArgument("org.springframework.amqp.core.QueueBuilder", CollectionsKt.listOf((Object[])$this$SPRING_RABBIT_OPERATIONS_QUEUE_RECEIVE_AND_REPLY_u24lambda_u245), 0, 0, null, 24, null);
        String[] $this$SPRING_RABBIT_OPERATIONS_QUEUE_ADMINISTRATION_u24lambda_u246 = stringArray = new ArgumentCallSiteCollector("SPRING_RABBIT_OPERATIONS_QUEUE_ADMINISTRATION", CollectionsKt.listOf((Object[])stringArray), null, 4, null);
        boolean bl6 = false;
        $this$SPRING_RABBIT_OPERATIONS_QUEUE_ADMINISTRATION_u24lambda_u246.putUserData(MQAccessType.KEY, (Object)MQAccessTypes.ADMINISTRATION_TYPE);
        SPRING_RABBIT_OPERATIONS_QUEUE_ADMINISTRATION = stringArray;
        stringArray = new ArgumentPlace[]{new ConstructorArgument("org.springframework.amqp.core.DirectExchange", 0, 0, null, 12, null), new MethodArgument("org.springframework.amqp.core.ExchangeBuilder", "directExchange", 0, 0, 8, null)};
        String[] $this$SPRING_RABBIT_OPERATIONS_DIRECT_u24lambda_u247 = stringArray = new ArgumentCallSiteCollector("SPRING_RABBIT_OPERATIONS_DIRECT", CollectionsKt.listOf((Object[])stringArray), null, 4, null);
        boolean bl7 = false;
        $this$SPRING_RABBIT_OPERATIONS_DIRECT_u24lambda_u247.putUserData(MQAccessType.KEY, (Object)MQAccessTypes.ADMINISTRATION_TYPE);
        SPRING_RABBIT_OPERATIONS_DIRECT = stringArray;
        stringArray = new ArgumentPlace[]{new ConstructorArgument("org.springframework.amqp.core.FanoutExchange", 0, 0, null, 12, null), new MethodArgument("org.springframework.amqp.core.ExchangeBuilder", "fanoutExchange", 0, 0, 8, null)};
        String[] $this$SPRING_RABBIT_OPERATIONS_FANOUT_u24lambda_u248 = stringArray = new ArgumentCallSiteCollector("SPRING_RABBIT_OPERATIONS_FANOUT", CollectionsKt.listOf((Object[])stringArray), null, 4, null);
        boolean bl8 = false;
        $this$SPRING_RABBIT_OPERATIONS_FANOUT_u24lambda_u248.putUserData(MQAccessType.KEY, (Object)MQAccessTypes.ADMINISTRATION_TYPE);
        SPRING_RABBIT_OPERATIONS_FANOUT = stringArray;
        stringArray = new ArgumentPlace[]{new ConstructorArgument("org.springframework.amqp.core.HeadersExchange", 0, 0, null, 12, null), new MethodArgument("org.springframework.amqp.core.ExchangeBuilder", "headersExchange", 0, 0, 8, null)};
        String[] $this$SPRING_RABBIT_OPERATIONS_HEADERS_u24lambda_u249 = stringArray = new ArgumentCallSiteCollector("SPRING_RABBIT_OPERATIONS_HEADERS", CollectionsKt.listOf((Object[])stringArray), null, 4, null);
        boolean bl9 = false;
        $this$SPRING_RABBIT_OPERATIONS_HEADERS_u24lambda_u249.putUserData(MQAccessType.KEY, (Object)MQAccessTypes.ADMINISTRATION_TYPE);
        SPRING_RABBIT_OPERATIONS_HEADERS = stringArray;
        stringArray = new ArgumentPlace[]{new ConstructorArgument("org.springframework.amqp.core.TopicExchange", 0, 0, null, 12, null), new MethodArgument("org.springframework.amqp.core.ExchangeBuilder", "topicExchange", 0, 0, 8, null)};
        String[] $this$SPRING_RABBIT_OPERATIONS_TOPIC_u24lambda_u2410 = stringArray = new ArgumentCallSiteCollector("SPRING_RABBIT_OPERATIONS_TOPIC", CollectionsKt.listOf((Object[])stringArray), null, 4, null);
        boolean bl10 = false;
        $this$SPRING_RABBIT_OPERATIONS_TOPIC_u24lambda_u2410.putUserData(MQAccessType.KEY, (Object)MQAccessTypes.ADMINISTRATION_TYPE);
        SPRING_RABBIT_OPERATIONS_TOPIC = stringArray;
        String[] $this$SPRING_RABBIT_BINDING_EXCHANGE_u24lambda_u2411 = stringArray = new ArgumentCallSiteCollector("SPRING_RABBIT_BINDING_EXCHANGE", "org.springframework.amqp.core.Binding", 2);
        boolean bl11 = false;
        $this$SPRING_RABBIT_BINDING_EXCHANGE_u24lambda_u2411.putUserData(MQAccessType.KEY, (Object)MQAccessTypes.ADMINISTRATION_TYPE);
        SPRING_RABBIT_BINDING_EXCHANGE = stringArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0017\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u0011\u0010\u001a\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lcom/intellij/spring/messaging/providers/SpringRabbitTemplateMQResolver$Companion;", "", "<init>", "()V", "SPRING_RABBIT_OPERATIONS_EXCHANGE_SEND", "Lcom/intellij/microservices/jvm/callsites/ArgumentCallSiteCollector;", "getSPRING_RABBIT_OPERATIONS_EXCHANGE_SEND", "()Lcom/intellij/microservices/jvm/callsites/ArgumentCallSiteCollector;", "SPRING_RABBIT_OPERATIONS_EXCHANGE_SEND_AND_RECEIVE", "getSPRING_RABBIT_OPERATIONS_EXCHANGE_SEND_AND_RECEIVE", "SPRING_RABBIT_OPERATIONS_EXCHANGE_ADMINISTRATION", "getSPRING_RABBIT_OPERATIONS_EXCHANGE_ADMINISTRATION", "SPRING_RABBIT_OPERATIONS_QUEUE_RECEIVE", "getSPRING_RABBIT_OPERATIONS_QUEUE_RECEIVE", "SPRING_RABBIT_OPERATIONS_QUEUE_RECEIVE_AND_REPLY", "getSPRING_RABBIT_OPERATIONS_QUEUE_RECEIVE_AND_REPLY", "SPRING_RABBIT_OPERATIONS_QUEUE_ADMINISTRATION", "getSPRING_RABBIT_OPERATIONS_QUEUE_ADMINISTRATION", "SPRING_RABBIT_OPERATIONS_DIRECT", "getSPRING_RABBIT_OPERATIONS_DIRECT", "SPRING_RABBIT_OPERATIONS_FANOUT", "getSPRING_RABBIT_OPERATIONS_FANOUT", "SPRING_RABBIT_OPERATIONS_HEADERS", "getSPRING_RABBIT_OPERATIONS_HEADERS", "SPRING_RABBIT_OPERATIONS_TOPIC", "getSPRING_RABBIT_OPERATIONS_TOPIC", "SPRING_RABBIT_BINDING_EXCHANGE", "getSPRING_RABBIT_BINDING_EXCHANGE", "intellij.spring.messaging"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ArgumentCallSiteCollector getSPRING_RABBIT_OPERATIONS_EXCHANGE_SEND() {
            return SPRING_RABBIT_OPERATIONS_EXCHANGE_SEND;
        }

        @NotNull
        public final ArgumentCallSiteCollector getSPRING_RABBIT_OPERATIONS_EXCHANGE_SEND_AND_RECEIVE() {
            return SPRING_RABBIT_OPERATIONS_EXCHANGE_SEND_AND_RECEIVE;
        }

        @NotNull
        public final ArgumentCallSiteCollector getSPRING_RABBIT_OPERATIONS_EXCHANGE_ADMINISTRATION() {
            return SPRING_RABBIT_OPERATIONS_EXCHANGE_ADMINISTRATION;
        }

        @NotNull
        public final ArgumentCallSiteCollector getSPRING_RABBIT_OPERATIONS_QUEUE_RECEIVE() {
            return SPRING_RABBIT_OPERATIONS_QUEUE_RECEIVE;
        }

        @NotNull
        public final ArgumentCallSiteCollector getSPRING_RABBIT_OPERATIONS_QUEUE_RECEIVE_AND_REPLY() {
            return SPRING_RABBIT_OPERATIONS_QUEUE_RECEIVE_AND_REPLY;
        }

        @NotNull
        public final ArgumentCallSiteCollector getSPRING_RABBIT_OPERATIONS_QUEUE_ADMINISTRATION() {
            return SPRING_RABBIT_OPERATIONS_QUEUE_ADMINISTRATION;
        }

        @NotNull
        public final ArgumentCallSiteCollector getSPRING_RABBIT_OPERATIONS_DIRECT() {
            return SPRING_RABBIT_OPERATIONS_DIRECT;
        }

        @NotNull
        public final ArgumentCallSiteCollector getSPRING_RABBIT_OPERATIONS_FANOUT() {
            return SPRING_RABBIT_OPERATIONS_FANOUT;
        }

        @NotNull
        public final ArgumentCallSiteCollector getSPRING_RABBIT_OPERATIONS_HEADERS() {
            return SPRING_RABBIT_OPERATIONS_HEADERS;
        }

        @NotNull
        public final ArgumentCallSiteCollector getSPRING_RABBIT_OPERATIONS_TOPIC() {
            return SPRING_RABBIT_OPERATIONS_TOPIC;
        }

        @NotNull
        public final ArgumentCallSiteCollector getSPRING_RABBIT_BINDING_EXCHANGE() {
            return SPRING_RABBIT_BINDING_EXCHANGE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/spring/messaging/providers/SpringRabbitTemplateMQResolver$Factory;", "Lcom/intellij/microservices/mq/MQResolverFactory;", "<init>", "()V", "forProject", "", "Lcom/intellij/microservices/mq/MQResolver;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.spring.messaging"})
    public static final class Factory
    implements MQResolverFactory {
        @NotNull
        public List<MQResolver> forProject(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (!SpringMQUtils.INSTANCE.hasSpringAmqpLibrary(project)) {
                return CollectionsKt.emptyList();
            }
            Object[] objectArray = new MQResolver[]{new SpringRabbitTemplateMQResolver(project, (MQType)MQTypes.RABBIT_MQ_EXCHANGE_TYPE, Companion.getSPRING_RABBIT_OPERATIONS_EXCHANGE_SEND()), new SpringRabbitTemplateMQResolver(project, (MQType)MQTypes.RABBIT_MQ_EXCHANGE_TYPE, Companion.getSPRING_RABBIT_OPERATIONS_EXCHANGE_SEND_AND_RECEIVE()), new SpringRabbitTemplateMQResolver(project, (MQType)MQTypes.RABBIT_MQ_EXCHANGE_TYPE, Companion.getSPRING_RABBIT_OPERATIONS_EXCHANGE_ADMINISTRATION()), new SpringRabbitTemplateMQResolver(project, (MQType)MQTypes.RABBIT_MQ_QUEUE_TYPE, Companion.getSPRING_RABBIT_OPERATIONS_QUEUE_RECEIVE()), new SpringRabbitTemplateMQResolver(project, (MQType)MQTypes.RABBIT_MQ_QUEUE_TYPE, Companion.getSPRING_RABBIT_OPERATIONS_QUEUE_RECEIVE_AND_REPLY()), new SpringRabbitTemplateMQResolver(project, (MQType)MQTypes.RABBIT_MQ_QUEUE_TYPE, Companion.getSPRING_RABBIT_OPERATIONS_QUEUE_ADMINISTRATION()), new SpringRabbitTemplateMQResolver(project, (MQType)MQTypes.RABBIT_MQ_DIRECT_TYPE, Companion.getSPRING_RABBIT_OPERATIONS_DIRECT()), new SpringRabbitTemplateMQResolver(project, (MQType)MQTypes.RABBIT_MQ_FANOUT_TYPE, Companion.getSPRING_RABBIT_OPERATIONS_FANOUT()), new SpringRabbitTemplateMQResolver(project, (MQType)MQTypes.RABBIT_MQ_HEADERS_TYPE, Companion.getSPRING_RABBIT_OPERATIONS_HEADERS()), new SpringRabbitTemplateMQResolver(project, (MQType)MQTypes.RABBIT_MQ_TOPIC_TYPE, Companion.getSPRING_RABBIT_OPERATIONS_TOPIC()), new SpringRabbitTemplateMQResolver(project, (MQType)MQTypes.RABBIT_MQ_EXCHANGE_TYPE, Companion.getSPRING_RABBIT_BINDING_EXCHANGE()), new SpringRabbitBindingDestinationMQResolver(project)};
            return CollectionsKt.listOf((Object[])objectArray);
        }
    }
}

