/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.actions;

import com.intellij.icons.AllIcons;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiFile;
import com.intellij.ws.common.CommonWsUtils;
import com.intellij.ws.common.actions.AbstractCreateWebServiceAction;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.constants.RSAnnotations;
import com.intellij.ws.rest.utils.RSUtils;
import org.jetbrains.annotations.NotNull;

final class CreateRestfulWebServiceAction
extends AbstractCreateWebServiceAction {
    public static final String RESTFUL_SERVICE_DISPLAY_NAME_KEY = "restful.service.display.name";

    CreateRestfulWebServiceAction() {
        super(RSBundle.messagePointer(RESTFUL_SERVICE_DISPLAY_NAME_KEY, new Object[0]), RSBundle.messagePointer(RESTFUL_SERVICE_DISPLAY_NAME_KEY, new Object[0]), () -> AllIcons.Javaee.WebService);
    }

    @Override
    protected String getKindName() {
        return RSBundle.message(RESTFUL_SERVICE_DISPLAY_NAME_KEY, new Object[0]);
    }

    @Override
    protected String buildText(String packageQName, String className, PsiFile file) {
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)file);
        JavaeeType javaeeType = module != null ? JavaeeType.discover((Module)module, (JavaeeClass)RSAnnotations.PATH) : JavaeeType.JAVAX;
        return CommonWsUtils.getFromFileTemplateWithCustomParameters(file.getProject(), "JAX-RS Resource.java", "PACKAGE_NAME", packageQName, "CLASS_NAME", className, "JAVAEE_TYPE", javaeeType.pkg);
    }

    @Override
    @NotNull
    protected String getDefaultNewName() {
        return "Resource";
    }

    protected boolean isAvailable(DataContext dataContext) {
        Module module = (Module)PlatformCoreDataKeys.MODULE.getData(dataContext);
        return super.isAvailable(dataContext) && module != null && RSUtils.hasRestLibrary(module);
    }
}

