/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.constants.RSAnnotations;
import com.intellij.ws.rest.constants.RSClassConstants;
import com.intellij.ws.rest.inspections.AbstractRestJavaInspection;
import com.intellij.ws.rest.inspections.fixes.ChangeMethodReturnTypeFix;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class VoidMethodMarkedWithGETInspection
extends AbstractRestJavaInspection {
    @NonNls
    private static final String MVC_VIEW = "jakarta.mvc.View";

    @Override
    protected void checkMethod(@NotNull PsiMethod method, @NotNull ProblemsHolder problemsHolder, @NotNull Module module) {
        if (method == null) {
            VoidMethodMarkedWithGETInspection.$$$reportNull$$$0(0);
        }
        if (problemsHolder == null) {
            VoidMethodMarkedWithGETInspection.$$$reportNull$$$0(1);
        }
        if (module == null) {
            VoidMethodMarkedWithGETInspection.$$$reportNull$$$0(2);
        }
        PsiType type = method.getReturnType();
        PsiTypeElement typeElement = method.getReturnTypeElement();
        JavaeeType javaeeType = JavaeeType.discover((Module)module, (JavaeeClass)RSAnnotations.PATH);
        if (PsiTypes.voidType().equals((Object)type) && AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)RSAnnotations.GET.fqn(javaeeType), (int)1) && typeElement != null && !VoidMethodMarkedWithGETInspection.isSuspendedMethod(method, javaeeType) && !VoidMethodMarkedWithGETInspection.isSseMethod(method, javaeeType) && !VoidMethodMarkedWithGETInspection.isViewAnnotated(method)) {
            problemsHolder.registerProblem((PsiElement)typeElement, RSBundle.message("webservices.inspections.rest.void.method.annotated.as.get.problem", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ChangeMethodReturnTypeFix(RSBundle.message("webservices.inspections.rest.void.method.annotated.as.get.fix.name", new Object[0]))});
        }
    }

    private static boolean isSuspendedMethod(@NotNull PsiMethod method, @NotNull JavaeeType javaeeType) {
        PsiParameter[] parameters;
        if (method == null) {
            VoidMethodMarkedWithGETInspection.$$$reportNull$$$0(3);
        }
        if (javaeeType == null) {
            VoidMethodMarkedWithGETInspection.$$$reportNull$$$0(4);
        }
        for (PsiParameter parameter : parameters = method.getParameterList().getParameters()) {
            PsiType type;
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, (String)RSAnnotations.SUSPENDED.fqn(javaeeType), (int)1) || !((type = parameter.getType()) instanceof PsiClassType) || !InheritanceUtil.isInheritor((PsiClass)((PsiClassType)type).resolve(), (String)RSClassConstants.ASYNC_RESPONSE.fqn(javaeeType))) continue;
            return true;
        }
        return false;
    }

    private static boolean isSseMethod(@NotNull PsiMethod method, @NotNull JavaeeType javaeeType) {
        PsiParameter[] parameters;
        if (method == null) {
            VoidMethodMarkedWithGETInspection.$$$reportNull$$$0(5);
        }
        if (javaeeType == null) {
            VoidMethodMarkedWithGETInspection.$$$reportNull$$$0(6);
        }
        for (PsiParameter parameter : parameters = method.getParameterList().getParameters()) {
            PsiType type;
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, (String)RSAnnotations.CONTEXT.fqn(javaeeType), (int)1) || !((type = parameter.getType()) instanceof PsiClassType) || !InheritanceUtil.isInheritor((PsiClass)((PsiClassType)type).resolve(), (String)RSClassConstants.SSE_EVENT_SINK.fqn(javaeeType))) continue;
            return true;
        }
        return false;
    }

    private static boolean isViewAnnotated(@NotNull PsiMethod method) {
        if (method == null) {
            VoidMethodMarkedWithGETInspection.$$$reportNull$$$0(7);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)MVC_VIEW, (int)0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaeeType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/rest/inspections/VoidMethodMarkedWithGETInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethod";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuspendedMethod";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isSseMethod";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isViewAnnotated";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

