/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat.admin;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.javaee.appServers.deployment.DeploymentModel;
import com.intellij.javaee.appServers.deployment.DeploymentStatus;
import com.intellij.javaee.oss.admin.JavaeeAdminDeployCallback;
import com.intellij.javaee.oss.admin.JavaeeAdminStartCallback;
import com.intellij.javaee.oss.admin.jmx.JavaeeJmxAdminServerBase;
import com.intellij.javaee.oss.admin.jmx.JmxAdminException;
import com.intellij.javaee.oss.server.JavaeeServerInstance;
import com.intellij.javaee.oss.server.WslSupportUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.tomcat.Tomcat4Deployer;
import org.jetbrains.idea.tomcat.TomcatBundle;
import org.jetbrains.idea.tomcat.TomcatContextItem;
import org.jetbrains.idea.tomcat.TomcatContexts;
import org.jetbrains.idea.tomcat.TomcatDeploymentModelBase;
import org.jetbrains.idea.tomcat.TomcatModuleDeploymentModel;
import org.jetbrains.idea.tomcat.TomcatServerXmlWrapper;
import org.jetbrains.idea.tomcat.TomcatStartupPolicy;
import org.jetbrains.idea.tomcat.TomcatUtil;
import org.jetbrains.idea.tomcat.admin.TomEEAgentAdminServerImpl;
import org.jetbrains.idea.tomcat.admin.TomcatAdminServerBase;
import org.jetbrains.idea.tomcat.server.TomcatLocalModel;

public class TomcatAdminLocalServerImpl
extends TomcatAdminServerBase<TomcatLocalModel> {
    @NonNls
    private static final String STARTED_SUFFIX = "org.apache.jk.server.JkMain start";
    @NonNls
    private static final String STARTED_PREFIX = "INFO: Server startup in";
    @NonNls
    private static final String STARTING_MESSAGE = "Starting service Tomcat-Apache";
    @NonNls
    private static final String WORKDIR_ATTR = "workDir";
    @NonNls
    private static final String CONTEXT_CLASS_NAME = "className";
    @NonNls
    private static final String SESSION_MANAGER_ELEMENT = "Manager";
    @NonNls
    private static final String SESSION_PATHNAME_ATTR = "pathname";
    @NonNls
    private static final String SESSION_DIRNAME = "sessions";
    @NonNls
    private static final String SESSION_FILENAME = "SESSIONS.ser";
    private final JavaeeServerInstance myServerInstance;
    private boolean myIsStartedUp = false;

    public TomcatAdminLocalServerImpl(TomcatLocalModel serverModel, TomEEAgentAdminServerImpl tomEEAdmin, JavaeeServerInstance serverInstance, @Nullable String jmxUsername, @Nullable String jmxPassword) {
        super(serverModel, tomEEAdmin, jmxUsername, jmxPassword);
        this.myServerInstance = serverInstance;
    }

    @Override
    public void start(String host, int port, String username, String password, JavaeeAdminStartCallback callback) throws Exception {
        super.start(host, port, username, password, callback);
        this.myServerInstance.getProcessHandler().addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                String text = event.getText();
                if (!TomcatAdminLocalServerImpl.this.myIsStartedUp && TomcatAdminLocalServerImpl.this.isStartingMessage(text)) {
                    TomcatAdminLocalServerImpl.this.myIsStartedUp = true;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/idea/tomcat/admin/TomcatAdminLocalServerImpl$1";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public boolean doConnectTomcat() {
        return this.isUseJmx() ? this.doConnectJmx() : this.myIsStartedUp;
    }

    private boolean isStartingMessage(String text) {
        TomcatLocalModel tomcatModel = (TomcatLocalModel)((Object)this.getServerModel());
        String trimmedText = text.trim();
        if (trimmedText.startsWith(STARTED_PREFIX) || trimmedText.endsWith(STARTED_SUFFIX)) {
            return true;
        }
        if (!tomcatModel.isVersion5OrHigher()) {
            return trimmedText.contains(STARTING_MESSAGE);
        }
        return trimmedText.contains(TomcatStartupPolicy.getDefaultCatalinaFileName() + " start");
    }

    @Override
    public void startDeploy(DeploymentModel deployment, File source, JavaeeAdminDeployCallback callback) {
        try {
            new DeployStep(deployment){

                @Override
                protected void doPerform() throws ExecutionException {
                    TomcatAdminLocalServerImpl.this.undeployBeforeDeploy(this.getDeploymentModel());
                }
            }.perform();
            if (this.isUseJmx()) {
                super.startDeploy(deployment, source, callback);
            } else {
                new DeployStep(deployment){

                    @Override
                    protected void doPerform() {
                        new Tomcat4Deployer((TomcatLocalModel)((Object)TomcatAdminLocalServerImpl.this.getServerModel())).deploy(this.getDeploymentModel().getContextPath());
                    }
                }.perform();
                callback.setDeploymentStatus(deployment, DeploymentStatus.DEPLOYED);
            }
        }
        catch (JmxAdminException e) {
            callback.setDeploymentStatus(deployment, DeploymentStatus.FAILED, (Exception)((Object)e));
        }
    }

    @Override
    protected boolean doDeploy(JavaeeJmxAdminServerBase.DeploymentContext context) throws JmxAdminException {
        final Ref isContextCustom = new Ref();
        new DeployStep(context.getDeploymentModel()){

            @Override
            protected void doPerform() throws ExecutionException {
                TomcatModuleDeploymentModel deploymentModel = this.getDeploymentModel();
                TomcatAdminLocalServerImpl.addApplicationContext(deploymentModel);
                Element tomcatContext = TomcatUtil.findContextElement(((TomcatLocalModel)((Object)TomcatAdminLocalServerImpl.this.getServerModel())).getBaseDirectoryPath(), deploymentModel);
                isContextCustom.set((Object)(tomcatContext != null && tomcatContext.getAttributeValue(TomcatAdminLocalServerImpl.CONTEXT_CLASS_NAME) != null ? 1 : 0));
            }
        }.perform();
        return (Boolean)isContextCustom.get() != false || super.doDeploy(context);
    }

    private void undeployBeforeDeploy(TomcatModuleDeploymentModel deploymentModel) throws ExecutionException {
        TomcatContexts contexts = new TomcatContexts((TomcatLocalModel)((Object)this.getServerModel()), ((TomcatLocalModel)((Object)this.getServerModel())).getBaseDirectoryPath());
        for (TomcatContextItem contextItem : contexts.getItems()) {
            String docBase = contextItem.getElement().getAttributeValue("docBase");
            if (docBase == null || !docBase.equals(deploymentModel.getDeploymentSource().getFilePath())) continue;
            contextItem.remove();
        }
    }

    @Override
    public void startUndeploy(DeploymentModel deployment, File source, JavaeeAdminDeployCallback callback) {
        String contextPath = ((TomcatDeploymentModelBase)deployment).getContextPath();
        if (this.isUseJmx()) {
            String contextXML = TomcatUtil.getContextXML(((TomcatLocalModel)((Object)this.getServerModel())).getBaseDirectoryPath(), contextPath);
            File contextXmlFile = new File(contextXML);
            if (contextXmlFile.exists()) {
                FileUtil.delete((File)contextXmlFile);
            }
            super.startUndeploy(deployment, source, callback);
        } else {
            try {
                new TomcatContexts(null, ((TomcatLocalModel)((Object)this.getServerModel())).getBaseDirectoryPath()).addOrRemoveContextElementInServerXml(contextPath, null);
                new Tomcat4Deployer((TomcatLocalModel)((Object)this.getServerModel())).undeploy(contextPath);
            }
            catch (ExecutionException e) {
                LOG.debug((Throwable)e);
            }
            callback.setDeploymentStatus(deployment, DeploymentStatus.NOT_DEPLOYED);
        }
    }

    @Override
    protected String prepareDeployment(TomcatDeploymentModelBase deploymentModel, String deploymentPath) {
        return deploymentPath;
    }

    @Override
    public void startUpdateDeploymentStatus(DeploymentModel deployment, File source, JavaeeAdminDeployCallback callback) {
        if (this.isUseJmx()) {
            super.startUpdateDeploymentStatus(deployment, source, callback);
        } else {
            try {
                TomcatDeploymentModelBase tomcatDeployment = (TomcatDeploymentModelBase)deployment;
                Element contextElement = TomcatUtil.findContextElement(((TomcatLocalModel)((Object)this.getServerModel())).getBaseDirectoryPath(), tomcatDeployment);
                DeploymentStatus status = contextElement != null ? DeploymentStatus.DEPLOYED : DeploymentStatus.NOT_DEPLOYED;
                callback.setDeploymentStatus(deployment, status);
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public static void addApplicationContext(TomcatDeploymentModelBase tomcatModuleDeploymentModel) throws ExecutionException {
        try {
            String contextXML;
            String deploymentPath;
            TomcatLocalModel serverModel = (TomcatLocalModel)tomcatModuleDeploymentModel.getServerModel();
            String contextPath = tomcatModuleDeploymentModel.getContextPath();
            String tomcatHome = serverModel.getSourceBaseDirectoryPath();
            Element contextElement = TomcatUtil.findContextElement(tomcatHome, tomcatModuleDeploymentModel);
            if (contextElement == null) {
                contextElement = new Element("Context");
            }
            if (serverModel.PRESERVE_SESSIONS && serverModel.isVersion7OrHigher()) {
                String contextName = TomcatUtil.getContextName(contextPath);
                File contextSessionDir = new File(serverModel.getBaseDirectoryPath(), SESSION_DIRNAME + File.separator + contextName);
                if (contextSessionDir.exists() || FileUtil.createDirectory((File)contextSessionDir)) {
                    String contextFilePath = contextSessionDir.getAbsolutePath() + File.separator + SESSION_FILENAME;
                    Element managerElement = new Element(SESSION_MANAGER_ELEMENT);
                    managerElement.setAttribute(SESSION_PATHNAME_ATTR, contextFilePath);
                    contextElement.addContent(managerElement);
                } else {
                    LOG.debug("Can't create context session directory " + contextSessionDir);
                }
            }
            if ((deploymentPath = tomcatModuleDeploymentModel.getDeploymentSource().getFilePath()) == null) {
                throw new ExecutionException(TomcatBundle.message("exception.text.neither.exploded.directory.nor.jar.file.configured", new Object[0]));
            }
            if (!new File(deploymentPath).exists()) {
                throw new ExecutionException(TomcatBundle.message("exception.text.file.not.found.for.web.module", deploymentPath));
            }
            if (tomcatModuleDeploymentModel.getDeploymentSource().isArchive()) {
                contextXML = TomcatUtil.getContextXML(tomcatHome, contextPath);
                String xmlName = new File(contextXML).getName();
                String dirName = xmlName.substring(0, xmlName.length() - 4);
                Element localHost = new TomcatServerXmlWrapper(serverModel.getBaseDirectoryPath()).findLocalHost();
                String appBase = localHost.getAttributeValue("appBase");
                FileUtil.delete((File)new File(appBase, dirName));
            }
            if (!tomcatModuleDeploymentModel.isEEArtifact()) {
                contextElement.setAttribute("path", contextPath);
            }
            if (WslSupportUtil.isWslPath((String)tomcatHome)) {
                contextElement.setAttribute("docBase", WslSupportUtil.fromWinToLinuxMntPath((String)tomcatHome, (String)deploymentPath));
            } else {
                contextElement.setAttribute("docBase", deploymentPath);
            }
            if (serverModel.isVersion5OrHigher()) {
                contextXML = TomcatUtil.getContextXML(serverModel.getBaseDirectoryPath(), contextPath);
                File targetContextXmlFile = new File(contextXML);
                targetContextXmlFile.getParentFile().mkdirs();
                TomcatUtil.saveXMLFile(contextElement, targetContextXmlFile, true);
            } else {
                String root = FileUtil.toSystemDependentName((String)TomcatUtil.getGeneratedFilesPath(serverModel));
                String scratchdir = root + File.separator + "work" + File.separator + new File(TomcatUtil.getContextXML(serverModel.getBaseDirectoryPath(), contextPath)).getName();
                new File(scratchdir).mkdirs();
                contextElement.setAttribute(WORKDIR_ATTR, scratchdir);
                new TomcatContexts(serverModel, serverModel.getBaseDirectoryPath()).addOrRemoveContextElementInServerXml(contextPath, contextElement);
            }
        }
        catch (RuntimeConfigurationException e) {
            throw new ExecutionException(e.getMessage());
        }
    }

    private static abstract class DeployStep {
        private final TomcatModuleDeploymentModel myDeploymentModel;

        DeployStep(DeploymentModel deploymentModel) {
            this.myDeploymentModel = (TomcatModuleDeploymentModel)deploymentModel;
        }

        public final TomcatModuleDeploymentModel getDeploymentModel() {
            return this.myDeploymentModel;
        }

        public void perform() throws JmxAdminException {
            try {
                this.doPerform();
            }
            catch (ExecutionException e) {
                throw new JmxAdminException((Exception)((Object)e));
            }
        }

        protected abstract void doPerform() throws ExecutionException;
    }
}

