/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.mockJDI.members;

import com.intellij.debugger.mockJDI.MockLocalVariable;
import com.intellij.debugger.mockJDI.MockMirror;
import com.intellij.debugger.mockJDI.MockVirtualMachine;
import com.intellij.debugger.mockJDI.types.MockType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class MockPsiMethod
extends MockMirror
implements Method {
    private final PsiMethod myPsiMethod;

    public MockPsiMethod(MockVirtualMachine vm, PsiMethod psiMethod) {
        super(vm);
        this.myPsiMethod = psiMethod;
    }

    @Override
    public String returnTypeName() {
        return this.myPsiMethod.getReturnType().getCanonicalText();
    }

    @Override
    public Type returnType() {
        return MockType.createType(this.myVirtualMachine, this.myPsiMethod.getReturnType());
    }

    @Override
    public List<String> argumentTypeNames() {
        return ContainerUtil.map((Object[])this.myPsiMethod.getParameterList().getParameters(), parameter -> parameter.getType().getCanonicalText());
    }

    @Override
    public List<Type> argumentTypes() {
        return ContainerUtil.map((Object[])this.myPsiMethod.getParameterList().getParameters(), parameter -> MockType.createType(this.myVirtualMachine, parameter.getType()));
    }

    @Override
    public boolean isAbstract() {
        return this.myPsiMethod.hasModifierProperty("abstract");
    }

    @Override
    public boolean isSynchronized() {
        return this.myPsiMethod.hasModifierProperty("synchronized");
    }

    @Override
    public boolean isNative() {
        return this.myPsiMethod.hasModifierProperty("native");
    }

    @Override
    public boolean isVarArgs() {
        return this.myPsiMethod.isVarArgs();
    }

    @Override
    public boolean isBridge() {
        return false;
    }

    @Override
    public boolean isConstructor() {
        return this.myPsiMethod.isConstructor();
    }

    @Override
    public boolean isStaticInitializer() {
        return false;
    }

    @Override
    public boolean isObsolete() {
        return false;
    }

    @Override
    public List<Location> allLineLocations() throws AbsentInformationException {
        throw new AbsentInformationException();
    }

    @Override
    public List<Location> allLineLocations(String s, String s1) throws AbsentInformationException {
        throw new AbsentInformationException();
    }

    @Override
    public List<Location> locationsOfLine(int i2) throws AbsentInformationException {
        throw new AbsentInformationException();
    }

    @Override
    public List<Location> locationsOfLine(String s, String s1, int i2) throws AbsentInformationException {
        throw new AbsentInformationException();
    }

    @Override
    public Location locationOfCodeIndex(long l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<LocalVariable> variables() throws AbsentInformationException {
        throw new AbsentInformationException();
    }

    @Override
    public List<LocalVariable> variablesByName(String s) throws AbsentInformationException {
        throw new AbsentInformationException();
    }

    @Override
    public List<LocalVariable> arguments() {
        return ContainerUtil.map((Object[])this.myPsiMethod.getParameterList().getParameters(), p -> new MockLocalVariable(this.myVirtualMachine, (PsiVariable)p));
    }

    @Override
    public byte[] bytecodes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Location location() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String name() {
        return this.myPsiMethod.getName();
    }

    @Override
    public String signature() {
        return null;
    }

    @Override
    public String genericSignature() {
        return null;
    }

    @Override
    public ReferenceType declaringType() {
        return (ReferenceType)ReadAction.compute(() -> this.myVirtualMachine.createReferenceType(Objects.requireNonNull(this.myPsiMethod.getContainingClass())));
    }

    @Override
    public boolean isStatic() {
        return this.myPsiMethod.hasModifierProperty("static");
    }

    @Override
    public boolean isFinal() {
        return this.myPsiMethod.hasModifierProperty("final");
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    @Override
    public int modifiers() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPrivate() {
        return this.myPsiMethod.hasModifierProperty("private");
    }

    @Override
    public boolean isPackagePrivate() {
        return this.myPsiMethod.hasModifierProperty("packageLocal");
    }

    @Override
    public boolean isProtected() {
        return this.myPsiMethod.hasModifierProperty("protected");
    }

    @Override
    public boolean isPublic() {
        return this.myPsiMethod.hasModifierProperty("public");
    }

    @Override
    public int compareTo(@NotNull Method o) {
        if (o == null) {
            MockPsiMethod.$$$reportNull$$$0(0);
        }
        return this.name().compareTo(o.name());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/debugger/mockJDI/members/MockPsiMethod", "compareTo"));
    }
}

