/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.platform.testFramework.teamCity.GenerifyKt;
import com.intellij.platform.testFramework.teamCity.TeamCityPrinterKt;
import com.intellij.testFramework.ErrorLog;
import com.intellij.testFramework.LoggedError;
import java.io.PrintStream;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"reportAsFailures", "", "Lcom/intellij/testFramework/ErrorLog;", "logAsTeamcityTestFailure", "error", "Lcom/intellij/testFramework/LoggedError;", "findMessage", "", "t", "", "intellij.platform.testFramework.core"})
public final class ErrorLogReportingKt {
    public static final void reportAsFailures(@NotNull ErrorLog $this$reportAsFailures) {
        Intrinsics.checkNotNullParameter((Object)$this$reportAsFailures, (String)"<this>");
        List<LoggedError> errors = $this$reportAsFailures.takeLoggedErrors();
        for (LoggedError error : errors) {
            ErrorLogReportingKt.logAsTeamcityTestFailure(error);
        }
    }

    private static final void logAsTeamcityTestFailure(LoggedError error) {
        String message = ErrorLogReportingKt.findMessage(error);
        String stackTraceContent = ExceptionsKt.stackTraceToString((Throwable)error);
        String stackTraceHash = GenerifyKt.convertToHashCodeWithOnlyLetters(GenerifyKt.generifyErrorMessage(stackTraceContent).hashCode());
        String string = message;
        String generifiedMessage = string == null ? "Error logged without message" : GenerifyKt.generifyErrorMessage(string);
        String testName = stackTraceHash + " (" + generifiedMessage + ")";
        PrintStream printStream = System.out;
        Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"out");
        String string2 = message;
        if (string2 == null) {
            string2 = "";
        }
        TeamCityPrinterKt.reportTestFailure(printStream, testName, string2, stackTraceContent);
    }

    private static final String findMessage(Throwable t) {
        Throwable current = t;
        String message;
        CharSequence charSequence;
        while ((charSequence = (CharSequence)(message = current.getMessage())) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            Throwable cause = current.getCause();
            if (cause == null || Intrinsics.areEqual((Object)cause, (Object)current)) {
                return null;
            }
            current = cause;
        }
        return message;
    }
}

