/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.ide.highlighter;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.protobuf.ide.highlighter.PbSyntaxHighlighter;
import com.intellij.protobuf.lang.psi.PbEnumValue;
import com.intellij.protobuf.lang.psi.PbIdentifierValue;
import com.intellij.protobuf.lang.psi.PbNumberValue;
import com.intellij.protobuf.lang.psi.PbOptionName;
import com.intellij.protobuf.lang.psi.PbTypeName;
import com.intellij.protobuf.lang.psi.PbVisitor;
import com.intellij.protobuf.lang.psi.ProtoNumberValue;
import com.intellij.protobuf.lang.psi.ProtoTokenTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class PbHighlightingAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, final @NotNull AnnotationHolder holder) {
        if (element == null) {
            PbHighlightingAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            PbHighlightingAnnotator.$$$reportNull$$$0(1);
        }
        element.accept((PsiElementVisitor)new PbVisitor(){

            @Override
            public void visitIdentifierValue(@NotNull PbIdentifierValue value) {
                PsiReference ref;
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((ref = value.getReference()) != null) {
                    if (ref.resolve() != null) {
                        PbHighlightingAnnotator.setHighlighting(value, holder, PbSyntaxHighlighter.ENUM_VALUE);
                    }
                } else {
                    ProtoNumberValue numberValue = value.getAsNumber();
                    if (numberValue != null) {
                        this.visitNumberValue(numberValue);
                    } else if (value.getBooleanValue() != null) {
                        PbHighlightingAnnotator.setHighlighting(value, holder, PbSyntaxHighlighter.KEYWORD);
                    }
                }
            }

            @Override
            public void visitNumberValue(@NotNull PbNumberValue number) {
                if (number == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.visitNumberValue((ProtoNumberValue)number);
            }

            void visitNumberValue(@NotNull ProtoNumberValue number) {
                PsiElement numberElement;
                ProtoNumberValue.SourceType sourceType;
                if (number == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (((sourceType = number.getSourceType()) == ProtoNumberValue.SourceType.INF || sourceType == ProtoNumberValue.SourceType.NAN) && (numberElement = number.getNumberElement()) != null) {
                    PbHighlightingAnnotator.setHighlighting(numberElement, holder, PbSyntaxHighlighter.KEYWORD);
                }
            }

            @Override
            public void visitOptionName(@NotNull PbOptionName name) {
                if (name == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (name.isSpecial()) {
                    PbHighlightingAnnotator.setHighlighting(name, holder, PbSyntaxHighlighter.KEYWORD);
                }
            }

            @Override
            public void visitTypeName(@NotNull PbTypeName type) {
                if (type == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (type.isBuiltInType()) {
                    PbHighlightingAnnotator.setHighlighting(type, holder, PbSyntaxHighlighter.KEYWORD);
                }
            }

            public void visitElement(@NotNull PsiElement element) {
                PsiElement parent;
                IElementType type;
                if (element == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (Objects.equals(PbSyntaxHighlighter.getTokenKey(type = element.getNode().getElementType()), PbSyntaxHighlighter.KEYWORD)) {
                    PbHighlightingAnnotator.setHighlighting(element, holder, PbSyntaxHighlighter.KEYWORD);
                } else if (ProtoTokenTypes.IDENTIFIER_LITERAL.equals(type) && (parent = element.getParent()) instanceof PsiNameIdentifierOwner && element.equals(((PsiNameIdentifierOwner)parent).getNameIdentifier())) {
                    PbHighlightingAnnotator.highlightNameIdentifier((PsiNameIdentifierOwner)parent, element, holder);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "number";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/protobuf/ide/highlighter/PbHighlightingAnnotator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitIdentifierValue";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitNumberValue";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitOptionName";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTypeName";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void highlightNameIdentifier(PsiNameIdentifierOwner parent, PsiElement name, AnnotationHolder holder) {
        if (parent instanceof PbEnumValue) {
            PbHighlightingAnnotator.setHighlighting(name, holder, PbSyntaxHighlighter.ENUM_VALUE);
        }
    }

    private static void setHighlighting(@NotNull PsiElement element, @NotNull AnnotationHolder holder, @NotNull TextAttributesKey key) {
        if (element == null) {
            PbHighlightingAnnotator.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            PbHighlightingAnnotator.$$$reportNull$$$0(3);
        }
        if (key == null) {
            PbHighlightingAnnotator.$$$reportNull$$$0(4);
        }
        holder.newSilentAnnotation(HighlightInfoType.SYMBOL_TYPE_SEVERITY).range(element.getTextRange()).textAttributes(key).create();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/intellij/protobuf/ide/highlighter/PbHighlightingAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setHighlighting";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

