/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.GenericJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class JdbcHelperDetection {
    private final List<JdbcHelperImpl> myImpls = JdbcHelperDetection.loadHelpers();
    private final GenericJdbcHelper myGenericHelper = this.findGenericHelper();
    private static JdbcHelperDetection ourInstance;

    private static JdbcHelperDetection getInstance() {
        if (ourInstance == null) {
            ourInstance = new JdbcHelperDetection();
        }
        return ourInstance;
    }

    @NotNull
    public static JdbcHelperImpl detect(@NotNull Connection delegate, @NotNull JdbcHelperImpl fallback, @Nullable String forced) {
        JdbcHelperImpl res;
        block8: {
            JdbcHelperImpl jdbcHelperImpl;
            if (delegate == null) {
                JdbcHelperDetection.$$$reportNull$$$0(0);
            }
            if (fallback == null) {
                JdbcHelperDetection.$$$reportNull$$$0(1);
            }
            try {
                res = JdbcHelperDetection.detectImpl(delegate, fallback);
                JdbcNativeUtil.logInfo("Detected: " + res.getDbmsName() + " " + res.getVersion());
                if (forced == null) break block8;
                JdbcNativeUtil.logWarn("Forced helper: " + forced, null);
                jdbcHelperImpl = fallback.create(res.getVersion(), delegate);
            }
            catch (Exception e) {
                JdbcNativeUtil.logWarn("DBMS detection failed, falling back to " + fallback.getDbmsName(), e);
                JdbcHelperImpl jdbcHelperImpl2 = fallback.create(fallback.getVersion(), delegate);
                if (jdbcHelperImpl2 == null) {
                    JdbcHelperDetection.$$$reportNull$$$0(4);
                }
                return jdbcHelperImpl2;
            }
            if (jdbcHelperImpl == null) {
                JdbcHelperDetection.$$$reportNull$$$0(2);
            }
            return jdbcHelperImpl;
        }
        JdbcHelperImpl jdbcHelperImpl = res;
        if (jdbcHelperImpl == null) {
            JdbcHelperDetection.$$$reportNull$$$0(3);
        }
        return jdbcHelperImpl;
    }

    @NotNull
    public static JdbcHelperImpl detect(@NotNull Driver driver, @Nullable String url, @Nullable String forced) {
        if (driver == null) {
            JdbcHelperDetection.$$$reportNull$$$0(5);
        }
        if (forced == null) {
            return JdbcHelperDetection.detect(driver, url);
        }
        JdbcHelperImpl jdbcHelperImpl = JdbcHelperDetection.getForcedHelper(forced);
        if (jdbcHelperImpl == null) {
            JdbcHelperDetection.$$$reportNull$$$0(6);
        }
        return jdbcHelperImpl;
    }

    private static JdbcHelperImpl getForcedHelper(@NotNull String forced) {
        if (forced == null) {
            JdbcHelperDetection.$$$reportNull$$$0(7);
        }
        for (JdbcHelperImpl impl : JdbcHelperDetection.getInstance().myImpls) {
            if (!forced.equals(impl.getClass().getSimpleName())) continue;
            return impl;
        }
        JdbcNativeUtil.logWarn("Filed to find " + forced + " helper, falling back to generic", null);
        return JdbcHelperDetection.getGenericHelper();
    }

    public static GenericJdbcHelper getGenericHelper() {
        return JdbcHelperDetection.getInstance().myGenericHelper;
    }

    @NotNull
    public static JdbcHelperImpl detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            JdbcHelperDetection.$$$reportNull$$$0(8);
        }
        for (JdbcHelperImpl impl : JdbcHelperDetection.getImplsFor("detect", Driver.class, String.class)) {
            if (!impl.detect(driver, url)) continue;
            JdbcHelperImpl jdbcHelperImpl = impl;
            if (jdbcHelperImpl == null) {
                JdbcHelperDetection.$$$reportNull$$$0(9);
            }
            return jdbcHelperImpl;
        }
        GenericJdbcHelper genericJdbcHelper = JdbcHelperDetection.getGenericHelper();
        if (genericJdbcHelper == null) {
            JdbcHelperDetection.$$$reportNull$$$0(10);
        }
        return genericJdbcHelper;
    }

    @NotNull
    static JdbcHelperImpl detectImpl(@NotNull Connection delegate, @Nullable JdbcHelperImpl connectHelper) throws Exception {
        String version;
        String name;
        if (delegate == null) {
            JdbcHelperDetection.$$$reportNull$$$0(11);
        }
        DatabaseMetaData metaData = delegate.getMetaData();
        try {
            JdbcNativeUtil.logInfo("Driver: " + metaData.getDriverName() + " " + metaData.getDriverVersion());
        }
        catch (Exception e) {
            JdbcNativeUtil.logWarn("Driver version detection failed", e);
        }
        try {
            name = metaData.getDatabaseProductName();
        }
        catch (Throwable th) {
            name = null;
        }
        try {
            version = metaData.getDatabaseProductVersion();
        }
        catch (Throwable th) {
            version = null;
        }
        try {
            return JdbcHelperDetection.detectImpl(delegate, name, version, connectHelper);
        }
        catch (Throwable e) {
            JdbcNativeUtil.logWarn("DBMS detection failed", e);
            return JdbcHelperDetection.detectImpl(null, name, version, connectHelper);
        }
    }

    @NotNull
    @TestOnly
    public static JdbcHelperImpl detect(@Nullable String name, @Nullable String version) throws Exception {
        return JdbcHelperDetection.detectImpl(null, name, version, null);
    }

    @NotNull
    private static JdbcHelperImpl detectImpl(@Nullable Connection delegate, String name, String version, @Nullable JdbcHelperImpl connectHelper) throws Exception {
        for (JdbcHelperImpl impl : JdbcHelperDetection.getImplsFor("detect", Connection.class, String.class, String.class, JdbcHelperImpl.class)) {
            JdbcHelperImpl res = impl.detect(delegate, name, version, connectHelper);
            if (res == null) continue;
            JdbcHelperImpl jdbcHelperImpl = res;
            if (jdbcHelperImpl == null) {
                JdbcHelperDetection.$$$reportNull$$$0(12);
            }
            return jdbcHelperImpl;
        }
        throw new AssertionError((Object)"Should not happen");
    }

    private static Iterable<JdbcHelperImpl> getImplsFor(String name, Class<?> ... params) {
        LinkedHashMap items = new LinkedHashMap();
        for (JdbcHelperImpl impl : JdbcHelperDetection.getInstance().myImpls) {
            try {
                Class<?> declaring = impl.getClass().getMethod(name, params).getDeclaringClass();
                if (items.containsKey(declaring)) continue;
                items.put(declaring, impl);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }
        ArrayList entries = new ArrayList(items.entrySet());
        Collections.sort(entries, (o1, o2) -> JdbcHelperDetection.compareClasses((Class)o1.getKey(), (Class)o2.getKey()));
        return entries.stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    private static int compareClasses(Class<?> o1, Class<?> o2) {
        if (o1.equals(o2)) {
            return 0;
        }
        if (o1.isAssignableFrom(o2)) {
            return 1;
        }
        if (o2.isAssignableFrom(o1)) {
            return -1;
        }
        return 0;
    }

    private GenericJdbcHelper findGenericHelper() {
        for (JdbcHelperImpl helper : this.myImpls) {
            if (!(helper instanceof GenericJdbcHelper)) continue;
            return (GenericJdbcHelper)helper;
        }
        throw new AssertionError((Object)"Failed to find generic helper");
    }

    private static List<JdbcHelperImpl> loadHelpers() {
        ServiceLoader<JdbcHelperImpl> loader = ServiceLoader.load(JdbcHelperImpl.class);
        Iterator<JdbcHelperImpl> it = loader.iterator();
        ArrayList<JdbcHelperImpl> res = new ArrayList<JdbcHelperImpl>();
        while (it.hasNext()) {
            res.add(it.next());
        }
        List<JdbcHelperImpl> sorted = new CompleteOrderBuilder<JdbcHelperImpl>(new Comparator<JdbcHelperImpl>(){

            @Override
            public int compare(JdbcHelperImpl o1, JdbcHelperImpl o2) {
                int ord1 = this.protectOverflow(o1.relOrder(o2));
                int ord2 = -this.protectOverflow(o2.relOrder(o1));
                return Math.abs(ord1) > Math.abs(ord2) ? ord1 : ord2;
            }

            private int protectOverflow(int v) {
                return v == Integer.MIN_VALUE ? v + 1 : v;
            }
        }).sort(res);
        return sorted;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallback";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/JdbcHelperDetection";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forced";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/JdbcHelperDetection";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "detect";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "detectImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getForcedHelper";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "detectImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CompleteOrderBuilder<T> {
        private final Comparator<T> myPartialOrder;

        public CompleteOrderBuilder(Comparator<T> partialOrder) {
            this.myPartialOrder = partialOrder;
        }

        public List<T> sort(@NotNull List<T> list) {
            if (list == null) {
                CompleteOrderBuilder.$$$reportNull$$$0(0);
            }
            IntOpenHashSet visited = new IntOpenHashSet();
            ArrayList res = new ArrayList(list.size());
            for (int i = 0; i < list.size(); ++i) {
                if (visited.contains(i) || !this.isFirst(list, i, (IntSet)visited)) continue;
                this.visitFrom(list, i, (IntSet)visited, res);
            }
            return res;
        }

        private void visitFrom(@NotNull List<T> list, int last, IntSet visited, List<T> res) {
            if (list == null) {
                CompleteOrderBuilder.$$$reportNull$$$0(1);
            }
            IntArrayList stack = new IntArrayList();
            stack.add(last);
            while (!stack.isEmpty()) {
                int idx = stack.removeInt(stack.size() - 1);
                if (!visited.add(idx)) continue;
                res.add(list.get(idx));
                for (int i = 0; i < list.size(); ++i) {
                    if (visited.contains(i) || !this.isBefore(list, idx, i) || !this.isFirst(list, i, visited)) continue;
                    stack.add(i);
                }
            }
        }

        public boolean isBefore(@NotNull List<T> list, int i1, int i2) {
            if (list == null) {
                CompleteOrderBuilder.$$$reportNull$$$0(2);
            }
            return i1 != i2 && this.myPartialOrder.compare(list.get(i1), list.get(i2)) < 0;
        }

        private boolean isFirst(@NotNull List<T> list, int i, @NotNull IntSet filter) {
            if (list == null) {
                CompleteOrderBuilder.$$$reportNull$$$0(3);
            }
            if (filter == null) {
                CompleteOrderBuilder.$$$reportNull$$$0(4);
            }
            for (int j = 0; j < list.size(); ++j) {
                if (filter.contains(j) || !this.isBefore(list, j, i)) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/JdbcHelperDetection$CompleteOrderBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sort";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitFrom";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isBefore";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isFirst";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

