/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.remote.jdbc.RemoteCloseable;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.database.remote.jdbc.impl.UnparsedValueKind;
import com.intellij.execution.rmi.ssl.SslKeyStore;
import java.io.Serializable;
import java.security.Key;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SFlakeJdbcHelper
extends JdbcHelperImpl {
    private static final Set<String> SFLAKE_UNLIMITED_TYPES = JdbcNativeUtil.addAll(new HashSet(), "DOUBLE", "ARRAY", "OBJECT", "VARIANT", "BOOLEAN", "DATE", "BINARY");
    private static final Set<String> SFLAKE_TIME_TYPES = JdbcNativeUtil.addAll(new HashSet(), "TIME", "TIMESTAMPTZ", "TIMESTAMPLTZ", "TIMESTAMPNTZ");

    public SFlakeJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super("SNOWFLAKE", version, connection);
    }

    public SFlakeJdbcHelper() {
        this(null, null);
    }

    @Override
    public JdbcHelperImpl create(@Nullable String version, @Nullable Connection connection) {
        return new SFlakeJdbcHelper(version, connection);
    }

    @Override
    @Nullable
    public RemoteCloseable setStatementParameter(@NotNull RemotePreparedStatement statement, @Nullable Object value, @NotNull ColumnInfo columnInfo, boolean needsEscaping, int idx) throws Exception {
        if (statement == null) {
            SFlakeJdbcHelper.$$$reportNull$$$0(0);
        }
        if (columnInfo == null) {
            SFlakeJdbcHelper.$$$reportNull$$$0(1);
        }
        if (columnInfo.getType() != 93 || !(value instanceof Timestamp) || !"TIMESTAMPNTZ".equals(columnInfo.getTypeName())) {
            return super.setStatementParameter(statement, value, columnInfo, needsEscaping, idx);
        }
        statement.setString(idx, value.toString());
        return null;
    }

    @Override
    @Nullable
    public UnparsedValueKind detectUnparsedValueKind(@Nullable String typeName, int jdbcType) {
        if ("TIMESTAMPTZ".equals(typeName) || "TIMESTAMPLTZ".equals(typeName)) {
            return UnparsedValueKind.ZONED_TIMESTAMP;
        }
        return super.detectUnparsedValueKind(typeName, jdbcType);
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            SFlakeJdbcHelper.$$$reportNull$$$0(2);
        }
        if (e.typeName != null && SFLAKE_UNLIMITED_TYPES.contains(e.typeName)) {
            e.length = -1;
        } else if (e.typeName != null && SFLAKE_TIME_TYPES.contains(e.typeName)) {
            e.length = e.scale;
            e.scale = 0;
        }
    }

    @Override
    @Nullable
    public JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer, @Nullable JdbcHelperImpl connectHelper) {
        if (!JdbcNativeUtil.detectString(product, "snowflake")) {
            return null;
        }
        return SFlakeJdbcHelper.create(delegate, productVer);
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            SFlakeJdbcHelper.$$$reportNull$$$0(3);
        }
        return SFlakeJdbcHelper.classNameContains(driver, "snowflake");
    }

    @Override
    @Nullable
    public Connection connect(@NotNull Driver driver, String url, @NotNull Properties properties, @NotNull Map<String, Serializable> extra) throws SQLException {
        Key userKey;
        if (driver == null) {
            SFlakeJdbcHelper.$$$reportNull$$$0(4);
        }
        if (properties == null) {
            SFlakeJdbcHelper.$$$reportNull$$$0(5);
        }
        if (extra == null) {
            SFlakeJdbcHelper.$$$reportNull$$$0(6);
        }
        if ((userKey = SslKeyStore.getUserKey()) != null) {
            properties.put("privateKey", userKey);
        }
        return super.connect(driver, url, properties, extra);
    }

    @Override
    public JdbcSettings.SslMode[] supportedSslModes() {
        return new JdbcSettings.SslMode[]{JdbcSettings.SslMode.REQUIRE};
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return SFlakeJdbcHelper.extractVersion(version);
    }

    @NotNull
    private static SFlakeJdbcHelper create(@Nullable Connection delegate, @Nullable String productVer) {
        JdbcNativeUtil.logInfo("getDatabaseProductVersion: " + productVer);
        return new SFlakeJdbcHelper(SFlakeJdbcHelper.extractVersion(productVer), delegate);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    @Override
    public boolean supportsIlike() {
        return true;
    }

    @Override
    @Nullable
    protected JdbcHelperImpl.TemporalGetter getTemporalGetter(@Nullable String typeName, int type) {
        return type == 91 ? DATE_GETTER_IMPLICIT_TZ : super.getTemporalGetter(typeName, type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extra";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/SFlakeJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setStatementParameter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "detect";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "connect";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

