/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.connections;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.util.paths.VirtualFileMapping;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.perforce.ConnectionId;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.P4ConnectionParameters;
import org.jetbrains.idea.perforce.perforce.connections.P4ParametersConnection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionMapper;

public class PerforceMultipleConnections
implements PerforceConnectionMapper {
    @Nullable
    private final String myP4ConfigValue;
    private final VirtualFileMapping<P4ConnectionParameters> myParametersMap = new VirtualFileMapping();
    private final P4ConnectionParameters myDefaultParameters;
    private final Map<VirtualFile, P4ParametersConnection> myConnectionMap = new HashMap<VirtualFile, P4ParametersConnection>();
    private final Object myLock = new Object();
    private final Map<VirtualFile, File> myConfigsMap;

    public PerforceMultipleConnections(@Nullable String p4ConfigValue, P4ConnectionParameters defaultParameters, Map<VirtualFile, P4ConnectionParameters> parametersMap, Map<VirtualFile, File> configsMap) {
        this.myP4ConfigValue = p4ConfigValue;
        this.myDefaultParameters = defaultParameters;
        this.myConfigsMap = configsMap;
        for (Map.Entry<VirtualFile, P4ConnectionParameters> entry : parametersMap.entrySet()) {
            this.myParametersMap.add(entry.getKey(), (Object)entry.getValue());
        }
    }

    public P4ConnectionParameters getDefaultParameters() {
        return this.myDefaultParameters;
    }

    @Nullable
    public String getP4ConfigValue() {
        return this.myP4ConfigValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public P4ParametersConnection getConnection(@NotNull VirtualFile file) {
        if (file == null) {
            PerforceMultipleConnections.$$$reportNull$$$0(0);
        }
        Object object = this.myLock;
        synchronized (object) {
            P4ParametersConnection cached = this.myConnectionMap.get(file);
            if (cached != null) {
                return cached;
            }
        }
        @NotNull @NotNull Pair pair = this.myParametersMap.getMappingAndRootFor(file);
        if (pair == null) {
            return null;
        }
        Object object2 = this.myLock;
        synchronized (object2) {
            return this.createOrGetConnectionByParameters((VirtualFile)pair.first, (P4ConnectionParameters)pair.second);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private P4ParametersConnection createOrGetConnectionByParameters(VirtualFile vf, P4ConnectionParameters parameters) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myConnectionMap.containsKey(vf)) {
                return this.myConnectionMap.get(vf);
            }
            P4ConnectionParameters withParent = parameters.hasProblems() ? parameters : new P4ConnectionParameters(parameters);
            P4ParametersConnection connection = new P4ParametersConnection(withParent, new ConnectionId(this.myP4ConfigValue, vf.getPath()));
            this.myConnectionMap.put(vf, connection);
            return connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<VirtualFile, P4Connection> getAllConnections() {
        Object object = this.myLock;
        synchronized (object) {
            for (Pair entry : this.myParametersMap.entries()) {
                this.createOrGetConnectionByParameters((VirtualFile)entry.first, (P4ConnectionParameters)entry.second);
            }
            return Collections.unmodifiableMap(this.myConnectionMap);
        }
    }

    @NotNull
    public Collection<Pair<VirtualFile, P4ConnectionParameters>> getAllConnectionParameters() {
        Collection collection = this.myParametersMap.entries();
        if (collection == null) {
            PerforceMultipleConnections.$$$reportNull$$$0(1);
        }
        return collection;
    }

    public boolean hasAnyErrors() {
        if (this.myDefaultParameters.hasProblems()) {
            return true;
        }
        for (P4ConnectionParameters parameters : this.myParametersMap.values()) {
            if (!parameters.hasProblems()) continue;
            return true;
        }
        return false;
    }

    public Map<VirtualFile, File> getConfigsMap() {
        return this.myConfigsMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/perforce/connections/PerforceMultipleConnections";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/perforce/connections/PerforceMultipleConnections";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllConnectionParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConnection";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

