/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.connections;

import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.time.Duration;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.ftp.FtpClient;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystem;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.ftp.JBFtpKeepAliveCommand;

public class PatchedFtpFileSystem
extends FtpFileSystem {
    private static final Logger LOG = Logger.getInstance(PatchedFtpFileSystem.class);
    private final FtpClientPool ftpClientPool;

    public PatchedFtpFileSystem(GenericFileName rootName, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
        GenericObjectPoolConfig<FtpClient> poolConfig = new GenericObjectPoolConfig<FtpClient>();
        poolConfig.setMaxTotal(FtpFileSystemConfigBuilder.getInstance().getConnections(fileSystemOptions));
        poolConfig.setLifo(false);
        Duration keepAliveTimeout = FtpFileSystemConfigBuilder.getInstance().getControlKeepAliveTimeout(fileSystemOptions);
        if (keepAliveTimeout != null) {
            poolConfig.setTestWhileIdle(true);
            poolConfig.setTimeBetweenEvictionRunsMillis(keepAliveTimeout.toMillis());
            poolConfig.setEvictionPolicy((config, underTest, idleCount) -> false);
        }
        JBFtpKeepAliveCommand keepAliveCommand = FtpFileSystemConfigBuilder.getInstance().getKeepAliveCommand(fileSystemOptions);
        this.ftpClientPool = new FtpClientPool(new FtpClientFactory(keepAliveCommand), poolConfig);
    }

    @Override
    protected void doCloseCommunicationLink() {
        this.ftpClientPool.clear();
    }

    @Override
    public FtpClient getClient() throws FileSystemException {
        try {
            return (FtpClient)this.ftpClientPool.borrowObject();
        }
        catch (Exception e) {
            throw new FileSystemException(e);
        }
    }

    @Override
    public void putClient(FtpClient client) {
        this.ftpClientPool.returnObject(client);
    }

    public static class FtpClientPool
    extends GenericObjectPool<FtpClient> {
        public FtpClientPool(PooledObjectFactory<FtpClient> factory, GenericObjectPoolConfig<FtpClient> config) {
            super(factory, config);
        }
    }

    private class FtpClientFactory
    extends BasePooledObjectFactory<FtpClient> {
        final JBFtpKeepAliveCommand myKeepAliveCommand;

        private FtpClientFactory(JBFtpKeepAliveCommand keepAliveCommand) {
            this.myKeepAliveCommand = keepAliveCommand;
        }

        @Override
        public FtpClient create() throws FileSystemException {
            return PatchedFtpFileSystem.this.createWrapper();
        }

        @Override
        public PooledObject<FtpClient> wrap(FtpClient ftpClient) {
            return new DefaultPooledObject<FtpClient>(ftpClient);
        }

        @Override
        public void destroyObject(PooledObject<FtpClient> p) throws IOException {
            FtpClient client = p.getObject();
            try {
                if (client.isConnected()) {
                    client.disconnect();
                }
            }
            catch (IOException e) {
                LOG.warn("Could not close connection to FTP server.", (Throwable)e);
            }
        }

        @Override
        public boolean validateObject(PooledObject<FtpClient> p) {
            FtpClient client = p.getObject();
            try {
                this.myKeepAliveCommand.invoke(client);
                return client.isConnected();
            }
            catch (IOException e) {
                LOG.warn("Failed to send keep-alive message.", (Throwable)e);
                return false;
            }
        }
    }
}

