/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.psi.AopPsiTypePattern;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;

public class ConcatenationPattern
extends AopPsiTypePattern {
    private final AopPsiTypePattern myLeft;
    private final AopPsiTypePattern myRight;
    private final boolean myDoubleDot;

    public ConcatenationPattern(AopPsiTypePattern left, AopPsiTypePattern right, boolean doubleDot) {
        this.myLeft = left;
        this.myRight = right;
        this.myDoubleDot = doubleDot;
    }

    public boolean isDoubleDot() {
        return this.myDoubleDot;
    }

    public AopPsiTypePattern getLeft() {
        return this.myLeft;
    }

    public AopPsiTypePattern getRight() {
        return this.myRight;
    }

    @Override
    public boolean accepts(@NotNull PsiType type) {
        String qname;
        PsiClassType classType;
        PsiClass psiClass;
        if (type == null) {
            ConcatenationPattern.$$$reportNull$$$0(0);
        }
        return type instanceof PsiClassType && (psiClass = (classType = (PsiClassType)type).resolve()) != null && (qname = psiClass.getQualifiedName()) != null && this.accepts(qname);
    }

    @Override
    public boolean accepts(@NotNull String qualifiedName) {
        int i;
        if (qualifiedName == null) {
            ConcatenationPattern.$$$reportNull$$$0(1);
        }
        String[] strings = qualifiedName.split("\\.");
        int[] indices = new int[strings.length];
        indices[0] = -1;
        for (int i2 = 1; i2 < indices.length; ++i2) {
            indices[i2] = indices[i2 - 1] + strings[i2 - 1].length() + 1;
        }
        boolean[] rights = new boolean[strings.length];
        if (this.myDoubleDot) {
            for (i = 1; i < indices.length; ++i) {
                rights[i] = this.myRight.accepts(qualifiedName.substring(indices[i] + 1));
            }
        }
        for (i = 1; i < indices.length; ++i) {
            int index = indices[i];
            if (!this.myLeft.accepts(qualifiedName.substring(0, index))) continue;
            if (this.myDoubleDot) {
                for (int j = i; j < indices.length; ++j) {
                    if (!rights[j]) continue;
                    return true;
                }
                continue;
            }
            if (!this.myRight.accepts(qualifiedName.substring(index + 1))) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "type";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "qualifiedName";
                break;
            }
        }
        objectArray[1] = "com/intellij/aop/psi/ConcatenationPattern";
        objectArray[2] = "accepts";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

