/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module;

import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.facet.frameworks.LibrariesDownloadAssistant;
import com.intellij.facet.ui.FacetEditorsFactory;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.facet.ui.libraries.FacetLibrariesValidator;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.JavaeeVersion;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiFile;
import java.net.URL;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class JavaeeLibrariesUtil {
    private JavaeeLibrariesUtil() {
    }

    public static void addJavaeeLibrary(Module module, JavaeeVersion javaeeVersion) {
        FacetLibrariesValidator validator = FacetEditorsFactory.getInstance().createLibrariesValidator(JavaeeLibrariesUtil.getJavaeeLibraryInfos(javaeeVersion), module, javaeeVersion.getPresentableName());
        ValidationResult validationResult = validator.check();
        if (!validationResult.isOk()) {
            validationResult.getQuickFix().run((JComponent)WindowManager.getInstance().getFrame(module.getProject()).getRootPane());
        }
    }

    public static IntentionAndQuickFixAction createAddJavaeeLibraryQuickFix(Module module, @Nls String familyName) {
        return new AddJ2EEJarIntentionAction(module, familyName, JavaeeLibrariesUtil.getJavaeeVersion(ModuleRootManager.getInstance((Module)module).getSdk()));
    }

    public static LibraryInfo[] getJavaeeLibraryInfos(JavaeeVersion javaeeVersion) {
        LibraryInfo[] libs = LibrariesDownloadAssistant.getLibraryInfos((URL)JavaeeVersion.class.getResource("/resources/versions/javaee.xml"), (String)javaeeVersion.getId());
        assert (libs.length > 0);
        return libs;
    }

    @NotNull
    private static JavaeeVersion getJavaeeVersion(Sdk projectJdk) {
        JavaeeVersion javaeeVersion = projectJdk != null && JavaSdk.getInstance().isOfVersionOrHigher(projectJdk, JavaSdkVersion.JDK_1_5) ? JavaeeVersion.JAVAEE_6 : JavaeeVersion.J2EE_1_4;
        if (javaeeVersion == null) {
            JavaeeLibrariesUtil.$$$reportNull$$$0(0);
        }
        return javaeeVersion;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/JavaeeLibrariesUtil", "getJavaeeVersion"));
    }

    private static class AddJ2EEJarIntentionAction
    extends IntentionAndQuickFixAction {
        private final Module myModule;
        @Nls
        private final String myFamilyName;
        private final JavaeeVersion myJavaeeVersion;

        AddJ2EEJarIntentionAction(Module module, @Nls String familyName, JavaeeVersion javaeeVersion) {
            this.myModule = module;
            this.myFamilyName = familyName;
            this.myJavaeeVersion = javaeeVersion;
        }

        @NotNull
        public String getName() {
            String string = J2EEBundle.message((String)"intention.add.javaee.jar.text", (Object[])new Object[]{this.myJavaeeVersion.getPresentableName()});
            if (string == null) {
                AddJ2EEJarIntentionAction.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.myFamilyName;
            if (string == null) {
                AddJ2EEJarIntentionAction.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, PsiFile file, Editor editor) {
            if (project == null) {
                AddJ2EEJarIntentionAction.$$$reportNull$$$0(2);
            }
            JavaeeLibrariesUtil.addJavaeeLibrary(this.myModule, this.myJavaeeVersion);
        }

        public boolean startInWriteAction() {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            AddJ2EEJarIntentionAction that = (AddJ2EEJarIntentionAction)((Object)o);
            return this.myFamilyName.equals(that.myFamilyName) && this.myModule.equals(that.myModule);
        }

        public int hashCode() {
            int result = this.myModule.hashCode();
            result = 29 * result + this.myFamilyName.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javaee/module/JavaeeLibrariesUtil$AddJ2EEJarIntentionAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javaee/module/JavaeeLibrariesUtil$AddJ2EEJarIntentionAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

