/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui.packaging;

import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.ui.packaging.JavaeeArtifactTypeBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import org.jetbrains.annotations.Nls;

public class ArchiveArtifactTemplate
extends ArtifactTemplate {
    private final Artifact myArtifact;
    private final PackagingElementResolvingContext myContext;
    private final JavaeeArtifactTypeBase myArchiveArtifactType;

    public ArchiveArtifactTemplate(Artifact artifact, PackagingElementResolvingContext context, JavaeeArtifactTypeBase archiveArtifactType) {
        this.myArtifact = artifact;
        this.myContext = context;
        this.myArchiveArtifactType = archiveArtifactType;
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    public String getPresentableName() {
        return J2EEBundle.message((String)"for.0", (Object[])new Object[]{this.myArtifact.getName()});
    }

    public ArtifactTemplate.NewArtifactConfiguration createArtifact() {
        String explodedName = this.myArtifact.getName();
        Object archiveName = StringUtil.trimEnd((String)explodedName, (String)" exploded");
        if (((String)archiveName).equals(explodedName)) {
            archiveName = (String)archiveName + " archive";
        }
        CompositePackagingElement element = this.myArchiveArtifactType.createRootElement((String)archiveName);
        ArtifactPointer pointer = ArtifactPointerManager.getInstance((Project)this.myContext.getProject()).createPointer(this.myArtifact, this.myContext.getArtifactModel());
        element.addOrFindChild(PackagingElementFactory.getInstance().createArtifactElement(pointer, this.myContext.getProject()));
        return new ArtifactTemplate.NewArtifactConfiguration(element, (String)archiveName, (ArtifactType)this.myArchiveArtifactType);
    }
}

