/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.java.declared.debug;

import com.intellij.analysis.pwa.debug.PwaDebugSymbol;
import com.intellij.analysis.pwa.java.declared.debug.SymbolSignature;
import com.intellij.analysis.pwa.java.utils.PwaJavaHashUtils;
import com.intellij.openapi.util.Segment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u001d\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000fR\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lcom/intellij/analysis/pwa/java/declared/debug/JavaPwaDeclaration;", "Lcom/intellij/analysis/pwa/debug/PwaDebugSymbol;", "name", "", "symbolSignature", "Lcom/intellij/analysis/pwa/java/declared/debug/SymbolSignature;", "hashes", "Lcom/intellij/analysis/pwa/java/utils/PwaJavaHashUtils$Hash;", "elementPtr", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "conflictingDeclaration", "<init>", "(Ljava/lang/String;Lcom/intellij/analysis/pwa/java/declared/debug/SymbolSignature;Lcom/intellij/analysis/pwa/java/utils/PwaJavaHashUtils$Hash;Lcom/intellij/psi/SmartPsiElementPointer;Lcom/intellij/analysis/pwa/java/declared/debug/JavaPwaDeclaration;)V", "getName", "()Ljava/lang/String;", "getElementPtr", "()Lcom/intellij/psi/SmartPsiElementPointer;", "nameHash", "", "getNameHash", "()I", "signatureHash", "getSignatureHash", "signature", "getSignature", "startOffset", "getStartOffset", "()Ljava/lang/Integer;", "toString", "intellij.java.pwa"})
public final class JavaPwaDeclaration
implements PwaDebugSymbol {
    @NotNull
    private final String name;
    @NotNull
    private final SymbolSignature symbolSignature;
    @NotNull
    private final PwaJavaHashUtils.Hash hashes;
    @NotNull
    private final SmartPsiElementPointer<PsiElement> elementPtr;
    @Nullable
    private final JavaPwaDeclaration conflictingDeclaration;

    public JavaPwaDeclaration(@NotNull String name, @NotNull SymbolSignature symbolSignature, @NotNull PwaJavaHashUtils.Hash hashes, @NotNull SmartPsiElementPointer<PsiElement> elementPtr, @Nullable JavaPwaDeclaration conflictingDeclaration) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)symbolSignature, (String)"symbolSignature");
        Intrinsics.checkNotNullParameter((Object)hashes, (String)"hashes");
        Intrinsics.checkNotNullParameter(elementPtr, (String)"elementPtr");
        this.name = name;
        this.symbolSignature = symbolSignature;
        this.hashes = hashes;
        this.elementPtr = elementPtr;
        this.conflictingDeclaration = conflictingDeclaration;
    }

    public /* synthetic */ JavaPwaDeclaration(String string, SymbolSignature symbolSignature, PwaJavaHashUtils.Hash hash, SmartPsiElementPointer smartPsiElementPointer, JavaPwaDeclaration javaPwaDeclaration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            javaPwaDeclaration = null;
        }
        this(string, symbolSignature, hash, (SmartPsiElementPointer<PsiElement>)smartPsiElementPointer, javaPwaDeclaration);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final SmartPsiElementPointer<PsiElement> getElementPtr() {
        return this.elementPtr;
    }

    public int getNameHash() {
        return this.hashes.getNameHash();
    }

    public int getSignatureHash() {
        return this.hashes.getSignatureHash();
    }

    @NotNull
    public String getSignature() {
        return this.symbolSignature.toString();
    }

    @Nullable
    public Integer getStartOffset() {
        Segment segment = this.elementPtr.getRange();
        return segment != null ? Integer.valueOf(segment.getStartOffset()) : null;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u240.append(this.getName());
        $this$toString_u24lambda_u240.append("#");
        $this$toString_u24lambda_u240.append(this.symbolSignature);
        if (this.conflictingDeclaration != null) {
            $this$toString_u24lambda_u240.append(" conflicts with ");
            $this$toString_u24lambda_u240.append(this.conflictingDeclaration);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

