/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.java.support;

import com.intellij.analysis.pwa.support.PwaFileFilter;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/analysis/pwa/java/support/JavaPwaFileFilter;", "Lcom/intellij/analysis/pwa/support/PwaFileFilter;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "projectFileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "fastShouldAnalyse", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "shouldAnalyse", "psiFile", "Lcom/intellij/psi/PsiFile;", "intellij.java.pwa"})
public final class JavaPwaFileFilter
implements PwaFileFilter {
    @NotNull
    private final ProjectFileIndex projectFileIndex;

    public JavaPwaFileFilter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        this.projectFileIndex = projectFileIndex;
    }

    public boolean fastShouldAnalyse(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.isDirectory()) {
            return false;
        }
        return FileTypeRegistry.getInstance().isFileOfType(file, (FileType)JavaFileType.INSTANCE);
    }

    public boolean shouldAnalyse(@NotNull VirtualFile file, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        if (!(psiFile instanceof PsiJavaFile)) {
            return false;
        }
        return this.projectFileIndex.isUnderSourceRootOfType(file, JavaModuleSourceRootTypes.SOURCES);
    }
}

