/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.java.used;

import com.intellij.analysis.pwa.java.used.JavaUsedDependenciesVisitor;
import com.intellij.analysis.pwa.java.used.JavaUsedSymbolsSink;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.SyntaxTraverser;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a&\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0000\u001a\u0018\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0002H\u0000\u001a\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001aM\u0010\u0013\u001a\u00020\u00012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00182\u0006\u0010\u001c\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u001d\u00a8\u0006\u001e"}, d2={"emit", "", "Lcom/intellij/analysis/pwa/java/used/JavaUsedSymbolsSink;", "qualifiedName", "", "referenceName", "onContent", "", "emitCodeReferenceElement", "reference", "Lcom/intellij/psi/PsiJavaCodeReferenceElement;", "sink", "collectUsedDependencies", "file", "Lcom/intellij/psi/PsiJavaFile;", "collectSuperClasses", "", "aClass", "Lcom/intellij/psi/PsiClass;", "collectSupersFromList", "extendsListTypes", "", "Lcom/intellij/psi/PsiClassType;", "passed", "Ljava/util/HashSet;", "queue", "Ljava/util/ArrayDeque;", "possibleClassNames", "containingFile", "([Lcom/intellij/psi/PsiClassType;Ljava/util/HashSet;Ljava/util/ArrayDeque;Ljava/util/HashSet;Lcom/intellij/psi/PsiJavaFile;)V", "intellij.java.pwa"})
public final class JavaUsedSymbolsVisitorKt {
    private static final void emit(JavaUsedSymbolsSink $this$emit, String qualifiedName, String referenceName, boolean onContent) {
        if (qualifiedName == null) {
            $this$emit.emit(referenceName, onContent);
        } else {
            $this$emit.emit(qualifiedName + "." + referenceName, onContent);
        }
    }

    public static final void emitCodeReferenceElement(@NotNull PsiJavaCodeReferenceElement reference, @NotNull JavaUsedSymbolsSink sink) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        PsiElement psiElement = reference.getQualifier();
        PsiJavaCodeReferenceElement qualifier = psiElement instanceof PsiJavaCodeReferenceElement ? (PsiJavaCodeReferenceElement)psiElement : null;
        String name = reference.getReferenceName();
        if (name != null) {
            PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = qualifier;
            JavaUsedSymbolsVisitorKt.emit(sink, psiJavaCodeReferenceElement != null ? psiJavaCodeReferenceElement.getQualifiedName() : null, name, false);
        }
    }

    public static final void collectUsedDependencies(@NotNull PsiJavaFile file, @NotNull JavaUsedSymbolsSink sink) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)file));
        Intrinsics.checkNotNullExpressionValue((Object)syntaxTraverser, (String)"psiTraverser(...)");
        SyntaxTraverser traverser = syntaxTraverser;
        JavaUsedDependenciesVisitor dependenciesVisitor = new JavaUsedDependenciesVisitor(file, sink);
        Iterator iterator = traverser.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            PsiElement element = (PsiElement)iterator2.next();
            element.accept((PsiElementVisitor)dependenciesVisitor);
        }
    }

    private static final Set<String> collectSuperClasses(PsiClass aClass) {
        ArrayDeque<PsiClass> queue = new ArrayDeque<PsiClass>();
        HashSet<PsiClass> passed = new HashSet<PsiClass>();
        HashSet<String> possibleClassNames = new HashSet<String>();
        queue.add(aClass);
        while (!((Collection)queue).isEmpty()) {
            PsiJavaFile containingFile;
            PsiClass currentClass = (PsiClass)queue.removeFirst();
            passed.add(aClass);
            PsiFile psiFile = currentClass.getContainingFile();
            if ((psiFile instanceof PsiJavaFile ? (PsiJavaFile)psiFile : null) == null) continue;
            containingFile = containingFile;
            PsiClassType[] psiClassTypeArray = currentClass.getExtendsListTypes();
            Intrinsics.checkNotNullExpressionValue((Object)psiClassTypeArray, (String)"getExtendsListTypes(...)");
            JavaUsedSymbolsVisitorKt.collectSupersFromList(psiClassTypeArray, passed, queue, possibleClassNames, containingFile);
            PsiClassType[] psiClassTypeArray2 = currentClass.getImplementsListTypes();
            Intrinsics.checkNotNullExpressionValue((Object)psiClassTypeArray2, (String)"getImplementsListTypes(...)");
            JavaUsedSymbolsVisitorKt.collectSupersFromList(psiClassTypeArray2, passed, queue, possibleClassNames, containingFile);
        }
        return possibleClassNames;
    }

    private static final void collectSupersFromList(PsiClassType[] extendsListTypes, HashSet<PsiClass> passed, ArrayDeque<PsiClass> queue, HashSet<String> possibleClassNames, PsiJavaFile containingFile) {
        for (PsiClassType type : extendsListTypes) {
            PsiJavaCodeReferenceElement ref;
            String simpleName;
            PsiClass superClass = type.resolve();
            if (superClass != null) {
                String qualifiedName;
                if (!passed.contains(superClass)) {
                    queue.add(superClass);
                }
                if ((qualifiedName = superClass.getQualifiedName()) == null) continue;
                possibleClassNames.add(qualifiedName);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)type.getName(), (String)"getName(...)");
            possibleClassNames.add(simpleName);
            PsiPackageStatement psiPackageStatement = containingFile.getPackageStatement();
            String packageName = psiPackageStatement != null ? psiPackageStatement.getPackageName() : null;
            PsiImportList imports = containingFile.getImportList();
            if (packageName != null) {
                possibleClassNames.add(packageName + "." + simpleName);
            }
            if (imports == null) continue;
            PsiImportStatementBase specialImport = imports.findSingleImportStatement(simpleName);
            if (specialImport != null && (ref = specialImport.getImportReference()) != null) {
                possibleClassNames.add(ref.getQualifiedName());
            }
            for (PsiImportStatement importStatement : imports.getImportStatements()) {
                PsiJavaCodeReferenceElement importReference;
                String importQualifiedName;
                if (importStatement instanceof PsiImportStaticStatement || !importStatement.isOnDemand() || importStatement.getImportReference() == null || (importQualifiedName = importReference.getQualifiedName()) == null) continue;
                possibleClassNames.add(importQualifiedName + "." + simpleName);
            }
        }
    }

    public static final /* synthetic */ void access$emit(JavaUsedSymbolsSink $receiver, String qualifiedName, String referenceName, boolean onContent) {
        JavaUsedSymbolsVisitorKt.emit($receiver, qualifiedName, referenceName, onContent);
    }

    public static final /* synthetic */ Set access$collectSuperClasses(PsiClass aClass) {
        return JavaUsedSymbolsVisitorKt.collectSuperClasses(aClass);
    }
}

