/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.java.used.debug;

import com.intellij.analysis.pwa.debug.SimplePwaDebugUsedSymbol;
import com.intellij.analysis.pwa.java.used.JavaUsedSymbolsSink;
import com.intellij.analysis.pwa.java.utils.PwaJavaHashUtils;
import com.intellij.analysis.pwa.java.utils.PwaJdkHashUtils;
import com.intellij.analysis.pwa.java.utils.PwaLanguageLevelHashUtil;
import com.intellij.openapi.module.Module;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u0012\u0010\u0011\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\nH\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/analysis/pwa/java/used/debug/JavaDebugUsedSymbolsSink;", "Lcom/intellij/analysis/pwa/java/used/JavaUsedSymbolsSink;", "<init>", "()V", "deps", "", "Lcom/intellij/analysis/pwa/debug/SimplePwaDebugUsedSymbol;", "getDeps", "()Ljava/util/List;", "emit", "", "qualifiedName", "", "onContent", "", "emitJavaModuleDependency", "jpsModuleName", "emitLevelDependency", "module", "Lcom/intellij/openapi/module/Module;", "emitSdkDependency", "intellij.java.pwa"})
public final class JavaDebugUsedSymbolsSink
implements JavaUsedSymbolsSink {
    @NotNull
    private final List<SimplePwaDebugUsedSymbol> deps = new ArrayList();

    @NotNull
    public final List<SimplePwaDebugUsedSymbol> getDeps() {
        return this.deps;
    }

    @Override
    public void emit(@NotNull String qualifiedName, boolean onContent) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        StringBuilder $this$emit_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$emit_u24lambda_u240.append(qualifiedName);
        if (onContent) {
            $this$emit_u24lambda_u240.append(" (content)");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String name = string;
        int hash = onContent ? PwaJavaHashUtils.hashDependencyName(qualifiedName) : PwaJavaHashUtils.hashDependencyOnClassWithContent(qualifiedName);
        this.deps.add(new SimplePwaDebugUsedSymbol(name, null, hash));
    }

    @Override
    public void emitJavaModuleDependency(@NotNull String jpsModuleName) {
        Intrinsics.checkNotNullParameter((Object)jpsModuleName, (String)"jpsModuleName");
        this.deps.add(new SimplePwaDebugUsedSymbol("JavaModule#" + jpsModuleName, null, PwaJavaHashUtils.hashJavaModuleName(jpsModuleName)));
    }

    @Override
    public void emitLevelDependency(@Nullable Module module) {
        StringBuilder stringBuilder;
        StringBuilder $this$emitLevelDependency_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$emitLevelDependency_u24lambda_u241.append("LanguageLevel#");
        if (module != null) {
            $this$emitLevelDependency_u24lambda_u241.append("module ");
            v0 = $this$emitLevelDependency_u24lambda_u241.append(module.getName());
        } else {
            v0 = $this$emitLevelDependency_u24lambda_u241.append("project");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String name = string;
        int hash = module == null ? PwaLanguageLevelHashUtil.getProjectNameHash() : PwaLanguageLevelHashUtil.getModuleNameHash(module);
        this.deps.add(new SimplePwaDebugUsedSymbol(name, null, hash));
    }

    @Override
    public void emitSdkDependency() {
        this.deps.add(new SimplePwaDebugUsedSymbol("sdk", null, PwaJdkHashUtils.INSTANCE.getSdkNameHash()));
    }
}

