/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.collections.visualizer;

import com.intellij.debugger.collections.visualizer.CollectionModelAccessorBase;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0014\u00a8\u0006\u0014"}, d2={"Lcom/intellij/debugger/collections/visualizer/ArrayModelAccessor;", "Lcom/intellij/debugger/collections/visualizer/CollectionModelAccessorBase;", "valueDescriptor", "Lcom/intellij/debugger/ui/tree/ValueDescriptor;", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "<init>", "(Lcom/intellij/debugger/ui/tree/ValueDescriptor;Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;)V", "size", "", "value", "Lcom/sun/jdi/ObjectReference;", "elementAt", "Lcom/sun/jdi/Value;", "elementIdx", "", "subCollection", "Lkotlinx/coroutines/flow/Flow;", "startIndex", "amount", "intellij.debugger.collections.visualizer"})
final class ArrayModelAccessor
extends CollectionModelAccessorBase {
    public ArrayModelAccessor(@NotNull ValueDescriptor valueDescriptor, @NotNull EvaluationContextImpl evaluationContext) {
        Intrinsics.checkNotNullParameter((Object)valueDescriptor, (String)"valueDescriptor");
        Intrinsics.checkNotNullParameter((Object)evaluationContext, (String)"evaluationContext");
        super(valueDescriptor, evaluationContext);
    }

    @Override
    public long size(@NotNull ObjectReference value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return ((ArrayReference)value).length();
    }

    @Override
    @Nullable
    protected Value elementAt(@NotNull ObjectReference value, int elementIdx) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return ((ArrayReference)value).getValue(elementIdx);
    }

    @Override
    @NotNull
    protected Flow<Value> subCollection(@NotNull ObjectReference value, int startIndex, int amount) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        List<Value> list = ((ArrayReference)value).getValues(startIndex, amount);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValues(...)");
        return FlowKt.asFlow((Iterable)list);
    }
}

