/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.dataframe.analyzing;

import com.intellij.charts.dataframe.analyzing.AnalysisFail;
import com.intellij.charts.dataframe.analyzing.AnalysisResult;
import com.intellij.charts.dataframe.analyzing.AnalyzerState;
import com.intellij.charts.dataframe.analyzing.FileContentProvider;
import com.intellij.charts.dataframe.analyzing.NextPartNeeded;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H&J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000f"}, d2={"Lcom/intellij/charts/dataframe/analyzing/StructuredFileAnalyzer;", "", "<init>", "()V", "startAnalysis", "Lcom/intellij/charts/dataframe/analyzing/AnalyzerState;", "startPart", "", "continueAnalysis", "nextPart", "analyze", "Lcom/intellij/charts/dataframe/analyzing/AnalysisResult;", "contentProvider", "Lcom/intellij/charts/dataframe/analyzing/FileContentProvider;", "Companion", "intellij.charts"})
public abstract class StructuredFileAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int MAGIC_LIMIT = 10;

    @NotNull
    public abstract AnalyzerState startAnalysis(@NotNull String var1);

    @NotNull
    public abstract AnalyzerState continueAnalysis(@NotNull String var1);

    @NotNull
    public final AnalysisResult analyze(@NotNull FileContentProvider contentProvider) {
        AnalysisResult analysisResult;
        int counter;
        Intrinsics.checkNotNullParameter((Object)contentProvider, (String)"contentProvider");
        String currentPart = contentProvider.getCurrentPart();
        if (currentPart == null) {
            return new AnalysisFail("Empty file");
        }
        AnalyzerState currentState = this.startAnalysis(currentPart);
        for (counter = 0; currentState instanceof NextPartNeeded && contentProvider.hasNextPart() && counter < 10; ++counter) {
            currentState = ((NextPartNeeded)currentState).providePart(contentProvider.getNextPart());
        }
        if (currentState instanceof AnalysisResult) {
            analysisResult = (AnalysisResult)currentState;
        } else {
            String errorMessage = counter >= 10 ? "Read limit exceeded" : (!contentProvider.hasNextPart() ? "Provider depleted before analysis end" : "Expected result, but got: " + currentState);
            analysisResult = new AnalysisFail(errorMessage);
        }
        return analysisResult;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/charts/dataframe/analyzing/StructuredFileAnalyzer$Companion;", "", "<init>", "()V", "MAGIC_LIMIT", "", "intellij.charts"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

