/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.frame;

import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.Geom;
import org.jetbrains.letsPlot.core.plot.base.PlotContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.ScaleMapper;
import org.jetbrains.letsPlot.core.plot.base.render.svg.SvgComponent;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.PanelGridTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.PanelTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.Theme;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetCollector;
import org.jetbrains.letsPlot.core.plot.builder.FrameOfReference;
import org.jetbrains.letsPlot.core.plot.builder.GeomLayer;
import org.jetbrains.letsPlot.core.plot.builder.LayerRendererUtil;
import org.jetbrains.letsPlot.core.plot.builder.SvgLayerRenderer;
import org.jetbrains.letsPlot.core.plot.builder.assemble.GeomContextBuilder;
import org.jetbrains.letsPlot.core.plot.builder.assemble.ImmutableGeomContext;
import org.jetbrains.letsPlot.core.plot.builder.layout.GeomMarginsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayoutInfo;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgRectElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\b \u0018\u0000 A2\u00020\u0001:\u0001AB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0004J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020)H&J\u0018\u00101\u001a\u00020/2\u0006\u00102\u001a\u0002032\u0006\u00100\u001a\u00020)H&J\u0010\u00104\u001a\u00020/2\u0006\u00100\u001a\u00020)H&J\u0010\u00105\u001a\u00020/2\u0006\u00100\u001a\u00020)H&J\u0018\u00106\u001a\u00020/2\u0006\u00102\u001a\u0002032\u0006\u00100\u001a\u00020)H&J\u0010\u00107\u001a\u00020/2\u0006\u00100\u001a\u00020)H&J\u0010\u00108\u001a\u00020/2\u0006\u00100\u001a\u00020)H&J\u0010\u00109\u001a\u00020/2\u0006\u00100\u001a\u00020)H\u0014J\u0010\u0010:\u001a\u00020/2\u0006\u00100\u001a\u00020)H\u0014J\u0018\u0010;\u001a\u00020/2\u0006\u00100\u001a\u00020)2\u0006\u0010<\u001a\u00020\u0005H\u0002J\u0018\u0010=\u001a\u00020/2\u0006\u00100\u001a\u00020)2\u0006\u0010>\u001a\u00020\rH\u0002J\u0010\u0010?\u001a\u00020\u00052\u0006\u0010@\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\u0012X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0016\"\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\u0018X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001a\u00a8\u0006B"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/frame/FrameOfReferenceBase;", "Lorg/jetbrains/letsPlot/core/plot/builder/FrameOfReference;", "plotContext", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "adjustedDomain", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "layoutInfo", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutInfo;", "marginsLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;", "flipAxis", "", "(Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutInfo;Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;Z)V", "getAdjustedDomain", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "getCoord", "()Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "getFlipAxis", "()Z", "hAxisTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "getHAxisTheme", "()Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "isDebugDrawing", "setDebugDrawing", "(Z)V", "getLayoutInfo", "()Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutInfo;", "getMarginsLayout", "()Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;", "getPlotContext", "()Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "getTheme", "()Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;", "vAxisTheme", "getVAxisTheme", "buildGeom", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/SvgComponent;", "layer", "Lorg/jetbrains/letsPlot/core/plot/builder/GeomLayer;", "targetCollector", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetCollector;", "doDrawHAxis", "", "parent", "doDrawHGrid", "gridTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/PanelGridTheme;", "doDrawPanelBorder", "doDrawVAxis", "doDrawVGrid", "doFillBkgr", "doStrokeBkgr", "drawAfterGeomLayer", "drawBeforeGeomLayer", "drawDebugShapes", "geomBounds", "drawPanelAndAxis", "beforeGeomLayer", "toDataBounds", "clientRect", "Companion", "plot-builder"})
public abstract class FrameOfReferenceBase
extends FrameOfReference {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlotContext plotContext;
    @NotNull
    private final DoubleRectangle adjustedDomain;
    @NotNull
    private final TileLayoutInfo layoutInfo;
    @NotNull
    private final GeomMarginsLayout marginsLayout;
    @NotNull
    private final Theme theme;
    private final boolean flipAxis;
    @NotNull
    private final AxisTheme hAxisTheme;
    @NotNull
    private final AxisTheme vAxisTheme;
    private boolean isDebugDrawing;

    public FrameOfReferenceBase(@NotNull PlotContext plotContext, @NotNull DoubleRectangle adjustedDomain, @NotNull TileLayoutInfo layoutInfo, @NotNull GeomMarginsLayout marginsLayout, @NotNull Theme theme2, boolean flipAxis) {
        Intrinsics.checkNotNullParameter((Object)plotContext, (String)"plotContext");
        Intrinsics.checkNotNullParameter((Object)adjustedDomain, (String)"adjustedDomain");
        Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
        Intrinsics.checkNotNullParameter((Object)marginsLayout, (String)"marginsLayout");
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        this.plotContext = plotContext;
        this.adjustedDomain = adjustedDomain;
        this.layoutInfo = layoutInfo;
        this.marginsLayout = marginsLayout;
        this.theme = theme2;
        this.flipAxis = flipAxis;
        this.hAxisTheme = this.theme.horizontalAxis(this.flipAxis);
        this.vAxisTheme = this.theme.verticalAxis(this.flipAxis);
    }

    @NotNull
    protected final PlotContext getPlotContext() {
        return this.plotContext;
    }

    @NotNull
    protected final DoubleRectangle getAdjustedDomain() {
        return this.adjustedDomain;
    }

    @NotNull
    protected final TileLayoutInfo getLayoutInfo() {
        return this.layoutInfo;
    }

    @NotNull
    protected final GeomMarginsLayout getMarginsLayout() {
        return this.marginsLayout;
    }

    @NotNull
    protected final Theme getTheme() {
        return this.theme;
    }

    protected final boolean getFlipAxis() {
        return this.flipAxis;
    }

    @NotNull
    protected abstract CoordinateSystem getCoord();

    @NotNull
    protected final AxisTheme getHAxisTheme() {
        return this.hAxisTheme;
    }

    @NotNull
    protected final AxisTheme getVAxisTheme() {
        return this.vAxisTheme;
    }

    public final boolean isDebugDrawing() {
        return this.isDebugDrawing;
    }

    public final void setDebugDrawing(boolean bl) {
        this.isDebugDrawing = bl;
    }

    public abstract void doDrawVAxis(@NotNull SvgComponent var1);

    public abstract void doDrawHAxis(@NotNull SvgComponent var1);

    public abstract void doDrawHGrid(@NotNull PanelGridTheme var1, @NotNull SvgComponent var2);

    public abstract void doDrawVGrid(@NotNull PanelGridTheme var1, @NotNull SvgComponent var2);

    public abstract void doFillBkgr(@NotNull SvgComponent var1);

    public abstract void doStrokeBkgr(@NotNull SvgComponent var1);

    public abstract void doDrawPanelBorder(@NotNull SvgComponent var1);

    @Override
    protected void drawBeforeGeomLayer(@NotNull SvgComponent parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.drawPanelAndAxis(parent, true);
    }

    @Override
    protected void drawAfterGeomLayer(@NotNull SvgComponent parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.drawPanelAndAxis(parent, false);
    }

    @Override
    @NotNull
    public DoubleRectangle toDataBounds(@NotNull DoubleRectangle clientRect) {
        Intrinsics.checkNotNullParameter((Object)clientRect, (String)"clientRect");
        DoubleVector doubleVector = this.getCoord().fromClient(clientRect.getOrigin());
        if (doubleVector == null) {
            throw new IllegalStateException(("Can't translate client " + clientRect.getOrigin() + " to data domain.").toString());
        }
        DoubleVector domainPoint0 = doubleVector;
        DoubleVector clientBottomRight = clientRect.getOrigin().add(clientRect.getDimension());
        DoubleVector doubleVector2 = this.getCoord().fromClient(clientBottomRight);
        if (doubleVector2 == null) {
            throw new IllegalStateException(("Can't translate client " + clientBottomRight + " to data domain.").toString());
        }
        DoubleVector domainPoint1 = doubleVector2;
        return DoubleRectangle.Companion.span(domainPoint0, domainPoint1);
    }

    @NotNull
    protected final SvgComponent buildGeom(@NotNull GeomLayer layer, @NotNull GeomTargetCollector targetCollector) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter((Object)targetCollector, (String)"targetCollector");
        return Companion.buildGeom$plot_builder(this.plotContext, layer, this.adjustedDomain.flipIf(this.flipAxis), this.getCoord(), this.flipAxis, targetCollector, this.theme.panel().showRect() ? this.theme.panel().rectFill() : this.theme.plot().backgroundFill());
    }

    private final void drawPanelAndAxis(SvgComponent parent, boolean beforeGeomLayer) {
        DoubleRectangle geomInnerBounds = this.layoutInfo.getGeomInnerBounds();
        PanelTheme panelTheme = this.theme.panel();
        PanelGridTheme vGridTheme = panelTheme.verticalGrid(this.flipAxis);
        PanelGridTheme hGridTheme = panelTheme.horizontalGrid(this.flipAxis);
        boolean fillBkgr2 = panelTheme.showRect() && beforeGeomLayer;
        boolean strokeBkgr2 = panelTheme.showRect() && panelTheme.borderIsOntop() ^ beforeGeomLayer;
        boolean drawPanelBorder = panelTheme.showBorder() && panelTheme.borderIsOntop() ^ beforeGeomLayer;
        boolean drawVGrid = beforeGeomLayer ^ vGridTheme.isOntop();
        boolean drawHGrid = beforeGeomLayer ^ hGridTheme.isOntop();
        boolean drawHAxis = beforeGeomLayer ^ this.hAxisTheme.isOntop();
        boolean drawVAxis = beforeGeomLayer ^ this.vAxisTheme.isOntop();
        if (fillBkgr2) {
            this.doFillBkgr(parent);
        }
        if (drawVGrid) {
            this.doDrawVGrid(vGridTheme, parent);
        }
        if (drawHGrid) {
            this.doDrawHGrid(hGridTheme, parent);
        }
        if (drawHAxis) {
            this.doDrawHAxis(parent);
        }
        if (drawVAxis) {
            this.doDrawVAxis(parent);
        }
        if (strokeBkgr2) {
            this.doStrokeBkgr(parent);
        }
        if (drawPanelBorder) {
            this.doDrawPanelBorder(parent);
        }
        if (this.isDebugDrawing && !beforeGeomLayer) {
            this.drawDebugShapes(parent, geomInnerBounds);
        }
    }

    private final void drawDebugShapes(SvgComponent parent, DoubleRectangle geomBounds) {
        FrameOfReferenceBase $this$drawDebugShapes_u24lambda_u240 = this;
        boolean bl = false;
        DoubleRectangle tileBounds = $this$drawDebugShapes_u24lambda_u240.layoutInfo.getGeomWithAxisBounds();
        SvgRectElement rect2 = new SvgRectElement(tileBounds);
        rect2.fillColor().set(Color.Companion.getBLACK());
        rect2.strokeWidth().set(0.0);
        rect2.fillOpacity().set(0.1);
        parent.add(rect2);
        FrameOfReferenceBase $this$drawDebugShapes_u24lambda_u241 = this;
        boolean bl2 = false;
        SvgRectElement rect3 = new SvgRectElement(geomBounds);
        rect3.fillColor().set(Color.Companion.getPINK());
        rect3.strokeWidth().set(1.0);
        rect3.fillOpacity().set(0.5);
        parent.add(rect3);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JE\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/frame/FrameOfReferenceBase$Companion;", "", "()V", "buildGeom", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/SvgComponent;", "plotContext", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "layer", "Lorg/jetbrains/letsPlot/core/plot/builder/GeomLayer;", "xyAesBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "flippedAxis", "", "targetCollector", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetCollector;", "backgroundColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "buildGeom$plot_builder", "plot-builder"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SvgComponent buildGeom$plot_builder(@NotNull PlotContext plotContext, @NotNull GeomLayer layer, @NotNull DoubleRectangle xyAesBounds, @NotNull CoordinateSystem coord, boolean flippedAxis, @NotNull GeomTargetCollector targetCollector, @NotNull Color backgroundColor) {
            CoordinateSystem coordinateSystem;
            Intrinsics.checkNotNullParameter((Object)plotContext, (String)"plotContext");
            Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
            Intrinsics.checkNotNullParameter((Object)xyAesBounds, (String)"xyAesBounds");
            Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
            Intrinsics.checkNotNullParameter((Object)targetCollector, (String)"targetCollector");
            Intrinsics.checkNotNullParameter((Object)backgroundColor, (String)"backgroundColor");
            LayerRendererUtil.LayerRendererData rendererData = LayerRendererUtil.INSTANCE.createLayerRendererData(layer);
            boolean flippedAxis2 = layer.isYOrientation() ? !flippedAxis : flippedAxis;
            Map<Aes<?>, ScaleMapper<?>> aestheticMappers = rendererData.getAestheticMappers();
            Aesthetics aesthetics2 = rendererData.getAesthetics();
            boolean bl = layer.isYOrientation();
            if (bl) {
                coordinateSystem = coord.flip();
            } else if (!bl) {
                coordinateSystem = coord;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            CoordinateSystem coord2 = coordinateSystem;
            GeomTargetCollector it = targetCollector;
            boolean bl2 = false;
            it = flippedAxis2 ? it.withFlippedAxis() : it;
            boolean bl3 = false;
            GeomTargetCollector targetCollector2 = layer.isYOrientation() ? it.withYOrientation() : it;
            ImmutableGeomContext ctx2 = new GeomContextBuilder().flipped(flippedAxis2).aesthetics(aesthetics2).aestheticMappers(aestheticMappers).aesBounds(xyAesBounds).geomTargetCollector(targetCollector2).fontFamilyRegistry(layer.getFontFamilyRegistry()).defaultFormatters(layer.getDefaultFormatters()).annotation(rendererData.getAnnotation()).backgroundColor(backgroundColor).plotContext(plotContext).build();
            PositionAdjustment pos = rendererData.getPos();
            Geom geom2 = layer.getGeom();
            return new SvgLayerRenderer(aesthetics2, geom2, pos, coord2, ctx2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

