/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.utils.persistence.data.nodes;

import com.intellij.javaee.utils.persistence.data.nodes.PropertyNode;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SortNode
extends PropertyNode {
    private Direction myDirection;
    private String myPropertyName;

    public SortNode(@NotNull String expression) {
        if (expression == null) {
            SortNode.$$$reportNull$$$0(0);
        }
        super(expression);
        this.myDirection = Direction.DEFAULT;
        this.myPropertyName = "";
        for (Direction direction : Direction.ALL) {
            String name = direction.getName();
            if (!expression.endsWith(name)) continue;
            this.myDirection = direction;
            this.myPropertyName = StringUtil.decapitalize((String)(StringUtil.isEmpty((String)name) ? expression : expression.substring(0, expression.indexOf(name))));
            break;
        }
    }

    public Direction getDirection() {
        return this.myDirection;
    }

    @Override
    public String getPropertyName() {
        return this.myPropertyName;
    }

    @Override
    public boolean isDefaultKeyword() {
        return this.myDirection == Direction.DEFAULT;
    }

    @Override
    public Set<String> getPropertyKeywords() {
        HashSet<String> strings = new HashSet<String>();
        strings.add(Direction.ASC.getName());
        strings.add(Direction.DESC.getName());
        return strings;
    }

    @Override
    @NotNull
    public String getKeyword() {
        String string = this.myDirection.getName();
        if (string == null) {
            SortNode.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/utils/persistence/data/nodes/SortNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/utils/persistence/data/nodes/SortNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyword";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static enum Direction {
        ASC("Asc"),
        DESC("Desc"),
        DEFAULT("");

        public static Direction[] ALL;
        private final String myName;

        private Direction(String name) {
            if (name == null) {
                Direction.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        public String getName() {
            return this.myName;
        }

        static {
            ALL = new Direction[]{ASC, DESC, DEFAULT};
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javaee/utils/persistence/data/nodes/SortNode$Direction", "<init>"));
        }
    }
}

