/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.utils.persistence.data.parser;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PartType {
    private final List<String> keywords;
    private final String myDebugName;
    private final int numberOfArguments;
    private boolean useIgnoreCaseKeyword = false;

    private PartType(String debugName, int numberOfArguments, String ... keywords) {
        this.myDebugName = debugName;
        this.numberOfArguments = numberOfArguments;
        this.keywords = Arrays.asList(keywords);
    }

    private PartType(String name, String ... keywords) {
        this(name, 1, keywords);
    }

    public static PartType create(String name, int numberOfArguments, String ... keywords) {
        return new PartType(name, numberOfArguments, keywords);
    }

    public static PartType create(String name, String ... keywords) {
        return new PartType(name, 1, keywords);
    }

    public static PartType createIgnoreCase(String name, String ... keywords) {
        return new PartType(name, 1, keywords).useIgnoreCase();
    }

    public Collection<String> getKeywords() {
        return Collections.unmodifiableList(this.keywords);
    }

    protected boolean supports(String property) {
        if (this.keywords == null) {
            return true;
        }
        for (String keyword : this.keywords) {
            if (!property.endsWith(keyword)) continue;
            return true;
        }
        return false;
    }

    public int getNumberOfArguments() {
        return this.numberOfArguments;
    }

    @NotNull
    public String extractProperty(@NotNull String part) {
        if (part == null) {
            PartType.$$$reportNull$$$0(0);
        }
        String candidate = StringUtil.decapitalize((String)part);
        for (String keyword : this.keywords) {
            if (!candidate.endsWith(keyword)) continue;
            String string = candidate.substring(0, candidate.length() - keyword.length());
            if (string == null) {
                PartType.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = candidate;
        if (string == null) {
            PartType.$$$reportNull$$$0(2);
        }
        return string;
    }

    public String toString() {
        return String.format("%s (%s): %s", this.name(), this.getNumberOfArguments(), this.getKeywords());
    }

    public String name() {
        return this.myDebugName;
    }

    public PartType useIgnoreCase() {
        this.useIgnoreCaseKeyword = true;
        return this;
    }

    public boolean isUseIgnoreCase() {
        return this.useIgnoreCaseKeyword;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/utils/persistence/data/parser/PartType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/utils/persistence/data/parser/PartType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "extractProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractProperty";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

