/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web;

import com.intellij.javaee.UriUtil;
import com.intellij.javaee.appServers.deployment.DeploymentModel;
import com.intellij.javaee.appServers.run.configuration.CommonModel;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.javaee.model.JavaeeModelElement;
import com.intellij.javaee.web.WebDirectoryElement;
import com.intellij.javaee.web.WebModel;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.model.xml.Filter;
import com.intellij.javaee.web.model.xml.JspConfig;
import com.intellij.javaee.web.model.xml.JspPropertyGroup;
import com.intellij.javaee.web.model.xml.Servlet;
import com.intellij.javaee.web.model.xml.WebApp;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WebUtil {
    @NonNls
    public static final String WEB_FRAMEWORK_GROUP_ID = "web";

    public static WebUtil getWebUtil() {
        return (WebUtil)ApplicationManager.getApplication().getService(WebUtil.class);
    }

    @Nullable
    public static WebFacet getWebFacet(@NotNull JavaeeModelElement element) {
        if (element == null) {
            WebUtil.$$$reportNull$$$0(0);
        }
        return JavaeeFacetUtil.getInstance().getJavaeeFacet(element, WebFacet.ID);
    }

    @Nullable
    public static WebFacet getWebFacet(@NotNull PsiElement element) {
        if (element == null) {
            WebUtil.$$$reportNull$$$0(1);
        }
        return JavaeeFacetUtil.getInstance().getJavaeeFacet(element, WebFacet.ID);
    }

    @Nullable
    public static WebFacet getWebFacet(VirtualFile file, Project project) {
        return JavaeeFacetUtil.getInstance().getJavaeeFacet(file, WebFacet.ID, project);
    }

    @Nullable
    public static WebRoot findParentWebRoot(VirtualFile selectedFile, List<? extends WebRoot> webRoots) {
        if (selectedFile == null) {
            return null;
        }
        for (WebRoot webRoot : webRoots) {
            VirtualFile file = webRoot.getFile();
            if (file == null || !VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)selectedFile, (boolean)false)) continue;
            return webRoot;
        }
        return null;
    }

    public static boolean isInsideWebRoots(VirtualFile file, List<? extends WebRoot> webRoots) {
        for (WebRoot webRoot : webRoots) {
            VirtualFile resDir = webRoot.getFile();
            if (resDir == null || !resDir.isValid() || !VfsUtilCore.isAncestor((VirtualFile)resDir, (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInsideWebRoots(VirtualFile file, Project project) {
        return WebUtil.findFacetByFileUnderWebRoot(file, project) != null;
    }

    @Nullable
    public static Servlet findServlet(@NotNull WebFacet webFacet, String name) {
        WebApp root;
        if (webFacet == null) {
            WebUtil.$$$reportNull$$$0(2);
        }
        return (root = webFacet.getRoot()) == null ? null : (Servlet)DomUtil.findByName(root.getServlets(), (String)name);
    }

    @Nullable
    public static Filter findFilter(@NotNull WebFacet webFacet, String name) {
        WebApp root;
        if (webFacet == null) {
            WebUtil.$$$reportNull$$$0(3);
        }
        return (root = webFacet.getRoot()) == null ? null : (Filter)DomUtil.findByName(root.getFilters(), (String)name);
    }

    @NotNull
    public static TextRange trimRange(@NotNull String url, TextRange range) {
        if (url == null) {
            WebUtil.$$$reportNull$$$0(4);
        }
        for (int i = 0; i < url.length(); ++i) {
            switch (url.charAt(i)) {
                case '#': 
                case '?': {
                    int startOffset = range.getStartOffset();
                    return new TextRange(startOffset, startOffset + i);
                }
            }
        }
        TextRange textRange = range;
        if (textRange == null) {
            WebUtil.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    @NotNull
    public static String trimURL(@NotNull String url) {
        if (url == null) {
            WebUtil.$$$reportNull$$$0(6);
        }
        String string = PathReference.trimPath((String)url);
        if (string == null) {
            WebUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static int indexOfDynamicJSP(String text) {
        int len = text.length();
        block4: for (int i = 0; i < len; ++i) {
            switch (text.charAt(i)) {
                case '$': {
                    if (i + 1 >= len || text.charAt(i + 1) != '{') continue block4;
                    return i;
                }
                case '<': {
                    if (i + 1 >= len || text.charAt(i + 1) != '%') continue block4;
                    return i;
                }
            }
        }
        return -1;
    }

    public static int getLastPosOfURL(@NotNull String url) {
        if (url == null) {
            WebUtil.$$$reportNull$$$0(8);
        }
        for (int i = 0; i < url.length(); ++i) {
            switch (url.charAt(i)) {
                case '#': 
                case '?': {
                    return i;
                }
            }
        }
        return -1;
    }

    @Nullable
    public abstract JspFile getJspFile(Servlet var1);

    public abstract WebDirectoryElement createWebDirectoryElement(WebFacet var1, @NotNull String var2, boolean var3);

    @Nullable
    public abstract WebModel getLocalWebModel(@NotNull XmlFile var1);

    @Nullable
    public static String getRelativePath(WebDirectoryElement src, WebDirectoryElement dst) {
        WebDirectoryElement commonAncestor = WebUtil.getCommonAncestor(src, dst);
        if (commonAncestor != null) {
            StringBuilder buffer = new StringBuilder();
            if (src != commonAncestor) {
                while (src.getParent() != commonAncestor) {
                    buffer.append('/');
                    src = src.getParentDirectory();
                    assert (src != null);
                }
            }
            buffer.append(WebUtil.getRelativePathFromAncestor(dst, commonAncestor));
            return buffer.toString();
        }
        return null;
    }

    public static String getRelativePathFromAncestor(WebDirectoryElement file, WebDirectoryElement ancestor) {
        int length = 0;
        WebDirectoryElement parent = file;
        while (true) {
            if (parent == null) {
                return null;
            }
            if (parent.equals(ancestor)) break;
            if (length > 0) {
                ++length;
            }
            length += parent.getName().length();
            parent = parent.getParentDirectory();
        }
        char[] chars = new char[length];
        int index = chars.length;
        parent = file;
        while (!parent.equals(ancestor)) {
            if (index < length) {
                chars[--index] = 47;
            }
            String name = parent.getName();
            for (int i = name.length() - 1; i >= 0; --i) {
                chars[--index] = name.charAt(i);
            }
            parent = parent.getParentDirectory();
        }
        return new String(chars);
    }

    public static WebDirectoryElement getCommonAncestor(WebDirectoryElement file1, WebDirectoryElement file2) {
        WebDirectoryElement[] maxLengthPath;
        WebDirectoryElement[] minLengthPath;
        WebDirectoryElement[] path2;
        WebDirectoryElement[] path1 = WebUtil.getPathComponents(file1);
        if (path1.length < (path2 = WebUtil.getPathComponents(file2)).length) {
            minLengthPath = path1;
            maxLengthPath = path2;
        } else {
            minLengthPath = path2;
            maxLengthPath = path1;
        }
        int lastEqualIdx = -1;
        int i = 0;
        while (i < minLengthPath.length && minLengthPath[i].equals(maxLengthPath[i])) {
            lastEqualIdx = i++;
        }
        return lastEqualIdx != -1 ? minLengthPath[lastEqualIdx] : null;
    }

    private static WebDirectoryElement[] getPathComponents(WebDirectoryElement file) {
        ArrayList<WebDirectoryElement> componentsList = new ArrayList<WebDirectoryElement>();
        while (file != null) {
            componentsList.add(file);
            file = file.getParentDirectory();
        }
        int size = componentsList.size();
        WebDirectoryElement[] components = new WebDirectoryElement[size];
        for (int i = 0; i < size; ++i) {
            components[i] = (WebDirectoryElement)componentsList.get(size - i - 1);
        }
        return components;
    }

    @Nullable
    public abstract WebDirectoryElement findWebDirectoryByFile(@NotNull VirtualFile var1, @NotNull WebFacet var2);

    @Nullable
    public static WebDirectoryElement findWebDirectoryByFile(@NotNull VirtualFile file, Project project) {
        WebFacet webFacet;
        if (file == null) {
            WebUtil.$$$reportNull$$$0(9);
        }
        return (webFacet = WebUtil.getWebFacet(file, project)) == null ? null : WebUtil.getWebUtil().findWebDirectoryByFile(file, webFacet);
    }

    @Nullable
    public static WebDirectoryElement findWebDirectoryByFile(@NotNull PsiFileSystemItem file) {
        if (file == null) {
            WebUtil.$$$reportNull$$$0(10);
        }
        VirtualFile virtualFile = file.getVirtualFile();
        WebFacet webFacet = WebUtil.getWebFacet((PsiElement)file);
        if (webFacet != null && virtualFile != null) {
            return WebUtil.getWebUtil().findWebDirectoryByFile(virtualFile, webFacet);
        }
        return null;
    }

    @Nullable
    public abstract WebDirectoryElement getParentWebDirectory(@NotNull PsiFile var1);

    @Nullable
    public abstract String getWebPath(PsiFile var1);

    @Nullable
    public abstract String getWebPath(@NotNull Project var1, @NotNull VirtualFile var2);

    @Nullable
    public abstract WebDirectoryElement findWebDirectoryElement(@NotNull @NonNls String var1, @NotNull WebFacet var2);

    public static boolean processMatchingJspGroups(@NotNull PsiFile file, Processor<? super JspPropertyGroup> processor) {
        if (file == null) {
            WebUtil.$$$reportNull$$$0(11);
        }
        return WebUtil.processMatchingJspGroups(file.getProject(), file.getOriginalFile().getViewProvider().getVirtualFile(), processor);
    }

    public static boolean processMatchingJspGroups(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull Processor<? super JspPropertyGroup> processor) {
        WebFacet facet;
        if (project == null) {
            WebUtil.$$$reportNull$$$0(12);
        }
        if (virtualFile == null) {
            WebUtil.$$$reportNull$$$0(13);
        }
        if (processor == null) {
            WebUtil.$$$reportNull$$$0(14);
        }
        if ((facet = WebUtil.getWebFacet(virtualFile, project)) == null) {
            return false;
        }
        WebApp app = facet.getRoot();
        if (app == null) {
            return false;
        }
        String path = WebUtil.getWebUtil().getWebPath(project, virtualFile);
        if (path == null) {
            return false;
        }
        for (JspConfig config : app.getJspConfigs()) {
            block1: for (JspPropertyGroup group : config.getJspPropertyGroups()) {
                for (GenericDomValue<String> domValue : group.getUrlPatterns()) {
                    String pattern = (String)domValue.getValue();
                    if (pattern == null || !WebUtil.pathMatchesUrlPattern(path, pattern)) continue;
                    if (processor.process((Object)group)) continue block1;
                    return true;
                }
            }
        }
        return false;
    }

    @NotNull
    public static List<PathReference> getPreludes(BaseJspFile file) {
        SmartList result = new SmartList();
        WebUtil.processMatchingJspGroups((PsiFile)file, (Processor<? super JspPropertyGroup>)((Processor)arg_0 -> WebUtil.lambda$getPreludes$0((List)result, arg_0)));
        SmartList smartList = result;
        if (smartList == null) {
            WebUtil.$$$reportNull$$$0(15);
        }
        return smartList;
    }

    public static List<PathReference> getCodas(BaseJspFile file) {
        SmartList result = new SmartList();
        WebUtil.processMatchingJspGroups((PsiFile)file, (Processor<? super JspPropertyGroup>)((Processor)arg_0 -> WebUtil.lambda$getCodas$1((List)result, arg_0)));
        return result;
    }

    public static boolean pathMatchesUrlPattern(@NotNull String path, @NotNull String pattern) {
        if (path == null) {
            WebUtil.$$$reportNull$$$0(16);
        }
        if (pattern == null) {
            WebUtil.$$$reportNull$$$0(17);
        }
        if (pattern.endsWith("/*")) {
            return path.startsWith(pattern.substring(0, pattern.length() - 1));
        }
        if (pattern.startsWith("*.")) {
            return path.endsWith(pattern.substring(1));
        }
        return path.equals(pattern);
    }

    @Nullable
    public static WebFacet findFacetByFileUnderWebRoot(@NotNull VirtualFile file, @NotNull Project project) {
        Module module;
        if (file == null) {
            WebUtil.$$$reportNull$$$0(18);
        }
        if (project == null) {
            WebUtil.$$$reportNull$$$0(19);
        }
        if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project)) == null || module.isDisposed()) {
            return null;
        }
        Collection<WebFacet> facets = WebFacet.getInstances(module);
        for (WebFacet facet : facets) {
            if (facet.isDisposed() || !WebUtil.isInsideWebRoots(file, facet.getWebRoots())) continue;
            return facet;
        }
        return null;
    }

    public abstract Collection<PsiFileSystemItem> getContextsByPath(String var1, @NotNull Module var2);

    public abstract void visitAllFacets(@NotNull Module var1, Consumer<? super WebFacet> var2);

    public static VirtualFile findSourceFile(@NotNull String relative, @NotNull CommonModel commonModel, @NotNull Function<? super DeploymentModel, String> fun) {
        Pair<DeploymentModel, String> deploymentModel;
        if (relative == null) {
            WebUtil.$$$reportNull$$$0(20);
        }
        if (commonModel == null) {
            WebUtil.$$$reportNull$$$0(21);
        }
        if (fun == null) {
            WebUtil.$$$reportNull$$$0(22);
        }
        if ((deploymentModel = WebUtil.findDeploymentModel(StringUtil.trimTrailing((String)relative, (char)'/'), commonModel, fun)) == null) {
            return null;
        }
        Artifact artifact = ((DeploymentModel)deploymentModel.getFirst()).getArtifact();
        if (artifact == null) {
            return null;
        }
        for (WebFacet facet : JavaeeArtifactUtil.getInstance().getFacetsIncludedInArtifact(commonModel.getProject(), artifact, WebFacet.ID)) {
            VirtualFile file = WebUtil.getWebUtil().createWebDirectoryElement(facet, (String)deploymentModel.getSecond(), false).getOriginalVirtualFile();
            if (file == null) continue;
            return file;
        }
        return null;
    }

    @Nullable
    private static Pair<DeploymentModel, String> findDeploymentModel(String relative, CommonModel commonModel, Function<? super DeploymentModel, String> fun) {
        DeploymentModel defaultModel = null;
        for (DeploymentModel deploymentModel : commonModel.getDeploymentModels()) {
            String contextPath = (String)fun.fun((Object)deploymentModel);
            if (contextPath == null) continue;
            if ((contextPath = UriUtil.trimSlashFrom((String)contextPath)).isEmpty()) {
                defaultModel = deploymentModel;
                continue;
            }
            if (!relative.startsWith(contextPath)) continue;
            return Pair.create((Object)deploymentModel, (Object)relative.substring(contextPath.length()));
        }
        return defaultModel != null ? Pair.create(defaultModel, (Object)relative) : null;
    }

    private static /* synthetic */ boolean lambda$getCodas$1(List result, JspPropertyGroup group) {
        for (GenericDomValue<PathReference> value : group.getIncludeCodas()) {
            ContainerUtil.addIfNotNull((Collection)result, (Object)((PathReference)value.getValue()));
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$getPreludes$0(List result, JspPropertyGroup group) {
        for (GenericDomValue<PathReference> value : group.getIncludePreludes()) {
            ContainerUtil.addIfNotNull((Collection)result, (Object)((PathReference)value.getValue()));
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webFacet";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 5: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/web/WebUtil";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relative";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonModel";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/web/WebUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "trimRange";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "trimURL";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreludes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getWebFacet";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findServlet";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFilter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "trimRange";
                break;
            }
            case 5: 
            case 7: 
            case 15: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "trimURL";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLastPosOfURL";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findWebDirectoryByFile";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processMatchingJspGroups";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "pathMatchesUrlPattern";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findFacetByFileUnderWebRoot";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findSourceFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 15 -> new IllegalStateException(string);
        };
    }
}

