/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.util.SystemProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PlatformUtils {
    public static final String PLATFORM_PREFIX_KEY = "idea.platform.prefix";
    public static final String IDEA_PREFIX = "idea";
    public static final String IDEA_CE_PREFIX = "Idea";
    public static final String IDEA_EDU_PREFIX = "IdeaEdu";
    public static final String APPCODE_PREFIX = "AppCode";
    public static final String AQUA_PREFIX = "Aqua";
    public static final String CLION_PREFIX = "CLion";
    public static final String PYCHARM_PREFIX = "Python";
    public static final String PYCHARM_CE_PREFIX = "PyCharmCore";
    public static final String DATASPELL_PREFIX = "DataSpell";
    public static final String PYCHARM_EDU_PREFIX = "PyCharmEdu";
    public static final String RUBY_PREFIX = "Ruby";
    public static final String PHP_PREFIX = "PhpStorm";
    public static final String WEB_PREFIX = "WebStorm";
    public static final String DBE_PREFIX = "DataGrip";
    public static final String RIDER_PREFIX = "Rider";
    public static final String GOIDE_PREFIX = "GoLand";
    public static final String FLEET_PREFIX = "FleetBackend";
    public static final String RUSTROVER_PREFIX = "RustRover";
    public static final String WRITERSIDE_PREFIX = "Writerside";
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final String CWM_GUEST_PREFIX = "CodeWithMeGuest";
    public static final String JETBRAINS_CLIENT_PREFIX = "JetBrainsClient";
    public static final String GATEWAY_PREFIX = "Gateway";
    private static final Set<String> COMMERCIAL_EDITIONS = new HashSet<String>(Arrays.asList("idea", "AppCode", "CLion", "Python", "DataSpell", "Ruby", "PhpStorm", "WebStorm", "DataGrip", "Rider", "GoLand", "RustRover", "Aqua"));

    @NotNull
    public static String getPlatformPrefix() {
        String string = PlatformUtils.getPlatformPrefix(IDEA_PREFIX);
        if (string == null) {
            PlatformUtils.$$$reportNull$$$0(0);
        }
        return string;
    }

    public static String getPlatformPrefix(@Nullable String defaultPrefix) {
        return System.getProperty(PLATFORM_PREFIX_KEY, defaultPrefix);
    }

    public static void setDefaultPrefixForCE() {
        System.setProperty(PLATFORM_PREFIX_KEY, PlatformUtils.getPlatformPrefix(IDEA_CE_PREFIX));
    }

    public static boolean isJetBrainsProduct() {
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        return appInfo != null && appInfo.getShortCompanyName().equals("JetBrains");
    }

    public static boolean isIntelliJ() {
        return PlatformUtils.isIdeaUltimate() || PlatformUtils.isIdeaCommunity() || PlatformUtils.is(IDEA_EDU_PREFIX);
    }

    public static boolean isIdeaUltimate() {
        return PlatformUtils.is(IDEA_PREFIX);
    }

    public static boolean isIdeaCommunity() {
        return PlatformUtils.is(IDEA_CE_PREFIX);
    }

    @Deprecated
    public static boolean isIdeaEducational() {
        return PlatformUtils.is(IDEA_EDU_PREFIX);
    }

    public static boolean isRubyMine() {
        return PlatformUtils.is(RUBY_PREFIX);
    }

    @Deprecated
    public static boolean isAppCode() {
        return PlatformUtils.is(APPCODE_PREFIX);
    }

    public static boolean isAqua() {
        return PlatformUtils.is(AQUA_PREFIX);
    }

    @Deprecated
    public static boolean isCLion() {
        return PlatformUtils.is(CLION_PREFIX);
    }

    public static boolean isCidr() {
        return PlatformUtils.isAppCode() || PlatformUtils.isCLion();
    }

    public static boolean isPyCharm() {
        return PlatformUtils.is(PYCHARM_PREFIX) || PlatformUtils.isPyCharmCommunity() || PlatformUtils.isPyCharmEducational() || PlatformUtils.isDataSpell();
    }

    @Deprecated
    public static boolean isPyCharmPro() {
        return PlatformUtils.is(PYCHARM_PREFIX);
    }

    public static boolean isPyCharmCommunity() {
        return PlatformUtils.is(PYCHARM_CE_PREFIX);
    }

    public static boolean isDataSpell() {
        return PlatformUtils.is(DATASPELL_PREFIX);
    }

    public static boolean isPyCharmEducational() {
        return PlatformUtils.is(PYCHARM_EDU_PREFIX);
    }

    public static boolean isPhpStorm() {
        return PlatformUtils.is(PHP_PREFIX);
    }

    public static boolean isWebStorm() {
        return PlatformUtils.is(WEB_PREFIX);
    }

    public static boolean isWriterSide() {
        return PlatformUtils.is(WRITERSIDE_PREFIX);
    }

    public static boolean isDataGrip() {
        return PlatformUtils.is(DBE_PREFIX);
    }

    public static boolean isRider() {
        return PlatformUtils.is(RIDER_PREFIX);
    }

    public static boolean isGoIde() {
        return PlatformUtils.is(GOIDE_PREFIX);
    }

    public static boolean isJetBrainsClient() {
        return PlatformUtils.is(JETBRAINS_CLIENT_PREFIX);
    }

    public static boolean isGateway() {
        return PlatformUtils.is(GATEWAY_PREFIX);
    }

    public static boolean isCommunityEdition() {
        return PlatformUtils.isIdeaCommunity() || PlatformUtils.isPyCharmCommunity();
    }

    public static boolean isCommercialEdition() {
        return COMMERCIAL_EDITIONS.contains(PlatformUtils.getPlatformPrefix());
    }

    public static boolean isFleetBackend() {
        return PlatformUtils.is(FLEET_PREFIX);
    }

    public static boolean isRustRover() {
        return PlatformUtils.is(RUSTROVER_PREFIX);
    }

    public static boolean isQodana() {
        return SystemProperties.getBooleanProperty("qodana.application", false);
    }

    private static boolean is(String idePrefix) {
        return idePrefix.equals(PlatformUtils.getPlatformPrefix());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PlatformUtils", "getPlatformPrefix"));
    }
}

