/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.portForwarding.utils.WindowsProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 89842007717352L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-118225140 - -((char)-2545), -118225140 - -((char)-16395), (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-118225140 - -((char)-2546), -118225140 - -((char)-24100), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 98679225696276L;
                thread = Thread.currentThread();
                ActionTimestamp[] actionTimestampArray = SshAgentIpcService.C();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (actionTimestampArray == null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-1942850610 + -((char)-5399), -1942850610 + -31108, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-1942850610 + -((char)-5398), -1942850610 + -((char)-19386), (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-1942850610 + -((char)-5397), -1942850610 + -((char)-3575), (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                ActionTimestamp[] actionTimestampArray;
                l2 = 127258209534174L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    actionTimestampArray = SshAgentIpcService.C();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1671404640 + -((char)-9352), -1671404640 + -28190, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1671404640 + -((char)-9355), -1671404640 + -((char)-7763), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        this.hPipe = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        windowsNamedPipeAgentIpc = this;
                        if (actionTimestampArray == null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-1671404640 + -((char)-9354), 1671404640 + (char)-11474, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1671404640 + -((char)-9349), 1671404640 + 27890, (int)l2) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1671404640 + -((char)-9348), -1671404640 + -((char)-14833), (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-1671404640 + -((char)-9354), 1671404640 + (char)-11474, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1671404640 + -((char)-9351), 1671404640 + (char)-26180, (int)l2));
            if (ActionTimestamp.Z()) {
                SshAgentIpcService.C(new ActionTimestamp[5]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                ActionTimestamp[] actionTimestampArray;
                block6: {
                    long l2 = 75039442245528L;
                    actionTimestampArray = SshAgentIpcService.C();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (actionTimestampArray == null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (actionTimestampArray == null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        block32: {
            boolean bl;
            block34: {
                block33: {
                    Object object;
                    Object object2;
                    ActionTimestamp[] actionTimestampArray;
                    long l2;
                    block28: {
                        block29: {
                            l2 = 2291572106078L;
                            this.assertConnectionThread();
                            Object object3 = this.lock;
                            synchronized (object3) {
                                boolean bl2;
                                NamedPipeState namedPipeState;
                                NamedPipeState namedPipeState2;
                                block26: {
                                    block27: {
                                        actionTimestampArray = SshAgentIpcService.C();
                                        boolean bl3 = false;
                                        try {
                                            namedPipeState2 = this.state;
                                            namedPipeState = NamedPipeState.Closing;
                                            if (actionTimestampArray == null) break block26;
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block27;
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                        }
                                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                                        boolean bl4 = false;
                                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1940491350 - -((char)-18436), -1940491350 - -((char)-20486), (int)l2));
                                        logger.info(WindowsNamedPipeAgentIpc.b(-1940491350 - -((char)-18432), 1940491350 - (char)-16312, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1940491350 - -((char)-18441), 1940491350 - (char)-9596, (int)l2) + this.state);
                                        throw new ClosedChannelException();
                                    }
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Open;
                                }
                                try {
                                    bl2 = namedPipeState2 == namedPipeState;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl2) {
                                    boolean bl5 = false;
                                    String string = WindowsNamedPipeAgentIpc.b(-1940491350 - -((char)-18432), 1940491350 - (char)-16312, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1940491350 - -((char)-18442), 1940491350 - (char)-7216, (int)l2) + this.state;
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.state = NamedPipeState.Connecting;
                                Unit unit = Unit.INSTANCE;
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl6 = false;
                            try {
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1940491350 - -((char)-18436), -1940491350 - -((char)-20486), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1940491350 - -((char)-18432), 1940491350 - (char)-16312, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1940491350 - -((char)-18439), -1940360280 + -((char)-2643), (int)l2));
                                object2 = Kernel32.INSTANCE;
                                if (actionTimestampArray == null) break block28;
                                if (object2.ConnectNamedPipe(this.hPipe, null)) break block29;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            int n2 = Kernel32.INSTANCE.GetLastError();
                            if (n2 == 535) {
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                                boolean bl7 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1940491350 - -((char)-18436), -1940491350 - -((char)-20486), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1940491350 - -((char)-18432), 1940491350 - (char)-16312, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1940491350 - -((char)-18440), -1940491350 - -((char)-3293), (int)l2));
                            } else {
                                throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-1940491350 - -((char)-18432), 1940491350 - (char)-16312, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1940491350 - -((char)-18413), -1940491350 - -((char)-7226), (int)l2) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n2)).toString());
                            }
                        }
                        object2 = this.lock;
                    }
                    Kernel32 kernel32 = object2;
                    synchronized (kernel32) {
                        boolean bl8;
                        NamedPipeState namedPipeState;
                        NamedPipeState namedPipeState3;
                        block30: {
                            block31: {
                                boolean bl9 = false;
                                namedPipeState3 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (actionTimestampArray == null) break block30;
                                try {
                                    block35: {
                                        if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block31;
                                        break block35;
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                        }
                                    }
                                    throw new ClosedChannelException();
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                            }
                            namedPipeState3 = this.state;
                            namedPipeState = NamedPipeState.Connecting;
                        }
                        try {
                            bl8 = namedPipeState3 == namedPipeState;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        if (!bl8) {
                            boolean bl10 = false;
                            String string = WindowsNamedPipeAgentIpc.b(-1940491350 - -((char)-18432), 1940491350 - (char)-16312, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1940491350 - -((char)-18442), 1940491350 - (char)-7216, (int)l2) + this.state;
                            throw new IllegalArgumentException(string.toString());
                        }
                        this.state = NamedPipeState.Connected;
                        object = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                    boolean bl11 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1940491350 - -((char)-18436), -1940491350 - -((char)-20486), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1940491350 - -((char)-18432), 1940491350 - (char)-16312, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1940491350 - -((char)-18414), -1940491350 - -((char)-5517), (int)l2));
                    long l3 = this.getRequesterPid();
                    this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
                    object = new PipeReadableByteChannel(this);
                    PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
                    try {
                        try {
                            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                                final /* synthetic */ PipeReadableByteChannel $read;
                                final /* synthetic */ PipeWritableByteChannel $write;
                                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                                private static final String[] a;
                                private static final String[] b;
                                {
                                    this.$read = $read;
                                    this.$write = $write;
                                    this.this$0 = $receiver;
                                }

                                public InputStream getInputStream() {
                                    long l2 = 16226041124455L;
                                    InputStream inputStream = Channels.newInputStream(this.$read);
                                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(345369450 - (char)-24731, 345369450 - (char)-20593, (int)l2));
                                    return inputStream;
                                }

                                public OutputStream getOutputStream() {
                                    long l2 = 47789632146571L;
                                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(468968460 - 3364, 468968460 - 10036, (int)l2));
                                    return outputStream;
                                }

                                public void close() {
                                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                static {
                                    block13: {
                                        var5 = new String[2];
                                        var3_1 = 0;
                                        var2_2 = "\u00a8yj6\u00b6\u00e96-3\u0080\u00b4\u0083\u00f4\u00e2\u00e1\u00cf\u0094\u00a5\\\u0014:\u00a78\u00eb\u00e7\u0090a\u0087[\u00d3|=/\u00cc[\u0081.\u00aa\f\u00a8";
                                        var4_3 = "\u00a8yj6\u00b6\u00e96-3\u0080\u00b4\u0083\u00f4\u00e2\u00e1\u00cf\u0094\u00a5\\\u0014:\u00a78\u00eb\u00e7\u0090a\u0087[\u00d3|=/\u00cc[\u0081.\u00aa\f\u00a8".length();
                                        var1_4 = 19;
                                        var0_5 = -1;
lbl7:
                                        // 2 sources

                                        while (true) {
                                            continue;
                                            break;
                                        }
lbl9:
                                        // 1 sources

                                        while (true) {
                                            var5[var3_1++] = new String(v0).intern();
                                            if ((var0_5 += var1_4) < var4_3) {
                                                var1_4 = var2_2.charAt(var0_5);
                                                ** continue;
                                            }
                                            break block13;
                                            break;
                                        }
                                        v1 = ++var0_5;
                                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                                        v3 = v2.length;
                                        var6_6 = 0;
                                        v4 = 117;
                                        v5 = v2;
                                        v6 = v3;
                                        if (v3 > 1) ** GOTO lbl67
                                        do {
                                            v7 = v4;
                                            v5 = v5;
                                            v8 = v5;
                                            v9 = v4;
                                            v10 = var6_6;
                                            while (true) {
                                                switch (var6_6 % 7) {
                                                    case 0: {
                                                        v11 = 97;
                                                        break;
                                                    }
                                                    case 1: {
                                                        v11 = 106;
                                                        break;
                                                    }
                                                    case 2: {
                                                        v11 = 92;
                                                        break;
                                                    }
                                                    case 3: {
                                                        v11 = 15;
                                                        break;
                                                    }
                                                    case 4: {
                                                        v11 = 92;
                                                        break;
                                                    }
                                                    case 5: {
                                                        v11 = 5;
                                                        break;
                                                    }
                                                    default: {
                                                        v11 = 102;
                                                    }
                                                }
                                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                                ++var6_6;
                                                v4 = v7;
                                                if (v7 != 0) break;
                                                v7 = v4;
                                                v5 = v5;
                                                v10 = v4;
                                                v8 = v5;
                                                v9 = v4;
                                            }
lbl67:
                                            // 2 sources

                                            v0 = v5;
                                            v6 = v6;
                                        } while (v6 > var6_6);
                                        ** while (true)
                                    }
                                    accept.3.a = var5;
                                    accept.3.b = new String[2];
                                }

                                private static String a(int n2, int n3, int n4) {
                                    int n5 = (n2 ^ n4 ^ 0xFFFF9A62) & 0xFFFF;
                                    if (b[n5] == null) {
                                        int n6;
                                        char[] cArray = a[n5].toCharArray();
                                        int n7 = switch (cArray[0] & 0xFF) {
                                            case 0 -> 137;
                                            case 1 -> 173;
                                            case 2 -> 163;
                                            case 3 -> 243;
                                            case 4 -> 71;
                                            case 5 -> 115;
                                            case 6 -> 211;
                                            case 7 -> 168;
                                            case 8 -> 247;
                                            case 9 -> 233;
                                            case 10 -> 52;
                                            case 11 -> 73;
                                            case 12 -> 59;
                                            case 13 -> 57;
                                            case 14 -> 207;
                                            case 15 -> 144;
                                            case 16 -> 145;
                                            case 17 -> 32;
                                            case 18 -> 16;
                                            case 19 -> 208;
                                            case 20 -> 40;
                                            case 21 -> 226;
                                            case 22 -> 7;
                                            case 23 -> 195;
                                            case 24 -> 58;
                                            case 25 -> 201;
                                            case 26 -> 93;
                                            case 27 -> 134;
                                            case 28 -> 49;
                                            case 29 -> 46;
                                            case 30 -> 26;
                                            case 31 -> 67;
                                            case 32 -> 47;
                                            case 33 -> 28;
                                            case 34 -> 245;
                                            case 35 -> 65;
                                            case 36 -> 55;
                                            case 37 -> 130;
                                            case 38 -> 132;
                                            case 39 -> 82;
                                            case 40 -> 113;
                                            case 41 -> 11;
                                            case 42 -> 114;
                                            case 43 -> 85;
                                            case 44 -> 56;
                                            case 45 -> 70;
                                            case 46 -> 19;
                                            case 47 -> 33;
                                            case 48 -> 2;
                                            case 49 -> 84;
                                            case 50 -> 225;
                                            case 51 -> 255;
                                            case 52 -> 214;
                                            case 53 -> 190;
                                            case 54 -> 188;
                                            case 55 -> 120;
                                            case 56 -> 37;
                                            case 57 -> 29;
                                            case 58 -> 21;
                                            case 59 -> 136;
                                            case 60 -> 129;
                                            case 61 -> 252;
                                            case 62 -> 229;
                                            case 63 -> 99;
                                            case 64 -> 166;
                                            case 65 -> 112;
                                            case 66 -> 191;
                                            case 67 -> 23;
                                            case 68 -> 74;
                                            case 69 -> 92;
                                            case 70 -> 209;
                                            case 71 -> 127;
                                            case 72 -> 8;
                                            case 73 -> 246;
                                            case 74 -> 81;
                                            case 75 -> 89;
                                            case 76 -> 75;
                                            case 77 -> 171;
                                            case 78 -> 34;
                                            case 79 -> 90;
                                            case 80 -> 215;
                                            case 81 -> 126;
                                            case 82 -> 182;
                                            case 83 -> 192;
                                            case 84 -> 223;
                                            case 85 -> 206;
                                            case 86 -> 157;
                                            case 87 -> 77;
                                            case 88 -> 116;
                                            case 89 -> 54;
                                            case 90 -> 103;
                                            case 91 -> 187;
                                            case 92 -> 121;
                                            case 93 -> 105;
                                            case 94 -> 3;
                                            case 95 -> 135;
                                            case 96 -> 230;
                                            case 97 -> 216;
                                            case 98 -> 154;
                                            case 99 -> 202;
                                            case 100 -> 217;
                                            case 101 -> 125;
                                            case 102 -> 239;
                                            case 103 -> 224;
                                            case 104 -> 167;
                                            case 105 -> 0;
                                            case 106 -> 185;
                                            case 107 -> 53;
                                            case 108 -> 94;
                                            case 109 -> 118;
                                            case 110 -> 17;
                                            case 111 -> 140;
                                            case 112 -> 101;
                                            case 113 -> 111;
                                            case 114 -> 12;
                                            case 115 -> 159;
                                            case 116 -> 251;
                                            case 117 -> 221;
                                            case 118 -> 78;
                                            case 119 -> 63;
                                            case 120 -> 205;
                                            case 121 -> 139;
                                            case 122 -> 238;
                                            case 123 -> 30;
                                            case 124 -> 80;
                                            case 125 -> 6;
                                            case 126 -> 178;
                                            case 127 -> 106;
                                            case 128 -> 213;
                                            case 129 -> 186;
                                            case 130 -> 62;
                                            case 131 -> 143;
                                            case 132 -> 141;
                                            case 133 -> 194;
                                            case 134 -> 199;
                                            case 135 -> 235;
                                            case 136 -> 218;
                                            case 137 -> 210;
                                            case 138 -> 241;
                                            case 139 -> 123;
                                            case 140 -> 108;
                                            case 141 -> 184;
                                            case 142 -> 198;
                                            case 143 -> 87;
                                            case 144 -> 228;
                                            case 145 -> 43;
                                            case 146 -> 240;
                                            case 147 -> 39;
                                            case 148 -> 165;
                                            case 149 -> 227;
                                            case 150 -> 36;
                                            case 151 -> 150;
                                            case 152 -> 76;
                                            case 153 -> 200;
                                            case 154 -> 152;
                                            case 155 -> 232;
                                            case 156 -> 183;
                                            case 157 -> 158;
                                            case 158 -> 124;
                                            case 159 -> 149;
                                            case 160 -> 220;
                                            case 161 -> 212;
                                            case 162 -> 31;
                                            case 163 -> 86;
                                            case 164 -> 253;
                                            case 165 -> 4;
                                            case 166 -> 222;
                                            case 167 -> 66;
                                            case 168 -> 196;
                                            case 169 -> 153;
                                            case 170 -> 237;
                                            case 171 -> 155;
                                            case 172 -> 138;
                                            case 173 -> 248;
                                            case 174 -> 83;
                                            case 175 -> 109;
                                            case 176 -> 96;
                                            case 177 -> 45;
                                            case 178 -> 193;
                                            case 179 -> 20;
                                            case 180 -> 147;
                                            case 181 -> 50;
                                            case 182 -> 91;
                                            case 183 -> 181;
                                            case 184 -> 98;
                                            case 185 -> 102;
                                            case 186 -> 72;
                                            case 187 -> 249;
                                            case 188 -> 234;
                                            case 189 -> 189;
                                            case 190 -> 88;
                                            case 191 -> 110;
                                            case 192 -> 250;
                                            case 193 -> 128;
                                            case 194 -> 68;
                                            case 195 -> 64;
                                            case 196 -> 35;
                                            case 197 -> 15;
                                            case 198 -> 175;
                                            case 199 -> 204;
                                            case 200 -> 18;
                                            case 201 -> 146;
                                            case 202 -> 180;
                                            case 203 -> 97;
                                            case 204 -> 133;
                                            case 205 -> 170;
                                            case 206 -> 25;
                                            case 207 -> 24;
                                            case 208 -> 242;
                                            case 209 -> 104;
                                            case 210 -> 22;
                                            case 211 -> 174;
                                            case 212 -> 10;
                                            case 213 -> 176;
                                            case 214 -> 160;
                                            case 215 -> 9;
                                            case 216 -> 27;
                                            case 217 -> 95;
                                            case 218 -> 179;
                                            case 219 -> 119;
                                            case 220 -> 172;
                                            case 221 -> 69;
                                            case 222 -> 254;
                                            case 223 -> 42;
                                            case 224 -> 142;
                                            case 225 -> 79;
                                            case 226 -> 1;
                                            case 227 -> 197;
                                            case 228 -> 14;
                                            case 229 -> 219;
                                            case 230 -> 131;
                                            case 231 -> 161;
                                            case 232 -> 51;
                                            case 233 -> 122;
                                            case 234 -> 169;
                                            case 235 -> 162;
                                            case 236 -> 100;
                                            case 237 -> 61;
                                            case 238 -> 151;
                                            case 239 -> 117;
                                            case 240 -> 48;
                                            case 241 -> 236;
                                            case 242 -> 203;
                                            case 243 -> 5;
                                            case 244 -> 231;
                                            case 245 -> 244;
                                            case 246 -> 156;
                                            case 247 -> 38;
                                            case 248 -> 107;
                                            case 249 -> 13;
                                            case 250 -> 177;
                                            case 251 -> 41;
                                            case 252 -> 164;
                                            case 253 -> 44;
                                            case 254 -> 60;
                                            default -> 148;
                                        };
                                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                                        if (n8 < 0) {
                                            n8 += 256;
                                        }
                                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                                            n6 += 256;
                                        }
                                        int n9 = 0;
                                        while (n9 < cArray.length) {
                                            int n10 = n9 % 2;
                                            int n11 = n9;
                                            char[] cArray2 = cArray;
                                            char c2 = cArray[n11];
                                            if (n10 == 0) {
                                                cArray2[n11] = (char)(c2 ^ n8);
                                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                                            } else {
                                                cArray2[n11] = (char)(c2 ^ n6);
                                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                                            }
                                            ++n9;
                                        }
                                        accept.3.b[n5] = new String(cArray).intern();
                                    }
                                    return b[n5];
                                }
                            };
                            if (actionTimestampArray != null) break block32;
                            if (ActionTimestamp.C()) break block33;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block34;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            ActionTimestamp.C(bl);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 26343005484429L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    ActionTimestamp[] actionTimestampArray = SshAgentIpcService.C();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (actionTimestampArray == null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1971030660 + 13041, 1971030660 + 10995, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(1971030660 + 13045, -1971030660 + -6815, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1971030660 + 13032, 1971030660 + 15861, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1971030660 + 13041, 1971030660 + 10995, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(1971030660 + 13045, -1971030660 + -6815, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1971030660 + 13033, -1971030660 + -11837, (int)l3) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    ActionTimestamp[] actionTimestampArray;
                    block13: {
                        long l2 = 133749692353725L;
                        ActionTimestamp[] actionTimestampArray2 = SshAgentIpcService.C();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(115734810 + (char)-29888, 115734810 + (char)-25238, (int)l2));
                        actionTimestampArray = actionTimestampArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (actionTimestampArray == null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (actionTimestampArray == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(115734810 + (char)-29887, -115734810 + -((char)-13941), (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (actionTimestampArray == null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        ActionTimestamp[] actionTimestampArray;
        long l2;
        block25: {
            block26: {
                l2 = 91460628757951L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                actionTimestampArray = SshAgentIpcService.C();
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (actionTimestampArray == null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (actionTimestampArray == null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-699782730 + -13423, -699782730 + -11377, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-699782730 + -13419, 699782730 + 15525, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-699782730 + -13404, 699782730 + 22159, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-699782730 + -13419, 699782730 + 15525, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-699782730 + -13429, 699782730 + (char)-24547, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-699782730 + -13423, -699782730 + -11377, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-699782730 + -13419, 699782730 + 15525, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-699782730 + -13403, -699782730 + -16544, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (actionTimestampArray == null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-699782730 + -13423, -699782730 + -11377, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-699782730 + -13419, 699782730 + 15525, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-699782730 + -13410, -699782730 + -((char)-29000), (int)l2) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (actionTimestampArray == null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-699782730 + -13423, -699782730 + -11377, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-699782730 + -13419, 699782730 + 15525, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-699782730 + -13409, -699782730 + -27165, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                ActionTimestamp[] actionTimestampArray;
                block16: {
                    l2 = 66603849053393L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                actionTimestampArray = SshAgentIpcService.C();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (actionTimestampArray == null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1791202620 - 22803, 1791202620 - 24849, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(1791202620 - 22807, -1791202620 - -28861, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1791202620 - 22788, 1791202620 - (char)-29120, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(1791202620 - 22787, -1791202620 - -13997, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1791202620 - 22803, 1791202620 - 24849, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1791202620 - 22807, -1791202620 - -28861, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1791202620 - 22782, 1791202620 - 13336, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (actionTimestampArray == null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (actionTimestampArray == null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1791202620 - 22803, 1791202620 - 24849, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(1791202620 - 22807, -1791202620 - -28861, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1791202620 - 22781, -1791202620 - -15611, (int)l2) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1791202620 - 22803, 1791202620 - 24849, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1791202620 - 22807, -1791202620 - -28861, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1791202620 - 22784, -1791202620 - -21499, (int)l2));
                    if (actionTimestampArray == null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1791202620 - 22803, 1791202620 - 24849, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1791202620 - 22807, -1791202620 - -28861, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1791202620 - 22783, 1791202620 - (char)-30456, (int)l2) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
            }
            this.hPipe = WinNT.INVALID_HANDLE_VALUE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[32];
                var3_1 = 0;
                var2_2 = "5\u00cb\u0093\u0091w4J\u007f\u00149O*\u00e6\u00beR\u00dc\u00a9\u0002\u00fb\u0086y\u00b5,\u00f0#\u00d0}\r\u0081\u0006\u00ca\u0093l\u009a\u00e2\u0014\u0018\u00a5s\u00d9QBaA\u000fyR\u00e6<\u00df{\u00efK\u009a\u0019j\u0090z\u00a4\u00cc[\t\u00d1\u0001\u00c9\u00ae+\u0001tK\u00e3\u0005X\u0004>h\u00b2\b\u00b5\u00ef\u0083d'\u00acF\u008e\u0005rd{d\u001a\u001e\u00f7F\u00deD3\u0007\u00cd\u00b9M\u0090+\u00e3*\u00a0\u00f3T\u00f8k\u00f4*\u0005\u00dc/\u0099t\u0090\u00bf\u00cbe\u00db\u0010\u0000\u009c\u00c4\u00da'\u00e6\u00b9|\u00be\u009a\u00d8_RbS\u0093\t\u008a\u0088t\u008e\u00cf\"\u00ce\u00b0Z\u0010(\u00bc\u00c1\u00de\u0087f\u00adl<\u0098\u0088\u001fXj\u0012\u0092?p\u00fc&\u0013!\u00e4\n\u00a9\u00c4C_b\u001bf\u00e8\u00b5^2]\u00c4\u00beS#\u000e\u00e5\u008a\u0080<\u00b5s\n\u00f1\u00c8\u00cf\u00dbE\u00f4x$\u0007\u00a5\u00c1\u00a2`\u000e\u00e6&\u00a5\u00ec\u00f3\u00c7k[9x\u00fd\t:J\u00f2\u00ec\u00d8\u00d0\b\u008b\u00c8D\u0080\u00df0Y\u001d\f\u00b0O3k,/\u00c9\u00f9\u0099bnDF\u00bcT\u00b2\b\u001cC\u00cftY\u00df|7\u00e9\u00c4\u00a9\u00c7\u008a\u001b\u00c7N\u00ffP\b\\\u00b6\u00eb\u0019\u001b9\u00be\u00a1t\u0081\u00c90\u00a4S\t{\u00ed\u00dd\u0089&\u0092@=\u00bb\u00a3\u00b8\u00cb+\u00c6)\u001a \u0082\u009d\u00a1N=_H\u00fa?jx\u001d\u00a5'\u001f\u001f\u0005i\u0080\u00a1\u00f8\u00bb\u00b4.bb\u00ce\u00bd\u0096vo?\u0010\u00ee\u0094P\u00c2\u0013\u0000\u00cb\u00f0\n8T\u0088\u00d9\u0095\u000b\u00b9\u00d1\u0012\u00b8\bUM\u00b6\t\u0087v\u0015\u00c0o=l\u00ea\u00a7\u00fd\u0095!\u0003\u00bbZ\u0086&pc\b\u00f1J\u00ca/)+]E'@k\u00a34\u0080!\u0092\u00d5\u0019q\u0000\u00da\u00a2\u00da\u0019q\u0083O\u00eeXB1\u00b9K\u0097\u00ce\u00f4D\u00d5j\u00dc]\u00d0+\u0080\u0000\u0001\u0007!l\u000e\u001b\r\u00b1\u0091\u0007\u00ff\u00a8\u00b1\u00ef\u001d\u00c0\u0085(\u00bf\u00af\u009bX+\u00ee8\u00a3\u0083\u0004\u00d8Gs\u00a2\u000f#DHk`\u00acSd\u0010\u0083\u00847\u0086q\u0017\u00f3f\u00ceE!\u0015\u00d5_\u00b3}\u000f\u0003\u0088B\u0095\u00f8;\u00e7\u00da\r\u00a6\u00a8B\u00ddVD\"q\u001d\u000e/)j\u008e\u0014%%&U\u008cm\u00d6\u0097\u0093Z\u00b5#\u00fc\u0005\u00a1A8F;{\u00e3\u00fa\u00d8\u00c5~\u00a9\u000eN\u001c\u00eb\u0007\u00cdiA\u0090\u00d9\u00ef2k\u0082y\u001b\u00b5\u00b8\u0093\u00969\u00eeJ<\u00ef\u00fdy(\u00bb'\u0016\u00c8#\u001b\u001e\u0097\u00b2\u00a7\u001b\u00b3$u\u00ed\n\u00a5\u0092U\u00d4\u00f5B\u0000\u0083\rh\u0018\u00e1\u00b7\u0019zi\u00cfaF\u0094{\u00d4g\u00b7\u009dk\u00be\u00fb\u00d4\u00d2\u0017S\u00fc|\u008b)\u00cf\u0016\u00d9N\u00d3F\u00d1\u0091\u00ce\u0095[C$\u00aa8\u00da\u00db\u00af\u00e9\u001a\u00a72#\u00fb\u008e\u00d7\u00bd{D\u00945\u009e\u00c8\u00ef\u00aay\u00c0\u008b\u0082\u0014A";
                var4_3 = "5\u00cb\u0093\u0091w4J\u007f\u00149O*\u00e6\u00beR\u00dc\u00a9\u0002\u00fb\u0086y\u00b5,\u00f0#\u00d0}\r\u0081\u0006\u00ca\u0093l\u009a\u00e2\u0014\u0018\u00a5s\u00d9QBaA\u000fyR\u00e6<\u00df{\u00efK\u009a\u0019j\u0090z\u00a4\u00cc[\t\u00d1\u0001\u00c9\u00ae+\u0001tK\u00e3\u0005X\u0004>h\u00b2\b\u00b5\u00ef\u0083d'\u00acF\u008e\u0005rd{d\u001a\u001e\u00f7F\u00deD3\u0007\u00cd\u00b9M\u0090+\u00e3*\u00a0\u00f3T\u00f8k\u00f4*\u0005\u00dc/\u0099t\u0090\u00bf\u00cbe\u00db\u0010\u0000\u009c\u00c4\u00da'\u00e6\u00b9|\u00be\u009a\u00d8_RbS\u0093\t\u008a\u0088t\u008e\u00cf\"\u00ce\u00b0Z\u0010(\u00bc\u00c1\u00de\u0087f\u00adl<\u0098\u0088\u001fXj\u0012\u0092?p\u00fc&\u0013!\u00e4\n\u00a9\u00c4C_b\u001bf\u00e8\u00b5^2]\u00c4\u00beS#\u000e\u00e5\u008a\u0080<\u00b5s\n\u00f1\u00c8\u00cf\u00dbE\u00f4x$\u0007\u00a5\u00c1\u00a2`\u000e\u00e6&\u00a5\u00ec\u00f3\u00c7k[9x\u00fd\t:J\u00f2\u00ec\u00d8\u00d0\b\u008b\u00c8D\u0080\u00df0Y\u001d\f\u00b0O3k,/\u00c9\u00f9\u0099bnDF\u00bcT\u00b2\b\u001cC\u00cftY\u00df|7\u00e9\u00c4\u00a9\u00c7\u008a\u001b\u00c7N\u00ffP\b\\\u00b6\u00eb\u0019\u001b9\u00be\u00a1t\u0081\u00c90\u00a4S\t{\u00ed\u00dd\u0089&\u0092@=\u00bb\u00a3\u00b8\u00cb+\u00c6)\u001a \u0082\u009d\u00a1N=_H\u00fa?jx\u001d\u00a5'\u001f\u001f\u0005i\u0080\u00a1\u00f8\u00bb\u00b4.bb\u00ce\u00bd\u0096vo?\u0010\u00ee\u0094P\u00c2\u0013\u0000\u00cb\u00f0\n8T\u0088\u00d9\u0095\u000b\u00b9\u00d1\u0012\u00b8\bUM\u00b6\t\u0087v\u0015\u00c0o=l\u00ea\u00a7\u00fd\u0095!\u0003\u00bbZ\u0086&pc\b\u00f1J\u00ca/)+]E'@k\u00a34\u0080!\u0092\u00d5\u0019q\u0000\u00da\u00a2\u00da\u0019q\u0083O\u00eeXB1\u00b9K\u0097\u00ce\u00f4D\u00d5j\u00dc]\u00d0+\u0080\u0000\u0001\u0007!l\u000e\u001b\r\u00b1\u0091\u0007\u00ff\u00a8\u00b1\u00ef\u001d\u00c0\u0085(\u00bf\u00af\u009bX+\u00ee8\u00a3\u0083\u0004\u00d8Gs\u00a2\u000f#DHk`\u00acSd\u0010\u0083\u00847\u0086q\u0017\u00f3f\u00ceE!\u0015\u00d5_\u00b3}\u000f\u0003\u0088B\u0095\u00f8;\u00e7\u00da\r\u00a6\u00a8B\u00ddVD\"q\u001d\u000e/)j\u008e\u0014%%&U\u008cm\u00d6\u0097\u0093Z\u00b5#\u00fc\u0005\u00a1A8F;{\u00e3\u00fa\u00d8\u00c5~\u00a9\u000eN\u001c\u00eb\u0007\u00cdiA\u0090\u00d9\u00ef2k\u0082y\u001b\u00b5\u00b8\u0093\u00969\u00eeJ<\u00ef\u00fdy(\u00bb'\u0016\u00c8#\u001b\u001e\u0097\u00b2\u00a7\u001b\u00b3$u\u00ed\n\u00a5\u0092U\u00d4\u00f5B\u0000\u0083\rh\u0018\u00e1\u00b7\u0019zi\u00cfaF\u0094{\u00d4g\u00b7\u009dk\u00be\u00fb\u00d4\u00d2\u0017S\u00fc|\u008b)\u00cf\u0016\u00d9N\u00d3F\u00d1\u0091\u00ce\u0095[C$\u00aa8\u00da\u00db\u00af\u00e9\u001a\u00a72#\u00fb\u008e\u00d7\u00bd{D\u00945\u009e\u00c8\u00ef\u00aay\u00c0\u008b\u0082\u0014A".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 104;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00bc\u00a6\u001e\u00f9$\u00afI\u00f6\u00bb\u001dy\u00a0\u00a340\u00a5\u0001Ax#!9\u00c7I\u00e8\nm\u0015\u00c3e\u001bN\u00eb\u0006\u0090\u00d8Cs\u00a7";
                    var4_3 = "\u00bc\u00a6\u001e\u00f9$\u00afI\u00f6\u00bb\u001dy\u00a0\u00a340\u00a5\u0001Ax#!9\u00c7I\u00e8\nm\u0015\u00c3e\u001bN\u00eb\u0006\u0090\u00d8Cs\u00a7".length();
                    var1_4 = 9;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 101;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 120;
                            break;
                        }
                        case 1: {
                            v15 = 20;
                            break;
                        }
                        case 2: {
                            v15 = 81;
                            break;
                        }
                        case 3: {
                            v15 = 46;
                            break;
                        }
                        case 4: {
                            v15 = 100;
                            break;
                        }
                        case 5: {
                            v15 = 14;
                            break;
                        }
                        default: {
                            v15 = 99;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[32];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x48F3) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 30;
                case 1 -> 44;
                case 2 -> 106;
                case 3 -> 4;
                case 4 -> 122;
                case 5 -> 64;
                case 6 -> 132;
                case 7 -> 69;
                case 8 -> 241;
                case 9 -> 131;
                case 10 -> 207;
                case 11 -> 83;
                case 12 -> 8;
                case 13 -> 239;
                case 14 -> 206;
                case 15 -> 75;
                case 16 -> 216;
                case 17 -> 92;
                case 18 -> 143;
                case 19 -> 128;
                case 20 -> 252;
                case 21 -> 255;
                case 22 -> 90;
                case 23 -> 183;
                case 24 -> 116;
                case 25 -> 17;
                case 26 -> 146;
                case 27 -> 254;
                case 28 -> 48;
                case 29 -> 185;
                case 30 -> 209;
                case 31 -> 47;
                case 32 -> 33;
                case 33 -> 232;
                case 34 -> 164;
                case 35 -> 99;
                case 36 -> 238;
                case 37 -> 148;
                case 38 -> 162;
                case 39 -> 150;
                case 40 -> 163;
                case 41 -> 160;
                case 42 -> 245;
                case 43 -> 242;
                case 44 -> 178;
                case 45 -> 31;
                case 46 -> 51;
                case 47 -> 141;
                case 48 -> 84;
                case 49 -> 248;
                case 50 -> 235;
                case 51 -> 102;
                case 52 -> 78;
                case 53 -> 243;
                case 54 -> 13;
                case 55 -> 93;
                case 56 -> 155;
                case 57 -> 133;
                case 58 -> 127;
                case 59 -> 177;
                case 60 -> 217;
                case 61 -> 27;
                case 62 -> 59;
                case 63 -> 171;
                case 64 -> 199;
                case 65 -> 112;
                case 66 -> 170;
                case 67 -> 240;
                case 68 -> 138;
                case 69 -> 67;
                case 70 -> 0;
                case 71 -> 136;
                case 72 -> 36;
                case 73 -> 169;
                case 74 -> 193;
                case 75 -> 153;
                case 76 -> 57;
                case 77 -> 103;
                case 78 -> 214;
                case 79 -> 29;
                case 80 -> 225;
                case 81 -> 2;
                case 82 -> 203;
                case 83 -> 201;
                case 84 -> 233;
                case 85 -> 197;
                case 86 -> 237;
                case 87 -> 100;
                case 88 -> 221;
                case 89 -> 159;
                case 90 -> 104;
                case 91 -> 76;
                case 92 -> 19;
                case 93 -> 125;
                case 94 -> 194;
                case 95 -> 52;
                case 96 -> 50;
                case 97 -> 230;
                case 98 -> 62;
                case 99 -> 88;
                case 100 -> 135;
                case 101 -> 227;
                case 102 -> 28;
                case 103 -> 114;
                case 104 -> 165;
                case 105 -> 251;
                case 106 -> 5;
                case 107 -> 247;
                case 108 -> 200;
                case 109 -> 56;
                case 110 -> 118;
                case 111 -> 101;
                case 112 -> 182;
                case 113 -> 23;
                case 114 -> 39;
                case 115 -> 205;
                case 116 -> 68;
                case 117 -> 86;
                case 118 -> 82;
                case 119 -> 85;
                case 120 -> 151;
                case 121 -> 140;
                case 122 -> 24;
                case 123 -> 94;
                case 124 -> 196;
                case 125 -> 149;
                case 126 -> 98;
                case 127 -> 3;
                case 128 -> 81;
                case 129 -> 191;
                case 130 -> 231;
                case 131 -> 91;
                case 132 -> 35;
                case 133 -> 41;
                case 134 -> 71;
                case 135 -> 53;
                case 136 -> 110;
                case 137 -> 210;
                case 138 -> 202;
                case 139 -> 123;
                case 140 -> 139;
                case 141 -> 72;
                case 142 -> 236;
                case 143 -> 192;
                case 144 -> 129;
                case 145 -> 145;
                case 146 -> 157;
                case 147 -> 244;
                case 148 -> 224;
                case 149 -> 250;
                case 150 -> 249;
                case 151 -> 12;
                case 152 -> 37;
                case 153 -> 32;
                case 154 -> 34;
                case 155 -> 55;
                case 156 -> 121;
                case 157 -> 195;
                case 158 -> 25;
                case 159 -> 117;
                case 160 -> 11;
                case 161 -> 211;
                case 162 -> 20;
                case 163 -> 21;
                case 164 -> 80;
                case 165 -> 142;
                case 166 -> 22;
                case 167 -> 119;
                case 168 -> 61;
                case 169 -> 176;
                case 170 -> 26;
                case 171 -> 77;
                case 172 -> 253;
                case 173 -> 212;
                case 174 -> 219;
                case 175 -> 215;
                case 176 -> 66;
                case 177 -> 108;
                case 178 -> 111;
                case 179 -> 97;
                case 180 -> 54;
                case 181 -> 7;
                case 182 -> 190;
                case 183 -> 218;
                case 184 -> 198;
                case 185 -> 173;
                case 186 -> 152;
                case 187 -> 172;
                case 188 -> 49;
                case 189 -> 186;
                case 190 -> 223;
                case 191 -> 107;
                case 192 -> 120;
                case 193 -> 228;
                case 194 -> 63;
                case 195 -> 134;
                case 196 -> 147;
                case 197 -> 65;
                case 198 -> 96;
                case 199 -> 89;
                case 200 -> 38;
                case 201 -> 181;
                case 202 -> 154;
                case 203 -> 229;
                case 204 -> 246;
                case 205 -> 156;
                case 206 -> 220;
                case 207 -> 158;
                case 208 -> 10;
                case 209 -> 14;
                case 210 -> 189;
                case 211 -> 109;
                case 212 -> 60;
                case 213 -> 115;
                case 214 -> 130;
                case 215 -> 222;
                case 216 -> 6;
                case 217 -> 234;
                case 218 -> 180;
                case 219 -> 168;
                case 220 -> 166;
                case 221 -> 46;
                case 222 -> 179;
                case 223 -> 137;
                case 224 -> 95;
                case 225 -> 9;
                case 226 -> 167;
                case 227 -> 161;
                case 228 -> 43;
                case 229 -> 226;
                case 230 -> 15;
                case 231 -> 175;
                case 232 -> 16;
                case 233 -> 1;
                case 234 -> 184;
                case 235 -> 40;
                case 236 -> 79;
                case 237 -> 208;
                case 238 -> 70;
                case 239 -> 74;
                case 240 -> 204;
                case 241 -> 42;
                case 242 -> 213;
                case 243 -> 58;
                case 244 -> 105;
                case 245 -> 18;
                case 246 -> 73;
                case 247 -> 187;
                case 248 -> 174;
                case 249 -> 45;
                case 250 -> 126;
                case 251 -> 188;
                case 252 -> 113;
                case 253 -> 144;
                case 254 -> 87;
                default -> 124;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 87876062773295L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1031914110 + 11490, 1031914110 - 16134, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        ActionTimestamp[] actionTimestampArray;
                        block4: {
                            l2 = 103007205352879L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            actionTimestampArray = SshAgentIpcService.C();
                            try {
                                hANDLE2 = hANDLE;
                                if (actionTimestampArray == null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (actionTimestampArray == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1004651550 + 18115, 1004651550 + (char)-23801, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1004651550 + 18116, -1004651550 + -((char)-19786), (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1004651550 + 18117, -1004651550 + -30024, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "E\u00f2!\u00f9\u0017+I\u00ce\u0010\u0091iJ+\u00c0\u00caJ\u00abF\u00dc\u0088\u00a1J\u00b2\u0002\u000f";
                    var4_3 = "E\u00f2!\u00f9\u0017+I\u00ce\u0010\u0091iJ+\u00c0\u00caJ\u00abF\u00dc\u0088\u00a1J\u00b2\u0002\u000f".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 125;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "&\u00b6\u009c\u00a0\u00015\u00b8NX\u00d3K=\u00f2/\u00f7&\u00fd\u00ef\u00c2@\u00c7\n\u00c8\u0092\u00ff\u0082(\u009d\n\u00ee?\u00de\u0007BV\u00db\u00ca=\u00cb)a[1\u00fcF\u001b\u009a\u00b3Q\u0091H\u00ad\u00fb\u009d=\u0081\u00b9mO";
                        var4_3 = "&\u00b6\u009c\u00a0\u00015\u00b8NX\u00d3K=\u00f2/\u00f7&\u00fd\u00ef\u00c2@\u00c7\n\u00c8\u0092\u00ff\u0082(\u009d\n\u00ee?\u00de\u0007BV\u00db\u00ca=\u00cb)a[1\u00fcF\u001b\u009a\u00b3Q\u0091H\u00ad\u00fb\u009d=\u0081\u00b9mO".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 74;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 81;
                                break;
                            }
                            case 1: {
                                v15 = 35;
                                break;
                            }
                            case 2: {
                                v15 = 127;
                                break;
                            }
                            case 3: {
                                v15 = 48;
                                break;
                            }
                            case 4: {
                                v15 = 32;
                                break;
                            }
                            case 5: {
                                v15 = 104;
                                break;
                            }
                            default: {
                                v15 = 83;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x6F4F) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 239;
                    case 1 -> 39;
                    case 2 -> 51;
                    case 3 -> 170;
                    case 4 -> 209;
                    case 5 -> 247;
                    case 6 -> 15;
                    case 7 -> 186;
                    case 8 -> 16;
                    case 9 -> 43;
                    case 10 -> 76;
                    case 11 -> 107;
                    case 12 -> 67;
                    case 13 -> 118;
                    case 14 -> 100;
                    case 15 -> 201;
                    case 16 -> 42;
                    case 17 -> 230;
                    case 18 -> 165;
                    case 19 -> 74;
                    case 20 -> 53;
                    case 21 -> 18;
                    case 22 -> 151;
                    case 23 -> 245;
                    case 24 -> 113;
                    case 25 -> 58;
                    case 26 -> 159;
                    case 27 -> 145;
                    case 28 -> 93;
                    case 29 -> 82;
                    case 30 -> 174;
                    case 31 -> 157;
                    case 32 -> 220;
                    case 33 -> 97;
                    case 34 -> 69;
                    case 35 -> 180;
                    case 36 -> 175;
                    case 37 -> 35;
                    case 38 -> 99;
                    case 39 -> 23;
                    case 40 -> 229;
                    case 41 -> 164;
                    case 42 -> 10;
                    case 43 -> 109;
                    case 44 -> 144;
                    case 45 -> 251;
                    case 46 -> 127;
                    case 47 -> 61;
                    case 48 -> 75;
                    case 49 -> 222;
                    case 50 -> 236;
                    case 51 -> 128;
                    case 52 -> 66;
                    case 53 -> 95;
                    case 54 -> 167;
                    case 55 -> 90;
                    case 56 -> 160;
                    case 57 -> 149;
                    case 58 -> 202;
                    case 59 -> 103;
                    case 60 -> 26;
                    case 61 -> 54;
                    case 62 -> 4;
                    case 63 -> 246;
                    case 64 -> 208;
                    case 65 -> 255;
                    case 66 -> 5;
                    case 67 -> 140;
                    case 68 -> 242;
                    case 69 -> 112;
                    case 70 -> 131;
                    case 71 -> 192;
                    case 72 -> 11;
                    case 73 -> 17;
                    case 74 -> 169;
                    case 75 -> 106;
                    case 76 -> 94;
                    case 77 -> 227;
                    case 78 -> 111;
                    case 79 -> 121;
                    case 80 -> 200;
                    case 81 -> 78;
                    case 82 -> 142;
                    case 83 -> 141;
                    case 84 -> 221;
                    case 85 -> 89;
                    case 86 -> 7;
                    case 87 -> 25;
                    case 88 -> 237;
                    case 89 -> 249;
                    case 90 -> 28;
                    case 91 -> 184;
                    case 92 -> 122;
                    case 93 -> 253;
                    case 94 -> 207;
                    case 95 -> 161;
                    case 96 -> 116;
                    case 97 -> 105;
                    case 98 -> 1;
                    case 99 -> 243;
                    case 100 -> 138;
                    case 101 -> 101;
                    case 102 -> 139;
                    case 103 -> 153;
                    case 104 -> 252;
                    case 105 -> 62;
                    case 106 -> 238;
                    case 107 -> 126;
                    case 108 -> 3;
                    case 109 -> 48;
                    case 110 -> 6;
                    case 111 -> 216;
                    case 112 -> 110;
                    case 113 -> 32;
                    case 114 -> 91;
                    case 115 -> 19;
                    case 116 -> 83;
                    case 117 -> 173;
                    case 118 -> 232;
                    case 119 -> 73;
                    case 120 -> 143;
                    case 121 -> 21;
                    case 122 -> 55;
                    case 123 -> 163;
                    case 124 -> 65;
                    case 125 -> 166;
                    case 126 -> 63;
                    case 127 -> 45;
                    case 128 -> 64;
                    case 129 -> 244;
                    case 130 -> 191;
                    case 131 -> 104;
                    case 132 -> 235;
                    case 133 -> 158;
                    case 134 -> 85;
                    case 135 -> 206;
                    case 136 -> 150;
                    case 137 -> 226;
                    case 138 -> 27;
                    case 139 -> 20;
                    case 140 -> 50;
                    case 141 -> 81;
                    case 142 -> 88;
                    case 143 -> 224;
                    case 144 -> 70;
                    case 145 -> 154;
                    case 146 -> 24;
                    case 147 -> 152;
                    case 148 -> 134;
                    case 149 -> 123;
                    case 150 -> 146;
                    case 151 -> 96;
                    case 152 -> 194;
                    case 153 -> 37;
                    case 154 -> 129;
                    case 155 -> 47;
                    case 156 -> 205;
                    case 157 -> 182;
                    case 158 -> 254;
                    case 159 -> 30;
                    case 160 -> 117;
                    case 161 -> 84;
                    case 162 -> 178;
                    case 163 -> 156;
                    case 164 -> 79;
                    case 165 -> 162;
                    case 166 -> 68;
                    case 167 -> 210;
                    case 168 -> 40;
                    case 169 -> 2;
                    case 170 -> 57;
                    case 171 -> 168;
                    case 172 -> 147;
                    case 173 -> 155;
                    case 174 -> 125;
                    case 175 -> 77;
                    case 176 -> 130;
                    case 177 -> 172;
                    case 178 -> 135;
                    case 179 -> 49;
                    case 180 -> 36;
                    case 181 -> 12;
                    case 182 -> 136;
                    case 183 -> 190;
                    case 184 -> 233;
                    case 185 -> 211;
                    case 186 -> 223;
                    case 187 -> 108;
                    case 188 -> 199;
                    case 189 -> 176;
                    case 190 -> 137;
                    case 191 -> 22;
                    case 192 -> 52;
                    case 193 -> 124;
                    case 194 -> 133;
                    case 195 -> 114;
                    case 196 -> 195;
                    case 197 -> 119;
                    case 198 -> 98;
                    case 199 -> 217;
                    case 200 -> 41;
                    case 201 -> 198;
                    case 202 -> 228;
                    case 203 -> 215;
                    case 204 -> 177;
                    case 205 -> 86;
                    case 206 -> 197;
                    case 207 -> 60;
                    case 208 -> 231;
                    case 209 -> 219;
                    case 210 -> 13;
                    case 211 -> 250;
                    case 212 -> 203;
                    case 213 -> 240;
                    case 214 -> 214;
                    case 215 -> 9;
                    case 216 -> 102;
                    case 217 -> 248;
                    case 218 -> 225;
                    case 219 -> 189;
                    case 220 -> 179;
                    case 221 -> 193;
                    case 222 -> 71;
                    case 223 -> 0;
                    case 224 -> 212;
                    case 225 -> 46;
                    case 226 -> 31;
                    case 227 -> 204;
                    case 228 -> 56;
                    case 229 -> 181;
                    case 230 -> 14;
                    case 231 -> 120;
                    case 232 -> 187;
                    case 233 -> 38;
                    case 234 -> 218;
                    case 235 -> 33;
                    case 236 -> 148;
                    case 237 -> 213;
                    case 238 -> 72;
                    case 239 -> 115;
                    case 240 -> 8;
                    case 241 -> 92;
                    case 242 -> 59;
                    case 243 -> 44;
                    case 244 -> 80;
                    case 245 -> 87;
                    case 246 -> 183;
                    case 247 -> 171;
                    case 248 -> 132;
                    case 249 -> 196;
                    case 250 -> 34;
                    case 251 -> 234;
                    case 252 -> 188;
                    case 253 -> 185;
                    case 254 -> 241;
                    default -> 29;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 20521576507659L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "\tm\\\u0015B\u0019mP\t\u000egO\u001f\u000f[pL!";
                    var5_4 = "\tm\\\u0015B\u0019mP\t\u000egO\u001f\u000f[pL!".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 69;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 39;
                                    break;
                                }
                                case 1: {
                                    v11 = 77;
                                    break;
                                }
                                case 2: {
                                    v11 = 107;
                                    break;
                                }
                                case 3: {
                                    v11 = 62;
                                    break;
                                }
                                case 4: {
                                    v11 = 98;
                                    break;
                                }
                                case 5: {
                                    v11 = 48;
                                    break;
                                }
                                default: {
                                    v11 = 27;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 49055327457611L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "f=}\"%?\u001a\u0004`#q8\nl<z8)=\u0002F=s\tl<z8)=\u0002J7\rk:g5#0\u0018J0`?\"9";
                    var5_4 = "f=}\"%?\u001a\u0004`#q8\nl<z8)=\u0002F=s\tl<z8)=\u0002J7\rk:g5#0\u0018J0`?\"9".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 102;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "/|8ffsR\u0006/|8fjy";
                        var5_4 = "/|8ffsR\u0006/|8fjy".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 37;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 73;
                                break;
                            }
                            case 1: {
                                v15 = 53;
                                break;
                            }
                            case 2: {
                                v15 = 114;
                                break;
                            }
                            case 3: {
                                v15 = 48;
                                break;
                            }
                            case 4: {
                                v15 = 42;
                                break;
                            }
                            case 5: {
                                v15 = 56;
                                break;
                            }
                            default: {
                                v15 = 16;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 68802661509949L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-1580442060 - -((char)-6621), 1580442060 - (char)-22468, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 6826103875789L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00cdRf\u00ee\u00c1\u0003\u007f\u00d9\u0084\u0005\u0094\u0014k\u00e2\u0083\r\u00b4\u00e6Y\u00f60\u009cELp\u00d4j@\u0088\u0010N\u0017\u00c1#\u001c\u00b3\u00eb\u0094lK\n\u00febc\u0017+\u0005J\u00b3\u00b0\u0016\u00f83\u00f2\u0016\u00b6\u00d5')\u00bc\u00d3\u00fb^su\u008bC\u00060a\u00d8\u00c1b\u00a3F\u00d2\u00bc\u00f9w\u009f\u00ca:\u00b1\u00d9;\u0014\u00e6\u0091\b\u001au\u0085\\\u00d6\u00ea\bG\u00b3\u0013\u0096\u00c9\u00f2\u00fa\u007f";
                    var4_3 = "\u00cdRf\u00ee\u00c1\u0003\u007f\u00d9\u0084\u0005\u0094\u0014k\u00e2\u0083\r\u00b4\u00e6Y\u00f60\u009cELp\u00d4j@\u0088\u0010N\u0017\u00c1#\u001c\u00b3\u00eb\u0094lK\n\u00febc\u0017+\u0005J\u00b3\u00b0\u0016\u00f83\u00f2\u0016\u00b6\u00d5')\u00bc\u00d3\u00fb^su\u008bC\u00060a\u00d8\u00c1b\u00a3F\u00d2\u00bc\u00f9w\u009f\u00ca:\u00b1\u00d9;\u0014\u00e6\u0091\b\u001au\u0085\\\u00d6\u00ea\bG\u00b3\u0013\u0096\u00c9\u00f2\u00fa\u007f".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 81;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00ce\u00a2\u00eb\u00afc\u0018>\u00db\u00ec\u0098 \u00be\u001dQ\u00c2WL\u00dc\u00ec^\u00ac\u00ff\u00b0\u00c3\u00a0\u00dadJ\u0098^\u001b9g\u00b9\u00d9\u001f\u008e*\u0085\u00f3\\\u00c4\u00ba'\u008f\u00edj\u00f6\u0015\u00db\u00f7#\fD\u0011N\u008c\u00a37S\u00bb\u00f7h\u00ef\u00a4\u0015YQy\u0014\u0003>G\u00bd\u001b\u00e5]\u008c\u0005{\u009b\u008d\u001a\u00a9)H\u00d6\u00ad\u000e\u00c4\u00cb\u00bd[";
                        var4_3 = "\u00ce\u00a2\u00eb\u00afc\u0018>\u00db\u00ec\u0098 \u00be\u001dQ\u00c2WL\u00dc\u00ec^\u00ac\u00ff\u00b0\u00c3\u00a0\u00dadJ\u0098^\u001b9g\u00b9\u00d9\u001f\u008e*\u0085\u00f3\\\u00c4\u00ba'\u008f\u00edj\u00f6\u0015\u00db\u00f7#\fD\u0011N\u008c\u00a37S\u00bb\u00f7h\u00ef\u00a4\u0015YQy\u0014\u0003>G\u00bd\u001b\u00e5]\u008c\u0005{\u009b\u008d\u001a\u00a9)H\u00d6\u00ad\u000e\u00c4\u00cb\u00bd[".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 72;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 71;
                                break;
                            }
                            case 1: {
                                v15 = 123;
                                break;
                            }
                            case 2: {
                                v15 = 100;
                                break;
                            }
                            case 3: {
                                v15 = 85;
                                break;
                            }
                            case 4: {
                                v15 = 71;
                                break;
                            }
                            case 5: {
                                v15 = 21;
                                break;
                            }
                            default: {
                                v15 = 44;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFAF6A) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 212;
                    case 1 -> 199;
                    case 2 -> 92;
                    case 3 -> 196;
                    case 4 -> 154;
                    case 5 -> 121;
                    case 6 -> 34;
                    case 7 -> 40;
                    case 8 -> 23;
                    case 9 -> 68;
                    case 10 -> 225;
                    case 11 -> 228;
                    case 12 -> 89;
                    case 13 -> 30;
                    case 14 -> 206;
                    case 15 -> 75;
                    case 16 -> 195;
                    case 17 -> 172;
                    case 18 -> 230;
                    case 19 -> 238;
                    case 20 -> 17;
                    case 21 -> 97;
                    case 22 -> 94;
                    case 23 -> 204;
                    case 24 -> 15;
                    case 25 -> 14;
                    case 26 -> 188;
                    case 27 -> 251;
                    case 28 -> 117;
                    case 29 -> 2;
                    case 30 -> 169;
                    case 31 -> 115;
                    case 32 -> 215;
                    case 33 -> 161;
                    case 34 -> 41;
                    case 35 -> 56;
                    case 36 -> 179;
                    case 37 -> 80;
                    case 38 -> 90;
                    case 39 -> 11;
                    case 40 -> 147;
                    case 41 -> 71;
                    case 42 -> 50;
                    case 43 -> 165;
                    case 44 -> 27;
                    case 45 -> 235;
                    case 46 -> 49;
                    case 47 -> 53;
                    case 48 -> 70;
                    case 49 -> 62;
                    case 50 -> 47;
                    case 51 -> 132;
                    case 52 -> 32;
                    case 53 -> 12;
                    case 54 -> 138;
                    case 55 -> 164;
                    case 56 -> 226;
                    case 57 -> 191;
                    case 58 -> 162;
                    case 59 -> 63;
                    case 60 -> 78;
                    case 61 -> 146;
                    case 62 -> 217;
                    case 63 -> 59;
                    case 64 -> 137;
                    case 65 -> 166;
                    case 66 -> 233;
                    case 67 -> 10;
                    case 68 -> 106;
                    case 69 -> 24;
                    case 70 -> 25;
                    case 71 -> 232;
                    case 72 -> 125;
                    case 73 -> 120;
                    case 74 -> 249;
                    case 75 -> 245;
                    case 76 -> 104;
                    case 77 -> 159;
                    case 78 -> 156;
                    case 79 -> 58;
                    case 80 -> 236;
                    case 81 -> 43;
                    case 82 -> 81;
                    case 83 -> 135;
                    case 84 -> 214;
                    case 85 -> 190;
                    case 86 -> 18;
                    case 87 -> 72;
                    case 88 -> 77;
                    case 89 -> 244;
                    case 90 -> 22;
                    case 91 -> 211;
                    case 92 -> 198;
                    case 93 -> 37;
                    case 94 -> 131;
                    case 95 -> 116;
                    case 96 -> 247;
                    case 97 -> 127;
                    case 98 -> 252;
                    case 99 -> 102;
                    case 100 -> 98;
                    case 101 -> 216;
                    case 102 -> 79;
                    case 103 -> 95;
                    case 104 -> 175;
                    case 105 -> 150;
                    case 106 -> 109;
                    case 107 -> 201;
                    case 108 -> 176;
                    case 109 -> 157;
                    case 110 -> 181;
                    case 111 -> 76;
                    case 112 -> 163;
                    case 113 -> 67;
                    case 114 -> 48;
                    case 115 -> 218;
                    case 116 -> 54;
                    case 117 -> 6;
                    case 118 -> 240;
                    case 119 -> 152;
                    case 120 -> 13;
                    case 121 -> 28;
                    case 122 -> 248;
                    case 123 -> 148;
                    case 124 -> 187;
                    case 125 -> 239;
                    case 126 -> 134;
                    case 127 -> 208;
                    case 128 -> 129;
                    case 129 -> 21;
                    case 130 -> 220;
                    case 131 -> 130;
                    case 132 -> 149;
                    case 133 -> 171;
                    case 134 -> 5;
                    case 135 -> 114;
                    case 136 -> 52;
                    case 137 -> 107;
                    case 138 -> 88;
                    case 139 -> 209;
                    case 140 -> 91;
                    case 141 -> 151;
                    case 142 -> 31;
                    case 143 -> 167;
                    case 144 -> 100;
                    case 145 -> 255;
                    case 146 -> 36;
                    case 147 -> 66;
                    case 148 -> 200;
                    case 149 -> 108;
                    case 150 -> 20;
                    case 151 -> 193;
                    case 152 -> 19;
                    case 153 -> 61;
                    case 154 -> 46;
                    case 155 -> 182;
                    case 156 -> 227;
                    case 157 -> 118;
                    case 158 -> 223;
                    case 159 -> 145;
                    case 160 -> 184;
                    case 161 -> 111;
                    case 162 -> 96;
                    case 163 -> 160;
                    case 164 -> 234;
                    case 165 -> 253;
                    case 166 -> 229;
                    case 167 -> 140;
                    case 168 -> 55;
                    case 169 -> 123;
                    case 170 -> 42;
                    case 171 -> 93;
                    case 172 -> 136;
                    case 173 -> 237;
                    case 174 -> 69;
                    case 175 -> 87;
                    case 176 -> 4;
                    case 177 -> 186;
                    case 178 -> 192;
                    case 179 -> 219;
                    case 180 -> 203;
                    case 181 -> 173;
                    case 182 -> 141;
                    case 183 -> 51;
                    case 184 -> 143;
                    case 185 -> 231;
                    case 186 -> 1;
                    case 187 -> 44;
                    case 188 -> 155;
                    case 189 -> 197;
                    case 190 -> 139;
                    case 191 -> 122;
                    case 192 -> 168;
                    case 193 -> 158;
                    case 194 -> 210;
                    case 195 -> 128;
                    case 196 -> 39;
                    case 197 -> 83;
                    case 198 -> 153;
                    case 199 -> 178;
                    case 200 -> 174;
                    case 201 -> 82;
                    case 202 -> 112;
                    case 203 -> 101;
                    case 204 -> 242;
                    case 205 -> 177;
                    case 206 -> 33;
                    case 207 -> 57;
                    case 208 -> 250;
                    case 209 -> 254;
                    case 210 -> 170;
                    case 211 -> 105;
                    case 212 -> 73;
                    case 213 -> 205;
                    case 214 -> 84;
                    case 215 -> 207;
                    case 216 -> 221;
                    case 217 -> 60;
                    case 218 -> 65;
                    case 219 -> 243;
                    case 220 -> 3;
                    case 221 -> 0;
                    case 222 -> 119;
                    case 223 -> 144;
                    case 224 -> 64;
                    case 225 -> 126;
                    case 226 -> 16;
                    case 227 -> 103;
                    case 228 -> 183;
                    case 229 -> 224;
                    case 230 -> 113;
                    case 231 -> 8;
                    case 232 -> 9;
                    case 233 -> 74;
                    case 234 -> 124;
                    case 235 -> 86;
                    case 236 -> 110;
                    case 237 -> 189;
                    case 238 -> 194;
                    case 239 -> 29;
                    case 240 -> 45;
                    case 241 -> 26;
                    case 242 -> 142;
                    case 243 -> 99;
                    case 244 -> 180;
                    case 245 -> 35;
                    case 246 -> 222;
                    case 247 -> 185;
                    case 248 -> 38;
                    case 249 -> 7;
                    case 250 -> 85;
                    case 251 -> 133;
                    case 252 -> 202;
                    case 253 -> 213;
                    case 254 -> 246;
                    default -> 241;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 86269699452705L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(986301750 + (char)-18962, 986301750 + 16759, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 118674992163537L;
                    ActionTimestamp[] actionTimestampArray = SshAgentIpcService.C();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(750768960 + (char)-21611, -750768960 + -29016, (int)l2));
                    ActionTimestamp[] actionTimestampArray2 = actionTimestampArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (actionTimestampArray2 == null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 54109841260906L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u0093\u00cf\u001d\u0092\u009b\u0003 |=";
                var4_3 = "\u0093\u00cf\u001d\u0092\u009b\u0003 |=".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 54;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 45;
                                break;
                            }
                            case 1: {
                                v11 = 88;
                                break;
                            }
                            case 2: {
                                v11 = 18;
                                break;
                            }
                            case 3: {
                                v11 = 117;
                                break;
                            }
                            case 4: {
                                v11 = 55;
                                break;
                            }
                            case 5: {
                                v11 = 102;
                                break;
                            }
                            default: {
                                v11 = 60;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x1405) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 35;
                    case 1 -> 102;
                    case 2 -> 172;
                    case 3 -> 216;
                    case 4 -> 0;
                    case 5 -> 1;
                    case 6 -> 36;
                    case 7 -> 237;
                    case 8 -> 17;
                    case 9 -> 73;
                    case 10 -> 31;
                    case 11 -> 103;
                    case 12 -> 217;
                    case 13 -> 79;
                    case 14 -> 166;
                    case 15 -> 44;
                    case 16 -> 147;
                    case 17 -> 212;
                    case 18 -> 89;
                    case 19 -> 51;
                    case 20 -> 222;
                    case 21 -> 71;
                    case 22 -> 82;
                    case 23 -> 185;
                    case 24 -> 94;
                    case 25 -> 170;
                    case 26 -> 47;
                    case 27 -> 77;
                    case 28 -> 153;
                    case 29 -> 127;
                    case 30 -> 229;
                    case 31 -> 252;
                    case 32 -> 121;
                    case 33 -> 87;
                    case 34 -> 169;
                    case 35 -> 243;
                    case 36 -> 109;
                    case 37 -> 12;
                    case 38 -> 210;
                    case 39 -> 96;
                    case 40 -> 150;
                    case 41 -> 159;
                    case 42 -> 221;
                    case 43 -> 26;
                    case 44 -> 29;
                    case 45 -> 98;
                    case 46 -> 203;
                    case 47 -> 59;
                    case 48 -> 197;
                    case 49 -> 180;
                    case 50 -> 19;
                    case 51 -> 68;
                    case 52 -> 119;
                    case 53 -> 240;
                    case 54 -> 227;
                    case 55 -> 76;
                    case 56 -> 54;
                    case 57 -> 30;
                    case 58 -> 164;
                    case 59 -> 113;
                    case 60 -> 7;
                    case 61 -> 58;
                    case 62 -> 149;
                    case 63 -> 22;
                    case 64 -> 23;
                    case 65 -> 13;
                    case 66 -> 33;
                    case 67 -> 20;
                    case 68 -> 21;
                    case 69 -> 38;
                    case 70 -> 183;
                    case 71 -> 230;
                    case 72 -> 176;
                    case 73 -> 142;
                    case 74 -> 132;
                    case 75 -> 92;
                    case 76 -> 143;
                    case 77 -> 115;
                    case 78 -> 226;
                    case 79 -> 45;
                    case 80 -> 81;
                    case 81 -> 208;
                    case 82 -> 204;
                    case 83 -> 148;
                    case 84 -> 107;
                    case 85 -> 99;
                    case 86 -> 194;
                    case 87 -> 193;
                    case 88 -> 117;
                    case 89 -> 80;
                    case 90 -> 105;
                    case 91 -> 78;
                    case 92 -> 145;
                    case 93 -> 141;
                    case 94 -> 173;
                    case 95 -> 9;
                    case 96 -> 188;
                    case 97 -> 207;
                    case 98 -> 211;
                    case 99 -> 168;
                    case 100 -> 64;
                    case 101 -> 205;
                    case 102 -> 65;
                    case 103 -> 167;
                    case 104 -> 223;
                    case 105 -> 233;
                    case 106 -> 218;
                    case 107 -> 42;
                    case 108 -> 124;
                    case 109 -> 199;
                    case 110 -> 2;
                    case 111 -> 165;
                    case 112 -> 160;
                    case 113 -> 93;
                    case 114 -> 8;
                    case 115 -> 162;
                    case 116 -> 133;
                    case 117 -> 161;
                    case 118 -> 192;
                    case 119 -> 131;
                    case 120 -> 158;
                    case 121 -> 40;
                    case 122 -> 75;
                    case 123 -> 136;
                    case 124 -> 104;
                    case 125 -> 225;
                    case 126 -> 53;
                    case 127 -> 110;
                    case 128 -> 118;
                    case 129 -> 15;
                    case 130 -> 146;
                    case 131 -> 90;
                    case 132 -> 220;
                    case 133 -> 254;
                    case 134 -> 39;
                    case 135 -> 154;
                    case 136 -> 163;
                    case 137 -> 14;
                    case 138 -> 18;
                    case 139 -> 177;
                    case 140 -> 3;
                    case 141 -> 4;
                    case 142 -> 86;
                    case 143 -> 83;
                    case 144 -> 138;
                    case 145 -> 85;
                    case 146 -> 242;
                    case 147 -> 241;
                    case 148 -> 101;
                    case 149 -> 157;
                    case 150 -> 200;
                    case 151 -> 190;
                    case 152 -> 139;
                    case 153 -> 178;
                    case 154 -> 137;
                    case 155 -> 97;
                    case 156 -> 55;
                    case 157 -> 186;
                    case 158 -> 228;
                    case 159 -> 63;
                    case 160 -> 232;
                    case 161 -> 196;
                    case 162 -> 250;
                    case 163 -> 61;
                    case 164 -> 50;
                    case 165 -> 182;
                    case 166 -> 206;
                    case 167 -> 112;
                    case 168 -> 11;
                    case 169 -> 191;
                    case 170 -> 253;
                    case 171 -> 84;
                    case 172 -> 123;
                    case 173 -> 231;
                    case 174 -> 213;
                    case 175 -> 57;
                    case 176 -> 125;
                    case 177 -> 151;
                    case 178 -> 129;
                    case 179 -> 219;
                    case 180 -> 108;
                    case 181 -> 130;
                    case 182 -> 251;
                    case 183 -> 48;
                    case 184 -> 234;
                    case 185 -> 69;
                    case 186 -> 60;
                    case 187 -> 74;
                    case 188 -> 201;
                    case 189 -> 175;
                    case 190 -> 67;
                    case 191 -> 238;
                    case 192 -> 198;
                    case 193 -> 24;
                    case 194 -> 140;
                    case 195 -> 56;
                    case 196 -> 152;
                    case 197 -> 88;
                    case 198 -> 235;
                    case 199 -> 202;
                    case 200 -> 174;
                    case 201 -> 155;
                    case 202 -> 27;
                    case 203 -> 32;
                    case 204 -> 106;
                    case 205 -> 49;
                    case 206 -> 95;
                    case 207 -> 43;
                    case 208 -> 66;
                    case 209 -> 114;
                    case 210 -> 236;
                    case 211 -> 187;
                    case 212 -> 181;
                    case 213 -> 245;
                    case 214 -> 134;
                    case 215 -> 116;
                    case 216 -> 28;
                    case 217 -> 244;
                    case 218 -> 135;
                    case 219 -> 16;
                    case 220 -> 100;
                    case 221 -> 179;
                    case 222 -> 41;
                    case 223 -> 46;
                    case 224 -> 62;
                    case 225 -> 195;
                    case 226 -> 72;
                    case 227 -> 111;
                    case 228 -> 247;
                    case 229 -> 209;
                    case 230 -> 215;
                    case 231 -> 255;
                    case 232 -> 34;
                    case 233 -> 144;
                    case 234 -> 25;
                    case 235 -> 171;
                    case 236 -> 120;
                    case 237 -> 248;
                    case 238 -> 70;
                    case 239 -> 214;
                    case 240 -> 189;
                    case 241 -> 6;
                    case 242 -> 5;
                    case 243 -> 184;
                    case 244 -> 239;
                    case 245 -> 37;
                    case 246 -> 224;
                    case 247 -> 52;
                    case 248 -> 249;
                    case 249 -> 126;
                    case 250 -> 122;
                    case 251 -> 246;
                    case 252 -> 10;
                    case 253 -> 128;
                    case 254 -> 156;
                    default -> 91;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

