/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.messaging.amazon;

import com.intellij.javaee.messaging.JmsMQUtilsKt;
import com.intellij.microservices.jvm.callsites.ArgumentCallSite;
import com.intellij.microservices.jvm.callsites.ArgumentCallSiteCollector;
import com.intellij.microservices.jvm.callsites.ArgumentPlace;
import com.intellij.microservices.jvm.callsites.ConstructorArgument;
import com.intellij.microservices.jvm.callsites.MethodArgument;
import com.intellij.microservices.jvm.mq.CallSiteMQTargetInfo;
import com.intellij.microservices.mq.MQAccessType;
import com.intellij.microservices.mq.MQAccessTypes;
import com.intellij.microservices.mq.MQResolver;
import com.intellij.microservices.mq.MQResolverFactory;
import com.intellij.microservices.mq.MQTargetInfo;
import com.intellij.microservices.mq.MQType;
import com.intellij.microservices.mq.MQTypes;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/intellij/javaee/messaging/amazon/AmazonSqsResolver;", "Lcom/intellij/microservices/mq/MQResolver;", "project", "Lcom/intellij/openapi/project/Project;", "collector", "Lcom/intellij/microservices/jvm/callsites/ArgumentCallSiteCollector;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/microservices/jvm/callsites/ArgumentCallSiteCollector;)V", "supportedTypes", "", "Lcom/intellij/microservices/mq/MQType;", "getSupportedTypes", "()Ljava/util/List;", "getVariants", "", "Lcom/intellij/microservices/mq/MQTargetInfo;", "typeHint", "Companion", "Factory", "intellij.javaee.extensions"})
public final class AmazonSqsResolver
implements MQResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ArgumentCallSiteCollector collector;
    @NotNull
    private final List<MQType> supportedTypes;
    @NotNull
    private static final ArgumentCallSiteCollector AMAZON_SQS_QUEUE_OPERATIONS;

    public AmazonSqsResolver(@NotNull Project project, @NotNull ArgumentCallSiteCollector collector) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        this.project = project;
        this.collector = collector;
        this.supportedTypes = CollectionsKt.listOf((Object)MQTypes.AMAZON_SQS_QUEUE_TYPE);
    }

    @NotNull
    public List<MQType> getSupportedTypes() {
        return this.supportedTypes;
    }

    @NotNull
    public Iterable<MQTargetInfo> getVariants(@NotNull MQType typeHint) {
        Intrinsics.checkNotNullParameter((Object)typeHint, (String)"typeHint");
        return SequencesKt.asIterable((Sequence)SequencesKt.map((Sequence)this.collector.getCallSitesSequence(this.project), arg_0 -> AmazonSqsResolver.getVariants$lambda$0(this, arg_0)));
    }

    private static final CallSiteMQTargetInfo getVariants$lambda$0(AmazonSqsResolver this$0, ArgumentCallSite it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        MQType mQType = (MQType)MQTypes.AMAZON_SQS_QUEUE_TYPE;
        Object object = this$0.collector.getUserData(MQAccessType.KEY);
        Intrinsics.checkNotNull((Object)object);
        return new CallSiteMQTargetInfo(it, mQType, (MQAccessType)object);
    }

    static {
        ArgumentCallSiteCollector argumentCallSiteCollector = new ArgumentPlace[17];
        argumentCallSiteCollector[0] = new ConstructorArgument("com.amazonaws.services.sqs.model.GetQueueUrlRequest", 0, 1, null, 8, null);
        Object[] objectArray = new String[]{"setQueueName", "withQueueName"};
        argumentCallSiteCollector[1] = new MethodArgument("com.amazonaws.services.sqs.model.GetQueueUrlRequest", CollectionsKt.listOf((Object[])objectArray), 0, 1, null, 16, null);
        argumentCallSiteCollector[2] = new ConstructorArgument("com.amazonaws.auth.policy.resources.SQSQueueResource", 1, 2, null, 8, null);
        objectArray = new String[]{"setQueueName", "withQueueName"};
        argumentCallSiteCollector[3] = new MethodArgument("com.amazonaws.services.securityhub.model.AwsSqsQueueDetails", CollectionsKt.listOf((Object[])objectArray), 0, 1, null, 16, null);
        argumentCallSiteCollector[4] = new ConstructorArgument("com.amazonaws.services.sqs.model.CreateQueueRequest", 0, 1, null, 8, null);
        objectArray = new String[]{"setQueueName", "withQueueName"};
        argumentCallSiteCollector[5] = new MethodArgument("com.amazonaws.services.sqs.model.CreateQueueRequest", CollectionsKt.listOf((Object[])objectArray), 0, 1, null, 16, null);
        argumentCallSiteCollector[6] = new MethodArgument("com.amazonaws.services.sqs.AbstractAmazonSQSAsync", CollectionsKt.listOf((Object)"createQueueAsync"), 0, 1, null, 16, null);
        argumentCallSiteCollector[7] = new MethodArgument("com.amazonaws.services.sqs.AbstractAmazonSQSAsync", CollectionsKt.listOf((Object)"createQueueAsync"), 0, 2, null, 16, null);
        argumentCallSiteCollector[8] = new MethodArgument("com.amazonaws.services.sqs.AmazonSQSAsyncClient", CollectionsKt.listOf((Object)"createQueueAsync"), 0, 1, null, 16, null);
        argumentCallSiteCollector[9] = new MethodArgument("com.amazonaws.services.sqs.AmazonSQSAsyncClient", CollectionsKt.listOf((Object)"createQueueAsync"), 0, 2, null, 16, null);
        objectArray = new String[]{"createQueueAsync", "getQueueUrlAsync"};
        argumentCallSiteCollector[10] = new MethodArgument("com.amazonaws.services.sqs.AmazonSQSAsync", CollectionsKt.listOf((Object[])objectArray), 0, 1, null, 16, null);
        objectArray = new String[]{"createQueueAsync", "getQueueUrlAsync"};
        argumentCallSiteCollector[11] = new MethodArgument("com.amazonaws.services.sqs.AmazonSQSAsync", CollectionsKt.listOf((Object[])objectArray), 0, 2, null, 16, null);
        objectArray = new String[]{"createQueue", "getQueueUrl"};
        argumentCallSiteCollector[12] = new MethodArgument("com.amazonaws.services.sqs.AmazonSQSClient", CollectionsKt.listOf((Object[])objectArray), 0, 1, null, 16, null);
        objectArray = new String[]{"createQueue", "getQueueUrl"};
        argumentCallSiteCollector[13] = new MethodArgument("com.amazonaws.services.sqs.AmazonSQS", CollectionsKt.listOf((Object[])objectArray), 0, 1, null, 16, null);
        objectArray = new String[]{"createQueue", "getQueueUrl"};
        argumentCallSiteCollector[14] = new MethodArgument("com.amazonaws.services.sqs.AbstractAmazonSQS", CollectionsKt.listOf((Object[])objectArray), 0, 1, null, 16, null);
        objectArray = new String[]{"createQueue", "createQueueAsync", "getQueueUrl", "getQueueUrlAsync"};
        argumentCallSiteCollector[15] = new MethodArgument("com.amazonaws.services.sqs.buffered.AmazonSQSBufferedAsyncClient", CollectionsKt.listOf((Object[])objectArray), 0, 1, null, 16, null);
        objectArray = new String[]{"createQueueAsync", "getQueueUrlAsync"};
        argumentCallSiteCollector[16] = new MethodArgument("com.amazonaws.services.sqs.buffered.AmazonSQSBufferedAsyncClient", CollectionsKt.listOf((Object[])objectArray), 0, 2, null, 16, null);
        ArgumentCallSiteCollector $this$AMAZON_SQS_QUEUE_OPERATIONS_u24lambda_u241 = argumentCallSiteCollector = new ArgumentCallSiteCollector("AMAZON_SQS_QUEUE_OPERATIONS", CollectionsKt.listOf((Object[])argumentCallSiteCollector), null, 4, null);
        boolean bl = false;
        $this$AMAZON_SQS_QUEUE_OPERATIONS_u24lambda_u241.putUserData(MQAccessType.KEY, (Object)MQAccessTypes.UNKNOWN_TYPE);
        AMAZON_SQS_QUEUE_OPERATIONS = argumentCallSiteCollector;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/javaee/messaging/amazon/AmazonSqsResolver$Companion;", "", "<init>", "()V", "AMAZON_SQS_QUEUE_OPERATIONS", "Lcom/intellij/microservices/jvm/callsites/ArgumentCallSiteCollector;", "intellij.javaee.extensions"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/javaee/messaging/amazon/AmazonSqsResolver$Factory;", "Lcom/intellij/microservices/mq/MQResolverFactory;", "<init>", "()V", "forProject", "", "Lcom/intellij/microservices/mq/MQResolver;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javaee.extensions"})
    public static final class Factory
    implements MQResolverFactory {
        @NotNull
        public List<MQResolver> forProject(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (!JmsMQUtilsKt.isAmazonSqsAvailable(project)) {
                return CollectionsKt.emptyList();
            }
            return CollectionsKt.listOf((Object)new AmazonSqsResolver(project, AMAZON_SQS_QUEUE_OPERATIONS));
        }
    }
}

