/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.addsubtag;

import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.IdeBorderFactory;
import com.sixrr.xrp.base.BaseRefactoringDialog;
import com.sixrr.xrp.ui.ScopePanel;
import com.sixrr.xrp.utils.RefactorXBundle;
import com.sixrr.xrp.utils.XMLRefactoringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;

class AddSubtagDialog
extends BaseRefactoringDialog {
    private final JLabel attributeNameLabel = new JLabel();
    private final JTextField attributeNameField;
    private final JCheckBox addIfAbsentCheckbox;
    private final XmlTag tag;

    AddSubtagDialog(XmlTag tag) {
        super(tag.getProject(), true);
        this.tag = tag;
        XmlFile containingFile = (XmlFile)tag.getContainingFile();
        this.scopePanel = new ScopePanel(containingFile, this);
        this.setTitle(RefactorXBundle.message("dialog.title.add.subtag", new Object[0]));
        this.attributeNameLabel.setText(RefactorXBundle.message("label.text.name.for.new.subtag", new Object[0]));
        this.attributeNameField = new JTextField();
        this.addIfAbsentCheckbox = new JCheckBox(RefactorXBundle.message("checkbox.text.add.subtag.only.if.absent", new Object[0]));
        this.addIfAbsentCheckbox.setSelected(true);
        Document document = this.attributeNameField.getDocument();
        document.addDocumentListener(this.docListener);
        this.init();
        this.validateButtons();
    }

    @Override
    protected String getDimensionServiceKey() {
        return "RefactorX.AddSubtag";
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.attributeNameField;
    }

    public String getSubtagName() {
        return this.attributeNameField.getText().trim();
    }

    public boolean getAddOnlyIfAbsent() {
        return this.addIfAbsentCheckbox.isSelected();
    }

    protected JComponent createNorthPanel() {
        String tagName = this.tag.getName();
        JPanel panel = new JPanel(new BorderLayout());
        TitledBorder border = IdeBorderFactory.createTitledBorder((String)RefactorXBundle.message("border.text.add.subtag.to.tag.0", tagName));
        panel.add((Component)this.attributeNameLabel, "North");
        Box box = Box.createVerticalBox();
        panel.setBorder(border);
        this.attributeNameField.setEditable(true);
        box.add(this.attributeNameField);
        box.add(this.addIfAbsentCheckbox);
        panel.add((Component)box, "Center");
        return panel;
    }

    @Override
    protected boolean isValid() {
        String tagName = this.getSubtagName();
        boolean tagNameEntered = XMLRefactoringUtil.tagNameIsValid(tagName);
        boolean scopeIsValid = this.scopePanel.isScopeValid();
        return tagNameEntered && scopeIsValid;
    }

    @Override
    protected String calculateXSLT() {
        String tagName = this.tag.getName();
        String subtagName = this.getSubtagName();
        if (this.getAddOnlyIfAbsent()) {
            return "<xsl:template match=\"" + tagName + "[child:: " + subtagName + "]\">\n\t<xsl:copy>\t\t<xsl:apply-templates select=\"@*|node()\"/>\n\t</xsl:copy>\n</xsl:template>\n<xsl:template match=\"" + tagName + "\">\n\t<xsl:copy>\t\t<xsl:apply-templates select=\"@*|node()\"/>\n\t\t<" + subtagName + "/>\n\t</xsl:copy></xsl:template>\n";
        }
        return "<xsl:template match=\"" + tagName + "\">\n\t<xsl:copy>\n\t\t<xsl:apply-templates select=\"@*|node()\"/>\n\t\t<" + subtagName + "/>\n\t</xsl:copy>\n</xsl:template>";
    }

    @Override
    @NotNull
    protected String getHelpId() {
        return "refactoring.addSubtag";
    }
}

