/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.addsubtag;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.sixrr.xrp.addsubtag.AddSubtag;
import com.sixrr.xrp.addsubtag.AddSubtagUsageViewDescriptor;
import com.sixrr.xrp.base.XRPBaseRefactoringProcessor;
import com.sixrr.xrp.base.XRPUsageInfo;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.psi.TagSearchVisitor;
import com.sixrr.xrp.utils.RefactorXBundle;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class AddSubtagProcessor
extends XRPBaseRefactoringProcessor {
    private final XmlTag tag;
    private final String subtagName;
    private final boolean addOnlyIfAbsent;
    private final Context context;

    AddSubtagProcessor(XmlTag tag, String subtagName, boolean addOnlyIfAbsent, Context context) {
        super(tag.getProject());
        this.subtagName = subtagName;
        this.tag = tag;
        this.addOnlyIfAbsent = addOnlyIfAbsent;
        this.context = context;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usageInfos) {
        if (usageInfos == null) {
            AddSubtagProcessor.$$$reportNull$$$0(0);
        }
        return new AddSubtagUsageViewDescriptor(this.tag);
    }

    @Override
    public void findUsages(@NotNull List<? super XRPUsageInfo> usages) {
        if (usages == null) {
            AddSubtagProcessor.$$$reportNull$$$0(1);
        }
        String tagName = this.tag.getName();
        TagSearchVisitor visitor = new TagSearchVisitor(tagName);
        for (XmlFile file : this.context) {
            file.accept((PsiElementVisitor)visitor);
        }
        List<XmlTag> tagsFound = visitor.getTags();
        for (XmlTag xmlTag : tagsFound) {
            if (this.addOnlyIfAbsent && this.subtagExists(xmlTag)) continue;
            usages.add(new AddSubtag(xmlTag, this.subtagName));
        }
    }

    private boolean subtagExists(XmlTag xmlTag) {
        XmlTag[] subtags;
        for (XmlTag subtag : subtags = xmlTag.getSubTags()) {
            if (!subtag.getName().equals(this.subtagName)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected String getCommandName() {
        String string = RefactorXBundle.message("command.name.add.subtag.to.tag", this.subtagName, this.tag.getName());
        if (string == null) {
            AddSubtagProcessor.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/sixrr/xrp/addsubtag/AddSubtagProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/sixrr/xrp/addsubtag/AddSubtagProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

