/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.intellij.docker.agent.DockerAgentContainer;
import com.intellij.docker.agent.cli.AsyncCliProcess;
import com.intellij.docker.agent.cli.Cli;
import com.intellij.docker.agent.cli.DockerCli;
import com.intellij.docker.agent.cli.ProcessResult;
import com.intellij.docker.agent.compose.beans.DockerComposeConfiguration;
import com.intellij.docker.agent.compose.beans.DockerComposeDeserializer;
import com.intellij.docker.agent.compose.beans.DockerComposeServiceBase;
import com.intellij.docker.agent.compose.beans.v1.DockerComposeConfigurationV1;
import com.intellij.docker.agent.compose.beans.v1.DockerComposeServiceV1;
import com.intellij.docker.agent.compose.beans.v2.DockerComposeConfigurationV2;
import com.intellij.docker.agent.compose.beans.v2.DockerComposeServiceV2;
import com.intellij.docker.agent.util.ComposeVersion;
import com.intellij.docker.agent.util.DockerComposeData;
import com.intellij.docker.agent.util.DockerComposeUtilsKt;
import com.intellij.docker.agent.util.DockerComposeVersion;
import com.intellij.docker.agent.util.InternalUtilsKt;
import com.intellij.docker.agent.util.Platform;
import com.intellij.docker.agent.util.PodmanComposeVersion;
import com.intellij.docker.agent.util.UtilsKt;
import com.intellij.docker.agent.util.Version;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.reflect.KFunction;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000v\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\u001a\n\u0010\u0013\u001a\u00020\u0001*\u00020\u0001\u001a(\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u001aH\u0087@\u00a2\u0006\u0002\u0010\u001b\u001a\f\u0010\u001d\u001a\u0004\u0018\u00010\u0016*\u00020\u001e\u001a\u0018\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\"\u001a\u0004\u0018\u00010\u00012\u0006\u0010#\u001a\u00020\u0001H\u0002\u001a\n\u0010$\u001a\u00020%*\u00020&\u001a\n\u0010$\u001a\u00020%*\u00020'\u001a\u0014\u0010(\u001a\u0004\u0018\u00010\u00012\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u0007\u001a4\u0010(\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010*2\u0018\u0010+\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010*H\u0007\u001a)\u0010(\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u001a2\u0010\u0010,\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u001aH\u0007\u00a2\u0006\u0002\u0010-\u001a\u001c\u0010.\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010/0\r2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00010\r\u001a\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\r2\u0006\u00101\u001a\u00020\u0001\u001a\u0010\u00102\u001a\u00020/2\u0006\u00103\u001a\u00020/H\u0002\u001a\u000e\u00104\u001a\u00020\u00012\u0006\u00105\u001a\u00020/\u001a\u0018\u00106\u001a\u0004\u0018\u00010/2\u000e\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010/0\r\u001a8\u00108\u001a\u0004\u0018\u00010\u00012\b\u00109\u001a\u0004\u0018\u00010\u00012\u000e\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010/0\r2\u0014\u0010+\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010*\u001a2\u00108\u001a\u0004\u0018\u00010\u00012\b\u00109\u001a\u0004\u0018\u00010\u00012\b\u0010:\u001a\u0004\u0018\u00010/2\u0014\u0010+\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010*\u001a\u000e\u0010;\u001a\u00020%2\u0006\u0010<\u001a\u00020\u0001\u001a\u0010\u0010=\u001a\u00020%2\u0006\u0010>\u001a\u00020\u0001H\u0002\u001a@\u0010?\u001a\u00020@*\u00020\u00182\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00010B2\n\b\u0002\u0010C\u001a\u0004\u0018\u00010\u00012\u0012\u0010D\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001a\"\u00020\u0001H\u0086@\u00a2\u0006\u0002\u0010E\u001a\u0016\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020G0**\u00020H\u001a\u0010\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00010J*\u00020H\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0010\u0010\u0010\u001a\u00020\u00018\u0002X\u0083D\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0011\u001a\u00020\u00018\u0002X\u0083D\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0012\u001a\u00020\u00018\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001c\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"COMPOSE_SERVICE_LABEL_KEY", "", "COMPOSE_PROJECT_LABEL_KEY", "COMPOSE_FILES_LABEL_KEY", "COMPOSE_WORKING_DIR_LABEL_KEY", "DOCKER_COMPOSE_VERSION_LABEL_KEY", "PODMAN_COMPOSE_VERSION_LABEL_KEY", "HTTP_URL_SCHEMA", "HTTPS_URL_SCHEMA", "TCP_URL_SCHEMA", "COMMA_REGEX", "Lkotlin/text/Regex;", "DOCKER_COMPOSE_SUPPORTED_FILENAMES", "", "getDOCKER_COMPOSE_SUPPORTED_FILENAMES", "()Ljava/util/List;", "DOCKER_COMPOSE_OVERRIDE_FILENAME", "DEFAULT_DOCKER_COMPOSE_PROJECT_NAME", "COMPOSE_PROJECT_NAME_ENV_VAR", "fixApiUrlSchema", "execComposeCommand", "", "Lcom/intellij/docker/agent/util/DockerComposeData;", "cli", "Lcom/intellij/docker/agent/cli/DockerCli;", "args", "", "(Lcom/intellij/docker/agent/util/DockerComposeData;Lcom/intellij/docker/agent/cli/DockerCli;[Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "WSL_MNT_ROOT", "getComposeData", "Lcom/intellij/docker/agent/DockerAgentContainer;", "getComposeFilePath", "originPath", "workingDirPath", "getWindowsPath", "wslPath", "isComposeFilesLabelSupported", "", "Lcom/intellij/docker/agent/util/ComposeVersion;", "Lcom/intellij/docker/agent/util/Version;", "escapeDollarSigns", "string", "", "envs", "command", "([Ljava/lang/String;)[Ljava/lang/String;", "findDockerComposeConfigurationFiles", "Ljava/nio/file/Path;", "configurationPathNames", "configurationPathname", "findDockerComposeConfigurationPath", "folder", "getDockerComposeProjectName", "composeFilePath", "getDockerComposeDefaultWorkDir", "configurationFilePaths", "getEffectiveDockerComposeProjectName", "projectName", "workDir", "isDockerComposeNamedVolumeBind", "bindPath", "isWindowsAbsolutePath", "path", "composeConfig", "Lcom/intellij/docker/agent/compose/beans/v2/DockerComposeConfigurationV2;", "files", "", "workingDir", "options", "(Lcom/intellij/docker/agent/cli/DockerCli;Ljava/util/Collection;Ljava/lang/String;[Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getServices", "Lcom/intellij/docker/agent/compose/beans/DockerComposeServiceBase;", "Lcom/intellij/docker/agent/compose/beans/DockerComposeConfiguration;", "getServiceNames", "", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\ndockerComposeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 dockerComposeUtils.kt\ncom/intellij/docker/agent/util/DockerComposeUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 7 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 8 logging.kt\ncom/intellij/docker/agent/util/LoggingKt\n+ 9 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,392:1\n1611#2,9:393\n1863#2:402\n1864#2:404\n1620#2:405\n1368#2:406\n1454#2,5:407\n1557#2:415\n1628#2,3:416\n1368#2:453\n1454#2,5:454\n774#2:462\n865#2,2:463\n1368#2:465\n1454#2,5:466\n1#3:403\n1#3:414\n37#4,2:412\n37#4,2:428\n37#4,2:459\n37#4,2:471\n693#5:419\n726#5,4:420\n11165#6:424\n11500#6,3:425\n108#7:430\n80#7,22:431\n8#8:461\n59#9:473\n51#9:474\n*S KotlinDebug\n*F\n+ 1 dockerComposeUtils.kt\ncom/intellij/docker/agent/util/DockerComposeUtilsKt\n*L\n78#1:393,9\n78#1:402\n78#1:404\n78#1:405\n78#1:406\n78#1:407,5\n99#1:415\n99#1:416,3\n345#1:453\n345#1:454,5\n358#1:462\n358#1:463,2\n359#1:465\n359#1:466,5\n78#1:403\n78#1:412,2\n175#1:428,2\n345#1:459,2\n366#1:471,2\n163#1:419\n163#1:420,4\n175#1:424\n175#1:425,3\n329#1:430\n329#1:431,22\n351#1:461\n374#1:473\n374#1:474\n*E\n"})
public final class DockerComposeUtilsKt {
    @NotNull
    public static final String COMPOSE_SERVICE_LABEL_KEY = "com.docker.compose.service";
    @NotNull
    public static final String COMPOSE_PROJECT_LABEL_KEY = "com.docker.compose.project";
    @NotNull
    public static final String COMPOSE_FILES_LABEL_KEY = "com.docker.compose.project.config_files";
    @NotNull
    public static final String COMPOSE_WORKING_DIR_LABEL_KEY = "com.docker.compose.project.working_dir";
    @NotNull
    public static final String DOCKER_COMPOSE_VERSION_LABEL_KEY = "com.docker.compose.version";
    @NotNull
    public static final String PODMAN_COMPOSE_VERSION_LABEL_KEY = "io.podman.compose.version";
    @NotNull
    private static final String HTTP_URL_SCHEMA = "http://";
    @NotNull
    private static final String HTTPS_URL_SCHEMA = "https://";
    @NotNull
    private static final String TCP_URL_SCHEMA = "tcp://";
    @NotNull
    private static final Regex COMMA_REGEX = new Regex(",");
    @NotNull
    private static final List<String> DOCKER_COMPOSE_SUPPORTED_FILENAMES;
    @NonNls
    @NotNull
    private static final String DOCKER_COMPOSE_OVERRIDE_FILENAME;
    @NonNls
    @NotNull
    private static final String DEFAULT_DOCKER_COMPOSE_PROJECT_NAME;
    @NonNls
    @NotNull
    public static final String COMPOSE_PROJECT_NAME_ENV_VAR = "COMPOSE_PROJECT_NAME";
    @NotNull
    private static final String WSL_MNT_ROOT = "/mnt/";

    @NotNull
    public static final List<String> getDOCKER_COMPOSE_SUPPORTED_FILENAMES() {
        return DOCKER_COMPOSE_SUPPORTED_FILENAMES;
    }

    @NotNull
    public static final String fixApiUrlSchema(@NotNull String $this$fixApiUrlSchema) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$fixApiUrlSchema, (String)"<this>");
        if (StringsKt.startsWith$default((String)$this$fixApiUrlSchema, (String)HTTP_URL_SCHEMA, (boolean)false, (int)2, null)) {
            String string = $this$fixApiUrlSchema.substring(7);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            object = TCP_URL_SCHEMA + string;
        } else if (StringsKt.startsWith$default((String)$this$fixApiUrlSchema, (String)HTTPS_URL_SCHEMA, (boolean)false, (int)2, null)) {
            String string = $this$fixApiUrlSchema.substring(8);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            object = TCP_URL_SCHEMA + string;
        } else {
            object = $this$fixApiUrlSchema;
        }
        return object;
    }

    /*
     * Unable to fully structure code
     */
    @ApiStatus.Experimental
    @Nullable
    public static final Object execComposeCommand(@NotNull DockerComposeData var0, @NotNull DockerCli var1_1, @NotNull String[] var2_2, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof execComposeCommand.1)) ** GOTO lbl-1000
        var22_4 = $completion;
        if ((var22_4.label & -2147483648) != 0) {
            var22_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DockerComposeUtilsKt.execComposeCommand(null, null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var23_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$mapNotNull$iv = $this$execComposeCommand.getFiles();
                $i$f$mapNotNull = false;
                var7_9 = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                var12_15 = $this$forEach$iv$iv$iv.iterator();
                while (var12_15.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = var12_15.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    p0 = (Path)element$iv$iv;
                    $i$f$execComposeCommand$stub_for_inlining = false;
                    $i$a$-mapNotNull-DockerComposeUtilsKt$execComposeCommand$fileArgs$1 = false;
                    if (UtilsKt.nullize(p0) == null) continue;
                    $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv;
                $i$f$flatMap = false;
                $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    it = (Path)element$iv$iv;
                    $i$a$-flatMap-DockerComposeUtilsKt$execComposeCommand$fileArgs$2 = false;
                    var14_18 = new String[]{"-f", it.toString()};
                    list$iv$iv = CollectionsKt.listOf((Object[])var14_18);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $this$toTypedArray$iv = (List)destination$iv$iv;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                fileArgs = thisCollection$iv.toArray(new String[0]);
                v0 = (Cli)cli;
                var5_7 = new SpreadBuilder(5);
                var5_7.add((Object)"compose");
                var5_7.addSpread((Object)fileArgs);
                var5_7.add((Object)"-p");
                var5_7.add((Object)$this$execComposeCommand.getProject());
                var5_7.addSpread((Object)args);
                $continuation.label = 1;
                v1 = Cli.execAsync$default(v0, CollectionsKt.listOf((Object[])var5_7.toArray((Object[])new String[var5_7.size()])), null, null, null, null, null, null, null, (Continuation)$continuation, 254, null);
                if (v1 == var23_6) {
                    return var23_6;
                }
                ** GOTO lbl63
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl63:
                // 2 sources

                $continuation.label = 2;
                v2 = ((AsyncCliProcess)v1).await($continuation);
                if (v2 == var23_6) {
                    return var23_6;
                }
                ** GOTO lbl71
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl71:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final DockerComposeData getComposeData(@NotNull DockerAgentContainer $this$getComposeData) {
        List list2;
        int versionBuilder2;
        CharSequence charSequence;
        String filesString;
        Object object;
        String workingDir2;
        Pair pair;
        Iterable version2;
        String versionLabel;
        String service;
        String project;
        Map<String, String> containerLabels;
        block12: {
            Intrinsics.checkNotNullParameter((Object)$this$getComposeData, (String)"<this>");
            containerLabels = $this$getComposeData.getContainerLabels();
            String string = containerLabels.get(COMPOSE_PROJECT_LABEL_KEY);
            if (string == null) {
                return null;
            }
            project = string;
            String string2 = containerLabels.get(COMPOSE_SERVICE_LABEL_KEY);
            if (string2 == null) {
                return null;
            }
            service = string2;
            Object[] objectArray = new Pair[]{TuplesKt.to((Object)DOCKER_COMPOSE_VERSION_LABEL_KEY, (Object)((Object)getComposeData.composeVersion.1.INSTANCE)), TuplesKt.to((Object)PODMAN_COMPOSE_VERSION_LABEL_KEY, (Object)((Object)getComposeData.composeVersion.2.INSTANCE))};
            for (Pair pair2 : (Iterable)CollectionsKt.listOf((Object[])objectArray)) {
                ComposeVersion composeVersion2;
                boolean bl = false;
                versionLabel = (String)pair2.component1();
                KFunction versionBuilder2 = (KFunction)pair2.component2();
                if (containerLabels.get(versionLabel) != null) {
                    boolean bl2 = false;
                    if (Version.Companion.from((String)((Object)version2)) != null) {
                        Version it;
                        boolean bl3 = false;
                        composeVersion2 = (ComposeVersion)((Function1)versionBuilder2).invoke((Object)it);
                    } else {
                        composeVersion2 = null;
                    }
                } else {
                    composeVersion2 = null;
                }
                if ((pair2 = composeVersion2) == null) continue;
                pair = pair2;
                break block12;
            }
            pair = null;
        }
        if (pair == null) {
            return null;
        }
        Pair composeVersion3 = pair;
        String string = containerLabels.get(COMPOSE_WORKING_DIR_LABEL_KEY);
        if (string == null) {
            string = workingDir2 = "";
        }
        if ((object = (filesString = containerLabels.get(COMPOSE_FILES_LABEL_KEY))) != null && (object = (versionLabel = COMMA_REGEX).split(charSequence = (CharSequence)object, versionBuilder2 = 0)) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            version2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string3 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(DockerComposeUtilsKt.getComposeFilePath((String)it, workingDir2));
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List filePaths = list2;
        return new DockerComposeData(service, project, workingDir2, SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)filePaths), (Function1)getComposeData.1.INSTANCE)), (ComposeVersion)composeVersion3);
    }

    private static final String getComposeFilePath(String originPath, String workingDirPath) {
        if (Platform.INSTANCE.isWindows()) {
            if (DockerComposeUtilsKt.isWindowsAbsolutePath(originPath)) {
                return originPath;
            }
            if (StringsKt.startsWith$default((String)originPath, (String)WSL_MNT_ROOT, (boolean)false, (int)2, null)) {
                String string = DockerComposeUtilsKt.getWindowsPath(originPath);
                if (string == null) {
                    string = originPath;
                }
                return string;
            }
            return InternalUtilsKt.toSystemDependentName(workingDirPath + File.separatorChar + originPath);
        }
        return new File(originPath).isAbsolute() ? originPath : InternalUtilsKt.toSystemIndependentName(workingDirPath + File.separatorChar + originPath);
    }

    private static final String getWindowsPath(String wslPath) {
        String string;
        int driveLetterIndex = 5;
        if (driveLetterIndex >= wslPath.length() || !Character.isLetter(wslPath.charAt(driveLetterIndex))) {
            return null;
        }
        int slashIndex = driveLetterIndex + 1;
        if (slashIndex < wslPath.length() && wslPath.charAt(slashIndex) != '/') {
            string = null;
        } else {
            char c = Character.toUpperCase(wslPath.charAt(driveLetterIndex));
            String string2 = wslPath.substring(slashIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            string = StringsKt.replace$default((String)StringsKt.replace$default((String)(c + ":" + string2), (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null), (char)'\\', (char)File.separatorChar, (boolean)false, (int)4, null);
        }
        return string;
    }

    public static final boolean isComposeFilesLabelSupported(@NotNull ComposeVersion $this$isComposeFilesLabelSupported) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isComposeFilesLabelSupported, (String)"<this>");
        ComposeVersion composeVersion2 = $this$isComposeFilesLabelSupported;
        if (composeVersion2 instanceof DockerComposeVersion) {
            bl = DockerComposeUtilsKt.isComposeFilesLabelSupported(((DockerComposeVersion)$this$isComposeFilesLabelSupported).getVersion());
        } else if (composeVersion2 instanceof PodmanComposeVersion) {
            bl = true;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public static final boolean isComposeFilesLabelSupported(@NotNull Version $this$isComposeFilesLabelSupported) {
        Intrinsics.checkNotNullParameter((Object)$this$isComposeFilesLabelSupported, (String)"<this>");
        return $this$isComposeFilesLabelSupported.compareTo(new Version(1, 25, 0)) >= 0;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static final String escapeDollarSigns(@Nullable String string) {
        String string2;
        String string3 = string;
        if (string3 != null) {
            CharSequence charSequence = string3;
            Regex regex = new Regex("\\$");
            String string4 = "\\$\\$";
            string2 = regex.replace(charSequence, string4);
        } else {
            string2 = null;
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static final Map<String, String> escapeDollarSigns(@Nullable Map<String, String> envs) {
        Map map2;
        Sequence sequence = envs;
        if (sequence != null && (sequence = MapsKt.asSequence(sequence)) != null) {
            void $this$associateByTo$iv$iv;
            Sequence $this$associateBy$iv = sequence;
            boolean $i$f$associateBy = false;
            Sequence sequence2 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                Map.Entry entry = (Map.Entry)element$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                Map.Entry it = (Map.Entry)element$iv$iv;
                String string = DockerComposeUtilsKt.escapeDollarSigns((String)it.getKey());
                boolean bl2 = false;
                String string2 = DockerComposeUtilsKt.escapeDollarSigns((String)it.getValue());
                map3.put(string, string2);
            }
            map2 = destination$iv$iv;
        } else {
            map2 = null;
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static final String[] escapeDollarSigns(@Nullable String[] command) {
        String[] stringArray;
        if (command != null) {
            void $this$mapTo$iv$iv;
            String[] $this$map$iv = command;
            boolean $i$f$map = false;
            String[] stringArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(DockerComposeUtilsKt.escapeDollarSigns((String)it));
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            stringArray = thisCollection$iv.toArray(new String[0]);
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    @NotNull
    public static final List<Path> findDockerComposeConfigurationFiles(@NotNull List<String> configurationPathNames) throws FileNotFoundException {
        List<Path> list2;
        Intrinsics.checkNotNullParameter(configurationPathNames, (String)"configurationPathNames");
        if (!(!configurationPathNames.isEmpty())) {
            boolean bl = false;
            String string = "Configuration path name list must not be empty";
            throw new IllegalArgumentException(string.toString());
        }
        String mainConfigurationPathname = configurationPathNames.get(0);
        if (Files.isDirectory(Paths.get(mainConfigurationPathname, new String[0]), new LinkOption[0])) {
            list2 = DockerComposeUtilsKt.findDockerComposeConfigurationFiles(mainConfigurationPathname);
        } else {
            List list3 = Stream.concat(Stream.of(Paths.get(mainConfigurationPathname, new String[0])), configurationPathNames.stream().skip(1L).map(arg_0 -> DockerComposeUtilsKt.findDockerComposeConfigurationFiles$lambda$10(DockerComposeUtilsKt::findDockerComposeConfigurationFiles$lambda$9, arg_0)).filter(arg_0 -> DockerComposeUtilsKt.findDockerComposeConfigurationFiles$lambda$12(DockerComposeUtilsKt::findDockerComposeConfigurationFiles$lambda$11, arg_0))).collect(Collectors.toList());
            Intrinsics.checkNotNull(list3);
            list2 = list3;
        }
        return list2;
    }

    @NotNull
    public static final List<Path> findDockerComposeConfigurationFiles(@NotNull String configurationPathname) throws FileNotFoundException {
        List list2;
        Intrinsics.checkNotNullParameter((Object)configurationPathname, (String)"configurationPathname");
        Path path = Paths.get(configurationPathname, new String[0]);
        if (Files.isDirectory(path, new LinkOption[0])) {
            Intrinsics.checkNotNull((Object)path);
            Path configurationPath = DockerComposeUtilsKt.findDockerComposeConfigurationPath(path);
            Path overrideConfiguration = configurationPath.resolveSibling(DOCKER_COMPOSE_OVERRIDE_FILENAME);
            if (Files.isRegularFile(overrideConfiguration, new LinkOption[0])) {
                Object[] objectArray = new Path[]{configurationPath, overrideConfiguration};
                list2 = CollectionsKt.listOf((Object[])objectArray);
            } else {
                list2 = CollectionsKt.listOf((Object)configurationPath);
            }
        } else if (Files.isRegularFile(path, new LinkOption[0])) {
            list2 = CollectionsKt.listOf((Object)path);
        } else {
            throw new FileNotFoundException("Neither folder nor file \"" + path + "\" exists");
        }
        return list2;
    }

    private static final Path findDockerComposeConfigurationPath(Path folder) throws FileNotFoundException {
        for (String filename : DOCKER_COMPOSE_SUPPORTED_FILENAMES) {
            Path configurationPath = folder.resolve(filename);
            if (!Files.isRegularFile(configurationPath, new LinkOption[0])) continue;
            Intrinsics.checkNotNull((Object)configurationPath);
            return configurationPath;
        }
        throw new FileNotFoundException(StringsKt.trimIndent((String)("\n      Can't find a suitable configuration file in this directory. \n      Supported filenames: " + CollectionsKt.joinToString$default((Iterable)DOCKER_COMPOSE_SUPPORTED_FILENAMES, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "\n    ")));
    }

    @NotNull
    public static final String getDockerComposeProjectName(@NotNull Path composeFilePath) {
        Intrinsics.checkNotNullParameter((Object)composeFilePath, (String)"composeFilePath");
        Path parent = composeFilePath.toAbsolutePath().getParent();
        return parent == null || parent.getFileName() == null ? DEFAULT_DOCKER_COMPOSE_PROJECT_NAME : ((Object)parent.getFileName()).toString();
    }

    @Nullable
    public static final Path getDockerComposeDefaultWorkDir(@NotNull List<? extends Path> configurationFilePaths) {
        Path path;
        Intrinsics.checkNotNullParameter(configurationFilePaths, (String)"configurationFilePaths");
        Path mainConfigurationFilePath = (Path)CollectionsKt.firstOrNull(configurationFilePaths);
        if (mainConfigurationFilePath == null) {
            path = null;
        } else {
            Path path2;
            try {
                path2 = mainConfigurationFilePath.toAbsolutePath().getParent();
            }
            catch (IOError e) {
                path2 = mainConfigurationFilePath.getParent();
            }
            path = path2;
        }
        return path;
    }

    @Nullable
    public static final String getEffectiveDockerComposeProjectName(@Nullable String projectName, @NotNull List<? extends Path> configurationFilePaths, @Nullable Map<String, String> envs) {
        Intrinsics.checkNotNullParameter(configurationFilePaths, (String)"configurationFilePaths");
        return DockerComposeUtilsKt.getEffectiveDockerComposeProjectName(projectName, DockerComposeUtilsKt.getDockerComposeDefaultWorkDir(configurationFilePaths), envs);
    }

    @Nullable
    public static final String getEffectiveDockerComposeProjectName(@Nullable String projectName, @Nullable Path workDir, @Nullable Map<String, String> envs) {
        String composeProjectName;
        if (projectName != null) {
            return projectName;
        }
        Map<String, String> map2 = envs;
        String string = composeProjectName = map2 != null ? map2.get(COMPOSE_PROJECT_NAME_ENV_VAR) : null;
        if (composeProjectName != null) {
            return composeProjectName;
        }
        return workDir == null || workDir.getFileName() == null ? null : ((Object)workDir.getFileName()).toString();
    }

    public static final boolean isDockerComposeNamedVolumeBind(@NotNull String bindPath) {
        String path;
        Intrinsics.checkNotNullParameter((Object)bindPath, (String)"bindPath");
        String $this$trim$iv = bindPath;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if (((CharSequence)(path = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())).length() == 0) {
            return false;
        }
        return DockerComposeUtilsKt.isWindowsAbsolutePath(path) ? false : !StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)path, (String)"~", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)path, (String)".", (boolean)false, (int)2, null);
    }

    private static final boolean isWindowsAbsolutePath(String path) {
        return Platform.INSTANCE.isWindows() && !(((CharSequence)path).length() == 0) && new File(path).isAbsolute();
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object composeConfig(@NotNull DockerCli var0, @NotNull Collection<String> var1_1, @Nullable String var2_2, @NotNull String[] var3_3, @NotNull Continuation<? super DockerComposeConfigurationV2> $completion) {
        if (!($completion instanceof composeConfig.1)) ** GOTO lbl-1000
        var21_5 = $completion;
        if ((var21_5.label & -2147483648) != 0) {
            var21_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DockerComposeUtilsKt.composeConfig(null, null, null, null, (Continuation<? super DockerComposeConfigurationV2>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var22_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$flatMap$iv = (Iterable)files;
                $i$f$flatMap = false;
                var8_11 = $this$flatMap$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    it = (String)element$iv$iv;
                    $i$a$-flatMap-DockerComposeUtilsKt$composeConfig$fileArgs$1 = false;
                    var15_31 = new String[]{"-f", it};
                    list$iv$iv = CollectionsKt.listOf((Object[])var15_31);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $this$toTypedArray$iv = (List)destination$iv$iv;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                fileArgs = thisCollection$iv.toArray(new String[0]);
                $i$f$toTypedArray = new SpreadBuilder(4);
                $i$f$toTypedArray.add((Object)"compose");
                $i$f$toTypedArray.addSpread((Object)fileArgs);
                $i$f$toTypedArray.add((Object)"config");
                $i$f$toTypedArray.add((Object)"--profiles");
                args = CollectionsKt.listOf((Object[])$i$f$toTypedArray.toArray((Object[])new String[$i$f$toTypedArray.size()]));
                $continuation.L$0 = $this$composeConfig;
                $continuation.L$1 = workingDir;
                $continuation.L$2 = options;
                $continuation.L$3 = fileArgs;
                $continuation.L$4 = args;
                $continuation.label = 1;
                v0 = Cli.execAsyncWithResult$default($this$composeConfig, args, null, null, null, null, workingDir, null, null, (Continuation)$continuation, 222, null);
                if (v0 == var22_7) {
                    return var22_7;
                }
                ** GOTO lbl53
            }
            case 1: {
                args = (List)$continuation.L$4;
                fileArgs = (String[])$continuation.L$3;
                options = (String[])$continuation.L$2;
                workingDir = (String)$continuation.L$1;
                $this$composeConfig = (DockerCli)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl53:
                // 2 sources

                $continuation.L$0 = $this$composeConfig;
                $continuation.L$1 = workingDir;
                $continuation.L$2 = options;
                $continuation.L$3 = fileArgs;
                $continuation.L$4 = args;
                $continuation.label = 2;
                v1 = ((AsyncCliProcess)v0).await($continuation);
                if (v1 == var22_7) {
                    return var22_7;
                }
                ** GOTO lbl71
            }
            case 2: {
                args = (List)$continuation.L$4;
                fileArgs = (String[])$continuation.L$3;
                options = (String[])$continuation.L$2;
                workingDir = (String)$continuation.L$1;
                $this$composeConfig = (DockerCli)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl71:
                // 2 sources

                it = destination$iv$iv = (execProfiles = (ProcessResult)v1).getExitCode() == 0;
                $i$a$-also-DockerComposeUtilsKt$composeConfig$useProfiles$1 = false;
                if (!it) {
                    $i$f$logger = false;
                    v2 = LoggerFactory.getLogger(DockerComposeData.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getLogger(...)");
                    v2.warn("The command " + $this$composeConfig.getExePath() + " " + args + " returned non-zero exit code " + execProfiles.getExitCode() + "stderr:\n" + CollectionsKt.joinToString$default((Iterable)execProfiles.getStdErr(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                }
                useProfiles = destination$iv$iv;
                if (useProfiles) {
                    $this$filter$iv = StringsKt.lines((CharSequence)CollectionsKt.joinToString$default((Iterable)execProfiles.getStdOut(), (CharSequence)"", null, null, (int)0, null, null, (int)62, null));
                    $i$f$filter = false;
                    $i$f$logger = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (E element$iv$iv : $this$filterTo$iv$iv) {
                        p0 = (String)element$iv$iv;
                        $i$f$composeConfig$stub_for_inlining$16 = false;
                        $i$a$-filter-DockerComposeUtilsKt$composeConfig$additionalArgs$1 = false;
                        v3 = !StringsKt.isBlank((CharSequence)p0);
                        if (!v3) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$flatMap$iv = (List)destination$iv$iv;
                    $i$f$flatMap = false;
                    $this$filterTo$iv$iv = $this$flatMap$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$flatMapTo = false;
                    for (E element$iv$iv : $this$flatMapTo$iv$iv) {
                        it = (String)element$iv$iv;
                        $i$a$-flatMap-DockerComposeUtilsKt$composeConfig$additionalArgs$2 = false;
                        var19_37 = new String[]{"--profile", it};
                        list$iv$iv = CollectionsKt.listOf((Object[])var19_37);
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    v4 = (List)destination$iv$iv;
                } else {
                    v4 = CollectionsKt.emptyList();
                }
                additionalArgs = v4;
                v5 = $this$composeConfig;
                $i$f$flatMap = new SpreadBuilder(5);
                $i$f$flatMap.add((Object)"compose");
                $i$f$flatMap.addSpread((Object)fileArgs);
                $this$toTypedArray$iv = additionalArgs;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                $i$f$flatMap.addSpread((Object)thisCollection$iv.toArray(new String[0]));
                $i$f$flatMap.add((Object)"config");
                $i$f$flatMap.addSpread((Object)options);
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.L$4 = null;
                $continuation.label = 3;
                v6 = Cli.execAsyncWithResult$default(v5, CollectionsKt.listOf((Object[])$i$f$flatMap.toArray((Object[])new String[$i$f$flatMap.size()])), null, null, null, null, var2_2, null, null, (Continuation)$continuation, 222, null);
                if (v6 == var22_7) {
                    return var22_7;
                }
                ** GOTO lbl136
            }
            case 3: {
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl136:
                // 2 sources

                $continuation.label = 4;
                v7 = ((AsyncCliProcess)v6).await($continuation);
                if (v7 == var22_7) {
                    return var22_7;
                }
                ** GOTO lbl144
            }
            case 4: {
                ResultKt.throwOnFailure((Object)$result);
                v7 = $result;
lbl144:
                // 2 sources

                if ((execConfig = (ProcessResult)v7).getExitCode() != 0) {
                    throw new IOException(CollectionsKt.joinToString$default((Iterable)execConfig.getStdErr(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                }
                $i$f$flatMap = DockerComposeDeserializer.Companion.getMapper();
                src$iv = new StringReader(CollectionsKt.joinToString$default((Iterable)execConfig.getStdOut(), (CharSequence)"", null, null, (int)0, null, null, (int)62, null));
                $i$f$readValue = false;
                $i$f$jacksonTypeRef = false;
                return $this$readValue$iv.readValue(src$iv, (TypeReference)new TypeReference<DockerComposeConfigurationV2>(){});
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object composeConfig$default(DockerCli dockerCli, Collection collection, String string, String[] stringArray, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return DockerComposeUtilsKt.composeConfig(dockerCli, collection, string, stringArray, (Continuation<? super DockerComposeConfigurationV2>)continuation);
    }

    @NotNull
    public static final Map<String, DockerComposeServiceBase> getServices(@NotNull DockerComposeConfiguration $this$getServices) {
        Intrinsics.checkNotNullParameter((Object)$this$getServices, (String)"<this>");
        Object t = $this$getServices.accept(new DockerComposeConfiguration.Visitor<Map<String, ? extends DockerComposeServiceBase>>(){

            public Map<String, DockerComposeServiceV1> visit(DockerComposeConfigurationV1 configuration) {
                Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                Map<String, DockerComposeServiceV1> map2 = configuration.getServices();
                Intrinsics.checkNotNullExpressionValue(map2, (String)"getServices(...)");
                return map2;
            }

            public Map<String, DockerComposeServiceV2> visit(DockerComposeConfigurationV2 configuration) {
                Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                Map<String, DockerComposeServiceV2> map2 = configuration.getServices();
                Intrinsics.checkNotNullExpressionValue(map2, (String)"getServices(...)");
                return map2;
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"accept(...)");
        return (Map)t;
    }

    @NotNull
    public static final Set<String> getServiceNames(@NotNull DockerComposeConfiguration $this$getServiceNames) {
        Intrinsics.checkNotNullParameter((Object)$this$getServiceNames, (String)"<this>");
        return DockerComposeUtilsKt.getServices($this$getServiceNames).keySet();
    }

    private static final Path findDockerComposeConfigurationFiles$lambda$9(String pathname) {
        Intrinsics.checkNotNullParameter((Object)pathname, (String)"pathname");
        return Paths.get(pathname, new String[0]);
    }

    private static final Path findDockerComposeConfigurationFiles$lambda$10(Function1 $tmp0, Object p0) {
        return (Path)$tmp0.invoke(p0);
    }

    private static final boolean findDockerComposeConfigurationFiles$lambda$11(Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return Files.exists(path, new LinkOption[0]);
    }

    private static final boolean findDockerComposeConfigurationFiles$lambda$12(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Object[] objectArray = new String[]{"docker-compose.yml", "docker-compose.yaml"};
        DOCKER_COMPOSE_SUPPORTED_FILENAMES = CollectionsKt.listOf((Object[])objectArray);
        DOCKER_COMPOSE_OVERRIDE_FILENAME = "docker-compose.override.yml";
        DEFAULT_DOCKER_COMPOSE_PROJECT_NAME = "default";
    }
}

