/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.target;

import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerCredentialsType;
import com.intellij.docker.remote.run.configuration.DockerContainerCliSettingsEditor;
import com.intellij.docker.remote.run.target.DockerRemoteRequest;
import com.intellij.docker.remote.run.target.configuration.DockerTargetEnvironmentConfiguration;
import com.intellij.docker.remote.run.target.configuration.DockerTargetType;
import com.intellij.execution.configuration.AbstractRunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.target.RunConfigurationTargetEnvironmentAdjuster;
import com.intellij.execution.target.TargetBasedSdkAdditionalData;
import com.intellij.execution.target.TargetBasedSdks;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteSdks;
import com.intellij.remoteServer.configuration.RemoteServer;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\b\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010H\u0016J\u0012\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013*\u00020\u0011H\u0002J\u0014\u0010\u0014\u001a\u00020\u0005*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007\u00a8\u0006\u0019"}, d2={"Lcom/intellij/docker/remote/run/target/DockerRunConfigurationTargetEnvironmentAdjuster;", "Lcom/intellij/execution/target/RunConfigurationTargetEnvironmentAdjuster;", "<init>", "()V", "adjust", "", "targetEnvironmentRequest", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "providesAdditionalRunConfigurationUI", "", "createAdditionalRunConfigurationUI", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/execution/configuration/AbstractRunConfiguration;", "sdkGetter", "Lkotlin/Function0;", "Lcom/intellij/openapi/projectRoots/Sdk;", "tryGetDockerServer", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "applyAdditionalDockerContainerSettings", "Lcom/intellij/docker/remote/run/target/DockerRemoteRequest;", "dockerContainerSettings", "Lcom/intellij/docker/remote/DockerContainerSettings;", "Factory", "intellij.clouds.docker.remoteRun"})
@SourceDebugExtension(value={"SMAP\nDockerRunConfigurationTargetEnvironmentAdjuster.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerRunConfigurationTargetEnvironmentAdjuster.kt\ncom/intellij/docker/remote/run/target/DockerRunConfigurationTargetEnvironmentAdjuster\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1187#2,2:93\n1261#2,4:95\n*S KotlinDebug\n*F\n+ 1 DockerRunConfigurationTargetEnvironmentAdjuster.kt\ncom/intellij/docker/remote/run/target/DockerRunConfigurationTargetEnvironmentAdjuster\n*L\n89#1:93,2\n89#1:95,4\n*E\n"})
public final class DockerRunConfigurationTargetEnvironmentAdjuster
implements RunConfigurationTargetEnvironmentAdjuster {
    @NotNull
    public static final DockerRunConfigurationTargetEnvironmentAdjuster INSTANCE = new DockerRunConfigurationTargetEnvironmentAdjuster();

    private DockerRunConfigurationTargetEnvironmentAdjuster() {
    }

    public void adjust(@NotNull TargetEnvironmentRequest targetEnvironmentRequest, @NotNull RunConfigurationBase<?> runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)targetEnvironmentRequest, (String)"targetEnvironmentRequest");
        Intrinsics.checkNotNullParameter(runConfiguration, (String)"runConfiguration");
        if (targetEnvironmentRequest instanceof DockerRemoteRequest) {
            DockerContainerSettings dockerContainerSettings = (DockerContainerSettings)runConfiguration.getCopyableUserData(DockerContainerSettings.KEY);
            if (dockerContainerSettings == null) {
                DockerContainerSettings dockerContainerSettings2 = DockerContainerSettings.defaultSettings(runConfiguration.getProject());
                dockerContainerSettings = dockerContainerSettings2;
                Intrinsics.checkNotNullExpressionValue((Object)dockerContainerSettings2, (String)"defaultSettings(...)");
            }
            DockerContainerSettings dockerContainerSettings3 = dockerContainerSettings;
            this.applyAdditionalDockerContainerSettings((DockerRemoteRequest)targetEnvironmentRequest, dockerContainerSettings3);
        }
    }

    public boolean providesAdditionalRunConfigurationUI() {
        return true;
    }

    @NotNull
    public SettingsEditor<AbstractRunConfiguration> createAdditionalRunConfigurationUI(@NotNull AbstractRunConfiguration runConfiguration, @NotNull Function0<? extends Sdk> sdkGetter) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter(sdkGetter, (String)"sdkGetter");
        return new DockerContainerCliSettingsEditor<AbstractRunConfiguration>(runConfiguration.getProject(), arg_0 -> DockerRunConfigurationTargetEnvironmentAdjuster.createAdditionalRunConfigurationUI$lambda$0(sdkGetter, arg_0));
    }

    private final RemoteServer<?> tryGetDockerServer(Sdk $this$tryGetDockerServer) {
        SdkAdditionalData sdkAdditionalData = $this$tryGetDockerServer.getSdkAdditionalData();
        TargetBasedSdkAdditionalData targetBasedSdkAdditionalData = sdkAdditionalData instanceof TargetBasedSdkAdditionalData ? (TargetBasedSdkAdditionalData)sdkAdditionalData : null;
        if (targetBasedSdkAdditionalData == null) {
            return null;
        }
        TargetBasedSdkAdditionalData targetBasedSdkAdditionalData2 = targetBasedSdkAdditionalData;
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = targetBasedSdkAdditionalData2.getTargetEnvironmentConfiguration();
        DockerTargetEnvironmentConfiguration dockerTargetEnvironmentConfiguration = targetEnvironmentConfiguration instanceof DockerTargetEnvironmentConfiguration ? (DockerTargetEnvironmentConfiguration)targetEnvironmentConfiguration : null;
        if (dockerTargetEnvironmentConfiguration == null) {
            return null;
        }
        DockerTargetEnvironmentConfiguration configuration = dockerTargetEnvironmentConfiguration;
        return configuration.getDockerServer();
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public final void applyAdditionalDockerContainerSettings(@NotNull DockerRemoteRequest $this$applyAdditionalDockerContainerSettings, @NotNull DockerContainerSettings dockerContainerSettings) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        String containerPath;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$applyAdditionalDockerContainerSettings), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dockerContainerSettings, (String)"dockerContainerSettings");
        String string = dockerContainerSettings.getRunCliOptions();
        if (string == null) {
            string = $this$applyAdditionalDockerContainerSettings.getConfiguration().getState().getContainerConfig().getRunCliOptions();
        }
        Object runCliOptions = ((Object)StringsKt.trim((CharSequence)string)).toString();
        for (DockerVolumeBindingImpl volumeBinding : dockerContainerSettings.getVolumeBindings()) {
            String hostPath = volumeBinding.getHostPath();
            containerPath = volumeBinding.getContainerPath();
            if (hostPath == null || containerPath == null) continue;
            Set set = $this$applyAdditionalDockerContainerSettings.getUploadVolumes();
            Path path = Path.of(hostPath, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            set.add(new TargetEnvironment.UploadRoot(path, (TargetEnvironment.TargetPath)new TargetEnvironment.TargetPath.Persistent(containerPath), false, 4, null));
        }
        if (dockerContainerSettings.isPublishAllPorts()) {
            runCliOptions = !StringsKt.isBlank((CharSequence)((CharSequence)runCliOptions)) ? (String)runCliOptions + " --publish-all" : "--publish-all";
        } else {
            for (DockerPortBindingImpl portBinding : dockerContainerSettings.getPortBindings()) {
                $this$applyAdditionalDockerContainerSettings.getTargetPortBindings().add(new TargetEnvironment.TargetPortBinding(portBinding.getHostPort(), portBinding.getContainerPort()));
            }
        }
        List<DockerEnvVarImpl> list2 = dockerContainerSettings.getEnvVars();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getEnvVars(...)");
        Iterable iterable = list2;
        DockerRemoteRequest dockerRemoteRequest = $this$applyAdditionalDockerContainerSettings;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        containerPath = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            DockerEnvVarImpl it = (DockerEnvVarImpl)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getName(), (Object)it.getValue());
            map2.put(pair.getFirst(), pair.getSecond());
        }
        dockerRemoteRequest.setEnvironmentVariables(destination$iv$iv);
        $this$applyAdditionalDockerContainerSettings.setRunCliOptions((String)runCliOptions);
    }

    private static final RemoteServer createAdditionalRunConfigurationUI$lambda$0(Function0 $sdkGetter, AbstractRunConfiguration it) {
        Sdk sdk = (Sdk)$sdkGetter.invoke();
        return sdk != null ? INSTANCE.tryGetDockerServer(sdk) : null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/docker/remote/run/target/DockerRunConfigurationTargetEnvironmentAdjuster$Factory;", "Lcom/intellij/execution/target/RunConfigurationTargetEnvironmentAdjuster$Factory;", "<init>", "()V", "isEnabledFor", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "createAdjuster", "Lcom/intellij/execution/target/RunConfigurationTargetEnvironmentAdjuster;", "intellij.clouds.docker.remoteRun"})
    public static final class Factory
    implements RunConfigurationTargetEnvironmentAdjuster.Factory {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isEnabledFor(@NotNull Sdk sdk) {
            Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
            if (TargetBasedSdks.isBasedOnTargetType((Sdk)sdk, (String)DockerTargetType.Companion.getTYPE_ID())) return true;
            DockerCredentialsType dockerCredentialsType = DockerCredentialsType.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)dockerCredentialsType), (String)"getInstance(...)");
            if (!RemoteSdks.isBasedOnCredentialsType((Sdk)sdk, (CredentialsType)dockerCredentialsType)) return false;
            return true;
        }

        @NotNull
        public RunConfigurationTargetEnvironmentAdjuster createAdjuster(@NotNull Sdk sdk) {
            Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
            return INSTANCE;
        }
    }
}

