/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.nashorn.jdi;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.javascript.debugger.nashorn.jdi.ClassValue;
import com.intellij.javascript.debugger.nashorn.jdi.JdiArray;
import com.intellij.javascript.debugger.nashorn.jdi.JdiObject;
import com.intellij.openapi.util.UserDataHolderEx;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueManager;
import org.jetbrains.debugger.values.ValueType;

public final class JdiValueManager
extends ValueManager {
    private static final ObjectValueFactory OBJECT_VALUE_FACTORY = new ObjectValueFactory(){

        @Override
        public ObjectValue create(@NotNull ObjectReference objectReference, @NotNull JdiValueManager valueManager) {
            if (objectReference == null) {
                1.$$$reportNull$$$0(0);
            }
            if (valueManager == null) {
                1.$$$reportNull$$$0(1);
            }
            return new JdiObject(ValueType.OBJECT, objectReference, valueManager);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "objectReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "valueManager";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/debugger/nashorn/jdi/JdiValueManager$1";
            objectArray[2] = "create";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final DebuggerManagerThreadImpl managerThread;
    private final DebugProcessImpl debugProcess;
    private final Long2ObjectMap<Value> refToValue;

    public JdiValueManager(@NotNull DebugProcessImpl debugProcess) {
        if (debugProcess == null) {
            JdiValueManager.$$$reportNull$$$0(0);
        }
        this.refToValue = new Long2ObjectOpenHashMap();
        this.debugProcess = debugProcess;
        this.managerThread = debugProcess.getManagerThread();
    }

    public DebugProcessImpl getDebugProcess() {
        return this.debugProcess;
    }

    public UserDataHolderEx getProcessLevelCache() {
        return this.debugProcess;
    }

    @NotNull
    public DebuggerManagerThreadImpl getManagerThread() {
        DebuggerManagerThreadImpl debuggerManagerThreadImpl = this.managerThread;
        if (debuggerManagerThreadImpl == null) {
            JdiValueManager.$$$reportNull$$$0(1);
        }
        return debuggerManagerThreadImpl;
    }

    @NotNull
    public Value createValue(@Nullable com.sun.jdi.Value value) {
        Value value2 = this.createValue(value, OBJECT_VALUE_FACTORY);
        if (value2 == null) {
            JdiValueManager.$$$reportNull$$$0(2);
        }
        return value2;
    }

    @NotNull
    public Value createValue(@Nullable com.sun.jdi.Value value, @NotNull ObjectValueFactory objectValueFactory) {
        if (objectValueFactory == null) {
            JdiValueManager.$$$reportNull$$$0(3);
        }
        if (value == null) {
            org.jetbrains.debugger.values.PrimitiveValue primitiveValue = org.jetbrains.debugger.values.PrimitiveValue.NULL;
            if (primitiveValue == null) {
                JdiValueManager.$$$reportNull$$$0(4);
            }
            return primitiveValue;
        }
        if (value instanceof PrimitiveValue) {
            if (value instanceof ByteValue || value instanceof ShortValue || value instanceof IntegerValue) {
                return new org.jetbrains.debugger.values.PrimitiveValue(ValueType.NUMBER, ((PrimitiveValue)value).intValue());
            }
            if (value instanceof LongValue) {
                return new org.jetbrains.debugger.values.PrimitiveValue(ValueType.NUMBER, ((PrimitiveValue)value).longValue());
            }
            if (value instanceof FloatValue || value instanceof DoubleValue) {
                return new org.jetbrains.debugger.values.PrimitiveValue(ValueType.NUMBER, Double.toString(((PrimitiveValue)value).doubleValue()));
            }
            if (value instanceof BooleanValue) {
                return new org.jetbrains.debugger.values.PrimitiveValue(ValueType.BOOLEAN, Boolean.toString(((PrimitiveValue)value).booleanValue()));
            }
            if (value instanceof CharValue) {
                return new org.jetbrains.debugger.values.PrimitiveValue(ValueType.STRING, Character.toString(((PrimitiveValue)value).charValue()));
            }
        } else if (value instanceof ObjectReference) {
            ObjectReference objectReference = (ObjectReference)value;
            Object result = this.getCachedValue(objectReference);
            if (result != null) {
                Value value2 = result;
                if (value2 == null) {
                    JdiValueManager.$$$reportNull$$$0(5);
                }
                return value2;
            }
            result = value instanceof StringReference ? new org.jetbrains.debugger.values.PrimitiveValue(ValueType.STRING, ((StringReference)value).value()) : (value instanceof ArrayReference ? new JdiArray((ArrayReference)value, this) : (value instanceof ClassObjectReference ? new ClassValue((ClassObjectReference)value, this) : objectValueFactory.create(objectReference, this)));
            Value value3 = this.getOrCacheValue(objectReference, (Value)result);
            if (value3 == null) {
                JdiValueManager.$$$reportNull$$$0(6);
            }
            return value3;
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Value getCachedValue(@NotNull ObjectReference objectReference) {
        if (objectReference == null) {
            JdiValueManager.$$$reportNull$$$0(7);
        }
        Long2ObjectMap<Value> long2ObjectMap = this.refToValue;
        synchronized (long2ObjectMap) {
            return (Value)this.refToValue.get(objectReference.uniqueID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Value getOrCacheValue(@NotNull ObjectReference objectReference, @NotNull Value value) {
        if (objectReference == null) {
            JdiValueManager.$$$reportNull$$$0(8);
        }
        if (value == null) {
            JdiValueManager.$$$reportNull$$$0(9);
        }
        long uniqueId = objectReference.uniqueID();
        Long2ObjectMap<Value> long2ObjectMap = this.refToValue;
        // MONITORENTER : long2ObjectMap
        Value newValue = (Value)this.refToValue.get(uniqueId);
        if (newValue == null) {
            this.refToValue.put(uniqueId, (Object)value);
            Value value2 = value;
            // MONITOREXIT : long2ObjectMap
            if (value2 != null) return value2;
            JdiValueManager.$$$reportNull$$$0(10);
            return value2;
        }
        Value value3 = newValue;
        // MONITOREXIT : long2ObjectMap
        if (value3 != null) return value3;
        JdiValueManager.$$$reportNull$$$0(11);
        return value3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 6, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/debugger/nashorn/jdi/JdiValueManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectValueFactory";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectReference";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/debugger/nashorn/jdi/JdiValueManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getManagerThread";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createValue";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCacheValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCachedValue";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOrCacheValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5, 6, 10, 11 -> new IllegalStateException(string);
        };
    }

    public static abstract class ObjectValueFactory {
        public abstract ObjectValue create(@NotNull ObjectReference var1, @NotNull JdiValueManager var2);
    }
}

