/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.actions;

import com.intellij.dsm.DsmBundle;
import com.intellij.dsm.actions.DsmDisposable;
import com.intellij.dsm.ui.DsmLegend;
import com.intellij.dsm.ui.DsmView;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ui.UIUtil;
import icons.DsmIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

final class DsmUIUtil {
    private DsmUIUtil() {
    }

    static void showView(@NotNull Project project, @NotNull DsmView view, @Nls(capitalization=Nls.Capitalization.Title) String name) {
        if (project == null) {
            DsmUIUtil.$$$reportNull$$$0(0);
        }
        if (view == null) {
            DsmUIUtil.$$$reportNull$$$0(1);
        }
        for (JComponent component : UIUtil.uiTraverser((Component)view).traverse().filter(JComponent.class)) {
            PopupHandler.installPopupMenu((JComponent)component, (String)"DSM.Popup", (String)"DSM.View");
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        ToolWindow toolWindow = toolWindowManager.getToolWindow(DsmUIUtil.getToolwindowId());
        if (toolWindow == null) {
            DsmDisposable disposable = DsmDisposable.getInstance(project);
            toolWindow = toolWindowManager.registerToolWindow(DsmUIUtil.getToolwindowId(), true, ToolWindowAnchor.RIGHT, (Disposable)disposable, true, true);
            toolWindow.setIcon(DsmIcons.ToolWindowDsm);
            ContentManagerWatcher.watchContentManager((ToolWindow)toolWindow, (ContentManager)toolWindow.getContentManager());
        }
        toolWindow.setAvailable(true);
        toolWindow.setToHideOnEmptyContent(true);
        Rectangle bounds = WindowManager.getInstance().getIdeFrame(project).suggestChildFrameBounds();
        toolWindow.setDefaultState(ToolWindowAnchor.RIGHT, ToolWindowType.FLOATING, bounds);
        JPanel p = new JPanel(new BorderLayout());
        p.putClientProperty("DSM", "OUTER_WITH_TOOLWINDOW");
        p.add((Component)view, "Center");
        ContentManager contentManager = toolWindow.getContentManager();
        Content content = contentManager.getFactory().createContent((JComponent)p, name, false);
        JComponent tableComponent = view.getTable().getComponent();
        content.setPreferredFocusableComponent(tableComponent);
        contentManager.addContent(content);
        ActionManager actionManager = ActionManager.getInstance();
        ActionGroup group = (ActionGroup)actionManager.getAction("DSM.Toolbar");
        ActionToolbar toolbar = actionManager.createActionToolbar("DsmToolbar", group, true);
        toolbar.setTargetComponent(tableComponent);
        JPanel topComponent = new JPanel(new BorderLayout());
        topComponent.add((Component)toolbar.getComponent(), "West");
        topComponent.add((Component)new DsmLegend(tableComponent), "East");
        p.add((Component)topComponent, "North");
        toolWindow.activate(() -> contentManager.setSelectedContent(content, true));
    }

    static String getToolwindowId() {
        return DsmBundle.message("dsm", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "view";
                break;
            }
        }
        objectArray[1] = "com/intellij/dsm/actions/DsmUIUtil";
        objectArray[2] = "showView";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

