/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.model;

import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.openapi.util.NlsSafe;
import java.util.Set;

public final class DsmModelUtil {
    private DsmModelUtil() {
    }

    public static <N> void fillLeafMap(DsmTreeStructure.TreeNode<N> node, int fillValue, int[] vertexMap) {
        if (node.isLeaf()) {
            vertexMap[node.getLeafIndex()] = fillValue;
            return;
        }
        for (DsmTreeStructure.TreeNode<N> child : node.getRawChildren()) {
            DsmModelUtil.fillLeafMap(child, fillValue, vertexMap);
        }
    }

    public static <N> int countLeaves(DsmTreeStructure.TreeNode<N> node) {
        if (node.isLeaf()) {
            return 1;
        }
        int count = 0;
        for (DsmTreeStructure.TreeNode<N> child : node.getRawChildren()) {
            count += DsmModelUtil.countLeaves(child);
        }
        return count;
    }

    public static <N> int countCycles(DsmTreeStructure.TreeNode<N> node) {
        if (node.isLeaf()) {
            return 0;
        }
        int count = 0;
        if (node.getCycle() != null) {
            ++count;
        }
        for (DsmTreeStructure.TreeNode<N> child : node.getChildren()) {
            count += DsmModelUtil.countCycles(child);
        }
        return count;
    }

    public static <N> void collectLeafData(DsmTreeStructure.TreeNode<N> node, Set<? super N> leaves) {
        if (node.isLeaf()) {
            leaves.add(node.getLeafData());
        } else {
            for (DsmTreeStructure.TreeNode<N> child : node.getRawChildren()) {
                DsmModelUtil.collectLeafData(child, leaves);
            }
        }
    }

    public static <N> void collectLeafData(Set<? extends DsmTreeStructure.TreeNode<N>> nodes, Set<? super N> leaves) {
        for (DsmTreeStructure.TreeNode<N> treeNode : nodes) {
            DsmModelUtil.collectLeafData(treeNode, leaves);
        }
    }

    @NlsSafe
    public static <N> String getShortName(Set<? extends DsmTreeStructure.TreeNode<N>> nodes) {
        StringBuilder result = new StringBuilder();
        for (DsmTreeStructure.TreeNode<N> node : nodes) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(node.getShortName());
        }
        return result.toString();
    }
}

