/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.ui;

import com.intellij.dsm.model.DsmTreeStructure;
import java.util.Collections;
import java.util.Set;

public final class DsmSelection<N> {
    public final Type type;
    public final Set<DsmTreeStructure.TreeNode<N>> node1;
    public final Set<DsmTreeStructure.TreeNode<N>> node2;
    public final int start1;
    public final int end1;
    public final int start2;
    public final int end2;

    private DsmSelection(Type type, Set<DsmTreeStructure.TreeNode<N>> nodes1, Set<DsmTreeStructure.TreeNode<N>> nodes2, int start1, int end1, int start2, int end2) {
        this.end2 = end2;
        this.start2 = start2;
        this.end1 = end1;
        this.start1 = start1;
        this.type = type;
        this.node1 = nodes1;
        this.node2 = nodes2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DsmSelection that = (DsmSelection)o;
        if (this.node1 != null ? !this.node1.equals(that.node1) : that.node1 != null) {
            return false;
        }
        if (this.node2 != null ? !this.node2.equals(that.node2) : that.node2 != null) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.node1 != null ? this.node1.hashCode() : 0);
        result = 31 * result + (this.node2 != null ? this.node2.hashCode() : 0);
        return result;
    }

    public static <N> DsmSelection<N> createRowSelection(DsmTreeStructure.TreeNode<N> node, int nodeIndex) {
        return new DsmSelection<N>(Type.ROW, Collections.singleton(node), Collections.singleton(node), nodeIndex, nodeIndex, nodeIndex, nodeIndex);
    }

    public static <N> DsmSelection<N> createRowSelection(Set<DsmTreeStructure.TreeNode<N>> nodes, int startIndex, int endIndex) {
        return new DsmSelection<N>(Type.ROW, nodes, nodes, startIndex, endIndex, startIndex, endIndex);
    }

    public static <N> DsmSelection<N> createCellSelection(DsmTreeStructure.TreeNode<N> row, DsmTreeStructure.TreeNode<N> col, int index1, int index2) {
        return new DsmSelection<N>(Type.CELL, Collections.singleton(row), Collections.singleton(col), index1, index1, index2, index2);
    }

    public static <N> DsmSelection<N> createCellSelection(Set<DsmTreeStructure.TreeNode<N>> rows, Set<DsmTreeStructure.TreeNode<N>> cols, int start1, int end1, int start2, int end2) {
        return new DsmSelection<N>(Type.CELL, rows, cols, start1, end1, start2, end2);
    }

    public static enum Type {
        ROW,
        CELL;

    }
}

