/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.ui;

import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.ui.AbstractNodeVisitor;
import com.intellij.dsm.ui.DsmSelection;
import com.intellij.dsm.ui.DsmTableImpl;
import com.intellij.dsm.ui.RowAnnotation;
import java.util.HashSet;
import java.util.Set;

class RowAnnotationsUpdater<N> {
    private final DsmTableImpl<N> myDsmTable;

    RowAnnotationsUpdater(DsmTableImpl<N> dsmTable) {
        this.myDsmTable = dsmTable;
    }

    void updateRowAnnotations() {
        this.myDsmTable.myRowAnnotations.clear();
        HashSet<DsmTreeStructure.TreeNode<N>> endNodes = new HashSet<DsmTreeStructure.TreeNode<N>>();
        for (DsmSelection selection : this.myDsmTable.mySelectionModel.getSelection()) {
            if (selection.type != DsmSelection.Type.ROW) continue;
            for (DsmTreeStructure.TreeNode node : selection.node1) {
                this.collectNodes(node, endNodes);
            }
        }
        if (!endNodes.isEmpty()) {
            this.updateRowAnnotations(endNodes);
        }
    }

    private void updateRowAnnotations(Set<DsmTreeStructure.TreeNode<N>> nodes) {
        HashSet to = new HashSet();
        HashSet from = new HashSet();
        for (DsmTreeStructure.TreeNode<Object> node : nodes) {
            int v = this.myDsmTable.myCache.rowIndices.getInt(node);
            if (v < 0) continue;
            assert (this.myDsmTable.myCache.myRows.get(v) == node);
            for (int w = 0; w < this.myDsmTable.myGraph.V(); ++w) {
                boolean bck;
                DsmTreeStructure.TreeNode other = this.myDsmTable.myCache.myRows.get(w);
                if (nodes.contains(other)) continue;
                boolean fwd = this.myDsmTable.myGraph.edge(node, other) != null;
                boolean bl = bck = this.myDsmTable.myGraph.edge(other, node) != null;
                if (fwd) {
                    to.add(other);
                }
                if (!bck) continue;
                from.add(other);
            }
        }
        for (DsmTreeStructure.TreeNode<Object> node : to) {
            if (from.contains(node)) {
                this.myDsmTable.myRowAnnotations.put(node, RowAnnotation.CYCLE_DEP);
                continue;
            }
            this.myDsmTable.myRowAnnotations.put(node, RowAnnotation.FWD_DEP);
        }
        for (DsmTreeStructure.TreeNode<Object> node : from) {
            if (to.contains(node)) continue;
            this.myDsmTable.myRowAnnotations.put(node, RowAnnotation.BCK_DEP);
        }
    }

    private void collectNodes(DsmTreeStructure.TreeNode<N> row, final Set<DsmTreeStructure.TreeNode<N>> endNodes) {
        this.myDsmTable.acceptNode(row, 0, 0, new AbstractNodeVisitor<N>(){

            @Override
            public void visitLeaf(DsmTreeStructure.TreeNode<N> node, int x, int y, int height, boolean isFirst, boolean isLast) {
                endNodes.add(node);
            }

            @Override
            public void visitCollapsed(DsmTreeStructure.TreeNode<N> node, int x, int y, int height, boolean isFirst, boolean isLast) {
                endNodes.add(node);
            }
        }, false, false);
    }
}

