/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.ui;

import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.ui.DsmTableConstants;
import com.intellij.dsm.ui.DsmTableImpl;
import com.intellij.dsm.ui.PaintRowHeaderVisitor;
import com.intellij.dsm.ui.RowHeaderMouseHandler;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RowHeaderView<N>
extends JComponent
implements UiDataProvider {
    private final DsmTableImpl<N> myDsmTable;
    private final RowHeaderMouseHandler<N> myMouseHandler;
    private DsmTreeStructure.TreeNode<N> myHintNode = null;

    RowHeaderView(DsmTableImpl<N> dsmTable) {
        this.myDsmTable = dsmTable;
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.myMouseHandler = new RowHeaderMouseHandler<N>(dsmTable, this);
        this.setToolTipText("");
    }

    @Override
    public Dimension getPreferredSize() {
        this.myDsmTable.updateCache();
        return new Dimension(this.myDsmTable.myCache.maxRowHeaderWidth + 1, this.myDsmTable.myCache.myTableSize + 1);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        this.myDsmTable.updateCache();
        this.myDsmTable.acceptNodes(new PaintRowHeaderVisitor<N>(this.myDsmTable, g));
        this.paintExpandedRowHint(g);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myDsmTable, true));
        }
        this.myMouseHandler.processMouseEvent(e);
        super.processMouseEvent(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        this.myMouseHandler.processMouseMotionEvent(e);
    }

    void showRowHint(DsmTreeStructure.TreeNode<N> node) {
        DsmTreeStructure.TreeNode<N> oldNode = this.myHintNode;
        DsmTreeStructure.TreeNode<N> treeNode = this.myHintNode = this.myDsmTable.isExpanded(node) ? node : null;
        if (this.myHintNode != oldNode) {
            this.myDsmTable.update();
        }
    }

    @Nullable
    DsmTreeStructure.TreeNode<N> locateRow(int x, int y) {
        if (y < 0) {
            return null;
        }
        int rowNumber = y / this.myDsmTable.myBoxSize;
        DsmTreeStructure.TreeNode node = null;
        if (rowNumber < this.myDsmTable.myCache.myRows.size()) {
            Rectangle r;
            for (node = this.myDsmTable.myCache.myRows.get(rowNumber); !(node == null || (r = this.myDsmTable.myCache.rowHeaderBounds.get(node)) != null && r.contains(x, y)); node = node.getParent()) {
            }
        }
        return node;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        this.myDsmTable.updateCache();
        DsmTreeStructure.TreeNode<N> node = this.locateRow(event.getX(), event.getY());
        if (node == null) {
            return null;
        }
        String name = node.getFullName();
        return name == null || name.equals(node.getShortName()) ? null : StringUtil.escapeXmlEntities((String)name);
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            RowHeaderView.$$$reportNull$$$0(0);
        }
        DataSink.uiDataSnapshot((DataSink)sink, this.myDsmTable);
    }

    private void paintExpandedRowHint(Graphics2D g) {
        String shortName;
        if (this.myHintNode == null) {
            return;
        }
        Rectangle r = this.myDsmTable.myCache.rowHeaderBounds.get(this.myHintNode);
        if (r == null) {
            return;
        }
        FontMetrics fontMetrics = g.getFontMetrics();
        int stringWidth = fontMetrics.stringWidth(shortName = this.myHintNode.getShortName());
        int newHeight = stringWidth + 2 + r.width + r.width;
        if (r.height >= newHeight) {
            return;
        }
        g.setPaint(this.myDsmTable.getHeaderBg(this.myHintNode));
        g.fillRect(r.x, r.y + r.width - 1, r.width, newHeight - r.width + 1);
        g.setPaint(DsmTableConstants.COLOR_GRID_COLOR);
        g.drawRect(r.x, r.y, r.width, newHeight);
        AffineTransform oldTransform = g.getTransform();
        g.translate(r.x, r.y + r.width);
        g.rotate(1.5707963267948966);
        PaintRowHeaderVisitor.paintRowIcon(this.myHintNode, 0, -r.width, r.width, this.myDsmTable, g);
        UISettings.setupAntialiasing((Graphics)g);
        g.setPaint(this.myDsmTable.getHeaderFg(this.myHintNode));
        int y = (r.width - fontMetrics.getHeight()) / 2 + fontMetrics.getDescent();
        g.drawString(shortName, r.width, -y);
        g.setTransform(oldTransform);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/dsm/ui/RowHeaderView", "uiDataSnapshot"));
    }
}

