const fs = require('fs')

function apply(className) {
  const inputFilePath = `../../../../../../gen/com/intellij/lang/javascript/parsing/${className}.java`
  const inputFileContents = fs.readFileSync(inputFilePath, 'utf-8')

  let isInsideParse = false
  const output = inputFileContents
    .split('\n')
    .filter(line =>
              !line.includes('import com.intellij.lang.PsiBuilder;') &&
              !line.includes('import com.intellij.lang.PsiBuilder.Marker;') &&
              !line.includes('import static generated.GeneratedTypes.*;')
    )
    .map(line => line
      .replace('PsiBuilder', 'State')
      .replace('implements PsiParser, LightPsiParser ', '')
      .replace('static boolean parse_root_', 'static public boolean parse_root_')
    )
    .filter(line => {
      if (isInsideParse) {
        if (line.includes('}')) {
          isInsideParse = false
        }
        return false
      }
      else if (line.includes('ASTNode parse(') || line.includes('void parseLight(')) {
        isInsideParse = true
        return false
      }
      return true
    })
    .join('\n')

  fs.writeFileSync(inputFilePath, output)
}

apply("JSTagOrGenericParser")
apply("JSTagOrGenericFlowParser")