import React, { useState, useEffect, useContext } from 'react';
import { Href, CollapseButton, Markdown, Extensions } from './index';
import { SchemaHelpers } from '../helpers';
var SchemaContext = React.createContext({
    reverse: false,
    deepExpanded: false,
});
export var Schema = function (_a) {
    var schemaName = _a.schemaName, schema = _a.schema, _b = _a.required, required = _b === void 0 ? false : _b, _c = _a.isPatternProperty, isPatternProperty = _c === void 0 ? false : _c, _d = _a.isProperty, isProperty = _d === void 0 ? false : _d, _e = _a.isCircular, isCircular = _e === void 0 ? false : _e, dependentRequired = _a.dependentRequired, _f = _a.expanded, propExpanded = _f === void 0 ? false : _f, _g = _a.onlyTitle, onlyTitle = _g === void 0 ? false : _g;
    var _h = useContext(SchemaContext), reverse = _h.reverse, deepExpanded = _h.deepExpanded;
    var _j = useState(propExpanded), expanded = _j[0], setExpanded = _j[1];
    var _k = useState(false), deepExpand = _k[0], setDeepExpand = _k[1];
    useEffect(function () {
        setDeepExpand(deepExpanded);
    }, [deepExpanded, setDeepExpand]);
    useEffect(function () {
        setExpanded(deepExpand);
    }, [deepExpand, setExpanded]);
    if (!schema ||
        (typeof schemaName === 'string' &&
            ((schemaName === null || schemaName === void 0 ? void 0 : schemaName.startsWith('x-parser-')) ||
                (schemaName === null || schemaName === void 0 ? void 0 : schemaName.startsWith('x-schema-private-'))))) {
        return null;
    }
    var dependentSchemas = SchemaHelpers.getDependentSchemas(schema);
    var constraints = SchemaHelpers.humanizeConstraints(schema);
    var externalDocs = schema.externalDocs();
    var renderType = schema.ext(SchemaHelpers.extRenderType) !== false;
    var rawValue = schema.ext(SchemaHelpers.extRawValue) === true;
    var parameterLocation = schema.ext(SchemaHelpers.extParameterLocation);
    var isExpandable = SchemaHelpers.isExpandable(schema) || dependentSchemas;
    var schemaType = SchemaHelpers.toSchemaType(schema);
    isCircular =
        isCircular ||
            schema.isCircular() ||
            schema.ext('x-parser-circular') ||
            false;
    var uid = schema.uid();
    var schemaItems = schema.items();
    if (schemaItems && !Array.isArray(schemaItems)) {
        isCircular =
            isCircular ||
                schemaItems.isCircular() ||
                schemaItems.ext('x-parser-circular') ||
                false;
        if (isCircular &&
            typeof schemaItems.circularSchema === 'function') {
            schemaType = SchemaHelpers.toSchemaType(schemaItems.circularSchema());
        }
    }
    else if (isCircular &&
        typeof schema.circularSchema === 'function') {
        schemaType = SchemaHelpers.toSchemaType(schema.circularSchema());
    }
    var styledSchemaName = isProperty ? 'italic' : '';
    var renderedSchemaName = typeof schemaName === 'string' ? (React.createElement("span", { className: "break-words text-sm ".concat(styledSchemaName) }, schemaName)) : (schemaName);
    return (React.createElement(SchemaContext.Provider, { value: { reverse: !reverse, deepExpanded: deepExpand } },
        React.createElement("div", null,
            React.createElement("div", { className: "flex py-2" },
                React.createElement("div", { className: "".concat(onlyTitle ? '' : 'min-w-1/4', " mr-2") },
                    isExpandable && !isCircular ? (React.createElement(React.Fragment, null,
                        React.createElement(CollapseButton, { onClick: function () { return setExpanded(function (prev) { return !prev; }); }, expanded: expanded }, renderedSchemaName),
                        React.createElement("button", { type: "button", onClick: function () { return setDeepExpand(function (prev) { return !prev; }); }, className: "ml-1 text-sm text-gray-500" }, deepExpand ? 'Collapse all' : 'Expand all'))) : (React.createElement("span", { className: "break-words text-sm ".concat(isProperty ? 'italic' : '') }, schemaName)),
                    isPatternProperty && (React.createElement("div", { className: "text-gray-500 text-xs italic" }, "(pattern property)")),
                    required && React.createElement("div", { className: "text-red-600 text-xs" }, "required"),
                    dependentRequired && (React.createElement(React.Fragment, null,
                        React.createElement("div", { className: "text-gray-500 text-xs" }, "required when defined:"),
                        React.createElement("div", { className: "text-red-600 text-xs" }, dependentRequired.join(', ')))),
                    schema.deprecated() && (React.createElement("div", { className: "text-red-600 text-xs" }, "deprecated")),
                    schema.writeOnly() && (React.createElement("div", { className: "text-gray-500 text-xs" }, "write-only")),
                    schema.readOnly() && (React.createElement("div", { className: "text-gray-500 text-xs" }, "read-only"))),
                rawValue ? (React.createElement("div", null,
                    React.createElement("div", { className: "text-sm" }, SchemaHelpers.prettifyValue(schema.const(), false)))) : (React.createElement("div", null,
                    React.createElement("div", null,
                        renderType && (React.createElement("div", { className: "capitalize text-sm text-teal-500 font-bold inline-block mr-2" }, isCircular ? "".concat(schemaType, " [CIRCULAR]") : schemaType)),
                        React.createElement("div", { className: "inline-block" },
                            schema.format() && (React.createElement("span", { className: "bg-yellow-600 font-bold no-underline text-white rounded lowercase mr-2 p-1 text-xs" },
                                "format: ",
                                schema.format())),
                            schema.pattern() !== undefined && (React.createElement("span", { className: "bg-yellow-600 font-bold no-underline text-white rounded mr-2 p-1 text-xs" },
                                "must match: ",
                                schema.pattern())),
                            schema.contentMediaType() !== undefined && (React.createElement("span", { className: "bg-yellow-600 font-bold no-underline text-white rounded lowercase mr-2 p-1 text-xs" },
                                "media type: ",
                                schema.contentMediaType())),
                            schema.contentEncoding() !== undefined && (React.createElement("span", { className: "bg-yellow-600 font-bold no-underline text-white rounded lowercase mr-2 p-1 text-xs" },
                                "encoding: ",
                                schema.contentEncoding())),
                            !!constraints.length &&
                                constraints.map(function (c) { return (React.createElement("span", { className: "bg-purple-600 font-bold no-underline text-white rounded lowercase mr-2 p-1 text-xs", key: c }, c)); }),
                            uid && !uid.startsWith('<anonymous-') && (React.createElement("span", { className: "border text-orange-600 rounded mr-2 p-1 text-xs" },
                                "uid: ",
                                uid))),
                        schema.hasDescription() && (React.createElement("div", null,
                            React.createElement(Markdown, null, schema.description()))),
                        schema.default() !== undefined && (React.createElement("div", { className: "text-xs" },
                            "Default value:",
                            React.createElement("span", { className: "border inline-block text-orange-600 rounded ml-1 py-0 px-2" }, SchemaHelpers.prettifyValue(schema.default())))),
                        schema.const() !== undefined && (React.createElement("div", { className: "text-xs" },
                            "Const:",
                            React.createElement("span", { className: "border inline-block text-orange-600 rounded ml-1 py-0 px-2" }, SchemaHelpers.prettifyValue(schema.const())))),
                        schema.enum() && (React.createElement("ul", { className: "text-xs" },
                            "Allowed values:",
                            ' ',
                            schema.enum().map(function (e, idx) { return (React.createElement("li", { key: idx, className: "border inline-block text-orange-600 rounded ml-1 py-0 px-2" },
                                React.createElement("span", null, SchemaHelpers.prettifyValue(e)))); }))),
                        parameterLocation && (React.createElement("div", { className: "text-xs" },
                            "Parameter location:",
                            ' ',
                            React.createElement("span", { className: "border text-orange-600 rounded mr-2 p-1 text-xs" }, parameterLocation))),
                        externalDocs && (React.createElement("span", { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 font-bold no-underline text-xs uppercase rounded px-2 py-0" },
                            React.createElement(Href, { href: externalDocs.url(), title: externalDocs.description() || '' }, "Documentation"))),
                        schema.examples() && (React.createElement("ul", { className: "text-xs" },
                            "Examples values:",
                            ' ',
                            schema.examples().map(function (e, idx) { return (React.createElement("li", { key: idx, className: "border inline-block text-orange-600 rounded ml-1 py-0 px-2 break-all" },
                                React.createElement("span", null, SchemaHelpers.prettifyValue(e)))); }))))))),
            isCircular || !isExpandable ? null : (React.createElement("div", { className: "rounded p-4 py-2 border bg-gray-100 ".concat(reverse ? 'bg-gray-200' : '', " ").concat(expanded ? 'block' : 'hidden') },
                React.createElement(SchemaProperties, { schema: schema }),
                React.createElement(SchemaItems, { schema: schema }),
                schema.oneOf() &&
                    schema
                        .oneOf()
                        .map(function (s, idx) { return (React.createElement(Schema, { key: idx, schema: s, schemaName: idx === 0 ? 'Adheres to:' : 'Or to:' })); }),
                schema.anyOf() &&
                    schema
                        .anyOf()
                        .map(function (s, idx) { return (React.createElement(Schema, { key: idx, schema: s, schemaName: idx === 0 ? 'Can adhere to:' : 'Or to:' })); }),
                schema.allOf() &&
                    schema
                        .allOf()
                        .map(function (s, idx) { return (React.createElement(Schema, { key: idx, schema: s, schemaName: idx === 0 ? 'Consists of:' : 'And with:' })); }),
                schema.not() && (React.createElement(Schema, { schema: schema.not(), schemaName: "Cannot adhere to:" })),
                schema.propertyNames() && (React.createElement(Schema, { schema: schema.propertyNames(), schemaName: "Property names must adhere to:" })),
                schema.contains() && (React.createElement(Schema, { schema: schema.contains(), schemaName: "Array must contain at least one of:" })),
                schema.if() && (React.createElement(Schema, { schema: schema.if(), schemaName: "If schema adheres to:" })),
                schema.then() && (React.createElement(Schema, { schema: schema.then(), schemaName: "Then must adhere to:" })),
                schema.else() && (React.createElement(Schema, { schema: schema.else(), schemaName: "Otherwise:" })),
                dependentSchemas && (React.createElement(Schema, { schema: dependentSchemas, schemaName: "Dependent schemas:" })),
                React.createElement(Extensions, { item: schema }),
                React.createElement(AdditionalProperties, { schema: schema }),
                React.createElement(AdditionalItems, { schema: schema }))))));
};
var SchemaProperties = function (_a) {
    var schema = _a.schema;
    var properties = schema.properties() || {};
    if (!Object.keys(properties)) {
        return null;
    }
    var required = schema.required() || [];
    var patternProperties = schema.patternProperties();
    var circularProps = schema.ext('x-parser-circular-props') || [];
    return (React.createElement(React.Fragment, null,
        Object.entries(properties).map(function (_a) {
            var propertyName = _a[0], property = _a[1];
            return (React.createElement(Schema, { schema: property, schemaName: propertyName, required: required.includes(propertyName), isProperty: true, isCircular: circularProps.includes(propertyName), dependentRequired: SchemaHelpers.getDependentRequired(propertyName, schema), key: propertyName }));
        }),
        Object.entries(patternProperties).map(function (_a) {
            var propertyName = _a[0], property = _a[1];
            return (React.createElement(Schema, { schema: property, schemaName: propertyName, isPatternProperty: true, isProperty: true, isCircular: circularProps.includes(propertyName), key: propertyName }));
        })));
};
var AdditionalProperties = function (_a) {
    var schema = _a.schema;
    if (schema.ext(SchemaHelpers.extRenderAdditionalInfo) === false) {
        return null;
    }
    var type = schema.type();
    type = Array.isArray(type) ? type : [type];
    if (!type.includes('object')) {
        return null;
    }
    var additionalProperties = schema.additionalProperties();
    if (additionalProperties === true || additionalProperties === undefined) {
        return (React.createElement("p", { className: "mt-2 text-xs text-gray-700" }, "Additional properties are allowed."));
    }
    if (additionalProperties === false) {
        return (React.createElement("p", { className: "mt-2 text-xs text-gray-700" },
            "Additional properties are ",
            React.createElement("strong", null, "NOT"),
            " allowed."));
    }
    return (React.createElement(Schema, { schemaName: "Additional properties:", schema: additionalProperties }));
};
var SchemaItems = function (_a) {
    var schema = _a.schema;
    var type = schema.type();
    type = Array.isArray(type) ? type : [type];
    if (!type.includes('array')) {
        return null;
    }
    var items = schema.items();
    if (items &&
        !Array.isArray(items) &&
        Object.keys(items.properties() || {}).length) {
        return React.createElement(SchemaProperties, { schema: items });
    }
    else if (Array.isArray(items)) {
        return (React.createElement(React.Fragment, null, items.map(function (item, idx) { return (React.createElement(Schema, { schema: item, schemaName: "".concat(idx + 1, " item:"), key: idx })); })));
    }
    return React.createElement(Schema, { schema: items, schemaName: "Items:" });
};
var AdditionalItems = function (_a) {
    var schema = _a.schema;
    if (schema.ext(SchemaHelpers.extRenderAdditionalInfo) === false) {
        return null;
    }
    var type = schema.type();
    type = Array.isArray(type) ? type : [type];
    if (!type.includes('array')) {
        return null;
    }
    if (!Array.isArray(schema.items())) {
        return null;
    }
    var additionalItems = schema.additionalItems();
    if (additionalItems === true || additionalItems === undefined) {
        return (React.createElement("p", { className: "mt-2 text-xs text-gray-700" }, "Additional items are allowed."));
    }
    if (additionalItems === false) {
        return (React.createElement("p", { className: "mt-2 text-xs text-gray-700" },
            "Additional items are ",
            React.createElement("strong", null, "NOT"),
            " allowed."));
    }
    return React.createElement(Schema, { schemaName: "Additional items:", schema: additionalItems });
};
//# sourceMappingURL=Schema.js.map