"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.tryHandleCustomTsServerCommandLsp = exports.tryHandleTsServerCommand = exports.initCommandNamesForSessionProvider = exports.registerProtocolHandlers = void 0;
const get_element_type_ts_server_1 = require("./get-element-type-ts-server");
const ide_get_element_type_1 = require("./ide-get-element-type");
const customHandlers = {
    "ideGetElementType": [get_element_type_ts_server_1.getElementTypeTsServer, getElementTypeLsp],
    "ideGetSymbolType": [get_element_type_ts_server_1.getSymbolTypeTsServer, getSymbolTypeLsp],
    "ideGetTypeProperties": [get_element_type_ts_server_1.getTypePropertiesTsServer, getTypePropertiesLsp],
    "ideAreTypesMutuallyAssignable": [get_element_type_ts_server_1.areTypesMutuallyAssignableTsServer, areTypesMutuallyAssignableLsp],
    "ideCloseSafely": [closeSafelyTsServer, undefined /* not supported on LSP */],
    "ideEnsureFileAndProjectOpenedCommand": [ensureFileAndProjectOpenedTsServer, undefined /* not supported on LSP */],
    "ideTestCancellation": [testCancellationTsServer, testCancellationLsp], // Special command to test cancellation support on the server
};
/** This method is used to register handlers for TS 5+ */
function registerProtocolHandlers(session, ts, projectService) {
    for (let command in customHandlers) {
        session.addProtocolHandler(command, (request) => {
            try {
                return customHandlers[command][0](ts, projectService, request.arguments) || emptyDoneResponse();
            }
            catch (e) {
                if (e.isOperationCancelledError) {
                    return cancelledResponse();
                }
                else if (e.isFileOutsideOfImportGraphError) {
                    return fileOutsideOfImportGraphResponse();
                }
                else {
                    throw e;
                }
            }
        });
    }
}
exports.registerProtocolHandlers = registerProtocolHandlers;
/** This method is used by the old session provider logic for TS <5 **/
function initCommandNamesForSessionProvider(TypeScriptCommandNames) {
    for (let command in customHandlers) {
        TypeScriptCommandNames[command] = command;
    }
}
exports.initCommandNamesForSessionProvider = initCommandNamesForSessionProvider;
/** This method is used by the old session provider logic for TS <5  **/
function tryHandleTsServerCommand(ts_impl, projectService, request) {
    var _a, _b;
    try {
        return (_b = (_a = customHandlers[request.command]) === null || _a === void 0 ? void 0 : _a[0]) === null || _b === void 0 ? void 0 : _b.call(_a, ts_impl, projectService, request.arguments);
    }
    catch (e) {
        return processError(e);
    }
}
exports.tryHandleTsServerCommand = tryHandleTsServerCommand;
function tryHandleCustomTsServerCommandLsp(ts, commandName, requestArguments, context) {
    var _a, _b;
    return __awaiter(this, void 0, void 0, function* () {
        return (_b = (_a = customHandlers[commandName]) === null || _a === void 0 ? void 0 : _a[1]) === null || _b === void 0 ? void 0 : _b.call(_a, ts, requestArguments, context);
    });
}
exports.tryHandleCustomTsServerCommandLsp = tryHandleCustomTsServerCommandLsp;
function closeSafelyTsServer(_ts, projectService, requestArguments) {
    projectService.ideProjectService.closeClientFileSafely(requestArguments.file);
    return notRequiredResponse();
}
function ensureFileAndProjectOpenedTsServer(_ts, projectService, requestArguments) {
    // Ensure that there is a project opened for the file
    projectService.ideProjectService.getProjectAndSourceFile(requestArguments.file, requestArguments.projectFileName);
    return emptyDoneResponse();
}
let lastIdeProjectId = 0;
function getElementTypeLsp(ts, requestArgument, lspSupport) {
    return lspSupport.process(requestArgument.file, requestArgument.range, context => {
        var _a;
        const ideProjectId = (_a = context.languageService.ideProjectId) !== null && _a !== void 0 ? _a : (context.languageService.ideProjectId = lastIdeProjectId++);
        const range = context.range;
        if (!range)
            return undefined;
        // TODO consider using languageService.webStormGetElementType
        return (0, ide_get_element_type_1.getElementType)(ts, ideProjectId, context.program, context.sourceFile, range, requestArgument.forceReturnType, context.cancellationToken, context.reverseMapper);
    });
}
function getSymbolTypeLsp(ts, requestArgument, lspSupport) {
    return lspSupport.process(requestArgument.originalRequestUri, undefined, context => {
        var _a;
        if (context.languageService.ideProjectId !== requestArgument.ideProjectId
            || ((_a = context.program.getTypeChecker().webStormCacheInfo) === null || _a === void 0 ? void 0 : _a.ideTypeCheckerId) !== requestArgument.ideTypeCheckerId) {
            return undefined;
        }
        return (0, ide_get_element_type_1.getSymbolType)(ts, context.program, requestArgument.symbolId, context.cancellationToken, context.reverseMapper);
    });
}
function getTypePropertiesLsp(ts, requestArgument, lspSupport) {
    return lspSupport.process(requestArgument.originalRequestUri, undefined, context => {
        var _a;
        if (context.languageService.ideProjectId !== requestArgument.ideProjectId
            || ((_a = context.program.getTypeChecker().webStormCacheInfo) === null || _a === void 0 ? void 0 : _a.ideTypeCheckerId) !== requestArgument.ideTypeCheckerId) {
            return undefined;
        }
        return (0, ide_get_element_type_1.getTypeProperties)(ts, context.program, requestArgument.typeId, context.cancellationToken, context.reverseMapper);
    });
}
function areTypesMutuallyAssignableLsp(ts, requestArgument, lspSupport) {
    return lspSupport.process(requestArgument.originalRequestUri, undefined, context => {
        var _a;
        if (context.languageService.ideProjectId !== requestArgument.ideProjectId
            || ((_a = context.program.getTypeChecker().webStormCacheInfo) === null || _a === void 0 ? void 0 : _a.ideTypeCheckerId) !== requestArgument.ideTypeCheckerId) {
            return undefined;
        }
        return (0, ide_get_element_type_1.areTypesMutuallyAssignable)(ts, context.program, requestArgument.type1Id, requestArgument.type2Id, context.cancellationToken);
    });
}
function testCancellationTsServer(_ts, projectService, _requestArguments) {
    const start = new Date().getTime();
    while (!projectService.cancellationToken.isCancellationRequested()) {
        // not possible to use promise here
        if (new Date().getTime() - start > 10000) {
            throw new Error("Test cancellation timeout - waited 10s");
        }
    }
    return cancelledResponse();
}
function testCancellationLsp(_ts, _requestArgument, lspSupport) {
    return __awaiter(this, void 0, void 0, function* () {
        const start = new Date().getTime();
        while (!lspSupport.cancellationToken.isCancellationRequested()) {
            if (new Date().getTime() - start > 10000) {
                throw new Error("Test cancellation timeout - waited 10s");
            }
        }
        return cancelledResponse();
    });
}
function notRequiredResponse() {
    return {
        responseRequired: false
    };
}
function emptyDoneResponse() {
    return {
        responseRequired: true,
        response: null
    };
}
function cancelledResponse() {
    return {
        responseRequired: true,
        response: {
            cancelled: true
        }
    };
}
function fileOutsideOfImportGraphResponse() {
    return {
        responseRequired: true,
        response: {
            error: "file-outside-of-import-graph"
        }
    };
}
//# sourceMappingURL=ide-commands.js.map