/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.jdbc.orm.model;

import com.intellij.jpa.jpb.model.core.util.Fqn;
import com.intellij.jpa.jpb.model.orm.ep.OrmSearcher;
import com.intellij.jpa.jpb.model.orm.model.OrmEntityAttribute;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.jpa.jpb.model.util.PsiUtilsKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.spring.data.jdbc.orm.SpringDataJdbcOrmFramework;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001e\u001a\u00020\u0013H\u0016J\b\u0010\u001f\u001a\u00020\u0013H\u0016J\u0013\u0010 \u001a\u00020\u00132\b\u0010!\u001a\u0004\u0018\u00010\"H\u0096\u0002J\b\u0010#\u001a\u00020$H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0014R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0014\u00a8\u0006%"}, d2={"Lcom/intellij/spring/data/jdbc/orm/model/SpringDataJdbcOrmEntityAttribute;", "Lcom/intellij/jpa/jpb/model/orm/model/OrmEntityAttribute;", "name", "", "typeFqn", "Lcom/intellij/jpa/jpb/model/core/util/Fqn;", "psiMember", "Lcom/intellij/psi/PsiMember;", "<init>", "(Ljava/lang/String;Lcom/intellij/jpa/jpb/model/core/util/Fqn;Lcom/intellij/psi/PsiMember;)V", "getName", "()Ljava/lang/String;", "getTypeFqn", "()Lcom/intellij/jpa/jpb/model/core/util/Fqn;", "ormFramework", "Lcom/intellij/jpa/jpb/model/orm/model/OrmFramework;", "getOrmFramework", "()Lcom/intellij/jpa/jpb/model/orm/model/OrmFramework;", "isId", "", "()Z", "associationCardinality", "Lcom/intellij/jpa/jpb/model/orm/model/OrmEntityAttribute$AssociationCardinality;", "getAssociationCardinality", "()Lcom/intellij/jpa/jpb/model/orm/model/OrmEntityAttribute$AssociationCardinality;", "psiMemberPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "getPsiMemberPointer", "()Lcom/intellij/psi/SmartPsiElementPointer;", "isAggregateReference", "isTransient", "isEmbedded", "equals", "other", "", "hashCode", "", "intellij.spring.data"})
public final class SpringDataJdbcOrmEntityAttribute
implements OrmEntityAttribute {
    @NotNull
    private final String name;
    @NotNull
    private final Fqn typeFqn;
    @NotNull
    private final OrmFramework ormFramework;
    private final boolean isId;
    @NotNull
    private final SmartPsiElementPointer<PsiMember> psiMemberPointer;

    public SpringDataJdbcOrmEntityAttribute(@NotNull String name, @NotNull Fqn typeFqn, @NotNull PsiMember psiMember) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)typeFqn, (String)"typeFqn");
        Intrinsics.checkNotNullParameter((Object)psiMember, (String)"psiMember");
        this.name = name;
        this.typeFqn = typeFqn;
        this.ormFramework = SpringDataJdbcOrmFramework.INSTANCE;
        this.isId = psiMember.hasAnnotation("org.springframework.data.annotation.Id");
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)((PsiElement)psiMember));
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
        this.psiMemberPointer = smartPsiElementPointer;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public Fqn getTypeFqn() {
        return this.typeFqn;
    }

    @NotNull
    public OrmFramework getOrmFramework() {
        return this.ormFramework;
    }

    public boolean isId() {
        return this.isId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public OrmEntityAttribute.AssociationCardinality getAssociationCardinality() {
        if (this.isAggregateReference()) {
            return OrmEntityAttribute.AssociationCardinality.MANY_TO_ONE;
        }
        PsiMember psiMember = (PsiMember)this.getPsiMemberPointer().getElement();
        if (psiMember == null) {
            return null;
        }
        PsiMember element = psiMember;
        if (!element.hasAnnotation("org.springframework.data.relational.core.mapping.MappedCollection")) {
            OrmSearcher ormSearcher = OrmSearcher.Companion.getForFramework((OrmFramework)SpringDataJdbcOrmFramework.INSTANCE);
            Fqn fqn = this.getTypeFqn().getInner();
            Project project = this.getPsiMemberPointer().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            if (ormSearcher.findEntityForFqn(fqn, project, null) == null) {
                return null;
            }
        }
        OrmEntityAttribute.AssociationCardinality associationCardinality = !((Collection)this.getTypeFqn().getGenerics()).isEmpty() ? OrmEntityAttribute.AssociationCardinality.ONE_TO_MANY : OrmEntityAttribute.AssociationCardinality.ONE_TO_ONE;
        return associationCardinality;
    }

    @NotNull
    public SmartPsiElementPointer<PsiMember> getPsiMemberPointer() {
        return this.psiMemberPointer;
    }

    public final boolean isAggregateReference() {
        return Intrinsics.areEqual((Object)this.getTypeFqn().getExternalFullName(), (Object)"org.springframework.data.jdbc.core.mapping.AggregateReference");
    }

    public boolean isTransient() {
        PsiMember psiMember = (PsiMember)this.getPsiMemberPointer().getElement();
        return psiMember != null ? psiMember.hasAnnotation("org.springframework.data.annotation.Transient") : false;
    }

    public boolean isEmbedded() {
        boolean bl;
        PsiMember psiMember = (PsiMember)this.getPsiMemberPointer().getElement();
        if (psiMember != null) {
            String[] stringArray = new String[]{"org.springframework.data.relational.core.mapping.Embedded", "org.springframework.data.relational.core.mapping.Embedded.Empty", "org.springframework.data.relational.core.mapping.Embedded.Nullable"};
            bl = PsiUtilsKt.hasOneOfAnnotations((PsiMember)psiMember, (String[])stringArray);
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.spring.data.jdbc.orm.model.SpringDataJdbcOrmEntityAttribute");
        SpringDataJdbcOrmEntityAttribute cfr_ignored_0 = (SpringDataJdbcOrmEntityAttribute)other;
        return Intrinsics.areEqual(this.getPsiMemberPointer(), ((SpringDataJdbcOrmEntityAttribute)other).getPsiMemberPointer());
    }

    public int hashCode() {
        return this.getPsiMemberPointer().hashCode();
    }
}

