/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.jpa.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.javaee.utils.persistence.data.inspections.PartTreeInconsistencyUtils;
import com.intellij.javaee.utils.persistence.data.inspections.TypeWrapper;
import com.intellij.javaee.utils.persistence.data.parser.PartTree;
import com.intellij.javaee.utils.persistence.data.parser.PartTreeParserContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.data.commons.SpringDataCommonsConstants;
import com.intellij.spring.data.commons.inspections.SpringDataTypeWrapper;
import com.intellij.spring.data.commons.projection.SpringDataProjectionUtil;
import com.intellij.spring.data.commons.util.SpringDataPartTreeParserContext;
import com.intellij.spring.data.jpa.SpringDataJpaUtil;
import com.intellij.spring.data.jpa.inspections.SpringDataRepositoriesInspection;
import com.intellij.spring.data.utils.SpringDataBundle;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UastContextKt;

public final class SpringDataRepositoryMethodReturnTypeInspection
extends SpringDataRepositoriesInspection {
    @Override
    protected void checkRepositoryMethod(@NotNull ProblemsHolder holder, @NotNull UClass repositoryClass, @NotNull UMethod uMethod, @NotNull Module module, @NotNull Pair<PsiClass, ? extends PsiType> typePair) {
        if (holder == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(0);
        }
        if (repositoryClass == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(1);
        }
        if (uMethod == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(2);
        }
        if (module == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(3);
        }
        if (typePair == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(4);
        }
        PsiMethod psiMethod = uMethod.getJavaPsi();
        PsiClass domainType = (PsiClass)typePair.first;
        if (domainType == null) {
            return;
        }
        PsiType returnType = psiMethod.getReturnType();
        if (returnType == null) {
            return;
        }
        PartTree.Subject subject = SpringDataRepositoryMethodReturnTypeInspection.getSubject(psiMethod, domainType);
        if (subject.isExistsProjection()) {
            if (!SpringDataRepositoryMethodReturnTypeInspection.isAssignableBooleanType(returnType, SpringDataRepositoryMethodReturnTypeInspection.isReactiveRepository(repositoryClass) || SpringDataRepositoryMethodReturnTypeInspection.isImperativeReactiveRepository(repositoryClass))) {
                SpringDataRepositoryMethodReturnTypeInspection.registerProblem(holder, uMethod, SpringDataBundle.message("incorrect.method.of.explicit.subject.return.type", PsiTypes.booleanType().getName()));
            }
        } else if (!SpringDataJpaUtil.hasQueryAnnotation(psiMethod) && !SpringDataRepositoryMethodReturnTypeInspection.isAssignableReturnType(domainType, repositoryClass.getJavaPsi(), psiMethod, subject)) {
            SpringDataRepositoryMethodReturnTypeInspection.registerProblem(holder, uMethod, SpringDataBundle.message("incorrect.method.return.type", domainType.getName()));
        }
        if (SpringDataRepositoryMethodReturnTypeInspection.isCoroutineRepository(repositoryClass)) {
            return;
        }
        SpringDataRepositoryMethodReturnTypeInspection.checkReactiveRepositoryTypes(holder, repositoryClass, uMethod);
    }

    private static void checkReactiveRepositoryTypes(@NotNull ProblemsHolder holder, @NotNull UClass repositoryClass, @NotNull UMethod uMethod) {
        PsiType returnType;
        if (holder == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(5);
        }
        if (repositoryClass == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(6);
        }
        if (uMethod == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(7);
        }
        if ((returnType = uMethod.getReturnType()) == null || SpringDataRepositoryMethodReturnTypeInspection.skipCheckOnClasses(returnType)) {
            return;
        }
        if (SpringDataRepositoryMethodReturnTypeInspection.isReactiveRepository(repositoryClass)) {
            TypeWrapper reactiveTypeWrapper = SpringDataRepositoryMethodReturnTypeInspection.getReactiveTypeWrapper(repositoryClass);
            if (reactiveTypeWrapper == null) {
                SpringDataRepositoryMethodReturnTypeInspection.registerProblem(holder, uMethod, SpringDataBundle.message("incorrect.method.return.type.unknown.reactive.type.expected", new Object[0]));
            } else if (returnType instanceof PsiClassType) {
                if (!SpringDataRepositoryMethodReturnTypeInspection.isSupportedType(reactiveTypeWrapper, ((PsiClassType)returnType).resolve())) {
                    SpringDataRepositoryMethodReturnTypeInspection.registerProblem(holder, uMethod, SpringDataBundle.message("incorrect.method.return.type.reactive.type.expected", StringUtil.join((String[])reactiveTypeWrapper.getAllSupportedTypes(), (String)",")));
                }
            } else if (returnType instanceof PsiPrimitiveType) {
                SpringDataRepositoryMethodReturnTypeInspection.registerProblem(holder, uMethod, SpringDataBundle.message("incorrect.method.return.type.reactive.type.expected", StringUtil.join((String[])reactiveTypeWrapper.getAllSupportedTypes(), (String)",")));
            }
        } else if (returnType instanceof PsiClassType && SpringDataRepositoryMethodReturnTypeInspection.isReactiveType(((PsiClassType)returnType).resolve()) && !SpringDataRepositoryMethodReturnTypeInspection.isImperativeReactiveRepository(repositoryClass)) {
            SpringDataRepositoryMethodReturnTypeInspection.registerProblem(holder, uMethod, SpringDataBundle.message("incorrect.method.return.type.non.reactive.type.expected", new Object[0]));
        }
    }

    private static boolean isSupportedType(@NotNull TypeWrapper reactiveTypeWrapper, @Nullable PsiClass resolve) {
        if (reactiveTypeWrapper == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(8);
        }
        if (resolve == null) {
            return false;
        }
        for (String supportedType : reactiveTypeWrapper.simpleTypes) {
            if (!InheritanceUtil.isInheritor((PsiClass)resolve, (String)supportedType)) continue;
            return true;
        }
        for (String supportedType : reactiveTypeWrapper.collectionTypes) {
            if (!InheritanceUtil.isInheritor((PsiClass)resolve, (String)supportedType)) continue;
            return true;
        }
        return false;
    }

    private static boolean skipCheckOnClasses(PsiType type) {
        PsiClass resolve;
        if (type instanceof PsiClassType && (resolve = ((PsiClassType)type).resolve()) != null) {
            String[] skipOnClasses;
            for (String aClass : skipOnClasses = new String[]{"java.util.Optional", "java.util.stream.Stream", "com.google.common.base.Optional", "com.google.common.util.concurrent.ListenableFuture", "java.util.concurrent.Future", "java.util.concurrent.CompletableFuture", "org.springframework.util.concurrent.ListenableFuture", "org.springframework.data.geo.GeoResult", "org.springframework.data.geo.GeoResults", "org.springframework.data.domain.SearchResults", "org.springframework.data.domain.SearchResult"}) {
                if (!InheritanceUtil.isInheritor((PsiClass)resolve, (String)aClass)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isReactiveType(@Nullable PsiClass psiClass) {
        if (psiClass == null) {
            return false;
        }
        for (TypeWrapper typeWrapper : SpringDataTypeWrapper.REACTIVE_ALL) {
            if (!SpringDataRepositoryMethodReturnTypeInspection.isInheritor(psiClass, typeWrapper.simpleTypes) && !SpringDataRepositoryMethodReturnTypeInspection.isInheritor(psiClass, typeWrapper.collectionTypes)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInheritor(@NotNull PsiClass psiClass, String ... simpleTypes) {
        if (psiClass == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(9);
        }
        for (String s : simpleTypes) {
            if (!StringUtil.isNotEmpty((String)s) || !InheritanceUtil.isInheritor((PsiClass)psiClass, (String)s)) continue;
            return true;
        }
        return false;
    }

    private static TypeWrapper getReactiveTypeWrapper(@NotNull UClass repositoryClass) {
        if (repositoryClass == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(10);
        }
        for (TypeWrapper typeWrapper : SpringDataTypeWrapper.REACTIVE_ALL) {
            if (!InheritanceUtil.isInheritor((PsiClass)repositoryClass.getJavaPsi(), (String)typeWrapper.repositoryClass)) continue;
            return typeWrapper;
        }
        return null;
    }

    private static boolean isAssignableBooleanType(@NotNull PsiType returnType, boolean isReactiveRepository) {
        if (returnType == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(11);
        }
        if (returnType.isAssignableFrom((PsiType)PsiTypes.booleanType())) {
            return true;
        }
        if (isReactiveRepository) {
            PsiType psiType = PartTreeInconsistencyUtils.getSubstitutedTypeParameters((PsiType)returnType, (String[])new String[]{"reactor.core.publisher.Mono", "rx.Single", "rx.Observable", "io.smallrye.mutiny.Uni"});
            return psiType != null && psiType.isAssignableFrom((PsiType)PsiTypes.booleanType());
        }
        return false;
    }

    @NotNull
    private static PartTree.Subject getSubject(@NotNull PsiMethod psiMethod, PsiClass domainType) {
        if (psiMethod == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(12);
        }
        String name = psiMethod.getName();
        PartTree partTree = new PartTree(name, domainType, (PartTreeParserContext)SpringDataPartTreeParserContext.create());
        PartTree.Subject subject = partTree.getSubject();
        if (subject == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(13);
        }
        return subject;
    }

    private static void registerProblem(@NotNull ProblemsHolder holder, @NotNull UMethod psiMethod, @InspectionMessage String message) {
        UTypeReferenceExpression returnTypeRef;
        if (holder == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(14);
        }
        if (psiMethod == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(15);
        }
        if ((returnTypeRef = SpringDataRepositoryMethodReturnTypeInspection.getReturnTypeRef(psiMethod)) == null) {
            return;
        }
        PsiElement identifier = returnTypeRef.getSourcePsi();
        if (identifier == null) {
            return;
        }
        TextRange textRange = identifier.getTextRange();
        if (textRange == null || textRange.isEmpty()) {
            return;
        }
        holder.registerProblem(identifier, message, new LocalQuickFix[0]);
    }

    private static UTypeReferenceExpression getReturnTypeRef(@NotNull UMethod psiMethod) {
        PsiElement sourcePsi;
        if (psiMethod == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(16);
        }
        if ((sourcePsi = psiMethod.getSourcePsi()) == null) {
            return null;
        }
        for (PsiElement child : sourcePsi.getChildren()) {
            UTypeReferenceExpression expression = (UTypeReferenceExpression)UastContextKt.toUElement((PsiElement)child, UTypeReferenceExpression.class);
            if (expression == null) continue;
            return expression;
        }
        return null;
    }

    public static boolean isAssignableReturnType(@NotNull PsiClass domainClass, @NotNull PsiClass repositoryClass, @NotNull PsiMethod psiMethod, PartTree.Subject subject) {
        PsiType returnType;
        if (domainClass == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(17);
        }
        if (repositoryClass == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(18);
        }
        if (psiMethod == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(19);
        }
        if ((returnType = psiMethod.getReturnType()) == null) {
            return false;
        }
        if ((subject.isDelete().booleanValue() || subject.isUpdate().booleanValue() || subject.isCountProjection()) && returnType.isAssignableFrom((PsiType)PsiTypes.longType())) {
            return true;
        }
        if (returnType instanceof PsiPrimitiveType || PsiPrimitiveType.getUnboxedType((PsiType)returnType) != null) {
            return true;
        }
        PsiClassType type = PsiTypesUtil.getClassType((PsiClass)domainClass);
        if (SpringDataRepositoryMethodReturnTypeInspection.isAssignableTypeOrProjectionType(type, returnType, repositoryClass)) {
            return true;
        }
        PsiType genericType = Stream.of(() -> SpringDataRepositoryMethodReturnTypeInspection.substituteResultsTypeParameter(returnType, "org.springframework.data.domain.SearchResults"), () -> SpringDataRepositoryMethodReturnTypeInspection.substituteResultsTypeParameter(returnType, "org.springframework.data.geo.GeoResults"), () -> PsiUtil.extractIterableTypeParameter((PsiType)returnType, (boolean)false), () -> SpringDataRepositoryMethodReturnTypeInspection.getSubstitutedTypeParameters(returnType)).map(Supplier::get).filter(Objects::nonNull).findFirst().orElse(null);
        if (genericType != null) {
            if (SpringDataRepositoryMethodReturnTypeInspection.isAssignableTypeOrProjectionType(type, genericType, repositoryClass)) {
                return true;
            }
            PsiType iterableTypeParameter = PsiUtil.extractIterableTypeParameter((PsiType)genericType, (boolean)false);
            if (iterableTypeParameter != null && SpringDataRepositoryMethodReturnTypeInspection.isAssignableTypeOrProjectionType(type, iterableTypeParameter, repositoryClass)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isAssignableTypeOrProjectionType(@NotNull PsiClassType domainType, @NotNull PsiType methodReturnType, @NotNull PsiClass repositoryClass) {
        if (domainType == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(20);
        }
        if (methodReturnType == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(21);
        }
        if (repositoryClass == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(22);
        }
        if (methodReturnType.isAssignableFrom((PsiType)domainType)) {
            return true;
        }
        if (methodReturnType instanceof PsiClassType) {
            PsiClass projectionClass = ((PsiClassType)methodReturnType).resolve();
            PsiClass domainClass = domainType.resolve();
            if (projectionClass != null && domainClass != null) {
                if (projectionClass instanceof PsiTypeParameter) {
                    return true;
                }
                if (InheritanceUtil.isInheritor((PsiClass)projectionClass, (String)"java.lang.Iterable")) {
                    return false;
                }
                if (SpringDataProjectionUtil.isExplicitProjectionType(projectionClass, domainClass, repositoryClass)) {
                    return true;
                }
                if (SpringDataProjectionUtil.hasProjectionMethods(projectionClass, domainClass)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static PsiType substituteResultsTypeParameter(PsiType returnType, @NonNls String resultType) {
        return PartTreeInconsistencyUtils.getSubstitutedTypeParameters((PsiType)returnType, (String[])new String[]{resultType});
    }

    @Nullable
    public static PsiType getSubstitutedTypeParameters(@Nullable PsiType returnType) {
        return PartTreeInconsistencyUtils.getSubstitutedTypeParameters((PsiType)returnType, (String[])SpringDataCommonsConstants.SUBSTITUTED_PARAM_TYPES);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryClass";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uMethod";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typePair";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reactiveTypeWrapper";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 12: 
            case 15: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/data/jpa/inspections/SpringDataRepositoryMethodReturnTypeInspection";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainClass";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReturnType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/data/jpa/inspections/SpringDataRepositoryMethodReturnTypeInspection";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkRepositoryMethod";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkReactiveRepositoryTypes";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isInheritor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getReactiveTypeWrapper";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableBooleanType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSubject";
                break;
            }
            case 13: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeRef";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableReturnType";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableTypeOrProjectionType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13 -> new IllegalStateException(string);
        };
    }
}

