/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.admin.jmx;

import com.intellij.javaee.appServers.deployment.DeploymentModel;
import com.intellij.javaee.appServers.deployment.DeploymentStatus;
import com.intellij.javaee.oss.admin.JavaeeAdminDeployCallback;
import com.intellij.javaee.oss.admin.JavaeeAdminServerBase;
import com.intellij.javaee.oss.admin.JavaeeAdminStartCallback;
import com.intellij.javaee.oss.admin.jmx.JmxAdminException;
import com.intellij.javaee.oss.util.AbstractConnectorCommand;
import com.intellij.javaee.util.DeployStateChecker;
import com.intellij.javaee.util.IDeployStateChecker;
import com.intellij.javaee.util.ILogger;
import com.intellij.javaee.util.ServerInstancePoller;
import java.io.File;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class JavaeeJmxAdminServerBase
extends JavaeeAdminServerBase {
    private final ServerInstancePoller myPoller = new ServerInstancePoller();
    private ILogger myLogger;

    protected boolean isUseJmx() {
        return true;
    }

    @Override
    public void start(String host, int port, String username, String password, JavaeeAdminStartCallback callback) throws Exception {
        super.start(host, port, username, password, callback);
        this.myLogger = callback.getLogger();
        if (this.isUseJmx()) {
            this.myPoller.onInstanceStart();
        }
    }

    protected ILogger getLogger() {
        return this.myLogger;
    }

    @Override
    public void shutdown() {
        if (this.isUseJmx()) {
            this.myPoller.onInstanceShutdown();
        }
    }

    @Override
    public boolean doConnect() {
        return Boolean.TRUE.equals(new JmxOperation(){

            @Override
            protected Boolean doPerform() throws JmxAdminException {
                return JavaeeJmxAdminServerBase.this.createConnectCommand().adminExecute();
            }

            @Override
            protected void onError(JmxAdminException e) {
                JavaeeJmxAdminServerBase.this.myLogger.debugEx((Exception)e);
            }
        }.perform());
    }

    @Override
    public void doDisconnect() {
    }

    @Override
    public void startDeploy(DeploymentModel deployment, File source, JavaeeAdminDeployCallback callback) {
        DeploymentContextImpl deployContext = new DeploymentContextImpl(deployment, source, callback);
        if (this.isUndeploySyncNeeded()) {
            this.doStartDeployWithUndeploy(deployContext);
        } else {
            this.doStartDeploy(deployContext);
        }
    }

    protected void doStartDeployWithUndeploy(final DeploymentContextImpl context) {
        final DeploymentContextImpl undeployContext = new DeploymentContextImpl(context.getDeploymentModel(), context.getSource(), null){

            @Override
            public void setDeploymentStatus(DeploymentStatus deploymentStatus) {
                if (deploymentStatus == DeploymentStatus.FAILED) {
                    super.setDeploymentStatus(deploymentStatus);
                } else {
                    JavaeeJmxAdminServerBase.this.doStartDeploy(context);
                }
            }
        };
        new DeploymentModelOperation(undeployContext){

            @Override
            protected Boolean doPerform() throws JmxAdminException {
                if (JavaeeJmxAdminServerBase.this.doGetDeploymentStatus(undeployContext) == DeploymentStatus.NOT_DEPLOYED) {
                    this.doSetDeploymentStatus(DeploymentStatus.NOT_DEPLOYED);
                } else {
                    JavaeeJmxAdminServerBase.this.doStartUndeploy(undeployContext);
                }
                return null;
            }
        }.perform();
    }

    protected void doStartDeploy(final DeploymentContextImpl context) {
        new DeploymentModelOperation(context){

            @Override
            protected boolean isFailOnError() {
                return true;
            }

            @Override
            protected Boolean doPerform() throws JmxAdminException {
                if (!JavaeeJmxAdminServerBase.this.doDeploy(context)) {
                    this.doSetDeploymentStatus(DeploymentStatus.FAILED);
                    return null;
                }
                JavaeeJmxAdminServerBase.this.myPoller.putDeployStateChecker((IDeployStateChecker)new DeploymentModelOperation.DeployStateCheckerBase(){

                    @Override
                    protected DeploymentStatus doCheck(DeploymentStatus status) {
                        return status == DeploymentStatus.DEPLOYED || status == DeploymentStatus.FAILED ? status : null;
                    }
                });
                return null;
            }
        }.perform();
    }

    @Override
    public void startUndeploy(DeploymentModel deployment, File source, JavaeeAdminDeployCallback callback) {
        DeploymentContextImpl context = new DeploymentContextImpl(deployment, source, callback);
        context.setDeploymentStatus(DeploymentStatus.DEACTIVATING);
        this.doStartUndeploy(context);
    }

    private void doStartUndeploy(final DeploymentContextImpl context) {
        new DeploymentModelOperation(context){

            @Override
            protected Boolean doPerform() throws JmxAdminException {
                JavaeeJmxAdminServerBase.this.myPoller.removeDeployStateChecker((Object)context.getDeploymentModel());
                if (!JavaeeJmxAdminServerBase.this.doUndeploy(context)) {
                    this.doSetDeploymentStatus(DeploymentStatus.UNKNOWN);
                    return null;
                }
                if (JavaeeJmxAdminServerBase.this.isUndeploySyncNeeded()) {
                    JavaeeJmxAdminServerBase.this.myPoller.putDeployStateChecker((IDeployStateChecker)new DeploymentModelOperation.DeployStateCheckerBase(){

                        @Override
                        protected DeploymentStatus doCheck(DeploymentStatus status) {
                            return status == DeploymentStatus.DEPLOYED ? null : 5.checkStatus(status);
                        }
                    });
                } else {
                    this.doSetDeploymentStatus(5.checkStatus(JavaeeJmxAdminServerBase.this.doGetDeploymentStatus(context)));
                }
                return null;
            }

            private static DeploymentStatus checkStatus(DeploymentStatus status) {
                return status == DeploymentStatus.NOT_DEPLOYED ? DeploymentStatus.NOT_DEPLOYED : DeploymentStatus.UNKNOWN;
            }
        }.perform();
    }

    @Override
    public void startUpdateDeploymentStatus(DeploymentModel deployment, File source, JavaeeAdminDeployCallback callback) {
        final DeploymentContextImpl context = new DeploymentContextImpl(deployment, source, callback);
        new DeploymentModelOperation(context){

            @Override
            protected Boolean doPerform() throws JmxAdminException {
                DeploymentStatus status = JavaeeJmxAdminServerBase.this.doGetDeploymentStatus(context);
                this.doSetDeploymentStatus(status == DeploymentStatus.DEPLOYED ? DeploymentStatus.DEPLOYED : DeploymentStatus.NOT_DEPLOYED);
                return null;
            }
        }.perform();
    }

    protected abstract JmxAdminCommandBase<Boolean> createConnectCommand();

    protected abstract boolean isUndeploySyncNeeded();

    protected abstract boolean doDeploy(DeploymentContext var1) throws JmxAdminException;

    protected abstract boolean doUndeploy(DeploymentContext var1) throws JmxAdminException;

    protected abstract DeploymentStatus doGetDeploymentStatus(DeploymentContext var1) throws JmxAdminException;

    protected static class DeploymentContextImpl
    implements DeploymentContext {
        private final DeploymentModel myDeploymentModel;
        private final File mySource;
        private final JavaeeAdminDeployCallback myCallback;

        public DeploymentContextImpl(DeploymentModel deploymentModel, File source, JavaeeAdminDeployCallback callback) {
            this.myDeploymentModel = deploymentModel;
            this.mySource = source;
            this.myCallback = callback;
        }

        public void setDeploymentStatus(DeploymentStatus deploymentStatus) {
            this.myCallback.setDeploymentStatus(this.myDeploymentModel, deploymentStatus);
        }

        public void setDeploymentStatus(DeploymentStatus deploymentStatus, JmxAdminException e) {
            this.myCallback.setDeploymentStatus(this.myDeploymentModel, deploymentStatus, e);
        }

        @Override
        public DeploymentModel getDeploymentModel() {
            return this.myDeploymentModel;
        }

        @Override
        public File getSource() {
            return this.mySource;
        }
    }

    protected abstract class JmxAdminCommandBase<T>
    extends AbstractConnectorCommand<T> {
        protected JmxAdminCommandBase() {
        }

        @Override
        protected String getHost() {
            return JavaeeJmxAdminServerBase.this.getHost();
        }

        @Override
        protected int getJmxPort() {
            return JavaeeJmxAdminServerBase.this.getPort();
        }

        @Nullable
        public final T adminExecute() throws JmxAdminException {
            try {
                return this.execute();
            }
            catch (ExecutionException | TimeoutException e) {
                throw new JmxAdminException(e);
            }
        }

        @Override
        protected ILogger getLogger() {
            return JavaeeJmxAdminServerBase.this.myLogger;
        }
    }

    protected abstract class DeploymentModelOperation
    extends JmxOperation {
        private final DeploymentContextImpl myDeploymentContext;

        public DeploymentModelOperation(DeploymentContextImpl deploymentContext) {
            this.myDeploymentContext = deploymentContext;
        }

        protected final DeploymentModel getDeploymentModel() {
            return this.myDeploymentContext.getDeploymentModel();
        }

        protected void doSetDeploymentStatus(DeploymentStatus deploymentStatus) {
            this.myDeploymentContext.setDeploymentStatus(deploymentStatus);
        }

        @Override
        protected void onError(JmxAdminException e) {
            this.myDeploymentContext.setDeploymentStatus(this.isFailOnError() ? DeploymentStatus.FAILED : DeploymentStatus.UNKNOWN, e);
        }

        protected boolean isFailOnError() {
            return false;
        }

        protected abstract class DeployStateCheckerBase
        implements DeployStateChecker {
            protected DeployStateCheckerBase() {
            }

            public DeploymentModel getDeploymentModel() {
                return DeploymentModelOperation.this.myDeploymentContext.getDeploymentModel();
            }

            public boolean check() {
                try {
                    DeploymentStatus statusGet = JavaeeJmxAdminServerBase.this.doGetDeploymentStatus(DeploymentModelOperation.this.myDeploymentContext);
                    DeploymentStatus statusSet = this.doCheck(statusGet);
                    if (statusSet != null) {
                        DeploymentModelOperation.this.doSetDeploymentStatus(statusSet);
                        return true;
                    }
                    return false;
                }
                catch (JmxAdminException ex) {
                    DeploymentModelOperation.this.onError(ex);
                    return true;
                }
            }

            @Nullable
            protected abstract DeploymentStatus doCheck(DeploymentStatus var1);
        }
    }

    @ApiStatus.Internal
    public static abstract class JmxOperation {
        @Nullable
        public Boolean perform() {
            try {
                return this.doPerform();
            }
            catch (JmxAdminException e) {
                this.onError(e);
                return false;
            }
        }

        @Nullable
        protected abstract Boolean doPerform() throws JmxAdminException;

        protected abstract void onError(JmxAdminException var1);
    }

    protected static interface DeploymentContext {
        public DeploymentModel getDeploymentModel();

        public File getSource();
    }
}

