/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor;

import com.intellij.microservices.url.UrlConstants;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 \u00132\u00020\u0001:\u0003\u0011\u0012\u0013B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u0082\u0001\u0002\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ktor/RequestMethod;", "", "method", "", "<init>", "(Ljava/lang/String;)V", "getMethod", "()Ljava/lang/String;", "schemes", "", "getSchemes", "()Ljava/util/List;", "equals", "", "other", "hashCode", "", "HttpRequestMethod", "Websocket", "Companion", "Lcom/intellij/ktor/RequestMethod$HttpRequestMethod;", "Lcom/intellij/ktor/RequestMethod$Websocket;", "intellij.ktor"})
public abstract class RequestMethod {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String method;

    private RequestMethod(String method) {
        this.method = method;
    }

    @NotNull
    public final String getMethod() {
        return this.method;
    }

    @NotNull
    public abstract List<String> getSchemes();

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RequestMethod)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.method, (Object)((RequestMethod)other).method)) {
            return false;
        }
        return Intrinsics.areEqual(this.getSchemes(), ((RequestMethod)other).getSchemes());
    }

    public int hashCode() {
        int result = this.method.hashCode();
        result = 31 * result + ((Object)this.getSchemes()).hashCode();
        return result;
    }

    public /* synthetic */ RequestMethod(String method, DefaultConstructorMarker $constructor_marker) {
        this(method);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ktor/RequestMethod$Companion;", "", "<init>", "()V", "of", "Lcom/intellij/ktor/RequestMethod;", "methodName", "", "intellij.ktor"})
    @SourceDebugExtension(value={"SMAP\nKtorUrlTargetInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtorUrlTargetInfo.kt\ncom/intellij/ktor/RequestMethod$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n295#2,2:124\n*S KotlinDebug\n*F\n+ 1 KtorUrlTargetInfo.kt\ncom/intellij/ktor/RequestMethod$Companion\n*L\n96#1:124,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final RequestMethod of(@Nullable String methodName) {
            Object v3;
            block5: {
                String upperMethodName;
                String string = methodName;
                if (string != null) {
                    String string2 = string.toUpperCase(Locale.ROOT);
                    v2 = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                } else {
                    v2 = upperMethodName = null;
                }
                if (Intrinsics.areEqual((Object)Websocket.INSTANCE.getMethod(), (Object)upperMethodName)) {
                    return Websocket.INSTANCE;
                }
                Iterable $this$firstOrNull$iv = (Iterable)HttpRequestMethod.HttpMethod.getEntries();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    HttpRequestMethod.HttpMethod it = (HttpRequestMethod.HttpMethod)((Object)element$iv);
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.name(), (Object)upperMethodName)) continue;
                    v3 = element$iv;
                    break block5;
                }
                v3 = null;
            }
            HttpRequestMethod.HttpMethod httpMethod = v3;
            if (httpMethod == null) {
                return null;
            }
            HttpRequestMethod.HttpMethod httpMethod2 = httpMethod;
            return new HttpRequestMethod(httpMethod2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u000bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lcom/intellij/ktor/RequestMethod$HttpRequestMethod;", "Lcom/intellij/ktor/RequestMethod;", "httpMethod", "Lcom/intellij/ktor/RequestMethod$HttpRequestMethod$HttpMethod;", "<init>", "(Lcom/intellij/ktor/RequestMethod$HttpRequestMethod$HttpMethod;)V", "schemes", "", "", "getSchemes", "()Ljava/util/List;", "HttpMethod", "intellij.ktor"})
    public static final class HttpRequestMethod
    extends RequestMethod {
        @NotNull
        private final List<String> schemes;

        public HttpRequestMethod(@NotNull HttpMethod httpMethod) {
            Intrinsics.checkNotNullParameter((Object)((Object)httpMethod), (String)"httpMethod");
            super(httpMethod.getValue(), null);
            this.schemes = UrlConstants.HTTP_SCHEMES;
        }

        @Override
        @NotNull
        public List<String> getSchemes() {
            return this.schemes;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ktor/RequestMethod$HttpRequestMethod$HttpMethod;", "", "value", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "GET", "HANDLE", "SSE", "POST", "PUT", "HEAD", "PATCH", "DELETE", "OPTIONS", "intellij.ktor"})
        public static final class HttpMethod
        extends Enum<HttpMethod> {
            @NotNull
            private final String value;
            public static final /* enum */ HttpMethod GET = new HttpMethod("GET");
            public static final /* enum */ HttpMethod HANDLE = new HttpMethod("GET");
            public static final /* enum */ HttpMethod SSE = new HttpMethod("GET");
            public static final /* enum */ HttpMethod POST = new HttpMethod("POST");
            public static final /* enum */ HttpMethod PUT = new HttpMethod("PUT");
            public static final /* enum */ HttpMethod HEAD = new HttpMethod("HEAD");
            public static final /* enum */ HttpMethod PATCH = new HttpMethod("PATCH");
            public static final /* enum */ HttpMethod DELETE = new HttpMethod("DELETE");
            public static final /* enum */ HttpMethod OPTIONS = new HttpMethod("OPTIONS");
            private static final /* synthetic */ HttpMethod[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private HttpMethod(String value) {
                this.value = value;
            }

            @NotNull
            public final String getValue() {
                return this.value;
            }

            public static HttpMethod[] values() {
                return (HttpMethod[])$VALUES.clone();
            }

            public static HttpMethod valueOf(String value) {
                return Enum.valueOf(HttpMethod.class, value);
            }

            @NotNull
            public static EnumEntries<HttpMethod> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.HANDLE, HttpMethod.SSE, HttpMethod.POST, HttpMethod.PUT, HttpMethod.HEAD, HttpMethod.PATCH, HttpMethod.DELETE, HttpMethod.OPTIONS};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0006H\u00d6\u0001R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ktor/RequestMethod$Websocket;", "Lcom/intellij/ktor/RequestMethod;", "<init>", "()V", "schemes", "", "", "getSchemes", "()Ljava/util/List;", "equals", "", "other", "", "hashCode", "", "toString", "intellij.ktor"})
    public static final class Websocket
    extends RequestMethod {
        @NotNull
        public static final Websocket INSTANCE = new Websocket();
        @NotNull
        private static final List<String> schemes = UrlConstants.WS_SCHEMES;

        private Websocket() {
            super("WEBSOCKET", null);
        }

        @Override
        @NotNull
        public List<String> getSchemes() {
            return schemes;
        }

        @NotNull
        public String toString() {
            return "Websocket";
        }

        @Override
        public int hashCode() {
            return -183142799;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Websocket)) {
                return false;
            }
            Websocket cfr_ignored_0 = (Websocket)other;
            return true;
        }
    }
}

