/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.initializr.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.newui.PluginLogo;
import com.intellij.ktor.initializr.json.KtorPluginSearchResult;
import com.intellij.ktor.initializr.plugins.KtorPluginsGroup;
import com.intellij.ktor.initializr.plugins.KtorPluginsGroupComponent;
import com.intellij.ktor.initializr.plugins.KtorPluginsGroupComponentWithProgress;
import com.intellij.ktor.initializr.plugins.KtorSearchUpDownPopupController;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0010\b \u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0006\u0010 \u001a\u00020\u001fJ\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0014H\u0002J\u0006\u0010$\u001a\u00020\"J\u0010\u0010)\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0014H\u0002J\u0018\u0010)\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u000fH$J\b\u0010+\u001a\u00020\"H\u0002J\u0010\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u0017H\u0002J\u0006\u0010.\u001a\u00020\"J\b\u00100\u001a\u00020\"H\u0002J\b\u00101\u001a\u00020\"H\u0002R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010#\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u00148F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0014\u0010/\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0019\u00a8\u00062"}, d2={"Lcom/intellij/ktor/initializr/plugins/KtorSearchResultPanel;", "", "controller", "Lcom/intellij/ktor/initializr/plugins/KtorSearchUpDownPopupController;", "panel", "Lcom/intellij/ktor/initializr/plugins/KtorPluginsGroupComponent;", "<init>", "(Lcom/intellij/ktor/initializr/plugins/KtorSearchUpDownPopupController;Lcom/intellij/ktor/initializr/plugins/KtorPluginsGroupComponent;)V", "getController", "()Lcom/intellij/ktor/initializr/plugins/KtorSearchUpDownPopupController;", "getPanel", "()Lcom/intellij/ktor/initializr/plugins/KtorPluginsGroupComponent;", "myVerticalScrollBar", "Ljavax/swing/JScrollBar;", "value", "Lcom/intellij/ktor/initializr/plugins/KtorPluginsGroup;", "group", "getGroup", "()Lcom/intellij/ktor/initializr/plugins/KtorPluginsGroup;", "myQuery", "", "myRunQuery", "Ljava/util/concurrent/atomic/AtomicBoolean;", "", "isEmpty", "()Z", "myPostFillGroupCallback", "Ljava/lang/Runnable;", "currentPluginIds", "", "createScrollPane", "Ljavax/swing/JComponent;", "createVScrollPane", "setEmptyText", "", "query", "setEmpty", "getQuery", "()Ljava/lang/String;", "setQuery", "(Ljava/lang/String;)V", "handleQuery", "result", "runPostFillGroupCallback", "loading", "start", "dispose", "isProgressMode", "removeGroup", "fullRepaint", "intellij.ktor"})
@SourceDebugExtension(value={"SMAP\nKtorSearchResultPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtorSearchResultPanel.kt\ncom/intellij/ktor/initializr/plugins/KtorSearchResultPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,181:1\n1#2:182\n1563#3:183\n1634#3,3:184\n1563#3:187\n1634#3,3:188\n*S KotlinDebug\n*F\n+ 1 KtorSearchResultPanel.kt\ncom/intellij/ktor/initializr/plugins/KtorSearchResultPanel\n*L\n115#1:183\n115#1:184,3\n86#1:187\n86#1:188,3\n*E\n"})
public abstract class KtorSearchResultPanel {
    @Nullable
    private final KtorSearchUpDownPopupController controller;
    @NotNull
    private final KtorPluginsGroupComponent panel;
    @Nullable
    private JScrollBar myVerticalScrollBar;
    @NotNull
    private KtorPluginsGroup group;
    @Nullable
    private String myQuery;
    @Nullable
    private AtomicBoolean myRunQuery;
    private boolean isEmpty;
    @Nullable
    private Runnable myPostFillGroupCallback;
    @NotNull
    private List<String> currentPluginIds;

    public KtorSearchResultPanel(@Nullable KtorSearchUpDownPopupController controller, @NotNull KtorPluginsGroupComponent panel) {
        Intrinsics.checkNotNullParameter((Object)((Object)panel), (String)"panel");
        this.controller = controller;
        this.panel = panel;
        String string = IdeBundle.message((String)"title.search.results", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.group = new KtorPluginsGroup(string, null, 2, null);
        this.isEmpty = true;
        this.currentPluginIds = CollectionsKt.emptyList();
        this.setEmptyText("");
        if (this.isProgressMode()) {
            this.loading(false);
        }
    }

    @Nullable
    public final KtorSearchUpDownPopupController getController() {
        return this.controller;
    }

    @NotNull
    public final KtorPluginsGroupComponent getPanel() {
        return this.panel;
    }

    @NotNull
    public final KtorPluginsGroup getGroup() {
        return this.group;
    }

    public final boolean isEmpty() {
        return this.isEmpty;
    }

    private final JComponent createScrollPane() {
        JBScrollPane pane = new JBScrollPane((Component)((Object)this.panel));
        pane.setBorder((Border)JBUI.Borders.empty());
        if (this.isProgressMode()) {
            this.myVerticalScrollBar = pane.getVerticalScrollBar();
        }
        return (JComponent)pane;
    }

    @NotNull
    public final JComponent createVScrollPane() {
        JComponent jComponent = this.createScrollPane();
        Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.ui.components.JBScrollPane");
        JBScrollPane pane = (JBScrollPane)jComponent;
        pane.setVerticalScrollBarPolicy(20);
        pane.setHorizontalScrollBarPolicy(31);
        return (JComponent)pane;
    }

    private final void setEmptyText(String query) {
        this.panel.getEmptyText().setText(IdeBundle.message((String)"empty.text.nothing.found", (Object[])new Object[0]));
    }

    public final void setEmpty() {
        this.isEmpty = true;
        this.myQuery = "";
    }

    @NotNull
    public final String getQuery() {
        String string = StringUtil.defaultIfEmpty((String)this.myQuery, (String)"");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"defaultIfEmpty(...)");
        return string;
    }

    public final void setQuery(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        boolean bl = SwingUtilities.isEventDispatchThread();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.setEmptyText(query);
        if (Intrinsics.areEqual((Object)query, (Object)this.myQuery)) {
            this.isEmpty = ((CharSequence)query).length() == 0;
            return;
        }
        if (this.myRunQuery != null) {
            AtomicBoolean atomicBoolean = this.myRunQuery;
            Intrinsics.checkNotNull((Object)atomicBoolean);
            atomicBoolean.set(false);
            this.myRunQuery = null;
            this.loading(false);
        }
        this.myQuery = query;
        boolean it = bl = ((CharSequence)query).length() == 0;
        boolean bl2 = false;
        this.isEmpty = it;
        if (!bl) {
            this.handleQuery(query);
        } else {
            this.removeGroup();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleQuery(String query) {
        if (this.isProgressMode()) {
            this.loading(true);
            AtomicBoolean atomicBoolean = this.myRunQuery = new AtomicBoolean(true);
            Intrinsics.checkNotNull((Object)atomicBoolean);
            AtomicBoolean runQuery = atomicBoolean;
            String string = IdeBundle.message((String)"title.search.results", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            KtorPluginsGroup group = new KtorPluginsGroup(string, null, 2, null);
            Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> KtorSearchResultPanel.handleQuery$lambda$4(this, query, group, runQuery));
            Intrinsics.checkNotNull((Object)future);
        } else {
            boolean somethingChanged;
            void $this$mapTo$iv$iv;
            this.handleQuery(query, this.group);
            Iterable $this$map$iv = this.group.getElements();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KtorPluginSearchResult ktorPluginSearchResult = (KtorPluginSearchResult)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getId());
            }
            List newPluginIds = (List)destination$iv$iv;
            boolean bl = somethingChanged = !Intrinsics.areEqual(this.currentPluginIds, (Object)newPluginIds);
            if (somethingChanged) {
                this.removeGroup();
                this.group = this.group;
                if (!((Collection)this.group.getElements()).isEmpty()) {
                    KtorPluginsGroupComponent.addGroup$default(this.panel, this.group, 0, 2, null);
                    this.group.titleWithCount();
                    this.panel.initialSelection(false);
                    this.currentPluginIds = newPluginIds;
                }
                this.runPostFillGroupCallback();
                this.fullRepaint();
            }
        }
    }

    protected abstract void handleQuery(@NotNull String var1, @NotNull KtorPluginsGroup var2);

    private final void runPostFillGroupCallback() {
        if (this.myPostFillGroupCallback != null) {
            Runnable runnable = this.myPostFillGroupCallback;
            Intrinsics.checkNotNull((Object)runnable);
            runnable.run();
            this.myPostFillGroupCallback = null;
        }
    }

    private final void loading(boolean start) {
        KtorPluginsGroupComponent ktorPluginsGroupComponent = this.panel;
        Intrinsics.checkNotNull((Object)((Object)ktorPluginsGroupComponent), (String)"null cannot be cast to non-null type com.intellij.ktor.initializr.plugins.KtorPluginsGroupComponentWithProgress");
        KtorPluginsGroupComponentWithProgress panel = (KtorPluginsGroupComponentWithProgress)ktorPluginsGroupComponent;
        if (start) {
            panel.startLoading();
        } else {
            panel.stopLoading();
        }
    }

    public final void dispose() {
        if (this.isProgressMode()) {
            KtorPluginsGroupComponent ktorPluginsGroupComponent = this.panel;
            Intrinsics.checkNotNull((Object)((Object)ktorPluginsGroupComponent), (String)"null cannot be cast to non-null type com.intellij.ktor.initializr.plugins.KtorPluginsGroupComponentWithProgress");
            ((KtorPluginsGroupComponentWithProgress)ktorPluginsGroupComponent).dispose();
        }
    }

    private final boolean isProgressMode() {
        return this.panel instanceof KtorPluginsGroupComponentWithProgress;
    }

    private final void removeGroup() {
        this.currentPluginIds = CollectionsKt.emptyList();
        if (this.group.getUi() != null) {
            this.panel.removeGroup(this.group);
            this.fullRepaint();
        }
        String string = IdeBundle.message((String)"title.search.results", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.group = new KtorPluginsGroup(string, null, 2, null);
    }

    private final void fullRepaint() {
        this.panel.doLayout();
        this.panel.revalidate();
        this.panel.repaint();
    }

    private static final void handleQuery$lambda$4$lambda$3$lambda$2(KtorSearchResultPanel this$0) {
        this$0.fullRepaint();
    }

    private static final void handleQuery$lambda$4$lambda$3(AtomicBoolean $runQuery, KtorSearchResultPanel this$0, boolean $somethingChanged, KtorPluginsGroup $group, List $newPluginIds) {
        boolean bl = SwingUtilities.isEventDispatchThread();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (!$runQuery.get()) {
            return;
        }
        this$0.myRunQuery = null;
        this$0.loading(false);
        if ($somethingChanged) {
            this$0.removeGroup();
            this$0.group = $group;
            if (!((Collection)$group.getElements()).isEmpty()) {
                $group.titleWithCount();
                PluginLogo.startBatchMode();
                KtorPluginsGroupComponent ktorPluginsGroupComponent = this$0.panel;
                KtorPluginsGroup ktorPluginsGroup = this$0.group;
                JScrollBar jScrollBar = this$0.myVerticalScrollBar;
                Intrinsics.checkNotNull((Object)jScrollBar);
                ktorPluginsGroupComponent.addLazyGroup(ktorPluginsGroup, jScrollBar, 10000, () -> KtorSearchResultPanel.handleQuery$lambda$4$lambda$3$lambda$2(this$0));
                this$0.currentPluginIds = $newPluginIds;
                PluginLogo.endBatchMode();
            }
            this$0.panel.initialSelection(false);
            this$0.runPostFillGroupCallback();
            this$0.fullRepaint();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void handleQuery$lambda$4(KtorSearchResultPanel this$0, String $query, KtorPluginsGroup $group, AtomicBoolean $runQuery) {
        void $this$mapTo$iv$iv;
        this$0.handleQuery($query, $group);
        Iterable $this$map$iv = $group.getElements();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtorPluginSearchResult ktorPluginSearchResult = (KtorPluginSearchResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        List newPluginIds = (List)destination$iv$iv;
        boolean somethingChanged = !Intrinsics.areEqual(this$0.currentPluginIds, (Object)newPluginIds);
        ApplicationManager.getApplication().invokeLater(() -> KtorSearchResultPanel.handleQuery$lambda$4$lambda$3($runQuery, this$0, somethingChanged, $group, newPluginIds), ModalityState.any());
    }
}

