/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.updates;

import com.intellij.ktor.KtorStarterBundle;
import com.intellij.ktor.plugins.add.KtorPluginsService;
import com.intellij.ktor.updates.KtorMigrationServiceKt;
import com.intellij.ktor.updates.MigrationStatus;
import com.intellij.ktor.utils.KtorVersionModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.ButtonsGroup;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.MutableProperty;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ktor/updates/KtorMigrationDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "maxAvailableKtorVersion", "Lcom/intellij/ktor/utils/KtorVersionModel;", "modulesForMigration", "", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ktor/utils/KtorVersionModel;Ljava/util/List;)V", "migrationPoint", "Lcom/intellij/ktor/updates/KtorMigrationDialog$MigrationPoint;", "result", "selectedModule", "dialogPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "doOKAction", "", "createCenterPanel", "Ljavax/swing/JComponent;", "MigrationPoint", "Companion", "intellij.ktor"})
@SourceDebugExtension(value={"SMAP\nKtorMigrationAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtorMigrationAction.kt\ncom/intellij/ktor/updates/KtorMigrationDialog\n+ 2 ButtonsGroup.kt\ncom/intellij/ui/dsl/builder/ButtonsGroupKt\n*L\n1#1,126:1\n27#2:127\n*S KotlinDebug\n*F\n+ 1 KtorMigrationAction.kt\ncom/intellij/ktor/updates/KtorMigrationDialog\n*L\n48#1:127\n*E\n"})
final class KtorMigrationDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final KtorVersionModel maxAvailableKtorVersion;
    @NotNull
    private final List<Module> modulesForMigration;
    @NotNull
    private final MigrationPoint migrationPoint;
    @NotNull
    private List<? extends Module> result;
    @NotNull
    private Module selectedModule;
    @NotNull
    private final DialogPanel dialogPanel;

    private KtorMigrationDialog(Project project, KtorVersionModel maxAvailableKtorVersion, List<? extends Module> modulesForMigration) {
        super(project);
        this.project = project;
        this.maxAvailableKtorVersion = maxAvailableKtorVersion;
        this.modulesForMigration = modulesForMigration;
        this.migrationPoint = MigrationPoint.ALL_PROJECT_MODULES;
        this.result = this.modulesForMigration;
        this.selectedModule = (Module)CollectionsKt.first(this.modulesForMigration);
        this.dialogPanel = com.intellij.ui.dsl.builder.BuilderKt.panel(arg_0 -> KtorMigrationDialog.dialogPanel$lambda$7(this, arg_0));
        Object[] objectArray = new Object[]{this.maxAvailableKtorVersion};
        this.setTitle(KtorStarterBundle.INSTANCE.message("ktor.perform.migration.dialog.title", objectArray));
        this.setOKButtonText(KtorStarterBundle.INSTANCE.message("ktor.perform.migration.dialog.ok", new Object[0]));
        this.init();
    }

    protected void doOKAction() {
        super.doOKAction();
        this.dialogPanel.apply();
        KtorMigrationServiceKt.tryPerformMigration(this.project, this.result, this.maxAvailableKtorVersion);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)this.dialogPanel;
    }

    private static final Unit dialogPanel$lambda$7$lambda$3$lambda$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.radioButton(KtorStarterBundle.INSTANCE.message("ktor.perform.migration.dialog.project", new Object[0]), (Object)MigrationPoint.ALL_PROJECT_MODULES);
        return Unit.INSTANCE;
    }

    private static final String dialogPanel$lambda$7$lambda$3$lambda$2$lambda$1(Module it) {
        Module module = it;
        return module != null ? module.getName() : null;
    }

    private static final Unit dialogPanel$lambda$7$lambda$3$lambda$2(KtorMigrationDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell button = $this$row.radioButton(KtorStarterBundle.INSTANCE.message("ktor.perform.migration.dialog.module", new Object[0]), (Object)MigrationPoint.SINGLE_MODULE);
        ComboBoxKt.bindItem((Cell)$this$row.comboBox((Collection)this$0.modulesForMigration, BuilderKt.textListCellRenderer(KtorMigrationDialog::dialogPanel$lambda$7$lambda$3$lambda$2$lambda$1)), (MutableProperty)MutablePropertyKt.toNullableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

            public Object get() {
                return KtorMigrationDialog.access$getSelectedModule$p((KtorMigrationDialog)((Object)this.receiver));
            }

            public void set(Object value) {
                KtorMigrationDialog.access$setSelectedModule$p((KtorMigrationDialog)((Object)this.receiver), (Module)value);
            }
        }))).enabledIf(ButtonKt.getSelected((Cell)button));
        return Unit.INSTANCE;
    }

    private static final Unit dialogPanel$lambda$7$lambda$3(KtorMigrationDialog this$0, Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        Panel.row$default((Panel)$this$buttonsGroup, null, KtorMigrationDialog::dialogPanel$lambda$7$lambda$3$lambda$0, (int)1, null);
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> KtorMigrationDialog.dialogPanel$lambda$7$lambda$3$lambda$2(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final MigrationPoint dialogPanel$lambda$7$lambda$4(KtorMigrationDialog this$0) {
        return this$0.migrationPoint;
    }

    private static final Unit dialogPanel$lambda$7$lambda$5(KtorMigrationDialog this$0, MigrationPoint it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        this$0.result = switch (WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
            case 1 -> this$0.modulesForMigration;
            case 2 -> CollectionsKt.listOf((Object)this$0.selectedModule);
            default -> throw new NoWhenBranchMatchedException();
        };
        return Unit.INSTANCE;
    }

    private static final Unit dialogPanel$lambda$7$lambda$6(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.text$default((Row)$this$row, (String)KtorStarterBundle.INSTANCE.message("ktor.perform.migration.dialog.warning", new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit dialogPanel$lambda$7(KtorMigrationDialog this$0, Panel $this$panel) {
        void getter$iv;
        void $this$bind$iv;
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        ButtonsGroup buttonsGroup = Panel.buttonsGroup$default((Panel)$this$panel, null, (boolean)false, arg_0 -> KtorMigrationDialog.dialogPanel$lambda$7$lambda$3(this$0, arg_0), (int)3, null);
        Function0 function0 = () -> KtorMigrationDialog.dialogPanel$lambda$7$lambda$4(this$0);
        Function1 setter$iv = arg_0 -> KtorMigrationDialog.dialogPanel$lambda$7$lambda$5(this$0, arg_0);
        boolean $i$f$bind = false;
        $this$bind$iv.bind(MutablePropertyKt.MutableProperty((Function0)getter$iv, (Function1)setter$iv), MigrationPoint.class);
        Panel.row$default((Panel)$this$panel, null, KtorMigrationDialog::dialogPanel$lambda$7$lambda$6, (int)1, null);
        return Unit.INSTANCE;
    }

    public /* synthetic */ KtorMigrationDialog(Project project, KtorVersionModel maxAvailableKtorVersion, List modulesForMigration, DefaultConstructorMarker $constructor_marker) {
        this(project, maxAvailableKtorVersion, modulesForMigration);
    }

    public static final /* synthetic */ Module access$getSelectedModule$p(KtorMigrationDialog $this) {
        return $this.selectedModule;
    }

    public static final /* synthetic */ void access$setSelectedModule$p(KtorMigrationDialog $this, Module module) {
        $this.selectedModule = module;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ktor/updates/KtorMigrationDialog$Companion;", "", "<init>", "()V", "of", "Lcom/intellij/ktor/updates/KtorMigrationDialog;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ktor"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final KtorMigrationDialog of(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Pair pair = (Pair)TasksKt.runWithModalProgressBlocking((Project)project, (String)KtorStarterBundle.INSTANCE.message("ktor.perform.migration.dialog.preparation", new Object[0]), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Pair<? extends KtorVersionModel, ? extends List<? extends Module>>>, Object>(project, null){
                int label;
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            KtorVersionModel maxKtorVersion = KtorPluginsService.Companion.getMaxAvailableKtorVersion();
                            if (maxKtorVersion == null) {
                                MigrationStatus.LATEST_VERSION_NOT_FOUND.report(this.$project);
                                return null;
                            }
                            List<Module> modulesForMigration = KtorMigrationServiceKt.modulesAvailableForMigration(this.$project, maxKtorVersion);
                            if (modulesForMigration.isEmpty()) {
                                MigrationStatus.NO_MODULES.report(this.$project);
                                return null;
                            }
                            return TuplesKt.to((Object)maxKtorVersion, modulesForMigration);
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Pair<KtorVersionModel, ? extends List<? extends Module>>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            if (pair == null) {
                return null;
            }
            Pair pair2 = pair;
            KtorVersionModel maxKtorVersion = (KtorVersionModel)pair2.component1();
            List modulesForMigration = (List)pair2.component2();
            return new KtorMigrationDialog(project, maxKtorVersion, modulesForMigration, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ktor/updates/KtorMigrationDialog$MigrationPoint;", "", "<init>", "(Ljava/lang/String;I)V", "ALL_PROJECT_MODULES", "SINGLE_MODULE", "intellij.ktor"})
    public static final class MigrationPoint
    extends Enum<MigrationPoint> {
        public static final /* enum */ MigrationPoint ALL_PROJECT_MODULES = new MigrationPoint();
        public static final /* enum */ MigrationPoint SINGLE_MODULE = new MigrationPoint();
        private static final /* synthetic */ MigrationPoint[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static MigrationPoint[] values() {
            return (MigrationPoint[])$VALUES.clone();
        }

        public static MigrationPoint valueOf(String value) {
            return Enum.valueOf(MigrationPoint.class, value);
        }

        @NotNull
        public static EnumEntries<MigrationPoint> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = migrationPointArray = new MigrationPoint[]{MigrationPoint.ALL_PROJECT_MODULES, MigrationPoint.SINGLE_MODULE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MigrationPoint.values().length];
            try {
                nArray[MigrationPoint.ALL_PROJECT_MODULES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MigrationPoint.SINGLE_MODULE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

