/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.action.delombok;

import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import de.plushnikov.intellij.plugin.processor.AbstractProcessor;
import de.plushnikov.intellij.plugin.processor.LombokProcessorManager;
import de.plushnikov.intellij.plugin.processor.clazz.fieldnameconstants.FieldNameConstantsPredefinedInnerClassFieldProcessor;
import de.plushnikov.intellij.plugin.provider.LombokUserDataKeys;
import de.plushnikov.intellij.plugin.psi.LombokLightClassBuilder;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class DelombokHandler {
    private final boolean processInnerClasses;
    private final Collection<AbstractProcessor> lombokProcessors;

    protected DelombokHandler(AbstractProcessor ... lombokProcessors) {
        this(false, lombokProcessors);
    }

    protected DelombokHandler(boolean processInnerClasses, AbstractProcessor ... lombokProcessors) {
        this.processInnerClasses = processInnerClasses;
        this.lombokProcessors = Arrays.asList(lombokProcessors);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiClass psiClass) {
        if (project == null) {
            DelombokHandler.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            DelombokHandler.$$$reportNull$$$0(1);
        }
        if (psiClass == null) {
            DelombokHandler.$$$reportNull$$$0(2);
        }
        if (psiFile.isWritable()) {
            this.invoke(project, psiClass, this.processInnerClasses);
            DelombokHandler.finish(project, psiFile);
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiJavaFile psiFile) {
        if (project == null) {
            DelombokHandler.$$$reportNull$$$0(3);
        }
        if (psiFile == null) {
            DelombokHandler.$$$reportNull$$$0(4);
        }
        for (PsiClass psiClass : psiFile.getClasses()) {
            this.invoke(project, psiClass, true);
        }
        DelombokHandler.finish(project, (PsiFile)psiFile);
    }

    private void invoke(Project project, PsiClass psiClass, boolean processInnerClasses) {
        HashSet<PsiAnnotation> processedAnnotations = new HashSet<PsiAnnotation>();
        DelombokHandler.processModifierList(psiClass);
        PsiClass[] allInnerClasses = psiClass.getAllInnerClasses();
        for (AbstractProcessor lombokProcessor : this.lombokProcessors) {
            processedAnnotations.addAll(DelombokHandler.processClass(project, psiClass, lombokProcessor));
        }
        DelombokHandler.postProcessAugmentedAnnotations((PsiModifierListOwner)psiClass);
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)psiClass);
        if (processInnerClasses) {
            for (PsiClass innerClass : allInnerClasses) {
                if (innerClass instanceof LombokLightClassBuilder) continue;
                this.invoke(project, innerClass, true);
            }
        }
        processedAnnotations.forEach(PsiElement::delete);
    }

    private static void finish(Project project, PsiFile psiFile) {
        JavaCodeStyleManager.getInstance((Project)project).optimizeImports(psiFile);
        UndoUtil.markPsiFileForUndo((PsiFile)psiFile);
    }

    private static Collection<PsiAnnotation> processClass(@NotNull Project project, @NotNull PsiClass psiClass, @NotNull AbstractProcessor lombokProcessor) {
        if (project == null) {
            DelombokHandler.$$$reportNull$$$0(5);
        }
        if (psiClass == null) {
            DelombokHandler.$$$reportNull$$$0(6);
        }
        if (lombokProcessor == null) {
            DelombokHandler.$$$reportNull$$$0(7);
        }
        Collection<PsiAnnotation> psiAnnotations = lombokProcessor.collectProcessedAnnotations(psiClass);
        List<? super PsiElement> psiElements = lombokProcessor.process(psiClass);
        if (lombokProcessor instanceof FieldNameConstantsPredefinedInnerClassFieldProcessor) {
            DelombokHandler.rebuildElementsBeforeExistingFields(project, psiClass, psiElements);
        } else {
            DelombokHandler.rebuildElements(project, psiClass, psiElements);
        }
        return psiAnnotations;
    }

    private static void processModifierList(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            DelombokHandler.$$$reportNull$$$0(8);
        }
        DelombokHandler.rebuildModifierList((PsiModifierListOwner)psiClass);
        PsiClassUtil.collectClassFieldsIntern(psiClass).forEach(DelombokHandler::rebuildModifierList);
        PsiClassUtil.collectClassMethodsIntern(psiClass).forEach(DelombokHandler::rebuildModifierList);
        PsiClassUtil.collectClassStaticMethodsIntern(psiClass).forEach(DelombokHandler::rebuildModifierList);
    }

    private static void rebuildModifierList(@NotNull PsiModifierListOwner modifierListOwner) {
        PsiModifierList modifierList;
        if (modifierListOwner == null) {
            DelombokHandler.$$$reportNull$$$0(9);
        }
        if (null != (modifierList = modifierListOwner.getModifierList())) {
            HashSet lombokModifiers = new HashSet();
            LombokProcessorManager.getLombokModifierProcessors().forEach(modifierProcessor -> {
                if (modifierProcessor.isSupported(modifierList)) {
                    modifierProcessor.transformModifiers(modifierList, lombokModifiers);
                    lombokModifiers.forEach(modifier -> modifierList.setModifierProperty(modifier, true));
                    lombokModifiers.clear();
                }
            });
        }
    }

    private static void postProcessAugmentedAnnotations(@NotNull PsiModifierListOwner psiModifierListOwner) {
        if (psiModifierListOwner == null) {
            DelombokHandler.$$$reportNull$$$0(10);
        }
        Collection augmentedAnnotations = (Collection)psiModifierListOwner.getUserData(LombokUserDataKeys.AUGMENTED_ANNOTATIONS);
        PsiModifierList psiModifierList = psiModifierListOwner.getModifierList();
        if (null != augmentedAnnotations && !augmentedAnnotations.isEmpty() && psiModifierList != null) {
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)psiModifierListOwner.getProject());
            for (String augmentedAnnotation : augmentedAnnotations) {
                psiModifierList.addAfter((PsiElement)elementFactory.createAnnotationFromText(augmentedAnnotation, (PsiElement)psiModifierListOwner), null);
            }
        }
    }

    private static void rebuildElementsBeforeExistingFields(Project project, PsiClass psiClass, List<? super PsiElement> psiElements) {
        if (!psiElements.isEmpty()) {
            PsiField existingField = PsiClassUtil.collectClassFieldsIntern(psiClass).stream().findFirst().orElse(null);
            Iterator<? super PsiElement> iterator = psiElements.iterator();
            PsiElement prev = psiClass.addBefore(DelombokHandler.rebuildPsiElement(project, iterator.next()), (PsiElement)existingField);
            while (iterator.hasNext()) {
                PsiElement curr = DelombokHandler.rebuildPsiElement(project, iterator.next());
                if (curr == null) continue;
                prev = psiClass.addAfter(curr, prev);
            }
        }
    }

    private static void rebuildElements(Project project, PsiClass psiClass, List<? super PsiElement> psiElements) {
        for (PsiElement psiElement : psiElements) {
            PsiElement element = DelombokHandler.rebuildPsiElement(project, psiElement);
            if (null == element) continue;
            psiClass.add(element);
        }
    }

    public Collection<PsiAnnotation> collectProcessableAnnotations(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            DelombokHandler.$$$reportNull$$$0(11);
        }
        ArrayList<PsiAnnotation> result = new ArrayList<PsiAnnotation>();
        for (AbstractProcessor lombokProcessor : this.lombokProcessors) {
            result.addAll(lombokProcessor.collectProcessedAnnotations(psiClass));
        }
        return result;
    }

    private static PsiElement rebuildPsiElement(@NotNull Project project, PsiElement psiElement) {
        if (project == null) {
            DelombokHandler.$$$reportNull$$$0(12);
        }
        if (psiElement instanceof PsiMethod) {
            return DelombokHandler.rebuildMethod(project, (PsiMethod)psiElement);
        }
        if (psiElement instanceof PsiField) {
            return DelombokHandler.rebuildField(project, (PsiField)psiElement);
        }
        if (psiElement instanceof PsiClass) {
            if (((PsiClass)psiElement).isEnum()) {
                return DelombokHandler.rebuildEnum(project, (PsiClass)psiElement);
            }
            return DelombokHandler.rebuildClass(project, (PsiClass)psiElement);
        }
        return null;
    }

    private static PsiClass rebuildEnum(@NotNull Project project, @NotNull PsiClass fromClass) {
        if (project == null) {
            DelombokHandler.$$$reportNull$$$0(13);
        }
        if (fromClass == null) {
            DelombokHandler.$$$reportNull$$$0(14);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        PsiClass resultClass = elementFactory.createEnum(StringUtil.defaultIfEmpty((String)fromClass.getName(), (String)"UnknownClassName"));
        DelombokHandler.copyModifiers(fromClass.getModifierList(), resultClass.getModifierList());
        DelombokHandler.rebuildTypeParameter((PsiTypeParameterListOwner)fromClass, (PsiTypeParameterListOwner)resultClass);
        List<PsiField> fields = Arrays.asList(fromClass.getFields());
        if (!fields.isEmpty()) {
            Iterator<PsiField> iterator = fields.iterator();
            PsiElement prev = resultClass.add((PsiElement)DelombokHandler.rebuildField(project, iterator.next()));
            while (iterator.hasNext()) {
                PsiField curr = iterator.next();
                prev = resultClass.addAfter((PsiElement)DelombokHandler.rebuildField(project, curr), prev);
            }
        }
        for (PsiMethod psiMethod : fromClass.getMethods()) {
            String psiMethodName = psiMethod.getName();
            if ("values".equals(psiMethodName) || "valueOf".equals(psiMethodName)) continue;
            resultClass.add((PsiElement)DelombokHandler.rebuildMethod(project, psiMethod));
        }
        return resultClass;
    }

    private static PsiClass rebuildClass(@NotNull Project project, @NotNull PsiClass fromClass) {
        if (project == null) {
            DelombokHandler.$$$reportNull$$$0(15);
        }
        if (fromClass == null) {
            DelombokHandler.$$$reportNull$$$0(16);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        PsiClass resultClass = elementFactory.createClass(StringUtil.defaultIfEmpty((String)fromClass.getName(), (String)"UnknownClassName"));
        DelombokHandler.copyModifiers(fromClass.getModifierList(), resultClass.getModifierList());
        DelombokHandler.copyAnnotations(fromClass.getModifierList(), resultClass.getModifierList());
        DelombokHandler.rebuildTypeParameter((PsiTypeParameterListOwner)fromClass, (PsiTypeParameterListOwner)resultClass);
        PsiReferenceList extendsList = fromClass.getExtendsList();
        PsiReferenceList resultExtendsList = resultClass.getExtendsList();
        if (null != extendsList && null != resultExtendsList) {
            Stream.of(extendsList.getReferencedTypes()).map(arg_0 -> ((PsiElementFactory)elementFactory).createReferenceElementByType(arg_0)).forEach(arg_0 -> ((PsiReferenceList)resultExtendsList).add(arg_0));
        }
        for (PsiField psiField : fromClass.getFields()) {
            resultClass.add((PsiElement)DelombokHandler.rebuildField(project, psiField));
        }
        for (PsiField psiField : fromClass.getMethods()) {
            resultClass.add((PsiElement)DelombokHandler.rebuildMethod(project, (PsiMethod)psiField));
        }
        return resultClass;
    }

    private static PsiMethod rebuildMethod(@NotNull Project project, @NotNull PsiMethod fromMethod) {
        if (project == null) {
            DelombokHandler.$$$reportNull$$$0(17);
        }
        if (fromMethod == null) {
            DelombokHandler.$$$reportNull$$$0(18);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        PsiType returnType = fromMethod.getReturnType();
        PsiMethod resultMethod = null == returnType ? elementFactory.createConstructor(fromMethod.getName()) : elementFactory.createMethod(fromMethod.getName(), returnType);
        DelombokHandler.rebuildTypeParameter((PsiTypeParameterListOwner)fromMethod, (PsiTypeParameterListOwner)resultMethod);
        PsiClassType[] referencedTypes = fromMethod.getThrowsList().getReferencedTypes();
        if (referencedTypes.length > 0) {
            PsiJavaCodeReferenceElement[] refs = new PsiJavaCodeReferenceElement[referencedTypes.length];
            for (int i = 0; i < refs.length; ++i) {
                refs[i] = elementFactory.createReferenceElementByType(referencedTypes[i]);
            }
            resultMethod.getThrowsList().replace((PsiElement)elementFactory.createReferenceList(refs));
        }
        for (PsiJavaCodeReferenceElement psiJavaCodeReferenceElement : fromMethod.getParameterList().getParameters()) {
            PsiParameter toParameter = elementFactory.createParameter(psiJavaCodeReferenceElement.getName(), psiJavaCodeReferenceElement.getType());
            PsiModifierList fromParameterModifierList = psiJavaCodeReferenceElement.getModifierList();
            if (fromParameterModifierList != null) {
                PsiModifierList toParameterModifierList = toParameter.getModifierList();
                DelombokHandler.copyAnnotations(fromParameterModifierList, toParameterModifierList);
                toParameterModifierList.setModifierProperty("final", fromParameterModifierList.hasModifierProperty("final"));
            }
            resultMethod.getParameterList().add((PsiElement)toParameter);
        }
        PsiModifierList fromMethodModifierList = fromMethod.getModifierList();
        PsiModifierList resultMethodModifierList = resultMethod.getModifierList();
        DelombokHandler.copyModifiers(fromMethodModifierList, resultMethodModifierList);
        DelombokHandler.copyAnnotations(fromMethodModifierList, resultMethodModifierList);
        PsiCodeBlock body = fromMethod.getBody();
        if (null != body) {
            resultMethod.getBody().replace((PsiElement)body);
        } else {
            resultMethod.getBody().delete();
        }
        return resultMethod;
    }

    private static void copyAnnotations(@NotNull PsiModifierList fromModifierList, @NotNull PsiModifierList toModifierList) {
        if (fromModifierList == null) {
            DelombokHandler.$$$reportNull$$$0(19);
        }
        if (toModifierList == null) {
            DelombokHandler.$$$reportNull$$$0(20);
        }
        for (PsiAnnotation originalAnnotation : fromModifierList.getAnnotations()) {
            String annotationQualifiedName = originalAnnotation.getQualifiedName();
            if (StringUtil.isEmptyOrSpaces((String)annotationQualifiedName)) continue;
            AddAnnotationPsiFix.addPhysicalAnnotationIfAbsent((String)annotationQualifiedName, (PsiNameValuePair[])originalAnnotation.getParameterList().getAttributes(), (PsiAnnotationOwner)toModifierList);
        }
    }

    private static void rebuildTypeParameter(@NotNull PsiTypeParameterListOwner listOwner, @NotNull PsiTypeParameterListOwner resultOwner) {
        PsiTypeParameterList resultOwnerTypeParameterList;
        if (listOwner == null) {
            DelombokHandler.$$$reportNull$$$0(21);
        }
        if (resultOwner == null) {
            DelombokHandler.$$$reportNull$$$0(22);
        }
        if (null != (resultOwnerTypeParameterList = resultOwner.getTypeParameterList())) {
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)resultOwner.getProject());
            for (PsiTypeParameter typeParameter : listOwner.getTypeParameters()) {
                String typeParameterAsString = DelombokHandler.getTypeParameterAsString(typeParameter);
                resultOwnerTypeParameterList.add((PsiElement)elementFactory.createTypeParameterFromText(typeParameterAsString, (PsiElement)resultOwner));
            }
        }
    }

    @NotNull
    private static String getTypeParameterAsString(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            DelombokHandler.$$$reportNull$$$0(23);
        }
        PsiClassType[] referencedTypes = typeParameter.getExtendsList().getReferencedTypes();
        String extendsText = "";
        if (referencedTypes.length > 0) {
            extendsText = Stream.of(referencedTypes).map(DelombokHandler::getTypeWithParameter).collect(Collectors.joining(" & ", " extends ", ""));
        }
        String string = typeParameter.getName() + extendsText;
        if (string == null) {
            DelombokHandler.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    private static String getTypeWithParameter(@NotNull PsiClassType psiClassType) {
        if (psiClassType == null) {
            DelombokHandler.$$$reportNull$$$0(25);
        }
        if (psiClassType instanceof PsiClassReferenceType) {
            String string = ((PsiClassReferenceType)psiClassType).getReference().getText();
            if (string == null) {
                DelombokHandler.$$$reportNull$$$0(26);
            }
            return string;
        }
        String string = psiClassType.getName();
        if (string == null) {
            DelombokHandler.$$$reportNull$$$0(27);
        }
        return string;
    }

    private static void copyModifiers(PsiModifierList fromModifierList, PsiModifierList resultModifierList) {
        for (String modifier : PsiModifier.MODIFIERS) {
            resultModifierList.setModifierProperty(modifier, fromModifierList.hasExplicitModifier(modifier));
        }
    }

    private static PsiField rebuildField(@NotNull Project project, @NotNull PsiField fromField) {
        PsiEnumConstant resultField;
        if (project == null) {
            DelombokHandler.$$$reportNull$$$0(28);
        }
        if (fromField == null) {
            DelombokHandler.$$$reportNull$$$0(29);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        if (fromField instanceof PsiEnumConstant) {
            resultField = elementFactory.createEnumConstantFromText(fromField.getName(), fromField.getContext());
        } else {
            resultField = elementFactory.createField(fromField.getName(), fromField.getType());
            resultField.setInitializer(fromField.getInitializer());
        }
        DelombokHandler.copyModifiers(fromField.getModifierList(), resultField.getModifierList());
        return resultField;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 24, 26, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lombokProcessor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierListOwner";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiModifierListOwner";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromClass";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromMethod";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromModifierList";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toModifierList";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultOwner";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 24: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/action/delombok/DelombokHandler";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClassType";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/action/delombok/DelombokHandler";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameterAsString";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeWithParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processClass";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processModifierList";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "rebuildModifierList";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "postProcessAugmentedAnnotations";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectProcessableAnnotations";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "rebuildPsiElement";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "rebuildEnum";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "rebuildClass";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "rebuildMethod";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "copyAnnotations";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "rebuildTypeParameter";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterAsString";
                break;
            }
            case 24: 
            case 26: 
            case 27: {
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getTypeWithParameter";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "rebuildField";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 24, 26, 27 -> new IllegalStateException(string);
        };
    }
}

