/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.activity;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.server.BuildManagerListener;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.java.analysis.OuterModelsModificationTrackerManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.SingletonNotificationManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.AppJavaExecutorUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import de.plushnikov.intellij.plugin.LombokBundle;
import de.plushnikov.intellij.plugin.util.LombokLibraryUtil;
import java.util.UUID;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.compiler.AnnotationProcessingConfiguration;

final class LombokBuildManagerListener
implements BuildManagerListener {
    private final SingletonNotificationManager myNotificationManager = new SingletonNotificationManager("Lombok plugin", NotificationType.ERROR);

    LombokBuildManagerListener() {
    }

    public void beforeBuildProcessStarted(@NotNull Project project, @NotNull UUID sessionId) {
        if (project == null) {
            LombokBuildManagerListener.$$$reportNull$$$0(0);
        }
        if (sessionId == null) {
            LombokBuildManagerListener.$$$reportNull$$$0(1);
        }
        AppJavaExecutorUtil.executeOnPooledIoThread(() -> {
            if (((Boolean)ReadAction.nonBlocking(() -> LombokBuildManagerListener.requiresAnnotationProcessing(project)).executeSynchronously()).booleanValue()) {
                this.suggestEnableAnnotations(project);
            }
        });
    }

    @RequiresBackgroundThread
    @RequiresReadLock
    private static boolean requiresAnnotationProcessing(@NotNull Project project) {
        if (project == null) {
            LombokBuildManagerListener.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (project.isDisposed()) {
            return false;
        }
        if (LombokBuildManagerListener.hasAnnotationProcessorsEnabled(project)) {
            return false;
        }
        if (!LombokLibraryUtil.hasLombokLibrary(project)) {
            return false;
        }
        return (Boolean)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
            GlobalSearchScope scope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)GlobalSearchScope.projectScope((Project)project), (FileType[])new FileType[]{JavaFileType.INSTANCE});
            CacheManager.getInstance((Project)project).processFilesWithWord((Processor)processor, "lombok", (short)1, scope, false);
            return new CachedValueProvider.Result((Object)processor.isFound(), new Object[]{OuterModelsModificationTrackerManager.getTracker((Project)project)});
        });
    }

    private static CompilerConfigurationImpl getCompilerConfiguration(@NotNull Project project) {
        if (project == null) {
            LombokBuildManagerListener.$$$reportNull$$$0(3);
        }
        return (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project);
    }

    private static boolean hasAnnotationProcessorsEnabled(@NotNull Project project) {
        CompilerConfigurationImpl compilerConfiguration;
        if (project == null) {
            LombokBuildManagerListener.$$$reportNull$$$0(4);
        }
        return (compilerConfiguration = LombokBuildManagerListener.getCompilerConfiguration(project)).getDefaultProcessorProfile().isEnabled() && ContainerUtil.and((Iterable)compilerConfiguration.getModuleProcessorProfiles(), AnnotationProcessingConfiguration::isEnabled);
    }

    private static void enableAnnotationProcessors(@NotNull Project project) {
        if (project == null) {
            LombokBuildManagerListener.$$$reportNull$$$0(5);
        }
        CompilerConfigurationImpl compilerConfiguration = LombokBuildManagerListener.getCompilerConfiguration(project);
        compilerConfiguration.getDefaultProcessorProfile().setEnabled(true);
        compilerConfiguration.getModuleProcessorProfiles().forEach(pp -> pp.setEnabled(true));
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
        JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(LombokBundle.message("popup.content.java.annotation.processing.has.been.enabled", new Object[0]), MessageType.INFO, null).setFadeoutTime(3000L).createBalloon().show(RelativePoint.getNorthEastOf((JComponent)statusBar.getComponent()), Balloon.Position.atRight);
    }

    private void suggestEnableAnnotations(final Project project) {
        this.myNotificationManager.notify("", LombokBundle.message("config.warn.annotation-processing.disabled.title", new Object[0]), project, notification -> {
            notification.setSuggestionType(true);
            notification.addAction((AnAction)new NotificationAction(LombokBundle.message("notification.enable.annotation.processing", new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (notification == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    LombokBuildManagerListener.enableAnnotationProcessors(project);
                    notification.expire();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "de/plushnikov/intellij/plugin/activity/LombokBuildManagerListener$1";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionId";
                break;
            }
        }
        objectArray2[1] = "de/plushnikov/intellij/plugin/activity/LombokBuildManagerListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeBuildProcessStarted";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "requiresAnnotationProcessing";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCompilerConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasAnnotationProcessorsEnabled";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "enableAnnotationProcessors";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

